/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.ldap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.naming.WsnBatchModeContext;
import com.ibm.websphere.naming.WsnOptimizedJndiContext;
import com.ibm.ws.naming.jbatch.BatchModeNotSupported;
import com.ibm.ws.naming.ldap.WsnLdapBindingEnumeration;
import com.ibm.ws.naming.ldap.WsnLdapContextPerTreeInfo;
import com.ibm.ws.naming.ldap.WsnLdapHelpers;
import com.ibm.ws.naming.ldap.WsnLdapNameEnumeration;
import com.ibm.ws.naming.util.BooleanWrapper;
import com.ibm.ws.naming.util.Helpers;
import com.ibm.ws.naming.util.JavaObjectHolder;
import com.ibm.ws.naming.util.NameFormatHelper;
import com.ibm.ws.naming.util.RasUtil;
import com.ibm.ws.naming.util.WsnName;
import com.ibm.ws.naming.util.WsnNameParser;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SchemaViolationException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;

public class WsnLdapContextImpl
implements Context,
WsnOptimizedJndiContext {
    private static final TraceComponent _tc = Tr.register(WsnLdapContextImpl.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String CLASS_NAME;
    private static NameComponent[] _emptyCosNameComponent;
    protected WsnNameParser _parser;
    protected DirContext _ldapCtx;
    protected Hashtable _env;
    protected WsnLdapContextPerTreeInfo _pti;
    private String _pathFromContainer;
    private static final String CLASS_ctor = "WsnLdapContextImpl(Hashtable,DirContext,WsnLdapContextPerTreeInfo) constructor";
    private static final String CLASS_ctor_1 = "WsnLdapContextImpl(Hashtable,DirContext,WsnLdapContextPerTreeInfo, WsnNameParser) constructor";
    private static final String METHOD_init = "init(Hashtable, DirContext, WsnLdapContextPerTreeInfo, WsnNameParser)";
    private static final String METHOD_bind = "bind(Name,Object)";
    private static final String METHOD_bindS = "bind(String,Object)";
    private static String METHOD_rebind;
    private static final String METHOD_rebindS = "rebind(String,Object)";
    private static final String METHOD_unbind = "unbind(Name)";
    private static final String METHOD_unbindS = "unbind(String)";
    private static final String METHOD_composeName = "composeName(Name,Name)";
    private static final String METHOD_composeNameS = "composeName(String,String)";
    private static final String METHOD_createSubcontext = "createSubcontext(Name)";
    private static final String METHOD_createSubcontextS = "createSubcontext(String)";
    private static final String METHOD_destroySubcontext = "destroySubcontext(Name)";
    private static final String METHOD_destroySubcontextS = "destroySubcontext(String)";
    private static final String METHOD_getNameParser = "getNameParser(Name)";
    private static final String METHOD_getNameParserS = "getNameParser(String)";
    private static final String METHOD_list = "list(Name)";
    private static final String METHOD_listS = "list(String)";
    private static final String METHOD_listBindings = "listBindings(Name)";
    private static final String METHOD_listBindingsS = "listBindings(String)";
    private static final String METHOD_lookup = "lookup(Name)";
    private static final String METHOD_lookupS = "lookup(String)";
    private static final String METHOD_rename = "rename(Name,Name)";
    private static final String METHOD_renameS = "rename(String,String)";
    private static final String METHOD_addToEnvironment = "addToEnvironment(String,Object)";
    private static final String METHOD_getEnvironment = "getEnvironment()";
    private static final String METHOD_removeFromEnvironment = "removeFromEnvironment(String)";
    private static final String METHOD_close = "close()";

    private WsnLdapContextImpl() {
    }

    protected WsnLdapContextImpl(Hashtable env, DirContext ldapCtx, WsnLdapContextPerTreeInfo pti) throws NamingException {
        Tr.entry(_tc, CLASS_ctor);
        WsnNameParser parser2 = WsnNameParser.getParser(env);
        this.init(env, ldapCtx, pti, parser2);
        Tr.exit(_tc, CLASS_ctor);
    }

    protected WsnLdapContextImpl(Hashtable env, DirContext ldapCtx, WsnLdapContextPerTreeInfo pti, WsnNameParser parser2) throws NamingException {
        Tr.debug(_tc, CLASS_ctor_1);
        this.init(env, ldapCtx, pti, parser2);
    }

    private void init(Hashtable env, DirContext ldapCtx, WsnLdapContextPerTreeInfo pti, WsnNameParser parser2) throws NamingException {
        Tr.entry(_tc, METHOD_init);
        this._env = (Hashtable)env.clone();
        this._ldapCtx = ldapCtx;
        this._pti = pti;
        this._parser = parser2;
        this._pathFromContainer = null;
        if (_emptyCosNameComponent == null) {
            _emptyCosNameComponent = new NameComponent[1];
            WsnLdapContextImpl._emptyCosNameComponent[0] = new NameComponent("", "");
        }
        Tr.exit(_tc, METHOD_init);
    }

    public void bind(Name name, java.lang.Object obj) throws NamingException {
        Tr.entry(_tc, METHOD_bind, name);
        Helpers.throwIfNullOrEmpty(name, METHOD_bind, (Context)this);
        Context urlCtx = Helpers.getContextIfUrlName(name, this._env);
        if (urlCtx != null) {
            urlCtx.bind(name, obj);
        } else {
            Attributes attrs = null;
            String ldapRDN = null;
            try {
                String et = this.getEntryTypeNeededToBind(obj);
                ldapRDN = this.convert_to_ldapName(name);
                attrs = this.initAttrsForEntryType(et, name, obj, ldapRDN);
            }
            catch (NamingException ne) {
                RasUtil.logException((Throwable)ne, _tc, CLASS_NAME, "bind", "194", this);
                Tr.exit(_tc, "caught/rethrow NamingException: " + ne);
                throw ne;
            }
            try {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "_ldapCtx.bind(ldapRDN, null, attrs)", new java.lang.Object[]{"ldapRDN=" + ldapRDN, attrs});
                }
                this._ldapCtx.bind(ldapRDN, null, attrs);
            }
            catch (NamingException ne) {
                FederatedContext fc = this.getCannotProceedException(ne, name);
                Context c = fc.getContext();
                c.bind(fc.getRemainingName(), obj);
            }
        }
        Tr.exit(_tc, METHOD_bind, name);
    }

    public void bind(String name, java.lang.Object obj) throws NamingException {
        Tr.entry(_tc, METHOD_bindS, name);
        String adjustedName = this.stripLeadingSlashFromName(name);
        Helpers.throwIfNullOrEmpty(adjustedName, METHOD_bindS, (Context)this);
        this.bind(this._parser.parse(adjustedName), obj);
        Tr.exit(_tc, METHOD_bindS, name);
    }

    public void rebind(Name name, java.lang.Object obj) throws NamingException {
        Tr.entry(_tc, METHOD_rebind, name);
        Helpers.throwIfNullOrEmpty(name, METHOD_rebind, (Context)this);
        Context urlCtx = Helpers.getContextIfUrlName(name, this._env);
        if (urlCtx != null) {
            urlCtx.rebind(name, obj);
        } else {
            Attributes attrs = null;
            String ldapRDN = null;
            try {
                String et = this.getEntryTypeNeededToBind(obj);
                ldapRDN = this.convert_to_ldapName(name);
                attrs = this.initAttrsForEntryType(et, name, obj, ldapRDN);
            }
            catch (NamingException ne) {
                RasUtil.logException((Throwable)ne, _tc, CLASS_NAME, "rebind", "250", this);
                Tr.exit(_tc, "caught/rethrow NamingException: " + ne);
                throw ne;
            }
            try {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "_ldapCtx.rebind(ldapRDN, null, attrs)", new java.lang.Object[]{"ldapRDN=" + ldapRDN, attrs});
                }
                this._ldapCtx.rebind(ldapRDN, null, attrs);
            }
            catch (NamingException ne) {
                FederatedContext fc = this.getCannotProceedException(ne, name);
                Context c = fc.getContext();
                c.rebind(fc.getRemainingName(), obj);
            }
        }
        Tr.exit(_tc, METHOD_rebind, name);
    }

    public void rebind(String name, java.lang.Object obj) throws NamingException {
        Tr.entry(_tc, METHOD_rebindS, name);
        String adjustedName = this.stripLeadingSlashFromName(name);
        Helpers.throwIfNullOrEmpty(adjustedName, METHOD_rebindS, (Context)this);
        this.rebind(this._parser.parse(adjustedName), obj);
        Tr.exit(_tc, METHOD_rebindS, name);
    }

    public void unbind(Name name) throws NamingException {
        Tr.entry(_tc, METHOD_unbind, name);
        Helpers.throwIfNullOrEmpty(name, METHOD_unbind, (Context)this);
        Context urlCtx = Helpers.getContextIfUrlName(name, this._env);
        if (urlCtx != null) {
            urlCtx.unbind(name);
        } else {
            String ldapRDN = this.convert_to_ldapName(name);
            try {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "_ldapCtx.unbind(ldapRDN)", new java.lang.Object[]{"ldapRDN=" + ldapRDN});
                }
                this._ldapCtx.unbind(ldapRDN);
            }
            catch (NamingException ne) {
                FederatedContext fc = this.getCannotProceedException(ne, name);
                Context c = fc.getContext();
                c.unbind(fc.getRemainingName());
            }
        }
        Tr.exit(_tc, METHOD_unbind, name);
    }

    public void unbind(String name) throws NamingException {
        Tr.entry(_tc, METHOD_unbindS, name);
        String adjustedName = this.stripLeadingSlashFromName(name);
        Helpers.throwIfNullOrEmpty(adjustedName, METHOD_unbindS, (Context)this);
        this.unbind(this._parser.parse(adjustedName));
        Tr.exit(_tc, METHOD_unbindS, name);
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, METHOD_composeName, " name=" + name + " prefix=" + prefix);
        }
        Helpers.throwIfNull(name, METHOD_composeName, (Context)this);
        Helpers.throwIfNull(prefix, METHOD_composeName, (Context)this);
        Name retName = null;
        Context urlCtx = Helpers.getContextIfUrlName(name, this._env);
        if (urlCtx != null) {
            retName = urlCtx.composeName(name, prefix);
        } else {
            retName = this._parser.parse("");
            Enumeration<String> e = prefix.getAll();
            while (e.hasMoreElements()) {
                retName.add(e.nextElement());
            }
            e = name.getAll();
            while (e.hasMoreElements()) {
                retName.add(e.nextElement());
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, METHOD_composeName, " returnName=" + retName);
        }
        return retName;
    }

    public String composeName(String name, String prefix) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, METHOD_composeNameS, " name=" + name + " prefix=" + prefix);
        }
        String adjustedName = this.stripLeadingSlashFromName(name);
        Helpers.throwIfNull(adjustedName, METHOD_composeNameS, (Context)this);
        Helpers.throwIfNull(prefix, METHOD_composeNameS, (Context)this);
        WsnName tempName = (WsnName)this.composeName(this._parser.parse(adjustedName), this._parser.parse(prefix));
        String retName = tempName.toString();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, METHOD_composeNameS, " returnName=" + retName);
        }
        return retName;
    }

    public Context createSubcontext(Name name) throws NamingException {
        Tr.entry(_tc, METHOD_createSubcontext, name);
        Helpers.throwIfNullOrEmpty(name, METHOD_createSubcontext, (Context)this);
        Context retCtx = null;
        Context urlCtx = Helpers.getContextIfUrlName(name, this._env);
        if (urlCtx != null) {
            retCtx = urlCtx.createSubcontext(name);
        } else {
            String ldapRDN = this.convert_to_ldapName(name);
            Attributes attrs = this.initAttrsForEntryType("PrimaryContext", name, null, ldapRDN);
            try {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "newLdapCtx = _ldapCtx.createSubcontext(ldapRDN,attrs)", new java.lang.Object[]{"ldapRDN=" + ldapRDN, attrs});
                }
                DirContext newLdapCtx = this._ldapCtx.createSubcontext(ldapRDN, attrs);
                retCtx = new WsnLdapContextImpl(this._env, newLdapCtx, this._pti, this._parser);
            }
            catch (NamingException ne) {
                FederatedContext fc = this.getCannotProceedException(ne, name);
                Context c = fc.getContext();
                retCtx = c.createSubcontext(fc.getRemainingName());
            }
        }
        Tr.exit(_tc, METHOD_createSubcontext, name);
        return retCtx;
    }

    public Context createSubcontext(String name) throws NamingException {
        Tr.entry(_tc, METHOD_createSubcontextS, name);
        String adjustedName = this.stripLeadingSlashFromName(name);
        Helpers.throwIfNullOrEmpty(adjustedName, METHOD_createSubcontextS, (Context)this);
        Context retValue = this.createSubcontext(this._parser.parse(adjustedName));
        Tr.exit(_tc, METHOD_createSubcontextS, name);
        return retValue;
    }

    public void destroySubcontext(Name name) throws NamingException {
        Tr.entry(_tc, METHOD_destroySubcontext, name);
        Helpers.throwIfNullOrEmpty(name, METHOD_destroySubcontext, (Context)this);
        Context urlCtx = Helpers.getContextIfUrlName(name, this._env);
        if (urlCtx != null) {
            urlCtx.destroySubcontext(name);
        } else {
            try {
                String ldapRDN = this.convert_to_ldapName(name);
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "_ldapCtx.destroySubcontext(ldapRDN)", new java.lang.Object[]{"ldapRDN=" + ldapRDN});
                }
                this._ldapCtx.destroySubcontext(ldapRDN);
            }
            catch (InvalidNameException ine) {
                RasUtil.logException((Throwable)ine, _tc, CLASS_NAME, "destroySubcontext", "460", this);
                throw new ContextNotEmptyException("Cannot destroy non-empty context at " + this.nameInNamespace());
            }
            catch (NamingException ne) {
                FederatedContext fc = this.getCannotProceedException(ne, name);
                Context c = fc.getContext();
                c.destroySubcontext(fc.getRemainingName());
            }
        }
        Tr.exit(_tc, METHOD_destroySubcontext, name);
    }

    public void destroySubcontext(String name) throws NamingException {
        Tr.entry(_tc, METHOD_destroySubcontextS, name);
        String adjustedName = this.stripLeadingSlashFromName(name);
        Helpers.throwIfNullOrEmpty(adjustedName, METHOD_destroySubcontext, (Context)this);
        this.destroySubcontext(this._parser.parse(adjustedName));
        Tr.exit(_tc, METHOD_destroySubcontextS, name);
    }

    public NameParser getNameParser(Name name) throws NamingException {
        Tr.entry(_tc, METHOD_getNameParser, name);
        NameParser retParser = null;
        if (Helpers.trueIfEmptyOrThrowIfNull(name, METHOD_getNameParser, (Context)this)) {
            retParser = this._parser;
        } else {
            Context urlCtx = Helpers.getContextIfUrlName(name, this._env);
            if (urlCtx != null) {
                retParser = urlCtx.getNameParser(name);
            } else {
                Context targetCtx = (Context)this.lookupWithoutEmptyOrUrlChecks(name);
                retParser = targetCtx.getNameParser("");
                Helpers.closeIfContext(targetCtx);
            }
        }
        Tr.exit(_tc, METHOD_getNameParser, name);
        return retParser;
    }

    public NameParser getNameParser(String name) throws NamingException {
        Tr.entry(_tc, METHOD_getNameParserS, name);
        String adjustedName = this.stripLeadingSlashFromName(name);
        Helpers.throwIfNull(adjustedName, METHOD_getNameParserS, (Context)this);
        NameParser retParser = this.getNameParser(this._parser.parse(adjustedName));
        Tr.exit(_tc, METHOD_getNameParserS, name);
        return retParser;
    }

    public NamingEnumeration list(Name name) throws NamingException {
        Tr.entry(_tc, METHOD_list, name);
        Helpers.throwIfNull(name, METHOD_list, (Context)this);
        WsnLdapNameEnumeration retEnum = null;
        Context urlCtx = Helpers.getContextIfUrlName(name, this._env);
        if (urlCtx != null) {
            retEnum = urlCtx.list(name);
        } else {
            try {
                String ldapRDN = this.convert_to_ldapName(name);
                SearchControls sc = new SearchControls(1, 0L, 0, null, false, false);
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "_ldapCtx.search(ldapRDN,objectClass=ibm-wsnEntry,sc)", "ldapRDN=" + ldapRDN);
                }
                NamingEnumeration<SearchResult> searchResults = this._ldapCtx.search(ldapRDN, "objectClass=ibm-wsnEntry", sc);
                retEnum = new WsnLdapNameEnumeration(this.getEnvironment(), searchResults, this._parser, true);
            }
            catch (NamingException ne) {
                FederatedContext fc = this.getCannotProceedException(ne, name);
                Context c = fc.getContext();
                retEnum = c.list(fc.getRemainingName());
            }
        }
        Tr.exit(_tc, METHOD_list, name);
        return retEnum;
    }

    public NamingEnumeration list(String name) throws NamingException {
        Tr.entry(_tc, METHOD_listS, name);
        String adjustedName = this.stripLeadingSlashFromName(name);
        Helpers.throwIfNull(adjustedName, METHOD_listS, (Context)this);
        NamingEnumeration retEnum = this.list(this._parser.parse(adjustedName));
        Tr.exit(_tc, METHOD_listS, name);
        return retEnum;
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        Tr.entry(_tc, METHOD_listBindings, name);
        Helpers.throwIfNull(name, METHOD_listBindings, (Context)this);
        WsnLdapBindingEnumeration retEnum = null;
        Context urlCtx = Helpers.getContextIfUrlName(name, this._env);
        if (urlCtx != null) {
            retEnum = urlCtx.listBindings(name);
        } else if (!name.isEmpty()) {
            Context leafCtx = (Context)this.lookupWithoutEmptyOrUrlChecks(name);
            retEnum = leafCtx.listBindings("");
        } else {
            try {
                SearchControls sc = new SearchControls(1, 0L, 0, null, false, false);
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "_ldapCtx.search(ldapRDN,objectClass=ibm-wsnEntry,sc)", "ldapRDN=\"\"");
                }
                NamingEnumeration<SearchResult> searchResults = this._ldapCtx.search("", "objectClass=ibm-wsnEntry", sc);
                retEnum = new WsnLdapBindingEnumeration(this, searchResults);
            }
            catch (NamingException ne) {
                FederatedContext fc = this.getCannotProceedException(ne, name);
                Context c = fc.getContext();
                retEnum = c.listBindings(fc.getRemainingName());
            }
        }
        Tr.exit(_tc, METHOD_listBindings, name);
        return retEnum;
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        Tr.entry(_tc, METHOD_listBindingsS, name);
        String adjustedName = this.stripLeadingSlashFromName(name);
        Helpers.throwIfNull(adjustedName, METHOD_listBindingsS, (Context)this);
        NamingEnumeration retEnum = this.listBindings(this._parser.parse(adjustedName));
        Tr.exit(_tc, METHOD_listBindingsS, name);
        return retEnum;
    }

    public java.lang.Object lookup(Name name) throws NamingException {
        Context urlCtx;
        Tr.entry(_tc, METHOD_lookup, name);
        java.lang.Object retObj = null;
        retObj = Helpers.trueIfEmptyOrThrowIfNull(name, METHOD_lookup, (Context)this) ? new WsnLdapContextImpl(this._env, this._ldapCtx, this._pti, this._parser) : ((urlCtx = Helpers.getContextIfUrlName(name, this._env)) != null ? urlCtx.lookup(name) : this.lookupWithoutEmptyOrUrlChecks(name));
        if (_tc.isEntryEnabled()) {
            String retObjClass = retObj.getClass().getName();
            Tr.exit(_tc, METHOD_lookup, new java.lang.Object[]{"name: " + name, "returning object of class=" + retObjClass});
        }
        return retObj;
    }

    public java.lang.Object lookup(String name) throws NamingException {
        Context urlCtx;
        Tr.entry(_tc, METHOD_lookupS, name);
        String adjustedName = this.stripLeadingSlashFromName(name);
        java.lang.Object retObj = null;
        retObj = Helpers.trueIfEmptyOrThrowIfNull(adjustedName, METHOD_lookupS, (Context)this) ? new WsnLdapContextImpl(this._env, this._ldapCtx, this._pti, this._parser) : ((urlCtx = Helpers.getContextIfUrlName(adjustedName, this._env)) != null ? urlCtx.lookup(adjustedName) : this.lookupWithoutEmptyOrUrlChecks(adjustedName));
        if (_tc.isEntryEnabled()) {
            String retObjClass = retObj.getClass().getName();
            Tr.exit(_tc, METHOD_lookupS, new java.lang.Object[]{"name: " + name, "returning object of class=" + retObjClass});
        }
        return retObj;
    }

    private java.lang.Object lookupWithoutEmptyOrUrlChecks(Name name) throws NamingException {
        java.lang.Object retObj = null;
        Attributes attrs = null;
        try {
            String ldapRDN = this.convert_to_ldapName(name);
            attrs = this._ldapCtx.getAttributes(ldapRDN);
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "attrs = _ldapCtx.getAttributes(ldapRDN)", new java.lang.Object[]{"ldapRDN=" + ldapRDN, attrs});
            }
            String et = WsnLdapHelpers.getStringFromAttribute(attrs, "ibm-wsnEntryType", true);
            retObj = this.getObjectFromEntry(et, attrs, name);
        }
        catch (NamingException ne) {
            FederatedContext fc = this.getCannotProceedException(ne, name);
            Context c = fc.getContext();
            retObj = c.lookup(fc.getRemainingName());
        }
        return retObj;
    }

    private java.lang.Object lookupWithoutEmptyOrUrlChecks(String name) throws NamingException {
        return this.lookupWithoutEmptyOrUrlChecks(this._parser.parse(name));
    }

    public java.lang.Object lookupLink(Name name) throws NamingException {
        String errMsg = "The 'lookupLink(Name)' method is not supported by this implementation, called with Name=" + name;
        Tr.event(_tc, errMsg);
        throw new OperationNotSupportedException(errMsg);
    }

    public java.lang.Object lookupLink(String name) throws NamingException {
        String errMsg = "The 'lookupLink(String)' method is not supported by this implementation, called with Name=" + name;
        Tr.event(_tc, errMsg);
        throw new OperationNotSupportedException(errMsg);
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, METHOD_rename, "oldName=" + oldName + " newName=" + newName);
        }
        Helpers.throwIfNullOrEmpty(oldName, METHOD_rename, (Context)this);
        Helpers.throwIfNullOrEmpty(newName, METHOD_rename, (Context)this);
        if (newName.compareTo(oldName) == 0) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, METHOD_rename, "oldName=newName=" + newName + " - no processing performed");
            }
            return;
        }
        boolean oldIsUrl = NameFormatHelper.isUrl(oldName);
        boolean newIsUrl = NameFormatHelper.isUrl(newName);
        if (oldIsUrl && newIsUrl) {
            Context urlCtx = Helpers.getContextIfUrlName(oldName, this._env);
            urlCtx.rename(oldName, newName);
        } else if (!oldIsUrl && !newIsUrl) {
            java.lang.Object theObj = this.lookup(oldName);
            this.unbind(oldName);
            try {
                this.bind(newName, theObj);
            }
            catch (NameAlreadyBoundException b) {
                RasUtil.logException((Throwable)b, _tc, CLASS_NAME, "rename", "822", this);
                Tr.event(_tc, "rename failure - NameAlreadyBoundException, restoring binding for oldName");
                this.bind(oldName, theObj);
                String msg = "newName=" + newName + " already bound to context " + this.toString();
                Tr.exit(_tc, METHOD_rename, "NameAlreadyBoundException: " + msg);
                throw new NameAlreadyBoundException(msg);
            }
            catch (NamingException e) {
                RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "rename", "831", this);
                Tr.event(_tc, "rename failure - other NamingException, restoring binding for oldName");
                this.bind(oldName, theObj);
                Tr.exit(_tc, METHOD_rename, "rethrowing NamingException=" + e);
                throw e;
            }
        } else {
            String msg = "rename(Name,Name) cannot mix URL and non-URL names: oldName=" + oldName + " newName=" + newName;
            Tr.exit(_tc, msg);
            throw new OperationNotSupportedException(msg);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, METHOD_rename, "oldName=" + oldName + " newName=" + newName);
        }
    }

    public void rename(String oldName, String newName) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, METHOD_renameS, "oldName=" + oldName + " newName=" + newName);
        }
        String adjustedOldName = this.stripLeadingSlashFromName(oldName);
        String adjustedNewName = this.stripLeadingSlashFromName(newName);
        Helpers.throwIfNullOrEmpty(oldName, METHOD_renameS, (Context)this);
        Helpers.throwIfNullOrEmpty(newName, METHOD_renameS, (Context)this);
        this.rename(this._parser.parse(oldName), this._parser.parse(newName));
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, METHOD_renameS, " oldName=" + oldName + " newName=" + newName);
        }
    }

    public java.lang.Object addToEnvironment(String propName, java.lang.Object propVal) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, METHOD_addToEnvironment, " propName=" + propName + " Object=" + propVal);
        }
        if (propName == null || propVal == null) {
            throw new NamingException("addToEnvironment(String,Object) called with null parameter, propName=" + propName + " Object=" + propVal);
        }
        java.lang.Object retValue = this._env.put(propName, propVal);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, METHOD_addToEnvironment, " propName=" + propName + " Object=" + propVal + " old value was=" + retValue);
        }
        return retValue;
    }

    public Hashtable getEnvironment() throws NamingException {
        Tr.entry(_tc, METHOD_getEnvironment);
        Hashtable retHash = (Hashtable)this._env.clone();
        Tr.exit(_tc, METHOD_getEnvironment);
        return retHash;
    }

    public java.lang.Object removeFromEnvironment(String propName) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, METHOD_removeFromEnvironment, " propName=" + propName);
        }
        if (propName == null) {
            throw new NamingException("removeFromEnvironment(String) called with null parameter, propName=" + propName);
        }
        java.lang.Object retValue = this._env.remove(propName);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, METHOD_removeFromEnvironment, " propName=" + propName + " old value was=" + retValue);
        }
        return retValue;
    }

    public void close() throws NamingException {
        Tr.entry(_tc, METHOD_close);
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, "_ldapCtx.close()");
        }
        this._ldapCtx.close();
        this._ldapCtx = null;
        this._env = null;
        this._parser = null;
        Tr.exit(_tc, METHOD_close);
    }

    public String getNameInNamespace() throws NamingException {
        String nins = this.nameInNamespace();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getNameInNamespace()-->>" + nins);
        }
        return nins;
    }

    public String toString() {
        String nins = "";
        try {
            nins = this.nameInNamespace();
        }
        catch (NamingException ne) {
            nins = "????? nameInNamespace failed ?????";
        }
        return this.getClass().getName() + "(" + nins + ")";
    }

    private String nameInNamespace() throws NamingException {
        String ldapStringName = this.getPathFromContainer();
        return ldapStringName;
    }

    private String convert_to_ldapName(Name name) throws NamingException {
        String ldapStringName = "";
        try {
            Name ldapName = NameFormatHelper.convertInsJndiNameToLdapJndiName(name);
            ldapStringName = NameFormatHelper.convertLdapJndiNameToLdapStringName(ldapName);
        }
        catch (Exception ex) {
            RasUtil.logException((Throwable)ex, _tc, CLASS_NAME, "convert_to_ldapName", "998", this);
            Tr.warning(_tc, "jldapJndiToLdapConv", name.toString());
            String msg = "Cannot convert the JNDI name " + name.toString() + " to an LDAP name string.";
            InvalidNameException ine = new InvalidNameException(msg);
            ine.setRootCause(ex);
            throw ine;
        }
        return ldapStringName;
    }

    private String convert_to_ldapName(String name) throws NamingException {
        return this.convert_to_ldapName(this._parser.parse(name));
    }

    private String convert_to_ldapNameComponentValue(String name) throws NamingException {
        String withPrefix = null;
        if (name.length() == 0) {
            Name emptyJndiNameComponent = this._parser.ncToName(_emptyCosNameComponent);
            withPrefix = this.convert_to_ldapName(emptyJndiNameComponent);
        } else {
            withPrefix = this.convert_to_ldapName(name);
        }
        int prefixLength = "ibm-wsnName=".length();
        String withoutPrefix = withPrefix.substring(prefixLength);
        String fixEscapes = "";
        for (int i = 0; i < withoutPrefix.length(); ++i) {
            String next = withoutPrefix.substring(i, i + 1);
            if (next.equals("\\")) {
                String next2 = withoutPrefix.substring(i, i + 2);
                if (!next2.equals("\\\\")) continue;
                fixEscapes = fixEscapes.concat("\\");
                ++i;
                continue;
            }
            fixEscapes = fixEscapes.concat(next);
        }
        return fixEscapes;
    }

    private String fixAliasObjectDN(String name) throws NamingException {
        String fixedName = "";
        for (int i = 0; i < name.length(); ++i) {
            String next = name.substring(i, i + 1);
            if (next.equals("\\")) {
                String next3 = name.substring(i, i + 3);
                if (next3.equals("\\\\.")) {
                    fixedName = fixedName.concat("\\\\\\.");
                    i += 2;
                    continue;
                }
                fixedName = fixedName.concat(next);
                continue;
            }
            fixedName = fixedName.concat(next);
        }
        fixedName = fixedName.concat(name.substring(name.length()));
        return fixedName;
    }

    private java.lang.Object toCorba(java.lang.Object obj) {
        if (obj instanceof Remote) {
            Remote remote = (Remote)obj;
            try {
                Object o = (Object)PortableRemoteObject.toStub((Remote)remote);
                return o;
            }
            catch (NoSuchObjectException e) {
                Tr.exit(_tc, "toCorba: exception");
                return null;
            }
        }
        return obj;
    }

    String getEntryTypeNeededToBind(java.lang.Object obj) throws NamingException {
        Tr.entry(_tc, "getEntryTypeNeededToBind");
        if (obj == null || obj instanceof Remote || obj instanceof Object) {
            Tr.exit(_tc, "getEntryTypeNeededToBind - Type: IORLeaf");
            return "IORLeaf";
        }
        if (obj instanceof WsnLdapContextImpl) {
            WsnLdapContextImpl wsnCtx = (WsnLdapContextImpl)obj;
            if (this._pti._masterServerUrl.equals(wsnCtx._pti._masterServerUrl) && this._pti._nameTreeContainerDN.equals(wsnCtx._pti._nameTreeContainerDN)) {
                Tr.exit(_tc, "getEntryTypeNeededToBind - Type: LinkedContext");
                return "LinkedContext";
            }
            Tr.exit(_tc, "getEntryTypeNeededToBind - We don't yet support Federation of name spaces");
            throw new SchemaViolationException("We don't yet support Federation of name spaces");
        }
        if (obj instanceof Referenceable || obj instanceof Reference || obj instanceof Serializable) {
            Tr.exit(_tc, "getEntryTypeNeededToBind - Type: SerializableLeaf");
            return "SerializableLeaf";
        }
        Tr.exit(_tc, "getEntryTypeNeededToBind - Throwing NamingException - Don't know how to bind this type of object");
        throw new NamingException("Don't know how to bind this type of object");
    }

    Attributes initAttrsForEntryType(String et, Name n, java.lang.Object o, String ldapRDN) throws NamingException {
        BasicAttributes attrs = new BasicAttributes();
        BasicAttribute objectclass = new BasicAttribute("objectClass");
        attrs.put(objectclass);
        objectclass.add("ibm-wsnEntry");
        BasicAttribute EntryType = new BasicAttribute("ibm-wsnEntryType");
        attrs.put(EntryType);
        EntryType.add(et);
        BasicAttribute Name2 = new BasicAttribute("ibm-wsnName");
        attrs.put(Name2);
        String lastNameComponent = n.get(n.size() - 1);
        String lastNameComponentLdapValue = this.convert_to_ldapNameComponentValue(lastNameComponent);
        Name2.add(lastNameComponentLdapValue);
        BasicAttribute javaClassName = new BasicAttribute("javaClassName");
        attrs.put(javaClassName);
        if (et.equals("IORLeaf")) {
            this.initAttrsForIORLeaf(attrs, objectclass, javaClassName, o);
        } else if (et.equals("SerializableLeaf")) {
            this.initAttrsForSerializableLeaf(attrs, objectclass, javaClassName, o);
        } else if (et.equals("PrimaryContext")) {
            this.initAttrsForPrimaryContext(attrs, objectclass, javaClassName, ldapRDN);
        } else if (et.equals("LinkedContext")) {
            this.initAttrsForLinkedContext(attrs, objectclass, javaClassName, (WsnLdapContextImpl)o);
        }
        return attrs;
    }

    void initAttrsForIORLeaf(Attributes attrs, Attribute objectclass, Attribute javaClassName, java.lang.Object o) throws NamingException {
        objectclass.add("corbaObjectReference");
        String javaObjectClass = "";
        if (o != null) {
            javaObjectClass = o.getClass().getName();
        }
        javaClassName.add(javaObjectClass);
        BasicAttribute corbaIor = new BasicAttribute("corbaIor");
        String ior = this._pti._orb.object_to_string((Object)this.toCorba(o));
        corbaIor.add(ior);
        attrs.put(corbaIor);
    }

    void initAttrsForPrimaryContext(Attributes attrs, Attribute objectclass, Attribute javaClassName, String ldapRDN) throws NamingException {
        objectclass.add("ibm-wsnPrimaryContextLocation");
        String javaObjectClass = "javax.naming.Context";
        javaClassName.add(javaObjectClass);
        BasicAttribute NameTreeContainerDN = new BasicAttribute("ibm-wsnNameTreeContainerDN");
        attrs.put(NameTreeContainerDN);
        NameTreeContainerDN.add(this._pti._nameTreeContainerDN);
        BasicAttribute PathFromContainer = new BasicAttribute("ibm-wsnPathFromContainer");
        attrs.put(PathFromContainer);
        String newPathFromContainer = ldapRDN + "," + this.getPathFromContainer();
        PathFromContainer.add(newPathFromContainer);
    }

    void initAttrsForLinkedContext(Attributes attrs, Attribute objectclass, Attribute javaClassName, WsnLdapContextImpl ctxToLink) throws NamingException {
        objectclass.add("aliasObject");
        String javaObjectClass = "javax.naming.Context";
        javaClassName.add(javaObjectClass);
        BasicAttribute aliasedObjectName = new BasicAttribute("aliasedObjectName");
        attrs.put(aliasedObjectName);
        String ctxToLinkDN = ctxToLink.getPathFromContainer() + "," + ctxToLink._pti._nameTreeContainerDN;
        aliasedObjectName.add(ctxToLinkDN);
    }

    void initAttrsForSerializableLeaf(Attributes attrs, Attribute objectclass, Attribute javaClassName, java.lang.Object o) throws NamingException {
        objectclass.add("javaSerializedObject");
        BasicAttribute javaSerializedData = new BasicAttribute("javaSerializedData");
        StringBuffer classNameBuff = new StringBuffer(64);
        byte[] data = null;
        try {
            data = (byte[])Helpers.processJavaObjectForBinding(o, true, classNameBuff);
        }
        catch (IOException e) {
            RasUtil.logException((Throwable)e, _tc, CLASS_NAME, "initAttrsForSerializableLeaf", "1267", this);
            NamingException ne = new NamingException("initAttrsForSerializedLeaf received IO Exception from processJavaObjectForBinding");
            ne.setRootCause(e);
            throw ne;
        }
        javaSerializedData.add(data);
        attrs.put(javaSerializedData);
        javaClassName.add(classNameBuff.toString());
    }

    java.lang.Object getObjectFromEntry(String et, Attributes attrs, Name n) throws NamingException {
        if (et.equals("IORLeaf")) {
            String ior = WsnLdapHelpers.getStringFromAttribute(attrs, "corbaIor", true);
            Object o = this._pti._orb.string_to_object(ior);
            return o;
        }
        if (et.equals("SerializableLeaf")) {
            Attribute javaSerializedData = attrs.get("javaSerializedData");
            byte[] data = (byte[])javaSerializedData.get();
            String className = WsnLdapHelpers.getStringFromAttribute(attrs, "javaClassName", false);
            BooleanWrapper isCacheableReference = new BooleanWrapper(false);
            java.lang.Object o = Helpers.processSerializedObjectForLookup(data, this, n.toString(), className, this._env, new JavaObjectHolder(), isCacheableReference);
            return o;
        }
        if (et.equals("PrimaryContext")) {
            String ldapRDN = this.convert_to_ldapName(n);
            Context ctx = this.getNewWsnLdapContextImpl(this._ldapCtx, ldapRDN);
            return ctx;
        }
        if (et.equals("LinkedContext")) {
            String ldapDN = WsnLdapHelpers.getStringFromAttribute(attrs, "aliasedObjectName", true);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "getObjectFromEntry: ldapDN=" + ldapDN);
            }
            String fixedLdapDN = this.fixAliasObjectDN(ldapDN);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "getObjectFromEntry: fixedLdapDN=" + fixedLdapDN);
            }
            Context ctx = this.getNewWsnLdapContextImpl(this._pti._initialLdapCtx, fixedLdapDN);
            return ctx;
        }
        if (et.equals("InvisibleContext")) {
            String ldapRDN = this.convert_to_ldapName(n);
            Context ctx = this.getNewWsnLdapContextImpl(this._ldapCtx, ldapRDN);
            return ctx;
        }
        throw new NamingException("getObjectFromEntry - unknown Entry Type: " + et + "for Name: " + n);
    }

    private Context getNewWsnLdapContextImpl(DirContext parentDirCtx, String newDirCtxRdn) throws NamingException {
        SearchResult sr;
        java.lang.Object obj;
        NamingEnumeration<SearchResult> ne;
        WsnLdapContextImpl ctx = null;
        SearchControls sc = new SearchControls();
        sc.setSearchScope(0);
        sc.setReturningObjFlag(true);
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, "ne = parentDirCtxsearch(newDirCtxRdn, \"objectClass=*\", sc);", new java.lang.Object[]{"parentDirCtx: " + parentDirCtx.getNameInNamespace(), "newDirCtxRdn: " + newDirCtxRdn, "sc=" + sc.toString()});
        }
        if ((ne = parentDirCtx.search(newDirCtxRdn, "objectClass=*", sc)).hasMore() && (obj = (sr = ne.next()).getObject()) != null && obj instanceof DirContext) {
            ctx = new WsnLdapContextImpl(this._env, (DirContext)obj, this._pti, this._parser);
        }
        if (ctx == null) {
            throw new NamingException("Object at " + newDirCtxRdn + " from " + parentDirCtx.getNameInNamespace() + " is not a DirContext");
        }
        return ctx;
    }

    private String getPathFromContainer() throws NamingException {
        if (this._pathFromContainer == null) {
            Name containerDN;
            String myStringDN;
            NameParser ldapParser = this._ldapCtx.getNameParser("");
            Name myDN = ldapParser.parse(myStringDN = this._ldapCtx.getNameInNamespace());
            if (!myDN.startsWith(containerDN = ldapParser.parse(this._pti._nameTreeContainerDN))) {
                throw new NamingException("getPathFromContainer - containerDN not prefix of myDN, myDN= " + myStringDN + "  containerDN= " + this._pti._nameTreeContainerDN);
            }
            Name pathFromContainer = myDN.getSuffix(containerDN.size());
            this._pathFromContainer = pathFromContainer.toString();
        }
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, "getPathFromContainer, returning: ", "_pathFromContainer = " + this._pathFromContainer);
        }
        return this._pathFromContainer;
    }

    public FederatedContext getCannotProceedException(NamingException ne, Name name) throws NamingException {
        Name remainingName = ne.getRemainingName();
        Name resolvedName = ne.getResolvedName();
        java.lang.Object obj = ne.getResolvedObj();
        if (name.size() <= 1) {
            throw ne;
        }
        Context ctx = this;
        int i = 0;
        for (i = 0; i < name.size() - 1; ++i) {
            String nameComponent = name.get(i);
            Name nameComponentAsName = this._parser.parse("");
            nameComponentAsName.add(nameComponent);
            java.lang.Object nextNode = null;
            try {
                if (ctx instanceof WsnLdapContextImpl) {
                    WsnLdapContextImpl wsnCtx = ctx;
                    nextNode = wsnCtx.lookupWithoutEmptyOrUrlChecks(nameComponentAsName);
                } else {
                    nextNode = ctx.lookup(nameComponentAsName);
                }
            }
            catch (NameNotFoundException origEx) {
                RasUtil.logException((Throwable)origEx, _tc, CLASS_NAME, "getCannotProceedException", "1520", this);
                NameNotFoundException newEx = new NameNotFoundException("An intermediate node in the name \"" + name.toString() + "\" does not exist");
                newEx.setRootCause(origEx);
                throw newEx;
            }
            catch (Exception origEx) {
                RasUtil.logException((Throwable)origEx, _tc, CLASS_NAME, "getCannotProceedException", "1527", this);
                NamingException newEx = new NamingException("Accessing an intermediate node in the name \"" + name.toString() + "\" caused an exception");
                newEx.setRootCause(origEx);
                throw newEx;
            }
            if (!(nextNode instanceof Context)) {
                throw new NotContextException("An intermediate node in the name \"" + name.toString() + "\" is not a Context, it is a " + nextNode.getClass().getName());
            }
            ctx = (Context)nextNode;
        }
        FederatedContext fc = new FederatedContext();
        fc.setContext(ctx);
        fc.setRemainingName(name.getSuffix(i));
        return fc;
    }

    public boolean supportsBatchMode() {
        return false;
    }

    public WsnBatchModeContext getBatchModeContext() throws NamingException {
        throw new BatchModeNotSupported("Server does not support batch operations.");
    }

    public boolean isLocal() {
        return false;
    }

    private String stripLeadingSlashFromName(String name) {
        if (name.substring(0, 1).equals("/")) {
            name = name.substring(1, name.length());
        }
        return name;
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming.client/src/com/ibm/ws/naming/ldap/WsnLdapContextImpl.java, WAS.naming.client, WAS70.SERV1, q0834.18, ver. 1.43");
        }
        CLASS_NAME = WsnLdapContextImpl.class.getName();
        _emptyCosNameComponent = null;
        METHOD_rebind = "rebind(Name,Object)";
    }

    private class FederatedContext {
        public Context ctx;
        public Name remainingName;

        private FederatedContext() {
        }

        public void setContext(Context ctx) {
            this.ctx = ctx;
        }

        public void setRemainingName(Name remainingName) {
            this.remainingName = remainingName;
        }

        public Context getContext() {
            return this.ctx;
        }

        public Name getRemainingName() {
            return this.remainingName;
        }
    }
}

