/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.metadata.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.metadata.annotations.AnnotationException;
import com.ibm.ws.metadata.annotations.EJBLocatorClassAdapter;
import com.ibm.ws.util.WCCMHelper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RolesAllowed;
import javax.annotation.security.RunAs;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jst.j2ee.application.internal.impl.ApplicationImpl;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.CommonPackage;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;

public class RoleMergeHelper {
    private static final String CLASS_NAME = RoleMergeHelper.class.getName();
    private static TraceComponent tc = Tr.register(CLASS_NAME, "MetaData", "com.ibm.ws.metadata.metadata");
    private ApplicationImpl ivApplication;
    private EARFile ivEarFile;
    private String[] ivRunAsArray = null;

    public RoleMergeHelper(ApplicationImpl app, EARFile ear) {
        this.ivEarFile = ear;
        if (app == null) {
            app = new ApplicationImpl();
            this.ivEarFile.setDeploymentDescriptor(app);
        }
        this.ivApplication = app;
    }

    public void mergeRoles() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "mergeRoles(" + this.ivEarFile + " : " + this.ivApplication + ")");
        }
        CommonarchiveFactory archiveFactory = CommonarchiveFactoryImpl.getActiveFactory();
        CommonFactory commonFactory = CommonPackage.eINSTANCE.getCommonFactory();
        EList roles = this.ivApplication.getSecurityRoles();
        HashSet<String> runAsSet = new HashSet<String>();
        HashSet<String> roleSet = new HashSet<String>();
        for (int i = 0; i < roles.size(); ++i) {
            SecurityRole role = (SecurityRole)roles.get(i);
            roleSet.add(role.getRoleName());
        }
        ArchiveOptions opt = new ArchiveOptions();
        opt.setAltBinariesPath(this.ivEarFile.getOptions().getAltBinariesPath());
        String oURI = null;
        EARFile opennedEar = null;
        try {
            oURI = this.ivEarFile.getOriginalURI();
            if (oURI == null) {
                oURI = this.ivEarFile.getURI();
            }
            opennedEar = archiveFactory.openEARFile(opt, oURI);
        }
        catch (OpenFailureException ex) {
            FFDCFilter.processException((Throwable)ex, CLASS_NAME + "mergeRoles", "158", this);
            AnnotationException aex = new AnnotationException("Unable to open ear file: " + oURI + ": ", ex);
            Tr.error(tc, "UNABLE_TO_OPEN_EAR_FILE_CWMDF0007E", new Object[]{oURI, aex});
            throw aex;
        }
        List ejbJars = opennedEar.getEJBJarFiles();
        for (int j = 0; j < ejbJars.size(); ++j) {
            EList ejbs;
            String moduleVersion;
            boolean metadataComplete = false;
            EJBJarFile jar = (EJBJarFile)ejbJars.get(j);
            ClassLoader classloader = jar.getArchiveClassLoader();
            EJBJar jarDD = WCCMHelper.getDeploymentDescriptor(jar, false);
            if (jarDD != null && !(metadataComplete = !(moduleVersion = jarDD.getVersion()).equals("3.0") ? true : (jarDD.isSetMetadataComplete() ? jarDD.isMetadataComplete() : false)) && !(ejbs = jarDD.getEnterpriseBeans()).isEmpty()) {
                for (EnterpriseBean ejb : ejbs) {
                    String runAsBinding;
                    JavaClass ejbJClass = ejb.getEjbClass();
                    if (ejbJClass == null) continue;
                    String className = ejbJClass.getQualifiedNameForReflection();
                    Class ejbClass = this.loadClass(className, classloader);
                    HashSet annotatedRoleSet = this.getAllRolesFromClass(ejbClass);
                    if (!annotatedRoleSet.isEmpty()) {
                        for (String newRole : annotatedRoleSet) {
                            if (!roleSet.add(newRole)) continue;
                            SecurityRole sr = commonFactory.createSecurityRole();
                            sr.setRoleName(newRole);
                            roles.add(sr);
                        }
                    }
                    if ((runAsBinding = this.getRunAsInfoFromClass(ejbClass)) == null) continue;
                    runAsSet.add(runAsBinding);
                }
            }
            if (metadataComplete) continue;
            EList files = jar.getFiles();
            for (File file : files) {
                String runAsBinding;
                if (file.isDirectoryEntry() || !file.getURI().endsWith(".class") || !this.isEJB(file)) continue;
                String uri = file.getURI();
                String className = (uri = uri.replaceAll("/", ".")).substring(0, uri.lastIndexOf("."));
                Class ejbClass = this.loadClass(className, classloader);
                HashSet annotatedRoleSet = this.getAllRolesFromClass(ejbClass);
                if (!annotatedRoleSet.isEmpty()) {
                    for (String newRole : annotatedRoleSet) {
                        if (!roleSet.add(newRole)) continue;
                        SecurityRole sr = commonFactory.createSecurityRole();
                        sr.setRoleName(newRole);
                        roles.add(sr);
                    }
                }
                if (ejbClass == null || (runAsBinding = this.getRunAsInfoFromClass(ejbClass)) == null) continue;
                runAsSet.add(runAsBinding);
            }
        }
        if (runAsSet != null && !runAsSet.isEmpty()) {
            this.ivRunAsArray = runAsSet.toArray(new String[0]);
        }
        opennedEar.close();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            if (roles != null) {
                Tr.debug(tc, "Roles = " + Arrays.toString(roles.toArray(new SecurityRole[0])));
            }
            if (this.ivRunAsArray != null) {
                Tr.debug(tc, "RunAs Roles = " + Arrays.toString(this.ivRunAsArray));
            }
            Tr.exit(tc, "mergeRoles");
        }
    }

    private boolean isEJB(File file) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isEJB(" + file.getOriginalURI() + ")");
        }
        try {
            InputStream is = file.getInputStream();
            ClassReader cr = new ClassReader(is);
            ClassWriter cw = new ClassWriter(true);
            EJBLocatorClassAdapter classAdapter = new EJBLocatorClassAdapter(cw);
            cr.accept(classAdapter, false);
            return classAdapter.isEJB();
        }
        catch (IOException ex) {
            FFDCFilter.processException((Throwable)ex, CLASS_NAME + "isEJB", "331", this);
            AnnotationException aex = new AnnotationException("Annotation processing failed:  ", ex);
            Tr.error(tc, "ANNOTATION_PROCESSING_FAILED_CWMDF0002E", aex);
            throw aex;
        }
    }

    private Class loadClass(String className, ClassLoader classLoader) {
        Class<?> testClass;
        try {
            testClass = Class.forName(className, false, classLoader);
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, CLASS_NAME + "getAllRolesFromClass", "324", this);
            Tr.warning(tc, "UNABLE_TO_LOAD_CLASS_CWMDF0008W", new Object[]{className, t});
            return null;
        }
        return testClass;
    }

    private HashSet getAllRolesFromClass(Class testClass) {
        HashSet<String> resultSet;
        block8: {
            String[] rolesAllowed;
            block9: {
                Method[] AllMethods = null;
                RolesAllowed methodRolesAllowed = null;
                resultSet = new HashSet<String>();
                if (testClass == null) break block8;
                DeclareRoles classDeclareRoles = testClass.getAnnotation(DeclareRoles.class);
                if (classDeclareRoles != null) {
                    String[] rolesDeclared;
                    for (String role : rolesDeclared = classDeclareRoles.value()) {
                        resultSet.add(role);
                    }
                }
                try {
                    AllMethods = testClass.getMethods();
                }
                catch (Throwable t) {
                    FFDCFilter.processException(t, CLASS_NAME + "getAllRolesFromClass", "380", this);
                    Tr.warning(tc, "UNABLE_TO_LOAD_METHODS_CWMDF0009W", new Object[]{testClass.getName(), t});
                }
                if (AllMethods == null) break block9;
                for (Method method2 : AllMethods) {
                    String[] rolesAllowed2;
                    methodRolesAllowed = method2.getAnnotation(RolesAllowed.class);
                    if (methodRolesAllowed == null) {
                        methodRolesAllowed = method2.getDeclaringClass().getAnnotation(RolesAllowed.class);
                    }
                    if (methodRolesAllowed == null) continue;
                    for (String role : rolesAllowed2 = methodRolesAllowed.value()) {
                        resultSet.add(role);
                    }
                }
                break block8;
            }
            RolesAllowed classRolesAllowed = testClass.getAnnotation(RolesAllowed.class);
            if (classRolesAllowed == null) break block8;
            for (String role : rolesAllowed = classRolesAllowed.value()) {
                resultSet.add(role);
            }
        }
        return resultSet;
    }

    private String getRunAsInfoFromClass(Class testClass) {
        RunAs RunAsAnnotation;
        String runAsBinding = null;
        if (testClass != null && (RunAsAnnotation = testClass.getAnnotation(RunAs.class)) != null) {
            runAsBinding = RunAsAnnotation.value();
        }
        return runAsBinding;
    }

    public String[] getRunAsRoles() {
        return this.ivRunAsArray;
    }
}

