/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.repository;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class TempFileInputStream
extends FileInputStream {
    private static TraceComponent tc = Tr.register(TempFileInputStream.class, "Repository", "com.ibm.ws.management.resources.repository");
    private File f = null;
    boolean readToEOF = false;

    public TempFileInputStream(String name) throws FileNotFoundException {
        super(name);
    }

    public TempFileInputStream(File file) throws FileNotFoundException {
        super(file);
        this.f = file;
    }

    public TempFileInputStream(FileDescriptor fdObj) {
        super(fdObj);
    }

    public int read() throws IOException {
        int result = super.read();
        if (this.f != null && result == -1) {
            this.readToEOF = true;
        }
        return result;
    }

    public int read(byte[] b) throws IOException {
        int result = super.read(b);
        if (this.f != null && result == -1) {
            this.readToEOF = true;
        }
        return result;
    }

    public int read(byte[] b, int offset, int length) throws IOException {
        int result = super.read(b, offset, length);
        if (this.f != null && result == -1) {
            this.readToEOF = true;
        }
        return result;
    }

    public void close() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "close() file=" + (this.f == null ? "null" : this.f.getName()));
        }
        if (this.getFD().valid()) {
            super.close();
            if (this.f != null && this.readToEOF && this.f.delete() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Succesfully deleted file on stream finalize: " + this.f.getPath());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "close");
        }
    }

    public void finalize() {
        if (this.f != null && this.readToEOF && this.f.delete() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Succesfully deleted file on stream finalize: " + this.f.getPath());
        }
    }

    private void deleteEmptyParents(File f, String limit) {
        File parent = f.getParentFile();
        if (parent.getPath().length() > limit.length() && parent.delete()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Succesfully deleted directory on stream finalize: " + parent.getPath());
            }
            this.deleteEmptyParents(parent, limit);
        }
    }
}

