/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.filetransfer;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTransferUtils {
    private static final String CLASSNAME = "com.ibm.ws.management.filetransfer.FileTransferUtils";
    private static TraceComponent tc = Tr.register(FileTransferUtils.class, "Admin", "com.ibm.ws.management.resources.fileservice");
    private static String blank = "%20";
    private static String PLUS = "-*plus*-";

    public static String urlEncode(String param) {
        int index = 0;
        while ((index = param.indexOf(" ")) != -1) {
            StringBuffer strBuffer = new StringBuffer(param);
            strBuffer.replace(index, index + 1, blank);
            param = strBuffer.toString();
        }
        return param;
    }

    public static String urlDecode(String param) {
        int index = 0;
        while ((index = param.indexOf(blank)) != -1) {
            StringBuffer strBuffer = new StringBuffer(param);
            strBuffer.replace(index, index + blank.length(), " ");
            param = strBuffer.toString();
        }
        return param;
    }

    public static String urlEncodePlus(String param) {
        int index = 0;
        int oldIndex = 0;
        StringBuffer newUrl = null;
        while ((index = param.indexOf("+", oldIndex)) != -1) {
            if (newUrl == null) {
                newUrl = new StringBuffer();
            }
            newUrl.append(param.substring(oldIndex, index));
            newUrl.append(PLUS);
            oldIndex = index + 1;
        }
        if (newUrl != null) {
            newUrl.append(param.substring(oldIndex));
            param = newUrl.toString();
        }
        return param;
    }

    public static String urlDecodePlus(String param) {
        int index = 0;
        int oldIndex = 0;
        StringBuffer newUrl = null;
        while ((index = param.indexOf(PLUS, oldIndex)) != -1) {
            if (newUrl == null) {
                newUrl = new StringBuffer();
            }
            newUrl.append(param.substring(oldIndex, index));
            newUrl.append("+");
            oldIndex = index + PLUS.length();
        }
        if (newUrl != null) {
            newUrl.append(param.substring(oldIndex));
            param = newUrl.toString();
        }
        return param;
    }

    public static String hexString(String text) {
        StringBuffer hex = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            hex.append(Integer.toHexString(c));
            hex.append(" ");
        }
        return hex.toString();
    }

    public static byte[] prop2bytes(Properties p) {
        byte[] buf = null;
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ObjectOutputStream objout = new ObjectOutputStream(bout);
            objout.writeObject(p);
            objout.close();
            buf = bout.toByteArray();
        }
        catch (IOException ioe) {
            FFDCFilter.processException(ioe, "com.ibm.ws.management.filetransfer.FileTransferUtils.prop2bytes", "132");
            Tr.debug(tc, "prop2bytes: error writing Properties object to byte[]: " + ioe);
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties stream2prop(InputStream in) {
        Properties p = null;
        ObjectInputStream oin = null;
        try {
            oin = new ObjectInputStream(in);
            p = (Properties)oin.readObject();
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.management.filetransfer.FileTransferUtils.stream2prop", "153");
            Tr.debug(tc, "stream2prop: error reading Properties object from InputStream: " + e);
        }
        finally {
            if (oin != null) {
                try {
                    oin.close();
                }
                catch (IOException ioe) {
                    FFDCFilter.processException(ioe, "com.ibm.ws.management.filetransfer.FileTransferUtils.stream2prop", "160");
                    Tr.debug(tc, "stream2prop: error closing ObjectInputStream: " + ioe);
                }
            }
        }
        return p;
    }

    public static byte[] map2bytes(Map<String, Serializable> m) {
        byte[] buf = null;
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ObjectOutputStream objout = new ObjectOutputStream(bout);
            objout.writeObject(m);
            objout.close();
            buf = bout.toByteArray();
        }
        catch (IOException ioe) {
            FFDCFilter.processException(ioe, "com.ibm.ws.management.filetransfer.FileTransferUtils.map2bytes", "185");
            Tr.debug(tc, "map2bytes: error writing Map object to byte[]: " + ioe);
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Serializable> stream2map(InputStream in) {
        Map m = null;
        ObjectInputStream oin = null;
        try {
            oin = new ObjectInputStream(in);
            m = (Map)oin.readObject();
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.management.filetransfer.FileTransferUtils.stream2map", "206");
            Tr.debug(tc, "stream2map: error reading Map<String,Serializable> object from InputStream: " + e);
        }
        finally {
            if (oin != null) {
                try {
                    oin.close();
                }
                catch (IOException ioe) {
                    FFDCFilter.processException(ioe, "com.ibm.ws.management.filetransfer.FileTransferUtils.stream2map", "213");
                    Tr.debug(tc, "stream2map: error closing ObjectInputStream: " + ioe);
                }
            }
        }
        return m;
    }
}

