/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ws.management.event.NotificationInfo;
import java.io.Serializable;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class FilterElement
implements Serializable {
    private static final long serialVersionUID = 5020421872211159772L;
    final int listenerId;
    final NotificationInfo info;

    FilterElement(NotificationListener listener, ObjectName name, NotificationFilter filter) {
        this(listener, new NotificationInfo(name, filter));
    }

    FilterElement(NotificationListener listener, NotificationInfo info) {
        this.listenerId = listener.hashCode();
        this.info = info;
    }

    private FilterElement(int listenerId, ObjectName name) {
        this.listenerId = listenerId;
        this.info = new NotificationInfo(name, null);
    }

    public FilterElement(int listenerId, NotificationInfo info) {
        this.listenerId = listenerId;
        this.info = info;
    }

    public boolean isNotificationEnabled(Notification ntfyObj) {
        return this.info.isNotificationEnabled(ntfyObj);
    }

    public boolean listenerMatches(NotificationListener listener) {
        if (listener != null) {
            return listener.hashCode() == this.listenerId;
        }
        return false;
    }

    public boolean matches(ObjectName name, NotificationListener listener) {
        return this.listenerMatches(listener) && (name == null || this.info.getName().equals(name));
    }

    public boolean equals(Object o) {
        if (o != null && o.getClass().equals(this.getClass())) {
            FilterElement entry = (FilterElement)o;
            return entry.listenerId == this.listenerId && entry.info.equals(this.info);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + new Integer(this.listenerId).hashCode();
        result = 37 * result + this.info.hashCode();
        return result;
    }

    public FilterElement elementWithOutFilter() {
        FilterElement noFilter = null;
        noFilter = this.info.getFilter() == null ? this : new FilterElement(this.listenerId, this.info.getName());
        return noFilter;
    }

    public String toString() {
        return "FilterElement:[id=" + this.listenerId + ";info=" + this.info + "]";
    }

    public int getListenerId() {
        return this.listenerId;
    }

    public NotificationInfo getInfo() {
        return this.info;
    }
}

