/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.ipc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSSecurityContext;
import com.ibm.websphere.security.auth.WSSecurityContextException;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.connector.AdminServiceProxy;
import com.ibm.ws.management.connector.ipc.CallData;
import com.ibm.ws.management.connector.ipc.ClientAccessor;
import com.ibm.ws.management.connector.ipc.ConnectionPool;
import com.ibm.ws.management.connector.ipc.ConnectionPoolMgr;
import com.ibm.ws.management.connector.ipc.ResultData;
import com.ibm.ws.management.event.ConsolidatedFilter;
import com.ibm.ws.management.event.ListenerIdentifier;
import com.ibm.ws.management.event.PullRemoteReceiver;
import com.ibm.ws.management.event.PushNotificationListener;
import com.ibm.ws.management.event.RemoteReceiver;
import com.ibm.ws.management.exception.ReceiverNotFoundException;
import com.ibm.ws.management.util.AdminCertificateHelper;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.security.auth.kerberos.KerberosPolicy;
import com.ibm.ws.security.auth.kerberos.KerberosThreadManager;
import com.ibm.ws.security.auth.rsatoken.RSATokenThreadManager;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.ssl.config.SSLConfig;
import com.ibm.wsspi.channel.framework.OutboundVirtualConnection;
import com.ibm.wsspi.ssl.RetrieveSignersHelper;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.security.Security;
import java.security.cert.CertPathValidatorException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.security.auth.Subject;

public class IPCConnectorClient
implements AdminServiceProxy {
    private static TraceComponent tc = Tr.register(IPCConnectorClient.class, "Admin", "com.ibm.ws.management.resources.connector");
    private int clientBufferSize = 8192;
    private boolean privateDebug = false;
    private String host;
    private String port;
    private String user;
    private String password;
    private String shortName;
    private String genericName;
    private String daemonName;
    private boolean securityEnabled;
    private boolean autoAcceptSigner;
    private String loginSource;
    private String authTarget;
    private String krb5Ccache;
    private String krb5Config;
    private String krb5Service;
    private String krb5RefreshingTicket;
    private ConnectionPool connPool;
    private Properties proxyProps;
    private X509Certificate targetCertificate = null;
    private KerberosPolicy kerberosPolicy = null;

    public IPCConnectorClient(Properties props) throws ConnectorException {
        long timeToExpiration;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "IPCConnectorClient");
        }
        this.proxyProps = (Properties)props.clone();
        this.host = this.proxyProps.getProperty("host");
        if (this.host.indexOf(58) > -1 && this.host.indexOf(91) < 0) {
            this.host = "[" + this.host + "]";
        }
        this.port = this.proxyProps.getProperty("port");
        this.user = this.proxyProps.getProperty("username");
        this.password = this.proxyProps.getProperty("password");
        this.securityEnabled = new Boolean(this.proxyProps.getProperty("securityEnabled"));
        this.autoAcceptSigner = new Boolean(this.proxyProps.getProperty("autoAcceptSignerForThisConnectionOnly"));
        this.loginSource = this.proxyProps.getProperty("loginsource");
        this.authTarget = this.proxyProps.getProperty("authTarget");
        this.krb5Ccache = this.proxyProps.getProperty("krb5Ccache");
        this.krb5Config = this.proxyProps.getProperty("krb5Config");
        this.krb5Service = this.proxyProps.getProperty("krb5Service");
        this.krb5RefreshingTicket = this.proxyProps.getProperty("krb5RefreshingTicket");
        int timeoutInSec = 0;
        try {
            timeoutInSec = Integer.parseInt(props.getProperty("com.ibm.IPC.requestTimeout"));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (timeoutInSec == 0) {
            try {
                String rto = System.getProperty("com.ibm.IPC.requestTimeout", "605");
                timeoutInSec = Integer.parseInt(rto);
            }
            catch (NumberFormatException e) {
                timeoutInSec = 185;
            }
        }
        try {
            timeToExpiration = Long.parseLong(props.getProperty("timeToExpiration"));
        }
        catch (NumberFormatException e) {
            timeToExpiration = 365L;
        }
        try {
            this.shortName = props.getProperty("zos.targetServer.serverShortName");
            this.genericName = props.getProperty("zos.targetServer.genericServerName");
            this.daemonName = props.getProperty("zos.targetServer.daemonName");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.shortName == null || this.shortName.length() == 0 || this.genericName == null || this.genericName.length() == 0 || this.daemonName == null || this.daemonName.length() == 0) {
            this.shortName = null;
            this.genericName = null;
            this.daemonName = null;
        }
        ConnectionPoolMgr.getInstance(this.securityEnabled).setReadTimeout(timeoutInSec);
        ConnectionPoolMgr.getInstance(this.securityEnabled).setTimeToExpiration(timeToExpiration);
        this.connPool = ConnectionPoolMgr.getInstance(this.securityEnabled).getConnectionPool(this.host, this.port, this.shortName, this.genericName, this.daemonName);
        boolean serverSecurityOn = this.serverSecurityEnabled();
        if (this.securityEnabled && !serverSecurityOn || !this.securityEnabled && serverSecurityOn) {
            throw new ConnectorException("Client and server security settings do not match");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "IPCConnectorClient");
        }
    }

    public void setUserAndPwd(String uid, String pwd) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setUserAndPwd");
        }
        this.user = uid;
        this.password = pwd;
        this.proxyProps.setProperty("username", this.user);
        this.proxyProps.setProperty("password", this.password);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setUserAndPwd");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillInCredential(CallData callData) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fillInCredential");
        }
        callData.secDataFilled = true;
        if (!AdminCertificateHelper.getInstance().isRSAPropagationEnabled() && SecurityHelper.isKerberosEnabled(this.proxyProps, SecurityContext.isServerProcess())) {
            this.kerberosPolicy = SecurityHelper.retrieveKerberosPolicy(this.proxyProps, SecurityContext.isServerProcess());
        }
        String serviceName = this.host;
        if (SecurityContext.isServerProcess()) {
            this.initCertificate();
            callData.authByToken = true;
            Subject subject = SecurityHelper.retrieveSubject();
            if (subject != null) {
                try {
                    SecurityHelper.getActualSubject(subject);
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.connector.ipc.IPCConnectorClient.fillInCredential", "205", this);
                    subject = null;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Running in server, subject is", subject);
            }
            if (subject != null) {
                WSSecurityContext ctx = SecurityHelper.getHelper().getWSSecurityContext();
                String realm = SecurityHelper.getHelper().getRealm();
                if (ctx != null) {
                    try {
                        if (AdminCertificateHelper.getInstance().isRSAPropagationEnabled()) {
                            this.targetCertificate = SecurityHelper.retrieveRSACertificate(this.proxyProps);
                        }
                        if (this.kerberosPolicy != null) {
                            realm = this.kerberosPolicy.get_realm_name();
                            serviceName = this.kerberosPolicy.get_spn_name();
                        }
                        RSATokenThreadManager.getInstance().setTargetCertificate(this.targetCertificate);
                        byte[] token = ctx.initSecContext(subject, serviceName, realm);
                        callData.token = token;
                    }
                    catch (WSSecurityContextException ex) {
                        Tr.error(tc, "ADMC0076E", ex);
                    }
                    finally {
                        RSATokenThreadManager.getInstance().setTargetCertificate(null);
                    }
                } else {
                    Tr.warning(tc, "WSSecurityContext is null");
                }
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Checking isKerberosPolicyRetrievalInProcess: " + KerberosThreadManager.getInstance().isKerberosPolicyRetrievalInProcess());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Checking authTarget: " + this.authTarget);
            }
            if (!KerberosThreadManager.getInstance().isKerberosPolicyRetrievalInProcess().booleanValue() && this.authTarget != null && this.authTarget.length() > 0 && (this.authTarget.equalsIgnoreCase("KRB5") || this.authTarget.equalsIgnoreCase("Kerberos"))) {
                byte[] token;
                callData.authByToken = true;
                String realm = null;
                String spn = null;
                if (this.kerberosPolicy != null) {
                    realm = this.kerberosPolicy.get_realm_name();
                    spn = this.kerberosPolicy.get_spn_name();
                }
                if ((token = SecurityHelper.getKerberosToken(this.host, this.user, this.password, this.authTarget, this.loginSource, this.krb5Ccache, this.krb5Config, this.krb5Service, this.krb5RefreshingTicket, spn, realm)) == null) {
                    throw new ConnectorException("Kerberos login probably failed; the token is null");
                }
                callData.token = token;
            } else {
                callData.authByToken = false;
                callData.user = this.user;
                callData.password = this.password;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fillInCredential");
        }
    }

    private void initCertificate() {
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "initCertificate");
            }
            try {
                if (!this.securityEnabled || !AdminCertificateHelper.getInstance().isRSAPropagationEnabled() || this.targetCertificate != null) break block12;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "security enabled and RSA certificate of target not yet set");
                }
                CallData certCallData = new CallData();
                certCallData.opName = "getAdminRSAPropagationCertificate";
                try {
                    ResultData result = this.sendReceive(certCallData);
                    if (result.isException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "exception while fetching RSA certification", result.obj);
                        }
                        throw (Exception)result.obj;
                    }
                    this.targetCertificate = (X509Certificate)result.obj;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "got RSA certification", this.targetCertificate);
                    }
                }
                catch (IOException ex) {
                    this.connPool.refresh();
                    ResultData result = this.sendReceive(certCallData);
                    if (result.isException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Error fetching RSA certification on second try", result.obj);
                        }
                        throw (Exception)result.obj;
                    }
                    this.targetCertificate = (X509Certificate)result.obj;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "got RSA certification second try", this.targetCertificate);
                    }
                }
            }
            catch (Throwable t) {
                FFDCFilter.processException(t, "com.ibm.ws.management.connector.ipc.IPCConnectorClient.initCertificate", "289", this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultData sendReceive(CallData callData) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendReceive", callData);
        }
        if (this.securityEnabled) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    IPCConnectorClient.this.setupSslSetting();
                    return null;
                }
            });
        }
        OutboundVirtualConnection ovc = null;
        try {
            ovc = (OutboundVirtualConnection)this.connPool.getConnection();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Connection obtained from pool: " + ovc);
            }
            ClientAccessor accessor = (ClientAccessor)ovc.getChannelAccessor();
            ResultData result = (ResultData)accessor.request(callData);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "sendReceive", result);
            }
            ResultData resultData = result;
            return resultData;
        }
        finally {
            if (ovc != null) {
                this.connPool.putConnection(ovc);
            }
        }
    }

    private boolean serverSecurityEnabled() throws ConnectorException {
        CallData callData = new CallData();
        ResultData result = null;
        Exception _ex = null;
        callData.opName = "serverSecurityEnabled";
        try {
            try {
                result = this.sendReceive(callData);
            }
            catch (IOException e) {
                this.connPool.refresh();
                result = this.sendReceive(callData);
            }
        }
        catch (Exception e) {
            _ex = e;
        }
        if (_ex == null) {
            if (result.isException) {
                _ex = (Exception)result.obj;
            } else {
                return (Boolean)result.obj;
            }
        }
        if (_ex instanceof RuntimeException) {
            throw (RuntimeException)_ex;
        }
        if (_ex instanceof ConnectorException) {
            throw (ConnectorException)_ex;
        }
        throw new ConnectorException(_ex);
    }

    public String getType() {
        return "IPC";
    }

    public Properties getProxyProperties() {
        return this.proxyProps;
    }

    public RemoteReceiver openRemoteNotificationChannel(AdminServiceProxy proxy) {
        return new PullRemoteReceiver(proxy);
    }

    public Session isAlive() throws ConnectorException {
        CallData callData = new CallData();
        ResultData result = null;
        Exception _ex = null;
        callData.opName = "isAlive";
        try {
            try {
                result = this.sendReceive(callData);
            }
            catch (IOException e) {
                this.connPool.refresh();
                result = this.sendReceive(callData);
            }
        }
        catch (Exception e) {
            _ex = e;
        }
        if (_ex == null) {
            if (result.isException) {
                _ex = (Exception)result.obj;
            } else {
                return (Session)result.obj;
            }
        }
        if (_ex instanceof RuntimeException) {
            throw (RuntimeException)_ex;
        }
        if (_ex instanceof ConnectorException) {
            throw (ConnectorException)_ex;
        }
        throw new ConnectorException(_ex);
    }

    public Session isAlive(int timeout) throws ConnectorException {
        CallData callData = new CallData();
        ResultData result = null;
        Exception _ex = null;
        callData.opName = "isAlive_i";
        callData.paramObj1 = new Integer(timeout);
        try {
            try {
                result = this.sendReceive(callData);
            }
            catch (IOException e) {
                this.connPool.refresh();
                result = this.sendReceive(callData);
            }
        }
        catch (Exception e) {
            _ex = e;
        }
        if (_ex == null) {
            if (result.isException) {
                _ex = (Exception)result.obj;
            } else {
                return (Session)result.obj;
            }
        }
        if (_ex instanceof RuntimeException) {
            throw (RuntimeException)_ex;
        }
        if (_ex instanceof ConnectorException) {
            throw (ConnectorException)_ex;
        }
        throw new ConnectorException(_ex);
    }

    public Set queryNames(ObjectName name, QueryExp query) throws ConnectorException {
        CallData callData = new CallData();
        ResultData result = null;
        Exception _ex = null;
        callData.opName = "queryNames";
        callData.objName = name;
        callData.paramObj1 = query;
        for (int i = 0; i < 2; ++i) {
            result = null;
            _ex = null;
            if (this.securityEnabled) {
                this.fillInCredential(callData);
            }
            try {
                try {
                    result = this.sendReceive(callData);
                }
                catch (IOException e) {
                    this.connPool.refresh();
                    result = this.sendReceive(callData);
                }
            }
            catch (Exception e) {
                _ex = e;
            }
            if (result == null || !result.isException || !IPCConnectorClient.isCertPathValidatorException(result.obj)) break;
            this.targetCertificate = null;
        }
        if (_ex == null) {
            if (result.isException) {
                _ex = (Exception)result.obj;
            } else {
                return (Set)result.obj;
            }
        }
        if (_ex instanceof RuntimeException) {
            throw (RuntimeException)_ex;
        }
        if (_ex instanceof ConnectorException) {
            throw (ConnectorException)_ex;
        }
        throw new ConnectorException(_ex);
    }

    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, ConnectorException {
        CallData callData = new CallData();
        ResultData result = null;
        Exception _ex = null;
        callData.opName = "getAttribute";
        callData.objName = name;
        callData.paramObj1 = attribute;
        for (int i = 0; i < 2; ++i) {
            result = null;
            _ex = null;
            if (this.securityEnabled) {
                this.fillInCredential(callData);
            }
            try {
                try {
                    result = this.sendReceive(callData);
                }
                catch (IOException e) {
                    this.connPool.refresh();
                    result = this.sendReceive(callData);
                }
            }
            catch (Exception e) {
                _ex = e;
            }
            if (result == null || !result.isException || !IPCConnectorClient.isCertPathValidatorException(result.obj)) break;
            this.targetCertificate = null;
        }
        if (_ex == null) {
            if (result.isException) {
                _ex = (Exception)result.obj;
            } else {
                return result.obj;
            }
        }
        if (_ex instanceof RuntimeException) {
            throw (RuntimeException)_ex;
        }
        if (_ex instanceof ConnectorException) {
            throw (ConnectorException)_ex;
        }
        if (_ex instanceof InstanceNotFoundException) {
            throw (InstanceNotFoundException)_ex;
        }
        if (_ex instanceof AttributeNotFoundException) {
            throw (AttributeNotFoundException)_ex;
        }
        if (_ex instanceof MBeanException) {
            throw (MBeanException)_ex;
        }
        if (_ex instanceof ReflectionException) {
            throw (ReflectionException)_ex;
        }
        throw new ConnectorException(_ex);
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException, ConnectorException {
        CallData callData = new CallData();
        ResultData result = null;
        Exception _ex = null;
        callData.opName = "getAttributes";
        callData.objName = name;
        callData.paramObj1 = attributes;
        for (int i = 0; i < 2; ++i) {
            result = null;
            _ex = null;
            if (this.securityEnabled) {
                this.fillInCredential(callData);
            }
            try {
                try {
                    result = this.sendReceive(callData);
                }
                catch (IOException e) {
                    this.connPool.refresh();
                    result = this.sendReceive(callData);
                }
            }
            catch (Exception e) {
                _ex = e;
            }
            if (result == null || !result.isException || !IPCConnectorClient.isCertPathValidatorException(result.obj)) break;
            this.targetCertificate = null;
        }
        if (_ex == null) {
            if (result.isException) {
                _ex = (Exception)result.obj;
            } else {
                return (AttributeList)result.obj;
            }
        }
        if (_ex instanceof RuntimeException) {
            throw (RuntimeException)_ex;
        }
        if (_ex instanceof ConnectorException) {
            throw (ConnectorException)_ex;
        }
        if (_ex instanceof InstanceNotFoundException) {
            throw (InstanceNotFoundException)_ex;
        }
        if (_ex instanceof ReflectionException) {
            throw (ReflectionException)_ex;
        }
        throw new ConnectorException(_ex);
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, ConnectorException {
        CallData callData = new CallData();
        ResultData result = null;
        Exception _ex = null;
        callData.opName = "setAttribute";
        callData.objName = name;
        callData.paramObj1 = attribute;
        for (int i = 0; i < 2; ++i) {
            result = null;
            _ex = null;
            if (this.securityEnabled) {
                this.fillInCredential(callData);
            }
            try {
                try {
                    result = this.sendReceive(callData);
                }
                catch (IOException e) {
                    this.connPool.refresh();
                    result = this.sendReceive(callData);
                }
            }
            catch (Exception e) {
                _ex = e;
            }
            if (result == null || !result.isException || !IPCConnectorClient.isCertPathValidatorException(result.obj)) break;
            this.targetCertificate = null;
        }
        if (_ex == null) {
            if (result.isException) {
                _ex = (Exception)result.obj;
            } else {
                return;
            }
        }
        if (_ex instanceof RuntimeException) {
            throw (RuntimeException)_ex;
        }
        if (_ex instanceof ConnectorException) {
            throw (ConnectorException)_ex;
        }
        if (_ex instanceof InstanceNotFoundException) {
            throw (InstanceNotFoundException)_ex;
        }
        if (_ex instanceof AttributeNotFoundException) {
            throw (AttributeNotFoundException)_ex;
        }
        if (_ex instanceof MBeanException) {
            throw (MBeanException)_ex;
        }
        if (_ex instanceof ReflectionException) {
            throw (ReflectionException)_ex;
        }
        throw new ConnectorException(_ex);
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException, ConnectorException {
        CallData callData = new CallData();
        ResultData result = null;
        Exception _ex = null;
        callData.opName = "setAttributes";
        callData.objName = name;
        callData.paramObj1 = attributes;
        for (int i = 0; i < 2; ++i) {
            result = null;
            _ex = null;
            if (this.securityEnabled) {
                this.fillInCredential(callData);
            }
            try {
                try {
                    result = this.sendReceive(callData);
                }
                catch (IOException e) {
                    this.connPool.refresh();
                    result = this.sendReceive(callData);
                }
            }
            catch (Exception e) {
                _ex = e;
            }
            if (result == null || !result.isException || !IPCConnectorClient.isCertPathValidatorException(result.obj)) break;
            this.targetCertificate = null;
        }
        if (_ex == null) {
            if (result.isException) {
                _ex = (Exception)result.obj;
            } else {
                return (AttributeList)result.obj;
            }
        }
        if (_ex instanceof RuntimeException) {
            throw (RuntimeException)_ex;
        }
        if (_ex instanceof ConnectorException) {
            throw (ConnectorException)_ex;
        }
        if (_ex instanceof InstanceNotFoundException) {
            throw (InstanceNotFoundException)_ex;
        }
        if (_ex instanceof ReflectionException) {
            throw (ReflectionException)_ex;
        }
        throw new ConnectorException(_ex);
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException, ConnectorException {
        CallData callData = new CallData();
        ResultData result = null;
        Exception _ex = null;
        callData.opName = "invoke";
        callData.invokeOpName = operationName;
        callData.objName = name;
        callData.paramObj1 = params;
        callData.paramObj2 = signature;
        for (int i = 0; i < 2; ++i) {
            result = null;
            _ex = null;
            if (this.securityEnabled) {
                this.fillInCredential(callData);
            }
            try {
                try {
                    result = this.sendReceive(callData);
                }
                catch (IOException e) {
                    this.connPool.refresh();
                    result = this.sendReceive(callData);
                }
            }
            catch (Exception e) {
                _ex = e;
            }
            if (result == null || !result.isException || !IPCConnectorClient.isCertPathValidatorException(result.obj)) break;
            this.targetCertificate = null;
        }
        if (_ex == null) {
            if (result.isException) {
                _ex = (Exception)result.obj;
            } else {
                return result.obj;
            }
        }
        if (_ex instanceof RuntimeException) {
            throw (RuntimeException)_ex;
        }
        if (_ex instanceof ConnectorException) {
            throw (ConnectorException)_ex;
        }
        if (_ex instanceof InstanceNotFoundException) {
            throw (InstanceNotFoundException)_ex;
        }
        if (_ex instanceof MBeanException) {
            throw (MBeanException)_ex;
        }
        if (_ex instanceof ReflectionException) {
            throw (ReflectionException)_ex;
        }
        throw new ConnectorException(_ex);
    }

    public String getDefaultDomain() throws ConnectorException {
        CallData callData = new CallData();
        ResultData result = null;
        Exception _ex = null;
        callData.opName = "getDefaultDomain";
        for (int i = 0; i < 2; ++i) {
            result = null;
            _ex = null;
            if (this.securityEnabled) {
                this.fillInCredential(callData);
            }
            try {
                try {
                    result = this.sendReceive(callData);
                }
                catch (IOException e) {
                    this.connPool.refresh();
                    result = this.sendReceive(callData);
                }
            }
            catch (Exception e) {
                _ex = e;
            }
            if (result == null || !result.isException || !IPCConnectorClient.isCertPathValidatorException(result.obj)) break;
            this.targetCertificate = null;
        }
        if (_ex == null) {
            if (result.isException) {
                _ex = (Exception)result.obj;
            } else {
                return (String)result.obj;
            }
        }
        if (_ex instanceof RuntimeException) {
            throw (RuntimeException)_ex;
        }
        if (_ex instanceof ConnectorException) {
            throw (ConnectorException)_ex;
        }
        throw new ConnectorException(_ex);
    }

    public String getDomainName() throws ConnectorException {
        CallData callData = new CallData();
        ResultData result = null;
        Exception _ex = null;
        callData.opName = "getDomainName";
        for (int i = 0; i < 2; ++i) {
            result = null;
            _ex = null;
            if (this.securityEnabled) {
                this.fillInCredential(callData);
            }
            try {
                try {
                    result = this.sendReceive(callData);
                }
                catch (IOException e) {
                    this.connPool.refresh();
                    result = this.sendReceive(callData);
                }
            }
            catch (Exception e) {
                _ex = e;
            }
            if (result == null || !result.isException || !IPCConnectorClient.isCertPathValidatorException(result.obj)) break;
            this.targetCertificate = null;
        }
        if (_ex == null) {
            if (result.isException) {
                _ex = (Exception)result.obj;
            } else {
                return (String)result.obj;
            }
        }
        if (_ex instanceof RuntimeException) {
            throw (RuntimeException)_ex;
        }
        if (_ex instanceof ConnectorException) {
            throw (ConnectorException)_ex;
        }
        throw new ConnectorException(_ex);
    }

    public Integer getMBeanCount() throws ConnectorException {
        CallData callData = new CallData();
        ResultData result = null;
        Exception _ex = null;
        callData.opName = "getMBeanCount";
        for (int i = 0; i < 2; ++i) {
            result = null;
            _ex = null;
            if (this.securityEnabled) {
                this.fillInCredential(callData);
            }
            try {
                try {
                    result = this.sendReceive(callData);
                }
                catch (IOException e) {
                    this.connPool.refresh();
                    result = this.sendReceive(callData);
                }
            }
            catch (Exception e) {
                _ex = e;
            }
            if (result == null || !result.isException || !IPCConnectorClient.isCertPathValidatorException(result.obj)) break;
            this.targetCertificate = null;
        }
        if (_ex == null) {
            if (result.isException) {
                _ex = (Exception)result.obj;
            } else {
                return (Integer)result.obj;
            }
        }
        if (_ex instanceof RuntimeException) {
            throw (RuntimeException)_ex;
        }
        if (_ex instanceof ConnectorException) {
            throw (ConnectorException)_ex;
        }
        throw new ConnectorException(_ex);
    }

    public ObjectName getServerMBean() throws ConnectorException {
        CallData callData = new CallData();
        ResultData result = null;
        Exception _ex = null;
        callData.opName = "getServerMBean";
        for (int i = 0; i < 2; ++i) {
            result = null;
            _ex = null;
            if (this.securityEnabled) {
                this.fillInCredential(callData);
            }
            try {
                try {
                    result = this.sendReceive(callData);
                }
                catch (IOException e) {
                    this.connPool.refresh();
                    result = this.sendReceive(callData);
                }
            }
            catch (Exception e) {
                _ex = e;
            }
            if (result == null || !result.isException || !IPCConnectorClient.isCertPathValidatorException(result.obj)) break;
            this.targetCertificate = null;
        }
        if (_ex == null) {
            if (result.isException) {
                _ex = (Exception)result.obj;
            } else {
                return (ObjectName)result.obj;
            }
        }
        if (_ex instanceof RuntimeException) {
            throw (RuntimeException)_ex;
        }
        if (_ex instanceof ConnectorException) {
            throw (ConnectorException)_ex;
        }
        throw new ConnectorException(_ex);
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException, ConnectorException {
        CallData callData = new CallData();
        ResultData result = null;
        Exception _ex = null;
        callData.opName = "getMBeanInfo";
        callData.objName = name;
        for (int i = 0; i < 2; ++i) {
            result = null;
            _ex = null;
            if (this.securityEnabled) {
                this.fillInCredential(callData);
            }
            try {
                try {
                    result = this.sendReceive(callData);
                }
                catch (IOException e) {
                    this.connPool.refresh();
                    result = this.sendReceive(callData);
                }
            }
            catch (Exception e) {
                _ex = e;
            }
            if (result == null || !result.isException || !IPCConnectorClient.isCertPathValidatorException(result.obj)) break;
            this.targetCertificate = null;
        }
        if (_ex == null) {
            if (result.isException) {
                _ex = (Exception)result.obj;
            } else {
                return (MBeanInfo)result.obj;
            }
        }
        if (_ex instanceof RuntimeException) {
            throw (RuntimeException)_ex;
        }
        if (_ex instanceof ConnectorException) {
            throw (ConnectorException)_ex;
        }
        if (_ex instanceof InstanceNotFoundException) {
            throw (InstanceNotFoundException)_ex;
        }
        if (_ex instanceof IntrospectionException) {
            throw (IntrospectionException)_ex;
        }
        if (_ex instanceof ReflectionException) {
            throw (ReflectionException)_ex;
        }
        throw new ConnectorException(_ex);
    }

    public boolean isRegistered(ObjectName name) throws ConnectorException {
        CallData callData = new CallData();
        ResultData result = null;
        Exception _ex = null;
        callData.opName = "isRegistered";
        callData.objName = name;
        for (int i = 0; i < 2; ++i) {
            result = null;
            _ex = null;
            if (this.securityEnabled) {
                this.fillInCredential(callData);
            }
            try {
                try {
                    result = this.sendReceive(callData);
                }
                catch (IOException e) {
                    this.connPool.refresh();
                    result = this.sendReceive(callData);
                }
            }
            catch (Exception e) {
                _ex = e;
            }
            if (result == null || !result.isException || !IPCConnectorClient.isCertPathValidatorException(result.obj)) break;
            this.targetCertificate = null;
        }
        if (_ex == null) {
            if (result.isException) {
                _ex = (Exception)result.obj;
            } else {
                return (Boolean)result.obj;
            }
        }
        if (_ex instanceof RuntimeException) {
            throw (RuntimeException)_ex;
        }
        if (_ex instanceof ConnectorException) {
            throw (ConnectorException)_ex;
        }
        throw new ConnectorException(_ex);
    }

    public ClassLoader getClassLoaderFor(ObjectName name) throws InstanceNotFoundException, ConnectorException {
        CallData callData = new CallData();
        ResultData result = null;
        Exception _ex = null;
        callData.opName = "getClassLoaderFor";
        callData.objName = name;
        for (int i = 0; i < 2; ++i) {
            result = null;
            _ex = null;
            if (this.securityEnabled) {
                this.fillInCredential(callData);
            }
            try {
                try {
                    result = this.sendReceive(callData);
                }
                catch (IOException e) {
                    this.connPool.refresh();
                    result = this.sendReceive(callData);
                }
            }
            catch (Exception e) {
                _ex = e;
            }
            if (result == null || !result.isException || !IPCConnectorClient.isCertPathValidatorException(result.obj)) break;
            this.targetCertificate = null;
        }
        if (_ex == null) {
            if (result.isException) {
                _ex = (Exception)result.obj;
            } else {
                return (ClassLoader)result.obj;
            }
        }
        if (_ex instanceof RuntimeException) {
            throw (RuntimeException)_ex;
        }
        if (_ex instanceof ConnectorException) {
            throw (ConnectorException)_ex;
        }
        if (_ex instanceof InstanceNotFoundException) {
            throw (InstanceNotFoundException)_ex;
        }
        throw new ConnectorException(_ex);
    }

    public ClassLoader getClassLoader(ObjectName name) throws InstanceNotFoundException, ConnectorException {
        CallData callData = new CallData();
        ResultData result = null;
        Exception _ex = null;
        callData.opName = "getClassLoader";
        callData.objName = name;
        for (int i = 0; i < 2; ++i) {
            result = null;
            _ex = null;
            if (this.securityEnabled) {
                this.fillInCredential(callData);
            }
            try {
                try {
                    result = this.sendReceive(callData);
                }
                catch (IOException e) {
                    this.connPool.refresh();
                    result = this.sendReceive(callData);
                }
            }
            catch (Exception e) {
                _ex = e;
            }
            if (result == null || !result.isException || !IPCConnectorClient.isCertPathValidatorException(result.obj)) break;
            this.targetCertificate = null;
        }
        if (_ex == null) {
            if (result.isException) {
                _ex = (Exception)result.obj;
            } else {
                return (ClassLoader)result.obj;
            }
        }
        if (_ex instanceof RuntimeException) {
            throw (RuntimeException)_ex;
        }
        if (_ex instanceof ConnectorException) {
            throw (ConnectorException)_ex;
        }
        if (_ex instanceof InstanceNotFoundException) {
            throw (InstanceNotFoundException)_ex;
        }
        throw new ConnectorException(_ex);
    }

    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException, ConnectorException {
        CallData callData = new CallData();
        ResultData result = null;
        Exception _ex = null;
        callData.opName = "isInstanceOf";
        callData.objName = name;
        callData.paramObj1 = className;
        for (int i = 0; i < 2; ++i) {
            result = null;
            _ex = null;
            if (this.securityEnabled) {
                this.fillInCredential(callData);
            }
            try {
                try {
                    result = this.sendReceive(callData);
                }
                catch (IOException e) {
                    this.connPool.refresh();
                    result = this.sendReceive(callData);
                }
            }
            catch (Exception e) {
                _ex = e;
            }
            if (result == null || !result.isException || !IPCConnectorClient.isCertPathValidatorException(result.obj)) break;
            this.targetCertificate = null;
        }
        if (_ex == null) {
            if (result.isException) {
                _ex = (Exception)result.obj;
            } else {
                return (Boolean)result.obj;
            }
        }
        if (_ex instanceof RuntimeException) {
            throw (RuntimeException)_ex;
        }
        if (_ex instanceof ConnectorException) {
            throw (ConnectorException)_ex;
        }
        if (_ex instanceof InstanceNotFoundException) {
            throw (InstanceNotFoundException)_ex;
        }
        throw new ConnectorException(_ex);
    }

    public Set queryMBeans(ObjectName name, QueryExp query) throws ConnectorException {
        CallData callData = new CallData();
        ResultData result = null;
        Exception _ex = null;
        callData.opName = "queryMBeans";
        callData.objName = name;
        callData.paramObj1 = query;
        for (int i = 0; i < 2; ++i) {
            result = null;
            _ex = null;
            if (this.securityEnabled) {
                this.fillInCredential(callData);
            }
            try {
                try {
                    result = this.sendReceive(callData);
                }
                catch (IOException e) {
                    this.connPool.refresh();
                    result = this.sendReceive(callData);
                }
            }
            catch (Exception e) {
                _ex = e;
            }
            if (result == null || !result.isException || !IPCConnectorClient.isCertPathValidatorException(result.obj)) break;
            this.targetCertificate = null;
        }
        if (_ex == null) {
            if (result.isException) {
                _ex = (Exception)result.obj;
            } else {
                return (Set)result.obj;
            }
        }
        if (_ex instanceof RuntimeException) {
            throw (RuntimeException)_ex;
        }
        if (_ex instanceof ConnectorException) {
            throw (ConnectorException)_ex;
        }
        throw new ConnectorException(_ex);
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException, ConnectorException {
        CallData callData = new CallData();
        ResultData result = null;
        Exception _ex = null;
        callData.opName = "getObjectInstance";
        callData.objName = name;
        for (int i = 0; i < 2; ++i) {
            result = null;
            _ex = null;
            if (this.securityEnabled) {
                this.fillInCredential(callData);
            }
            try {
                try {
                    result = this.sendReceive(callData);
                }
                catch (IOException e) {
                    this.connPool.refresh();
                    result = this.sendReceive(callData);
                }
            }
            catch (Exception e) {
                _ex = e;
            }
            if (result == null || !result.isException || !IPCConnectorClient.isCertPathValidatorException(result.obj)) break;
            this.targetCertificate = null;
        }
        if (_ex == null) {
            if (result.isException) {
                _ex = (Exception)result.obj;
            } else {
                return (ObjectInstance)result.obj;
            }
        }
        if (_ex instanceof RuntimeException) {
            throw (RuntimeException)_ex;
        }
        if (_ex instanceof ConnectorException) {
            throw (ConnectorException)_ex;
        }
        if (_ex instanceof InstanceNotFoundException) {
            throw (InstanceNotFoundException)_ex;
        }
        throw new ConnectorException(_ex);
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ConnectorException {
        CallData callData = new CallData();
        ResultData result = null;
        Exception _ex = null;
        callData.opName = "addNotificationListener_ON_ON_NF_O";
        callData.objName = name;
        callData.paramObj1 = listener;
        callData.paramObj2 = filter;
        callData.paramObj3 = handback;
        for (int i = 0; i < 2; ++i) {
            result = null;
            _ex = null;
            if (this.securityEnabled) {
                this.fillInCredential(callData);
            }
            try {
                try {
                    result = this.sendReceive(callData);
                }
                catch (IOException e) {
                    this.connPool.refresh();
                    result = this.sendReceive(callData);
                }
            }
            catch (Exception e) {
                _ex = e;
            }
            if (result == null || !result.isException || !IPCConnectorClient.isCertPathValidatorException(result.obj)) break;
            this.targetCertificate = null;
        }
        if (_ex == null) {
            if (result.isException) {
                _ex = (Exception)result.obj;
            } else {
                return;
            }
        }
        if (_ex instanceof RuntimeException) {
            throw (RuntimeException)_ex;
        }
        if (_ex instanceof ConnectorException) {
            throw (ConnectorException)_ex;
        }
        if (_ex instanceof InstanceNotFoundException) {
            throw (InstanceNotFoundException)_ex;
        }
        throw new ConnectorException(_ex);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ConnectorException, ListenerNotFoundException {
        CallData callData = new CallData();
        ResultData result = null;
        Exception _ex = null;
        callData.opName = "removeNotificationListener_ON_ON";
        callData.objName = name;
        callData.paramObj1 = listener;
        for (int i = 0; i < 2; ++i) {
            result = null;
            _ex = null;
            if (this.securityEnabled) {
                this.fillInCredential(callData);
            }
            try {
                try {
                    result = this.sendReceive(callData);
                }
                catch (IOException e) {
                    this.connPool.refresh();
                    result = this.sendReceive(callData);
                }
            }
            catch (Exception e) {
                _ex = e;
            }
            if (result == null || !result.isException || !IPCConnectorClient.isCertPathValidatorException(result.obj)) break;
            this.targetCertificate = null;
        }
        if (_ex == null) {
            if (result.isException) {
                _ex = (Exception)result.obj;
            } else {
                return;
            }
        }
        if (_ex instanceof RuntimeException) {
            throw (RuntimeException)_ex;
        }
        if (_ex instanceof ConnectorException) {
            throw (ConnectorException)_ex;
        }
        if (_ex instanceof InstanceNotFoundException) {
            throw (InstanceNotFoundException)_ex;
        }
        if (_ex instanceof ListenerNotFoundException) {
            throw (ListenerNotFoundException)_ex;
        }
        throw new ConnectorException(_ex);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ConnectorException, ListenerNotFoundException {
        CallData callData = new CallData();
        ResultData result = null;
        Exception _ex = null;
        callData.opName = "removeNotificationListener_ON_ON_NF_O";
        callData.objName = name;
        callData.paramObj1 = listener;
        callData.paramObj2 = filter;
        callData.paramObj3 = handback;
        for (int i = 0; i < 2; ++i) {
            result = null;
            _ex = null;
            if (this.securityEnabled) {
                this.fillInCredential(callData);
            }
            try {
                try {
                    result = this.sendReceive(callData);
                }
                catch (IOException e) {
                    this.connPool.refresh();
                    result = this.sendReceive(callData);
                }
            }
            catch (Exception e) {
                _ex = e;
            }
            if (result == null || !result.isException || !IPCConnectorClient.isCertPathValidatorException(result.obj)) break;
            this.targetCertificate = null;
        }
        if (_ex == null) {
            if (result.isException) {
                _ex = (Exception)result.obj;
            } else {
                return;
            }
        }
        if (_ex instanceof RuntimeException) {
            throw (RuntimeException)_ex;
        }
        if (_ex instanceof ConnectorException) {
            throw (ConnectorException)_ex;
        }
        if (_ex instanceof InstanceNotFoundException) {
            throw (InstanceNotFoundException)_ex;
        }
        if (_ex instanceof ListenerNotFoundException) {
            throw (ListenerNotFoundException)_ex;
        }
        throw new ConnectorException(_ex);
    }

    public ListenerIdentifier addNotificationListener(ConsolidatedFilter filter, PushNotificationListener listener) throws ConnectorException {
        CallData callData = new CallData();
        ResultData result = null;
        Exception _ex = null;
        callData.opName = "addNotificationListener_CF_PNL";
        callData.paramObj1 = filter;
        callData.paramObj2 = listener;
        for (int i = 0; i < 2; ++i) {
            result = null;
            _ex = null;
            if (this.securityEnabled) {
                this.fillInCredential(callData);
            }
            try {
                try {
                    result = this.sendReceive(callData);
                }
                catch (IOException e) {
                    this.connPool.refresh();
                    result = this.sendReceive(callData);
                }
            }
            catch (Exception e) {
                _ex = e;
            }
            if (result == null || !result.isException || !IPCConnectorClient.isCertPathValidatorException(result.obj)) break;
            this.targetCertificate = null;
        }
        if (_ex == null) {
            if (result.isException) {
                _ex = (Exception)result.obj;
            } else {
                return (ListenerIdentifier)result.obj;
            }
        }
        if (_ex instanceof RuntimeException) {
            throw (RuntimeException)_ex;
        }
        if (_ex instanceof ConnectorException) {
            throw (ConnectorException)_ex;
        }
        throw new ConnectorException(_ex);
    }

    public void removeNotificationListener(ListenerIdentifier listenerId) throws ReceiverNotFoundException, ConnectorException {
        CallData callData = new CallData();
        ResultData result = null;
        Exception _ex = null;
        callData.opName = "removeNotificationListener_LI";
        callData.paramObj1 = listenerId;
        for (int i = 0; i < 2; ++i) {
            result = null;
            _ex = null;
            if (this.securityEnabled) {
                this.fillInCredential(callData);
            }
            try {
                try {
                    result = this.sendReceive(callData);
                }
                catch (IOException e) {
                    this.connPool.refresh();
                    result = this.sendReceive(callData);
                }
            }
            catch (Exception e) {
                _ex = e;
            }
            if (result == null || !result.isException || !IPCConnectorClient.isCertPathValidatorException(result.obj)) break;
            this.targetCertificate = null;
        }
        if (_ex == null) {
            if (result.isException) {
                _ex = (Exception)result.obj;
            } else {
                return;
            }
        }
        if (_ex instanceof RuntimeException) {
            throw (RuntimeException)_ex;
        }
        if (_ex instanceof ConnectorException) {
            throw (ConnectorException)_ex;
        }
        if (_ex instanceof ReceiverNotFoundException) {
            throw (ReceiverNotFoundException)_ex;
        }
        throw new ConnectorException(_ex);
    }

    public void resetFilter(ListenerIdentifier listenerId, ConsolidatedFilter filters) throws ReceiverNotFoundException, ConnectorException {
        CallData callData = new CallData();
        ResultData result = null;
        Exception _ex = null;
        callData.opName = "resetFilter";
        callData.paramObj1 = listenerId;
        callData.paramObj2 = filters;
        for (int i = 0; i < 2; ++i) {
            result = null;
            _ex = null;
            if (this.securityEnabled) {
                this.fillInCredential(callData);
            }
            try {
                try {
                    result = this.sendReceive(callData);
                }
                catch (IOException e) {
                    this.connPool.refresh();
                    result = this.sendReceive(callData);
                }
            }
            catch (Exception e) {
                _ex = e;
            }
            if (result == null || !result.isException || !IPCConnectorClient.isCertPathValidatorException(result.obj)) break;
            this.targetCertificate = null;
        }
        if (_ex == null) {
            if (result.isException) {
                _ex = (Exception)result.obj;
            } else {
                return;
            }
        }
        if (_ex instanceof RuntimeException) {
            throw (RuntimeException)_ex;
        }
        if (_ex instanceof ConnectorException) {
            throw (ConnectorException)_ex;
        }
        if (_ex instanceof ReceiverNotFoundException) {
            throw (ReceiverNotFoundException)_ex;
        }
        throw new ConnectorException(_ex);
    }

    public Notification[] pullNotifications(ListenerIdentifier id, Integer batchSize) throws ReceiverNotFoundException, ConnectorException {
        CallData callData = new CallData();
        ResultData result = null;
        Exception _ex = null;
        callData.opName = "pullNotifications";
        callData.paramObj1 = id;
        callData.paramObj2 = batchSize;
        for (int i = 0; i < 2; ++i) {
            result = null;
            _ex = null;
            if (this.securityEnabled) {
                this.fillInCredential(callData);
            }
            try {
                try {
                    result = this.sendReceive(callData);
                }
                catch (IOException e) {
                    this.connPool.refresh();
                    result = this.sendReceive(callData);
                }
            }
            catch (Exception e) {
                _ex = e;
            }
            if (result == null || !result.isException || !IPCConnectorClient.isCertPathValidatorException(result.obj)) break;
            this.targetCertificate = null;
        }
        if (_ex == null) {
            if (result.isException) {
                _ex = (Exception)result.obj;
            } else {
                return (Notification[])result.obj;
            }
        }
        if (_ex instanceof RuntimeException) {
            throw (RuntimeException)_ex;
        }
        if (_ex instanceof ConnectorException) {
            throw (ConnectorException)_ex;
        }
        if (_ex instanceof ReceiverNotFoundException) {
            throw (ReceiverNotFoundException)_ex;
        }
        throw new ConnectorException(_ex);
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException, ConnectorException {
        CallData callData = new CallData();
        ResultData result = null;
        Exception _ex = null;
        callData.opName = "removeNotificationListener_ON_NL";
        callData.objName = name;
        callData.paramObj1 = listener;
        for (int i = 0; i < 2; ++i) {
            result = null;
            _ex = null;
            if (this.securityEnabled) {
                this.fillInCredential(callData);
            }
            try {
                try {
                    result = this.sendReceive(callData);
                }
                catch (IOException e) {
                    this.connPool.refresh();
                    result = this.sendReceive(callData);
                }
            }
            catch (Exception e) {
                _ex = e;
            }
            if (result == null || !result.isException || !IPCConnectorClient.isCertPathValidatorException(result.obj)) break;
            this.targetCertificate = null;
        }
        if (_ex == null) {
            if (result.isException) {
                _ex = (Exception)result.obj;
            } else {
                return;
            }
        }
        if (_ex instanceof RuntimeException) {
            throw (RuntimeException)_ex;
        }
        if (_ex instanceof ConnectorException) {
            throw (ConnectorException)_ex;
        }
        if (_ex instanceof InstanceNotFoundException) {
            throw (InstanceNotFoundException)_ex;
        }
        if (_ex instanceof ListenerNotFoundException) {
            throw (ListenerNotFoundException)_ex;
        }
        throw new ConnectorException(_ex);
    }

    public void removeNotificationListenerExtended(NotificationListener listener) throws ListenerNotFoundException, ConnectorException {
        throw new UnsupportedOperationException("removeNotificationListenerExtended in IPC connetor");
    }

    public void removeNotificationListenerExtended(ObjectName name, NotificationListener listener) throws ListenerNotFoundException, ConnectorException {
        throw new UnsupportedOperationException("removeNotificationListenerExtended in IPC connetor");
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ConnectorException {
        throw new UnsupportedOperationException("addNotificationListener in IPC connetor");
    }

    public void addNotificationListenerExtended(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws ConnectorException {
        throw new UnsupportedOperationException("addNotificationListenerExtended in IPC connetor");
    }

    public static boolean isCertPathValidatorException(Object obj) {
        WSSecurityException ex2;
        Throwable th2;
        WSSecurityContextException ex1;
        Throwable th1;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isCertPathValidatorException", obj);
        }
        boolean ret = false;
        if (obj != null && obj instanceof WSSecurityContextException && (th1 = (ex1 = (WSSecurityContextException)obj).getCause()) != null && th1 instanceof WSSecurityException && (th2 = (ex2 = (WSSecurityException)th1).getCause()) != null && th2 instanceof CertPathValidatorException) {
            ret = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isCertPathValidatorException: " + ret);
        }
        return ret;
    }

    private void setupSslSetting() {
        block38: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setupSslSetting");
            }
            try {
                String contextProvider;
                String keyStorePassword;
                String keyStoreType;
                String keyStore;
                String trustStorePassword;
                String trustStoreType;
                String trustStore = this.proxyProps.getProperty("javax.net.ssl.trustStore");
                if (trustStore == null) {
                    trustStore = this.proxyProps.getProperty("com.ibm.ssl.trustStore");
                }
                if ((trustStoreType = this.proxyProps.getProperty("javax.net.ssl.trustStoreType")) == null) {
                    trustStoreType = this.proxyProps.getProperty("com.ibm.ssl.trustStoreType");
                }
                if ((trustStorePassword = this.proxyProps.getProperty("javax.net.ssl.trustStorePassword")) == null) {
                    trustStorePassword = this.proxyProps.getProperty("com.ibm.ssl.trustStorePassword");
                }
                if ((keyStore = this.proxyProps.getProperty("javax.net.ssl.keyStore")) == null) {
                    keyStore = this.proxyProps.getProperty("com.ibm.ssl.keyStore");
                }
                if ((keyStoreType = this.proxyProps.getProperty("javax.net.ssl.keyStoreType")) == null) {
                    keyStoreType = this.proxyProps.getProperty("com.ibm.ssl.keyStoreType");
                }
                if ((keyStorePassword = this.proxyProps.getProperty("javax.net.ssl.keyStorePassword")) == null) {
                    keyStorePassword = this.proxyProps.getProperty("com.ibm.ssl.keyStorePassword");
                }
                if ((contextProvider = this.proxyProps.getProperty("com.ibm.ssl.contextProvider")) == null) {
                    contextProvider = this.proxyProps.getProperty("com.ibm.ssl.contextProvider");
                }
                SSLConfig config = null;
                if (keyStore != null && keyStorePassword != null || trustStore != null && trustStorePassword != null) {
                    config = new SSLConfig(this.proxyProps);
                    boolean usingJSSESocketFactory = false;
                    String sslSocketFactory = Security.getProperty("ssl.SocketFactory.provider");
                    if (sslSocketFactory == null || !sslSocketFactory.equals("com.ibm.websphere.ssl.protocol.SSLSocketFactory")) {
                        usingJSSESocketFactory = true;
                    }
                    if (keyStore != null) {
                        config.setProperty("com.ibm.ssl.keyStore", keyStore);
                        if (usingJSSESocketFactory) {
                            System.setProperty("javax.net.ssl.keyStore", keyStore);
                        }
                    }
                    if (keyStorePassword != null) {
                        config.setProperty("com.ibm.ssl.keyStorePassword", keyStorePassword);
                        if (usingJSSESocketFactory) {
                            System.setProperty("javax.net.ssl.keyStorePassword", keyStorePassword);
                        }
                    }
                    if (keyStoreType != null) {
                        config.setProperty("com.ibm.ssl.keyStoreType", keyStoreType);
                        if (usingJSSESocketFactory) {
                            System.setProperty("javax.net.ssl.keyStoreType", keyStoreType);
                        }
                    } else {
                        config.setProperty("com.ibm.ssl.keyStoreType", "JKS");
                        if (usingJSSESocketFactory) {
                            System.setProperty("javax.net.ssl.keyStoreType", "JKS");
                        }
                    }
                    if (trustStore != null) {
                        config.setProperty("com.ibm.ssl.trustStore", trustStore);
                        if (usingJSSESocketFactory) {
                            System.setProperty("javax.net.ssl.trustStore", trustStore);
                        }
                    }
                    if (trustStorePassword != null) {
                        config.setProperty("com.ibm.ssl.trustStorePassword", trustStorePassword);
                        if (usingJSSESocketFactory) {
                            System.setProperty("javax.net.ssl.trustStorePassword", trustStorePassword);
                        }
                    }
                    if (trustStoreType != null) {
                        config.setProperty("com.ibm.ssl.trustStoreType", trustStoreType);
                        if (usingJSSESocketFactory) {
                            System.setProperty("javax.net.ssl.trustStoreType", trustStoreType);
                        }
                    } else {
                        config.setProperty("com.ibm.ssl.trustStoreType", "JKS");
                        if (usingJSSESocketFactory) {
                            System.setProperty("javax.net.ssl.trustStoreType", "JKS");
                        }
                    }
                    config.decodePasswords();
                }
                HashMap<String, String> connectionInfo = new HashMap<String, String>();
                connectionInfo.put("com.ibm.ssl.direction", "outbound");
                connectionInfo.put("com.ibm.ssl.endPointName", "ADMIN_IPC");
                connectionInfo.put("com.ibm.ssl.remoteHost", this.host);
                connectionInfo.put("com.ibm.ssl.remotePort", this.port);
                JSSEHelper.getInstance().setOutboundConnectionInfo(connectionInfo);
                String ipcSslAlias = this.proxyProps.getProperty("sslConfig");
                if (config != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting SSL properties on thread from proxyProps or system props: " + config.toString());
                    }
                    JSSEHelper.getInstance().setSSLPropertiesOnThread(config);
                } else {
                    Properties ssl_props;
                    String newIpcSslAlias = ipcSslAlias;
                    if (newIpcSslAlias == null) {
                        newIpcSslAlias = SecurityHelper.getHelper().getClientSSLAlias();
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ipcSslAlias: " + newIpcSslAlias);
                    }
                    if ((ssl_props = JSSEHelper.getInstance().getProperties(newIpcSslAlias, connectionInfo, null)) != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Setting SSL properties on thread from JSSEHelper: " + ssl_props.toString());
                        }
                        JSSEHelper.getInstance().setSSLPropertiesOnThread(ssl_props);
                    }
                }
                if (this.autoAcceptSigner) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "autoAcceptSignerForThisConnectionOnly");
                    }
                    RetrieveSignersHelper.getInstance().autoAcceptSignerForThisConnectionOnly();
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.connector.ipc.IPCConnectorClient.setupSSLSetting", "2330", this);
                if (!tc.isDebugEnabled()) break block38;
                Tr.debug(tc, "Exception occurred configuring SSL for IPC.", new Object[]{e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setupSslSetting");
        }
    }
}

