/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.cmdframework.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementProxy;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.management.cmdframework.impl.CmdFrameworkConstants;
import com.ibm.ws.management.cmdframework.impl.CommandMetadataMgr;
import com.ibm.ws.management.cmdframework.impl.CommandMgrImpl;
import java.util.Properties;

public class LocalCommandMgr
extends CommandMgrImpl {
    private static TraceComponent tc = Tr.register(LocalCommandMgr.class, "LocalCommandMgr", "com.ibm.websphere.management.resources.cmdframework");

    public LocalCommandMgr() {
        this.helper = new CommandProviderHelper(){

            public ConfigService getConfigService() {
                ConfigService configService = ConfigServiceFactory.getConfigService();
                try {
                    if (configService == null) {
                        Properties prop = new Properties();
                        prop.setProperty("location", "local");
                        configService = ConfigServiceFactory.createConfigService(true, prop);
                    }
                }
                catch (Exception ex) {
                    Manager.Ffdc.log(ex, this, "com.ibm.ws.management.cmdframework.impl.LocalCommandMgr.getConfigService", "42", this);
                    ex.printStackTrace();
                }
                return configService;
            }

            public AdminClient getAdminClient() {
                return null;
            }

            public AdminService getAdminService() {
                return AdminServiceFactory.getAdminService();
            }

            public AppManagement getAppManagement() {
                AppManagement appMgr = null;
                try {
                    appMgr = AppManagementProxy.getLocalProxy();
                }
                catch (Exception ex) {
                    Manager.Ffdc.log(ex, this, "com.ibm.ws.management.cmdframework.impl.LocalCommandMgr.getAppManagement", "59", this);
                    ex.printStackTrace();
                }
                return appMgr;
            }
        };
    }

    public CommandProviderHelper getCommandProviderHelper() {
        return this.helper;
    }

    public AdminCommand createCommand(String command) throws ConnectorException, CommandException {
        CommandMetadata cmdmetadata;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCommand", command);
        }
        if ((cmdmetadata = CommandMetadataMgr.getInstance().getCommandMetadata(command)) != null && cmdmetadata.isSupportLocalMode()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createCommand");
            }
            AdminCommand adminCmd = super.createCommand(command);
            ((AbstractAdminCommand)adminCmd).setCmdMgrType(CmdFrameworkConstants.LOCAL_CMD_MANAGER);
            return adminCmd;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCommand - with exception");
        }
        throw new CommandException("Command " + command + " does not support localmode");
    }
}

