/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.cmdframework.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementProxy;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandGroupMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandStepMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.management.cmdframework.impl.ClientAdminCommand;
import com.ibm.ws.management.cmdframework.impl.ClientTaskCommand;
import com.ibm.ws.management.cmdframework.impl.CmdFrameworkConstants;
import com.ibm.ws.management.cmdframework.impl.CommandMetadataMgr;
import com.ibm.ws.management.cmdframework.impl.CommandMgrImpl;
import com.ibm.ws.management.cmdframework.impl.CommandUtility;
import com.ibm.ws.management.cmdframework.impl.EObjectSerializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import javax.management.MBeanException;
import org.eclipse.emf.common.util.EList;

public class ClientCommandMgr
extends CommandMgrImpl {
    private static TraceComponent tc = Tr.register(ClientCommandMgr.class, "ClientCommandMgr", "com.ibm.ws.management.cmdframework.impl");
    private AdminClient adminClient;
    public HashMap cmdMetadataMap = new HashMap();

    public ClientCommandMgr() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Init client command manager");
        }
        this.helper = new CommandProviderHelper(){

            public ConfigService getConfigService() {
                return ConfigServiceFactory.getConfigService();
            }

            public AdminClient getAdminClient() {
                return ClientCommandMgr.this.adminClient;
            }

            public AdminService getAdminService() {
                return null;
            }

            public AppManagement getAppManagement() {
                AppManagement appMgr = null;
                try {
                    appMgr = AppManagementProxy.getJMXProxyForClient(ClientCommandMgr.this.adminClient);
                }
                catch (Exception ex) {
                    Manager.Ffdc.log(ex, this, "com.ibm.ws.management.cmdframework.impl.LocalCommandMgr.getAppManagement", "59", this);
                    ex.printStackTrace();
                }
                return appMgr;
            }
        };
    }

    public CommandProviderHelper getCommandProviderHelper() {
        return this.helper;
    }

    public void setAdminClient(AdminClient inAdminClient) {
        this.adminClient = inAdminClient;
    }

    public Collection listCommandGroups() throws ConnectorException, CommandException {
        try {
            return (Collection)this.adminClient.invoke(CommandUtility.getRemoteCmdMgrMbean(this.adminClient), "listCommandGroups", null, null);
        }
        catch (MBeanException e) {
            Exception ex = e.getTargetException();
            if (ex instanceof CommandException) {
                throw (CommandException)ex;
            }
            throw new CommandException(ex);
        }
        catch (ConnectorException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new CommandException(e);
        }
    }

    public Collection listCommands(String commandGroup) throws ConnectorException, CommandException {
        try {
            return (Collection)this.adminClient.invoke(CommandUtility.getRemoteCmdMgrMbean(this.adminClient), "listCommands", new Object[]{commandGroup}, new String[]{"java.lang.String"});
        }
        catch (MBeanException e) {
            Exception ex = e.getTargetException();
            if (ex instanceof CommandException) {
                throw (CommandException)ex;
            }
            throw new CommandException(ex);
        }
        catch (ConnectorException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new CommandException(e);
        }
    }

    public Collection listCommands() throws ConnectorException, CommandException {
        try {
            return (Collection)this.adminClient.invoke(CommandUtility.getRemoteCmdMgrMbean(this.adminClient), "listCommands", null, null);
        }
        catch (MBeanException e) {
            Exception ex = e.getTargetException();
            if (ex instanceof CommandException) {
                throw (CommandException)ex;
            }
            throw new CommandException(ex);
        }
        catch (ConnectorException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new CommandException(e);
        }
    }

    public Collection listAllCommands() throws ConnectorException, CommandException {
        try {
            return (Collection)this.adminClient.invoke(CommandUtility.getRemoteCmdMgrMbean(this.adminClient), "listAllCommands", null, null);
        }
        catch (MBeanException e) {
            Exception ex = e.getTargetException();
            if (ex instanceof CommandException) {
                throw (CommandException)ex;
            }
            throw new CommandException(ex);
        }
        catch (ConnectorException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new CommandException(e);
        }
    }

    public CommandGroupMetadata getCommandGroupMetadata(String commandGrp) throws ConnectorException, CommandException {
        try {
            EObjectSerializer eObjCmdGrpMetadata = (EObjectSerializer)this.adminClient.invoke(CommandUtility.getRemoteCmdMgrMbean(this.adminClient), "getCommandGroupMetaInfo", new Object[]{commandGrp, Locale.getDefault()}, new String[]{"java.lang.String", "java.util.Locale"});
            return (CommandGroupMetadata)eObjCmdGrpMetadata.getEObjectValue();
        }
        catch (MBeanException e) {
            Exception ex = e.getTargetException();
            if (ex instanceof CommandException) {
                throw (CommandException)ex;
            }
            throw new CommandException(ex);
        }
        catch (ConnectorException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new CommandException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Collection getAllCommandGroupMetadata() throws ConnectorException, CommandException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllCommandMetadata");
        }
        ArrayList<CommandGroupMetadata> allCmdGrpMetadataList = new ArrayList<CommandGroupMetadata>();
        try {
            try {
                Collection eObjCmdGrpMetadataList = (Collection)this.adminClient.invoke(CommandUtility.getRemoteCmdMgrMbean(this.adminClient), "getAllCommandGrpMetaInfo", new Object[]{Locale.getDefault()}, new String[]{"java.util.Locale"});
                for (EObjectSerializer metadataEObj : eObjCmdGrpMetadataList) {
                    allCmdGrpMetadataList.add((CommandGroupMetadata)metadataEObj.getEObjectValue());
                }
                Object var6_9 = null;
            }
            catch (MBeanException e) {
                Exception ex = e.getTargetException();
                if (!(ex instanceof CommandException)) throw new CommandException(ex);
                throw (CommandException)ex;
            }
            catch (ConnectorException ex) {
                throw ex;
            }
            catch (Exception e) {
                throw new CommandException(e);
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "getAllCommandGroupMetadata", allCmdGrpMetadataList);
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return allCmdGrpMetadataList;
        Tr.exit(tc, "getAllCommandGroupMetadata", allCmdGrpMetadataList);
        return allCmdGrpMetadataList;
    }

    public CommandMetadata getCommandMetadata(String command) throws ConnectorException, CommandException {
        CommandMetadata result;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandMetadata", command);
        }
        if ((result = (CommandMetadata)this.cmdMetadataMap.get(command)) == null) {
            result = this.initCommandMetadata(command);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandMetadata", result);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Collection getAllCommandMetadata() throws ConnectorException, CommandException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllCommandMetadata");
        }
        ArrayList<CommandMetadata> allCmdMetadataList = new ArrayList<CommandMetadata>();
        try {
            try {
                Collection eObjCmdMetadataList = (Collection)this.adminClient.invoke(CommandUtility.getRemoteCmdMgrMbean(this.adminClient), "getAllCommandMetaInfo", new Object[]{Locale.getDefault()}, new String[]{"java.util.Locale"});
                for (EObjectSerializer metadataEObj : eObjCmdMetadataList) {
                    allCmdMetadataList.add((CommandMetadata)metadataEObj.getEObjectValue());
                }
                Object var6_9 = null;
            }
            catch (MBeanException e) {
                Exception ex = e.getTargetException();
                if (!(ex instanceof CommandException)) throw new CommandException(ex);
                throw (CommandException)ex;
            }
            catch (ConnectorException ex) {
                throw ex;
            }
            catch (Exception e) {
                throw new CommandException(e);
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "getAllCommandMetadata", allCmdMetadataList);
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return allCmdMetadataList;
        Tr.exit(tc, "getAllCommandMetadata", allCmdMetadataList);
        return allCmdMetadataList;
    }

    public AdminCommand createCommand(String command) throws ConnectorException, CommandException {
        AbstractAdminCommand adminCmd;
        CommandMetadata result;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCommand", command);
        }
        if ((result = (CommandMetadata)this.cmdMetadataMap.get(command)) == null) {
            result = this.initCommandMetadata(command);
        }
        if (result instanceof TaskCommandMetadata) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "createCommand", "Creating Task Command");
            }
            adminCmd = new ClientTaskCommand((TaskCommandMetadata)result);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "createCommand", "Creating Command");
            }
            adminCmd = new ClientAdminCommand(result);
        }
        ((AbstractAdminCommand)adminCmd).setCmdMgrType(CmdFrameworkConstants.CLIENT_CMD_MANAGER);
        return adminCmd;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CommandMetadata initCommandMetadata(String command) throws ConnectorException, CommandException {
        CommandMetadata commandMetadata;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initCommandMetadata", command);
        }
        try {
            try {
                String clientCmdName;
                CommandMetadata clientCmdMetadata;
                block14: {
                    EObjectSerializer eObjCmdMetadata = (EObjectSerializer)this.adminClient.invoke(CommandUtility.getRemoteCmdMgrMbean(this.adminClient), "getCommandMetaInfo", new Object[]{command, Locale.getDefault()}, new String[]{"java.lang.String", "java.util.Locale"});
                    clientCmdMetadata = (CommandMetadata)eObjCmdMetadata.getEObjectValue();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Command MetaData received is " + clientCmdMetadata);
                    }
                    clientCmdName = clientCmdMetadata.getName();
                    try {
                        CommandMetadataMgr.getInstance(true).getCommandMetadata(clientCmdName);
                    }
                    catch (CommandNotFoundException cnfe) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Command " + clientCmdName + " does not exist locally. Process to add...");
                        }
                        ArrayList<CommandMetadata> cmdMetadataList = new ArrayList<CommandMetadata>(0);
                        cmdMetadataList.add(clientCmdMetadata);
                        CommandMetadataMgr.getInstance(true).registerCommandMetadataRemote(cmdMetadataList);
                        if (!tc.isDebugEnabled()) break block14;
                        Tr.debug(tc, "Command " + clientCmdName + " added to local CommandMetadataMgr");
                    }
                }
                CommandMetadataMgr.getInstance(true).createParamDataEObject(clientCmdName);
                if (clientCmdMetadata instanceof TaskCommandMetadata) {
                    EList stepsList = ((TaskCommandMetadata)clientCmdMetadata).getSteps();
                    for (int i = 0; i < stepsList.size(); ++i) {
                        String stepName = ((CommandStepMetadata)stepsList.get(i)).getName();
                        CommandMetadataMgr.getInstance(true).createParamDataEObject(clientCmdName, stepName);
                    }
                }
                this.cmdMetadataMap.put(command, clientCmdMetadata);
                commandMetadata = clientCmdMetadata;
                Object var9_14 = null;
            }
            catch (MBeanException e) {
                Exception ex = e.getTargetException();
                if (!(ex instanceof CommandException)) throw new CommandException(ex);
                throw (CommandException)ex;
            }
            catch (ConnectorException ex) {
                throw ex;
            }
            catch (Exception e) {
                throw new CommandException(e);
            }
        }
        catch (Throwable throwable) {
            Object var9_15 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "initCommandMetadata");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return commandMetadata;
        Tr.exit(tc, "initCommandMetadata");
        return commandMetadata;
    }
}

