/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.ModuleRef;
import com.ibm.websphere.management.application.EditScheduler;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.AndSaveFilter;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.SaveFilter;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategyImpl;

public class SetApplicationInfoTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register(SetApplicationInfoTask.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    public static final String AllTasks = "SetApplicationInfo.AllTasks";
    public static final String UniqueModuleURI = "SetApplicationInfo.UniqueModuleURI";

    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTask");
        }
        try {
            EditScheduler edit = (EditScheduler)this.scheduler;
            EARFile ear = edit.getEarFile();
            File f = new File(ear.getURI());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ear uri: " + f);
            }
            if (!f.isDirectory()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not a dir so useMetadataFromBinaries");
                }
                ear.extractNoReopen(true);
                edit.getAppContext().getParent().notifyChanged(1, edit.getAppContext().getParent().getName());
            } else {
                SetApplicationInfoTask.saveEarFileToDeployment(ear, edit.getAppContext(), this.getResourceBundle(), new MetadataSaveFilter(this.getAltDDPattern(ear)));
            }
        }
        catch (Throwable th) {
            RasUtils.logException(th, tc, CLASS_NAME, "performTask", "115", this);
            throw new AdminException(th, "Exception in setApplicationInfo");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performTask");
        }
        return true;
    }

    private static void collectFiles(Collection c, ArrayList l, String base) throws Exception {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            String uri = (base == null ? "" : base + "/") + ((Resource)i.next()).getURI().toString();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Saving uri: " + uri);
            }
            l.add(uri);
        }
    }

    public static void saveEarFileToDeployment(EARFile earFile, RepositoryContext rc) throws Exception {
        SetApplicationInfoTask.saveEarFileToDeployment(earFile, rc, null, null);
    }

    public static void saveEarFileToDeployment(EARFile earFile, RepositoryContext rc, ResourceBundle resBundle, SaveFilter metadataFilter) throws Exception {
        ApplicationDeployment appDepl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveEarFileToDeployment");
        }
        ArrayList l = new ArrayList();
        Collection c = earFile.getLoadedMofResources();
        SetApplicationInfoTask.collectFiles(c, l, null);
        List files = earFile.getModuleFiles();
        for (int i = 0; i < files.size(); ++i) {
            Archive arch = (Archive)files.get(i);
            SetApplicationInfoTask.collectFiles(arch.getLoadedMofResources(), l, arch.getURI());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loaded resources are: " + l);
        }
        Set origSet = rc.getFiles();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "rc: " + rc.getPath());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "origSet: " + origSet);
        }
        if (ConfigRepoHelper.isMetadataComplete(appDepl = ConfigRepoHelper.getAppDeploymentForApp(rc))) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "metacdataComplete or useMetadataFrombinaries is set to true, calling extract on ear");
            }
            earFile.extract(126);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "need to extract on app and module level");
            }
            SetApplicationInfoTask.extractMetadata(earFile, 126, metadataFilter);
        }
        ArrayList added = new ArrayList();
        ArrayList updated = new ArrayList();
        String dirName = rc.getPath() + File.separator;
        for (int i = 0; i < l.size(); ++i) {
            Object o = l.get(i);
            if (new File(dirName + o).exists()) {
                if (origSet.contains(o)) {
                    updated.add(o);
                    continue;
                }
                added.add(o);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "error?? " + o + " was loaded as a resource but never saved.");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "edit added files: " + added);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "edit updated: " + updated);
        }
        rc.notifyChanged(1, updated);
        rc.notifyChanged(0, added);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "saveEarFileToDeployment");
        }
    }

    private String getAltDDPattern(EARFile ear) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAltDDPattern");
        }
        String altDDPattern = "";
        EList moduleRefs = ear.getModuleRefs();
        try {
            for (int i = 0; i < moduleRefs.size(); ++i) {
                ModuleRef mRef = (ModuleRef)moduleRefs.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "module URI: " + mRef.getUri());
                }
                if (mRef.getAltDeploymentDescriptor() == null) continue;
                String alt = mRef.getAltDeploymentDescriptor().eResource().getURI().toString();
                String altDir = mRef.getAltRoot();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "alt: " + alt + "\naltDir: " + altDir);
                }
                if (!AppUtils.isEmpty(alt)) {
                    altDDPattern = AppUtils.isEmpty(altDDPattern) ? altDDPattern + alt : altDDPattern + "|" + alt;
                }
                if (!AppUtils.isEmpty(altDir)) {
                    altDDPattern = altDDPattern + "|" + altDir + "/.*";
                }
                String altBnd = mRef.getAltBindings().eResource().getURI().toString();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "altBnd: " + altBnd);
                }
                if (!AppUtils.isEmpty(altBnd)) {
                    altDDPattern = altDDPattern + "|" + altBnd.substring(0, altBnd.lastIndexOf(47)) + "/[^/]*";
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "altDD pattern: " + altDDPattern);
            }
        }
        catch (Throwable th) {
            RasUtils.logException(th, tc, CLASS_NAME, "getAltDDPattern", "249", this);
            throw new AdminException(th, "exception in getting alt-DD pattern in setApplicationInfo");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAltDDPattern", new Object[]{altDDPattern});
        }
        return altDDPattern;
    }

    private static void extractMetadata(EARFile ear, int expandOption, SaveFilter metadataFilter) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractMetadata", new Object[]{new Integer(expandOption)});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "extract ear metadata");
        }
        ArchiveOptions earOptions = ear.getOptions();
        SaveFilter priorFilter = ear.getSaveFilter();
        ear.setSaveFilter(metadataFilter);
        ear.setSaveFilter(SetApplicationInfoTask.andFilters(priorFilter, metadataFilter));
        boolean oldFilterFlag = earOptions.getChildrenUseParentFilters();
        boolean oldSaveFlag = earOptions.getSaveIncrementally();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "oldSaveFlag: " + oldSaveFlag);
        }
        earOptions.setChildrenUseParentFilters(true);
        earOptions.setSaveIncrementally(true);
        try {
            try {
                ear.extract(expandOption);
            }
            catch (Throwable th) {
                throw new AdminException(th, "Extraction exception in setApplicationInfo");
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            ear.setSaveFilter(priorFilter);
            earOptions.setChildrenUseParentFilters(oldFilterFlag);
            earOptions.setSaveIncrementally(oldSaveFlag);
            throw throwable;
        }
        ear.setSaveFilter(priorFilter);
        earOptions.setChildrenUseParentFilters(oldFilterFlag);
        earOptions.setSaveIncrementally(oldSaveFlag);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractMetadata");
        }
    }

    protected static SaveFilter andFilters(SaveFilter firstFilter, SaveFilter secondFilter) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "andFilters");
        }
        if (secondFilter == null || SetApplicationInfoTask.isBasicSaveFilter(secondFilter)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "andFilters -return first filter");
            }
            return firstFilter;
        }
        if (firstFilter == null || SetApplicationInfoTask.isBasicSaveFilter(firstFilter)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "andFilters -return second filter");
            }
            return secondFilter;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "andFilters -return merged filter");
        }
        return new AndSaveFilter(firstFilter, secondFilter);
    }

    protected static boolean isBasicSaveFilter(SaveFilter saveFilter) {
        return saveFilter != null && saveFilter.getClass().equals(SaveStrategyImpl.class);
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/task/SetApplicationInfoTask.java, WAS.admin.installapp.server, WAS70.SERV1, q0834.18, ver. 1.9");
        }
        CLASS_NAME = SetApplicationInfoTask.class.getName();
    }

    class MetadataSaveFilter
    implements SaveFilter {
        private static final String APP_DEPLOYMENT_XML_PATTERN = "deployment.xml.*";
        private String altDDPattern = null;

        public MetadataSaveFilter(String altDDPattern) {
            if (altDDPattern != null) {
                this.altDDPattern = altDDPattern;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "altDDPattern: " + altDDPattern);
            }
        }

        public boolean shouldSave(String elementUri, Archive archive) {
            boolean ret;
            org.eclipse.jst.j2ee.commonarchivecore.internal.File elementFile;
            block21: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "shouldSave", new Object[]{elementUri, archive});
                }
                elementFile = null;
                try {
                    elementFile = archive.getFile(elementUri);
                }
                catch (FileNotFoundException e) {
                    if (!tc.isDebugEnabled()) break block21;
                    Tr.debug(tc, "not a file in module ... do further check");
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "elementFile: " + elementFile);
            }
            if (elementFile != null) {
                if (elementFile.isArchive()) {
                    if (!elementFile.isModuleFile()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "not a module file");
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "shouldSave", new Object[]{"false"});
                        }
                        return false;
                    }
                    if (elementFile.isModuleFile()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "a module file");
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "shouldSave", new Object[]{"true"});
                        }
                        return true;
                    }
                }
                if (elementFile.isApplicationClientFile()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "a client file");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "shouldSave", new Object[]{"false"});
                    }
                    return false;
                }
            }
            boolean bl = ret = elementUri.matches("META-INF/[^/]*|WEB-INF/[^/]*|.*wsdl|META-INF/wsdl/.*|WEB-INF/wsdl/.*") || elementUri.matches(APP_DEPLOYMENT_XML_PATTERN);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ret: " + ret);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "altDDPattern: " + this.altDDPattern);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "archive.isEarFile: " + archive.isEARFile());
            }
            if (!ret && this.altDDPattern != null && archive.isEARFile()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "altDDPattern: " + this.altDDPattern);
                }
                ret = elementUri.matches(this.altDDPattern);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "shouldSave", new Object[]{new Boolean(ret)});
            }
            return ret;
        }
    }
}

