/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.sync.AbstractAppSyncTask;
import com.ibm.websphere.management.application.sync.AppData;
import com.ibm.ws.management.util.RasUtils;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.management.ObjectName;

public class StopDeploymentTask
extends AbstractAppSyncTask {
    private static TraceComponent tc = Tr.register(StopDeploymentTask.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    private AppData _cachedAd;
    private AppData _newAd;

    public boolean performTask(AppData cachedAD, AppData newAD, Hashtable props) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTask");
        }
        if (!this.appWasDeployedOnNode(cachedAD.getAppName()) || this._isLocal) {
            return true;
        }
        this._cachedAd = cachedAD;
        this._newAd = newAD;
        int recycleMode = this._newAd.getRecycleMode();
        int op = this._newAd.getOperations();
        if (recycleMode == 16) {
            return this.fineGrainUpdate(props);
        }
        if (recycleMode == 1 || (cachedAD.getOperations() & 0x10) != 0) {
            boolean b = this.fullAppUpdate(props);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "performTask");
            }
            return b;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performTask");
        }
        return true;
    }

    private boolean fineGrainUpdate(Hashtable props) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fineGrainedUpdate");
        }
        List stoppedList = this._newAd.getModulesToStop();
        List recycleList = this._newAd.getModulesToRecycle();
        if (stoppedList != null && stoppedList.size() > 0) {
            for (int i = 0; i < stoppedList.size(); ++i) {
                String modName = (String)stoppedList.get(i);
                Tr.debug(tc, "stopping " + modName);
                this.stopDeployment("name=" + modName + ",Application=" + this._cachedAd.getAppName(), "_stopModule", new String[]{this._cachedAd.getAppName(), modName});
            }
        }
        if (recycleList != null && recycleList.size() > 0) {
            Hashtable<String, Vector> tbl = new Hashtable<String, Vector>();
            props.put("stoppedlist", tbl);
            for (int i = 0; i < recycleList.size(); ++i) {
                String modName = (String)recycleList.get(i);
                Tr.debug(tc, "recycling " + modName);
                Vector ret = this.stopDeployment("name=" + modName + ",Application=" + this._cachedAd.getAppName(), "_stopModule", new String[]{this._cachedAd.getAppName(), modName});
                tbl.put(modName, ret);
            }
            Tr.debug(tc, "After stop part of recycle work the table is: " + tbl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fineGrainedUpdate");
        }
        return true;
    }

    private boolean fullAppUpdate(Hashtable props) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fullAppUpdate");
        }
        Vector stoppedList = this.stopDeployment("type=Application,name=" + this._cachedAd.getAppName(), "stopApplication", new String[]{this._cachedAd.getAppName()});
        props.put("stoppedlist", stoppedList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fullAppUpdate");
        }
        return true;
    }

    private Vector stopDeployment(String query, String methodName, String[] params) throws Exception {
        Iterator it;
        if (this._isLocal) {
            return null;
        }
        Vector<ObjectName> ret = new Vector<ObjectName>();
        String q = "WebSphere:node=" + this._nodeName + "," + query + ",*";
        ObjectName on = new ObjectName(q);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Query for: " + q);
        }
        if ((it = AdminServiceFactory.getAdminService().queryNames(on, null).iterator()) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "it is null for: " + on);
            }
            return null;
        }
        ObjectName appMgrName = null;
        while (it.hasNext()) {
            String pName = ((ObjectName)it.next()).getKeyProperty("process");
            try {
                String[] stringArray;
                q = "WebSphere:type=ApplicationManager,node=" + this._nodeName + ",process=" + pName + ",*";
                Tr.debug(tc, "query " + q);
                on = new ObjectName(q);
                Iterator it1 = AdminServiceFactory.getAdminService().queryNames(on, null).iterator();
                if (it1 == null || !it1.hasNext()) {
                    Tr.warning(tc, "Could not find: " + q);
                    continue;
                }
                appMgrName = (ObjectName)it1.next();
                Tr.debug(tc, "Stopping ..: " + query + " by " + appMgrName + " method: " + methodName + " params: " + params[0] + (params.length == 1 ? "" : params[1]));
                AdminService adminService = AdminServiceFactory.getAdminService();
                if (params.length == 1) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = String.class.getName();
                } else {
                    String[] stringArray3 = new String[2];
                    stringArray3[0] = String.class.getName();
                    stringArray = stringArray3;
                    stringArray3[1] = String.class.getName();
                }
                adminService.invoke(appMgrName, methodName, params, stringArray);
                ret.addElement(appMgrName);
            }
            catch (Throwable th) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error stopping: " + query + " on: " + pName + " by: " + appMgrName);
                }
                RasUtils.logException(th, tc, CLASS_NAME, "stopDeployment", "196", this);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, query + " stopped by: " + ret);
        }
        return ret;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/sync/StopDeploymentTask.java, WAS.admin.installapp.sync, WAS70.SERV1, q0834.18, ver. 1.8");
        }
        CLASS_NAME = StopDeploymentTask.class.getName();
    }
}

