/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.sync.AbstractAppSyncTask;
import com.ibm.websphere.management.application.sync.AppData;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.ClusteredTarget;
import com.ibm.websphere.models.config.appdeployment.DeploymentTarget;
import com.ibm.websphere.models.config.appdeployment.DeploymentTargetMapping;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.ServerTarget;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.ws.management.application.sync.AppSyncUtils;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.util.RasUtils;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class StartDeploymentTask
extends AbstractAppSyncTask {
    private static TraceComponent tc = Tr.register(StartDeploymentTask.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    private AppData _cachedAd;
    private AppData _newAd;

    public boolean performTask(AppData cachedAD, AppData newAD, Hashtable props) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTask");
        }
        if (!this.appIsDeployedOnNode(cachedAD.getAppName()) || this._isLocal) {
            return true;
        }
        this._cachedAd = cachedAD;
        this._newAd = newAD;
        int recycleMode = this._newAd.getRecycleMode();
        int op = this._newAd.getOperations();
        if (recycleMode == 16) {
            return this.fineGrainUpdate(props);
        }
        if (recycleMode == 1) {
            return this.fullAppUpdate(props);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performTask");
        }
        return true;
    }

    private boolean fullAppUpdate(Hashtable props) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fullAppUpdate");
        }
        Vector stopped = (Vector)props.get("stoppedlist");
        this.startDeployment("name=" + this._cachedAd.getAppName(), "startApplication", new String[]{this._cachedAd.getAppName()}, stopped, (Vector)this._newSIMap.get(this._cachedAd.getAppName()));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fullAppUpdate");
        }
        return true;
    }

    private boolean fineGrainUpdate(Hashtable props) throws Exception {
        Hashtable allStops;
        ApplicationDeployment appD;
        List recycles;
        Resource res;
        block20: {
            List starts;
            block19: {
                block18: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "fineGrainedUpdate");
                    }
                    res = null;
                    starts = this._newAd.getModulesToStart();
                    recycles = this._newAd.getModulesToRecycle();
                    if (starts.size() != 0 || recycles.size() != 0) break block18;
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "Start or recycle size is 0: " + starts + "---" + recycles);
                    }
                    boolean bl = true;
                    Object var12_9 = null;
                    if (res != null) {
                        res.unload();
                    }
                    return bl;
                }
                res = AppSyncUtils.getResource(this._repository, this._cachedAd.getDeplURI(), "deployment.xml");
                if (res != null) break block19;
                Tr.debug(tc, "Could not get deployment resources for " + this._cachedAd.getDeplURI());
                boolean bl = false;
                Object var12_10 = null;
                if (res != null) {
                    res.unload();
                }
                return bl;
            }
            appD = ConfigRepoHelper.getAppDeploymentForApp(res);
            for (int i = 0; i < starts.size(); ++i) {
                String mod = (String)starts.get(i);
                Tr.debug(tc, "starting " + mod);
                Vector svrs = this.getServersForModule(mod, appD);
                this.startDeployment("name=" + mod + ",Application=" + this._cachedAd.getAppName(), "_startModule", new String[]{this._cachedAd.getAppName(), mod}, this.servers2AppMgrON(svrs), svrs);
            }
            allStops = (Hashtable)props.get("stoppedlist");
            if (allStops != null) break block20;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "No stopped table so nothing to recycle");
            }
            boolean mod = true;
            Object var12_11 = null;
            if (res != null) {
                res.unload();
            }
            return mod;
        }
        try {
            for (int j = 0; j < recycles.size(); ++j) {
                String mod = (String)recycles.get(j);
                Tr.debug(tc, "recycling " + (String)recycles.get(j));
                Vector stopped = (Vector)allStops.get(mod);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, mod + " was stopped at: " + stopped);
                }
                if (stopped == null || stopped.size() == 0) continue;
                Vector svrs = this.getServersForModule(mod, appD);
                this.startDeployment("name=" + mod + ",Application=" + this._cachedAd.getAppName(), "_startModule", new String[]{this._cachedAd.getAppName(), mod}, stopped, svrs);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "fineGrainedUpdate");
            }
            boolean bl = true;
            Object var12_12 = null;
            if (res != null) {
                res.unload();
            }
            return bl;
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                block21: {
                    Object var12_13 = null;
                    if (res == null) break block21;
                    res.unload();
                }
                throw throwable;
            }
        }
    }

    private void startDeployment(String query, String methodName, String[] params, Vector stopped, Vector shouldStart) {
        if (this._isLocal || stopped == null) {
            return;
        }
        if (stopped == null || stopped.size() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, query + " was never stopped. So not restarting.");
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "For depl: " + query + " was stopped by: " + stopped + " === and shouldStart: : " + shouldStart);
        }
        for (int l = 0; l < stopped.size(); ++l) {
            ObjectName on = (ObjectName)stopped.elementAt(l);
            String pName = on.getKeyProperty("process");
            if (!shouldStart.contains(pName)) continue;
            try {
                String[] stringArray;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Starting..");
                }
                AdminService adminService = AdminServiceFactory.getAdminService();
                if (params.length == 1) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = String.class.getName();
                } else {
                    String[] stringArray3 = new String[2];
                    stringArray3[0] = String.class.getName();
                    stringArray = stringArray3;
                    stringArray3[1] = String.class.getName();
                }
                adminService.invoke(on, methodName, params, stringArray);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Started: " + query + " on " + pName);
                continue;
            }
            catch (Throwable th) {
                Tr.warning(tc, "Unable to start: " + query + " using: " + on);
                RasUtils.logException(th, tc, CLASS_NAME, "startDeployments", "213", this);
            }
        }
    }

    private Vector servers2AppMgrON(Vector s) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "servers2AppMgrON");
        }
        Vector retVal = new Vector();
        for (int i = 0; i < s.size(); ++i) {
            ObjectName on = new ObjectName("WebSphere:type=Application,node=" + this._nodeName + ",process=" + s.elementAt(i) + ",name=" + this._cachedAd.getAppName() + ",*");
            Set set1 = AdminServiceFactory.getAdminService().queryNames(on, null);
            if (set1.size() == 0) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "No app running for: " + on);
                continue;
            }
            on = new ObjectName("WebSphere:type=ApplicationManager,node=" + this._nodeName + ",process=" + s.elementAt(i) + ",*");
            Iterator iter = AdminServiceFactory.getAdminService().queryNames(on, null).iterator();
            if (iter.hasNext()) {
                retVal.add(iter.next());
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Internal error: No result for: " + on);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "servers2AppMgrON: " + retVal);
        }
        return retVal;
    }

    private Vector getServersForModule(String mod, ApplicationDeployment appD) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServersForModule: " + mod);
        }
        Vector<String> retVal = new Vector<String>();
        EList l = appD.getModules();
        for (int i = 0; i < l.size(); ++i) {
            ModuleDeployment md2 = (ModuleDeployment)l.get(i);
            if (!md2.getUri().equals(mod)) continue;
            EList maps = md2.getTargetMappings();
            for (int j = 0; j < maps.size(); ++j) {
                DeploymentTargetMapping map = (DeploymentTargetMapping)maps.get(j);
                DeploymentTarget t = map.getTarget();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "module target:" + t);
                }
                if (t instanceof ServerTarget) {
                    if (!((ServerTarget)t).getNodeName().equals(this._nodeName)) continue;
                    retVal.add(((ServerTarget)t).getName());
                    continue;
                }
                if (!(t instanceof ClusteredTarget)) continue;
                Tr.debug(tc, "Handle clusters");
                String clName = ((ClusteredTarget)t).getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cluster target: " + clName);
                }
                this.addClusterMembers(clName, retVal);
            }
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServersForModule: " + retVal);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addClusterMembers(String clName, Vector retVal) {
        block16: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "addClusterMembers: " + clName);
            }
            String clURI = "cells/" + this._cellName + "/clusters/" + clName + "/cluster.xml";
            Resource clRes = null;
            try {
                try {
                    clRes = AppSyncUtils.getResource(this._repository, clURI, "cluster.xml");
                    if (clRes == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Cluster res not found for: " + clURI);
                        }
                        Object var10_5 = null;
                        if (clRes != null) {
                            clRes.unload();
                        }
                        return;
                    }
                    ServerCluster clst = (ServerCluster)clRes.getContents().get(0);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Cluster obj: " + clst);
                    }
                    EList l = clst.getMembers();
                    for (int lcv = 0; lcv < l.size(); ++lcv) {
                        ClusterMember member = (ClusterMember)l.get(lcv);
                        if (!member.getNodeName().equals(this._nodeName)) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Need to add " + member.getMemberName());
                        }
                        if (retVal.contains(member.getMemberName())) continue;
                        retVal.add(member.getMemberName());
                    }
                }
                catch (Throwable th) {
                    Tr.warning(tc, "Unexpected error finding cluster members on the node for " + clName + ". The application " + this._cachedAd.getAppName() + " will not be started on some cluster members.");
                    Object var10_7 = null;
                    if (clRes != null) {
                        clRes.unload();
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                Object var10_8 = null;
                if (clRes != null) {
                    clRes.unload();
                }
                throw throwable;
            }
            Object var10_6 = null;
            if (clRes != null) {
                clRes.unload();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addClusterMembers: " + retVal);
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/sync/StartDeploymentTask.java, WAS.admin.installapp.sync, WAS70.SERV1, q0834.18, ver. 1.7");
        }
        CLASS_NAME = StartDeploymentTask.class.getName();
    }
}

