/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.io.file.NativeFile;
import com.ibm.io.file.exception.NativeFileIOException;
import com.ibm.websphere.management.application.sync.AbstractAppSyncTask;
import com.ibm.websphere.management.application.sync.AppData;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.sync.AppSyncUtils;
import java.io.File;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class FilePermissionTask
extends AbstractAppSyncTask {
    private static TraceComponent tc = Tr.register(FilePermissionTask.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private String _cachedPerm;
    private String _newPerm;
    private String _binUrl;
    private String _appName;
    private int _op;
    private int _binUrlLength;
    private int _lengthToStrip;
    private Set _changeFromPartialUpdate;
    private boolean _isPartialUpdate = false;
    private Hashtable _permissionTbl;
    private Hashtable _maxPermissionTbl;
    private Hashtable _compiledFilePatternsTbl;
    private static final String PERM_MULTIPLE_SEPARATOR = "#";
    private static final String PERM_TYPE_ACL_SEPARATOR = "=";
    private static final String FILE_SEPARATOR = "/";

    public boolean performTask(AppData cachedAD, AppData newAD, Hashtable props) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTask", new Object[]{cachedAD, newAD, props});
        }
        if (!this.appIsDeployedOnNode(cachedAD.getAppName())) {
            return true;
        }
        if (!newAD.isDistEnabled()) {
            return true;
        }
        this._binUrl = newAD.getBinURL();
        this._appName = newAD.getAppName();
        this._binUrlLength = this._binUrl.length();
        this._lengthToStrip = this._binUrlLength - (this._appName.length() + 4);
        this._cachedPerm = (String)cachedAD.getProperties().get("filepermission");
        this._newPerm = (String)newAD.getProperties().get("filepermission");
        this._op = newAD.getOperations();
        AppUtils.dbg(tc, "_cachedPerm = " + this._cachedPerm);
        AppUtils.dbg(tc, "_newPerm = " + this._newPerm);
        AppUtils.dbg(tc, "_op = " + this._op);
        AppUtils.dbg(tc, "_binUrl = + " + this._binUrl);
        AppUtils.dbg(tc, "_appname = + " + this._appName);
        if (this._cachedPerm == null && this._newPerm == null) {
            AppUtils.dbg(tc, "_cachedPerm and _newPerm = null, return");
            return true;
        }
        if (this._op == 0) {
            AppUtils.dbg(tc, "return - noop operation");
            return true;
        }
        if ((this._op & 1) != 0 || (this._op & 0x100) != 0 || (this._op & 0x10000) != 0 || (this._op & 0x100000) != 0) {
            this._permissionTbl = this.getPermissionsTable(this._newPerm);
            this._maxPermissionTbl = this.getMaxAllowedPermissionTable();
            if ((this._op & 0x100000) != 0) {
                AppUtils.dbg(tc, "SYNC_PARTIALUPDATE");
                this._isPartialUpdate = true;
                this._changeFromPartialUpdate = new HashSet();
                List changeDoc = (List)newAD.getPartialUpdateDetails().get("DOCSADDED_KEY");
                this.buildChangeFromPartialUpdateList(changeDoc);
            }
            this._compiledFilePatternsTbl = this.compileFilePatterns(this._permissionTbl.keySet());
            this.setPermissions(newAD.getBinURL(), -1);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performTask");
        }
        return true;
    }

    private void buildChangeFromPartialUpdateList(List changeDoc) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildChangeFromPartialUpdateList - " + changeDoc);
        }
        if (changeDoc == null) {
            this._changeFromPartialUpdate = null;
        }
        for (String cDoc : changeDoc) {
            AppUtils.dbg(tc, "cDoc = " + cDoc);
            if (cDoc.indexOf(47) == -1) {
                AppUtils.dbg(tc, "did not find '/'");
                this._changeFromPartialUpdate.add(cDoc);
                continue;
            }
            int startIndex = 0;
            while (cDoc.indexOf(47, startIndex) != -1) {
                int indexFound = cDoc.indexOf(47, startIndex);
                String subS = cDoc.substring(0, indexFound);
                AppUtils.dbg(tc, "adding " + subS);
                this._changeFromPartialUpdate.add(subS);
                startIndex = indexFound + 1;
            }
            AppUtils.dbg(tc, "adding... " + cDoc);
            this._changeFromPartialUpdate.add(cDoc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildChangeFromPartialUpdateList - " + this._changeFromPartialUpdate);
        }
    }

    private boolean isFilePartialUpdate(String filePath) {
        boolean res = false;
        for (String doc : this._changeFromPartialUpdate) {
            if (!filePath.endsWith(doc)) continue;
            res = true;
        }
        if (res) {
            AppUtils.dbg(tc, "isFilePartialupdate true - " + filePath);
        }
        return res;
    }

    private void setPermissions(String dirName, int parentDirPerm) throws AdminException {
        File[] files;
        int filecount;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setPermissions " + dirName + ", parentDirPerm = " + parentDirPerm);
        }
        dirName = dirName.replace('\\', '/');
        AppUtils.dbg(tc, "new dirName = " + dirName);
        File dir = new File(dirName);
        if (!this._isPartialUpdate || this._isPartialUpdate && this.isFilePartialUpdate(dirName)) {
            String resolvedACLStr = this.resolveACL(dirName.substring(this._lengthToStrip));
            if (resolvedACLStr != null) {
                int resolvedACL = Integer.parseInt(resolvedACLStr);
                AppUtils.dbg(tc, "Set permission on dir = " + dirName);
                this.setPermission(dirName, resolvedACL);
                parentDirPerm = resolvedACL;
            } else if (parentDirPerm != -1) {
                this.setPermission(dirName, parentDirPerm);
            }
        }
        int n = filecount = (files = dir.listFiles()) != null ? files.length : 0;
        if (tc.isDebugEnabled()) {
            AppUtils.dbg(tc, "Number of files = " + filecount);
        }
        for (int i = 0; i < filecount; ++i) {
            String resolvedACLStr2;
            String pathName = files[i].getAbsolutePath().replace('\\', '/');
            AppUtils.dbg(tc, "Check dir entry =" + pathName);
            if (files[i].isDirectory()) {
                this.setPermissions(pathName, parentDirPerm);
                continue;
            }
            if (this._isPartialUpdate && (!this._isPartialUpdate || !this.isFilePartialUpdate(pathName)) || (resolvedACLStr2 = this.resolveACL(pathName.substring(this._lengthToStrip))) == null) continue;
            int resolvedACL = Integer.parseInt(resolvedACLStr2);
            AppUtils.dbg(tc, "Set permission on file = " + pathName);
            this.setPermission(pathName, resolvedACL);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setPermissions");
        }
    }

    private String resolveACL(String filePath) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolveACL : " + filePath);
        }
        String aclStr = null;
        Set filePatternSet = this._permissionTbl.keySet();
        for (String filePattern : filePatternSet) {
            Pattern p = (Pattern)this._compiledFilePatternsTbl.get(filePattern);
            if (!p.matcher(filePath).matches()) continue;
            AppUtils.dbg(tc, "ttt found matching file_pattern = " + filePattern);
            String tmpAclStr = (String)this._permissionTbl.get(filePattern);
            AppUtils.dbg(tc, "ttt permission from match = " + tmpAclStr);
            if (aclStr != null) {
                AppUtils.dbg(tc, "aclStr exists! Now resolving most least lenient acl");
                tmpAclStr = this.getLeastLenientFilePermission(tmpAclStr, aclStr);
            }
            aclStr = tmpAclStr;
        }
        AppUtils.dbg(tc, "ttt aclStr before max filter = " + aclStr);
        if (this._maxPermissionTbl == null || this._maxPermissionTbl.size() == 0 || aclStr == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "resolveACL : " + aclStr);
            }
            return aclStr;
        }
        Set maxAllowSet = this._maxPermissionTbl.keySet();
        for (String maxAllowPattern : maxAllowSet) {
            if (!filePath.matches(maxAllowPattern)) continue;
            AppUtils.dbg(tc, "ttt found matching max_file_name_pattern = " + maxAllowPattern);
            String tmpMaxAclStr = (String)this._maxPermissionTbl.get(maxAllowPattern);
            AppUtils.dbg(tc, "ttt permission from max match = " + tmpMaxAclStr);
            if (aclStr == null) continue;
            AppUtils.dbg(tc, "aclStr exists! Now filtering with max acl");
            aclStr = this.getLeastLenientFilePermission(tmpMaxAclStr, aclStr);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolveACL : " + aclStr);
        }
        return aclStr;
    }

    private Hashtable getPermissionsTable(String permissionsAndACLs) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPermissionTable", new Object[]{permissionsAndACLs});
        }
        Hashtable permTbl = new Hashtable();
        permTbl = this.buildPermissionsTable(permissionsAndACLs);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPermissionTable", new Object[]{permTbl});
        }
        return permTbl;
    }

    private Hashtable compileFilePatterns(Set regexPatternSet) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "compileFilePatterns", new Object[]{regexPatternSet});
        }
        Hashtable<String, Pattern> compiledPermTbl = new Hashtable<String, Pattern>();
        for (String regexPattern : regexPatternSet) {
            Pattern compiledPattern = Pattern.compile(regexPattern);
            AppUtils.dbg(tc, "compiled pattern:  " + regexPattern);
            compiledPermTbl.put(regexPattern, compiledPattern);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "compileFilePatterns", new Object[]{compiledPermTbl});
        }
        return compiledPermTbl;
    }

    private Hashtable buildPermissionsTable(String permissionsAndACLs) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildPermissionTable", new Object[]{permissionsAndACLs});
        }
        Hashtable<String, String> permTbl = new Hashtable<String, String>();
        if (permissionsAndACLs == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "buildPermissionsTable", new Object[]{permTbl});
            }
            return null;
        }
        String[] permissions = permissionsAndACLs.split(PERM_MULTIPLE_SEPARATOR);
        int sizeOfPermissions = permissions.length;
        for (int i = 0; i < sizeOfPermissions; ++i) {
            String[] splitPerm = permissions[i].split(PERM_TYPE_ACL_SEPARATOR, 2);
            String fileType = splitPerm[0];
            String aclStr = splitPerm[1];
            if (permTbl.containsKey(fileType) && !aclStr.equals((String)permTbl.get(fileType))) {
                aclStr = this.getLeastLenientFilePermission(aclStr, (String)permTbl.get(fileType));
            }
            AppUtils.dbg(tc, "ttt pattern = " + fileType + ", acl = " + aclStr);
            permTbl.put(fileType, aclStr);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildPermissionsTable", new Object[]{permTbl});
        }
        return permTbl;
    }

    private Hashtable getMaxAllowedPermissionTable() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMaxAllowedPermissionTable");
        }
        Hashtable maxPermTbl = new Hashtable();
        if (this.getMaxFilePermissionForApps() != null) {
            maxPermTbl = this.buildPermissionsTable(this.getMaxFilePermissionForApps());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMaxAllowedPermissionTable", new Object[]{maxPermTbl});
        }
        return maxPermTbl;
    }

    private String getLeastLenientFilePermission(String p1, String p2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLeastLenientFilePermission", new Object[]{p1, p2});
        }
        if (p1.equals(p2)) {
            return p1;
        }
        char[] perm1 = p1.toCharArray();
        int u1 = Character.getNumericValue(perm1[0]);
        int g1 = Character.getNumericValue(perm1[1]);
        int w1 = Character.getNumericValue(perm1[2]);
        char[] perm2 = p2.toCharArray();
        int u2 = Character.getNumericValue(perm2[0]);
        int g2 = Character.getNumericValue(perm2[1]);
        int w2 = Character.getNumericValue(perm2[2]);
        int uf = u1 <= u2 ? u1 : u2;
        int gf = g1 <= g2 ? g1 : g2;
        int wf = w1 <= w2 ? w1 : w2;
        String permf = "" + uf + gf + wf;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLeastLenientFilePermission = " + permf);
        }
        return permf;
    }

    private void setPermission(String file, int permission) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setPermission");
        }
        char[] perm = Integer.toString(permission).toCharArray();
        int user = Character.getNumericValue(perm[0]);
        int group = Character.getNumericValue(perm[1]);
        int world = Character.getNumericValue(perm[2]);
        this.doSetPermission(file, user, group, world);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setPermission");
        }
    }

    private void doSetPermission(String file, int user, int group, int world) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doSetPermission:  file = " + file + " u = " + user + ", g = " + group + ", w = " + world);
        }
        NativeFile nFile = new NativeFile(file);
        try {
            nFile.setPermissions(user, group, world);
        }
        catch (NativeFileIOException ex) {
            Tr.error(tc, "failure in setting file permissions", ex.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doSetPermission");
        }
    }

    private String getMaxFilePermissionForApps() {
        String maxFilePermission = AppSyncUtils.getMaxFilePermissionForApps(this._cellName, this._nodeName, this._repository);
        return maxFilePermission;
    }
}

