/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.j2ee.deploy.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.AppManagementFactory;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.application.j2ee.deploy.spi.DConfigBeanRootImpl;
import com.ibm.ws.management.application.j2ee.deploy.spi.J2EEDeploymentController;
import com.ibm.ws.management.application.j2ee.deploy.spi.exceptions.J2EEDeployInvalidModuleException;
import com.ibm.ws.management.util.RasUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.model.J2eeApplicationObject;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DConfigBeanRoot;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.BeanNotFoundException;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;

public class DeploymentConfigurationImpl
implements DeploymentConfiguration {
    private static TraceComponent tc = Tr.register(DeploymentConfigurationImpl.class, "Admin", "com.ibm.ws.management.resources.J2eeDeploymentMessages");
    private static final String CLASS_NAME;
    private static final String JSR88_ROOT_URI = "WebSphere88RootDepl";
    private static int gCounter;
    ResourceBundle resBundle;
    DeploymentManager dManager = null;
    DeployableObject rootObj = null;
    String _tmpArchive = null;
    J2EEDeploymentController _adController = null;
    Vector _depls = null;
    Vector _uris = null;
    Hashtable _dcRoots = null;

    public static synchronized String getTempFileName() {
        return AppUtils.getTempDir() + "j88_" + Long.toHexString(System.currentTimeMillis()) + "_" + gCounter++;
    }

    public DeploymentConfigurationImpl(DeployableObject dobj, DeploymentManager dm) throws InvalidModuleException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DeploymentConfigurationImpl: " + dobj);
        }
        this.rootObj = dobj;
        this.dManager = dm;
        this.resBundle = AppUtils.getBundle("com.ibm.ws.management.resources.J2eeDeploymentMessages", this.dManager.getCurrentLocale());
        this._depls = new Vector();
        this._uris = new Vector();
        this._dcRoots = new Hashtable();
        this._depls.addElement(this.rootObj);
        this._uris.addElement(JSR88_ROOT_URI);
        DConfigBeanRootImpl d = new DConfigBeanRootImpl(this, dobj.getDDBeanRoot(), JSR88_ROOT_URI);
        this._dcRoots.put(JSR88_ROOT_URI, d);
        if (this.rootObj.getType().equals(ModuleType.EAR)) {
            try {
                J2eeApplicationObject app = (J2eeApplicationObject)this.rootObj;
                String[] uris = app.getModuleUris();
                if (uris != null) {
                    for (int i = 0; i < uris.length; ++i) {
                        DeployableObject dob = app.getDeployableObject(uris[i]);
                        if (dob == null) continue;
                        this._depls.addElement(dob);
                        this._uris.addElement(uris[i]);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "<init>", "no module URIs");
                }
            }
            catch (Throwable th) {
                RasUtils.logException(th, tc, CLASS_NAME, "<init>", "127", this);
                throw new J2EEDeployInvalidModuleException(th.toString(), th);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DeploymentConfigurationImpl");
        }
    }

    public DeployableObject getDeployableObject() {
        return this.rootObj;
    }

    public DConfigBeanRoot getDConfigBeanRoot(DDBeanRoot arg0) throws ConfigurationException {
        DConfigBeanRoot dcr;
        if (!J2EEDeploymentController.isRootDDBean(arg0)) {
            return null;
        }
        if (arg0.getDeployableObject().getType().equals(ModuleType.RAR) || arg0.getDeployableObject().getType().equals(ModuleType.CAR)) {
            return null;
        }
        int index = this._depls.indexOf(arg0.getDeployableObject());
        if (index == -1) {
            throw new ConfigurationException(AppUtils.getMessage(this.resBundle, "ADMJ0001", new Object[]{arg0}));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "uri = " + this._uris.elementAt(index));
        }
        if ((dcr = (DConfigBeanRoot)this._dcRoots.get(this._uris.elementAt(index))) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "creating DCRoot for DD: " + arg0);
            }
            dcr = new DConfigBeanRootImpl(this, arg0, (String)this._uris.elementAt(index));
            this._dcRoots.put(this._uris.elementAt(index), dcr);
        }
        return dcr;
    }

    public void removeDConfigBean(DConfigBeanRoot arg0) throws BeanNotFoundException {
    }

    public DConfigBeanRoot restoreDConfigBean(InputStream arg0, DDBeanRoot arg1) throws ConfigurationException {
        return null;
    }

    public void saveDConfigBean(OutputStream arg0, DConfigBeanRoot arg1) throws ConfigurationException {
        DConfigBeanRootImpl impl = (DConfigBeanRootImpl)arg1;
        this.save(new DConfigBeanRootImpl[]{impl}, arg0);
    }

    public void save(OutputStream arg0) throws ConfigurationException {
        DConfigBeanRootImpl[] impls = new DConfigBeanRootImpl[this._dcRoots.size()];
        Iterator iter = this._dcRoots.values().iterator();
        int i = 0;
        while (iter.hasNext()) {
            impls[i++] = (DConfigBeanRootImpl)iter.next();
        }
        this.save(impls, arg0);
    }

    public void save(DConfigBeanRootImpl[] allDCs, OutputStream out) throws ConfigurationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "save: " + allDCs.length);
        }
        try {
            for (int i = 0; i < allDCs.length; ++i) {
                allDCs[i].saveTaskData();
            }
            this.getController().createDeploymentPlan(out);
            this.doCleanup();
        }
        catch (AppDeploymentException ex) {
            RasUtils.logException((Throwable)ex, tc, CLASS_NAME, "save", "227", this);
            ConfigurationException ce = new ConfigurationException(ex.toString());
            ce.initCause(ex);
            throw ce;
        }
        catch (InvalidModuleException ex) {
            RasUtils.logException((Throwable)ex, tc, CLASS_NAME, "save", "234", this);
            ConfigurationException ce = new ConfigurationException(ex.toString());
            ce.initCause(ex);
            throw ce;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "save");
        }
    }

    public void restore(InputStream arg0) throws ConfigurationException {
    }

    synchronized J2EEDeploymentController getController() throws InvalidModuleException {
        if (this._adController == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating ad controller");
            }
            try {
                this._tmpArchive = DeploymentConfigurationImpl.getTempFileName();
                this.extractArchive(this.rootObj, this._tmpArchive);
                if (!this.rootObj.getType().equals(ModuleType.EAR)) {
                    String earLocation = DeploymentConfigurationImpl.getTempFileName();
                    AppInstallHelper.createEarWrapper(this._tmpArchive, earLocation, JSR88_ROOT_URI, "/");
                    AppUtils.deleteDirTree(this._tmpArchive);
                    this._tmpArchive = earLocation;
                }
                Hashtable<String, Object> prefs = new Hashtable<String, Object>();
                prefs.put("jsr88", "");
                prefs.put("app.client.locale", this.dManager.getCurrentLocale());
                this._adController = (J2EEDeploymentController)AppManagementFactory.readArchive(this._tmpArchive, prefs);
                this._adController.setDConfigurationImpl(this);
            }
            catch (Throwable th) {
                RasUtils.logException(th, tc, CLASS_NAME, "getController", "280", this);
                throw new J2EEDeployInvalidModuleException(th.toString(), th);
            }
        }
        return this._adController;
    }

    public Vector getAllTypes() {
        Vector<ModuleType> v = new Vector<ModuleType>();
        for (int i = 0; i < this._depls.size(); ++i) {
            v.addElement(((DeployableObject)this._depls.elementAt(i)).getType());
        }
        return v;
    }

    public String getUriForDeployableObject(DeployableObject obj) {
        return (String)this._uris.elementAt(this._depls.indexOf(obj));
    }

    private void extractArchive(DeployableObject dobj, String dir) throws Exception {
        Enumeration entries;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractArchive: " + dobj + " to " + dir);
        }
        if ((entries = dobj.entries()) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "extractArchive", "no entries found!!");
            }
            return;
        }
        while (entries.hasMoreElements()) {
            byte[] bar;
            int bRead;
            String uri = (String)entries.nextElement();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "next uri: " + uri);
            }
            if (uri.endsWith("/")) continue;
            InputStream is = dobj.getEntry(uri);
            String fStr = dir + File.separator + uri;
            File f = new File(fStr);
            f.getParentFile().mkdirs();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Extracting .. " + uri + " at " + fStr);
            }
            FileOutputStream fout = new FileOutputStream(f);
            int avail = is.available();
            while (avail > 0 && (bRead = is.read(bar = new byte[avail])) >= 1) {
                fout.write(bar, 0, bRead);
                avail = is.available();
            }
            fout.flush();
            fout.close();
            is.close();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractArchive");
        }
    }

    protected void finalize() throws Throwable {
        this.doCleanup();
        super.finalize();
    }

    private void doCleanup() {
        if (this._tmpArchive != null) {
            try {
                if (this._adController != null) {
                    this._adController.close(false, false, true);
                }
                AppUtils.deleteDirTree(this._tmpArchive);
            }
            catch (Throwable th) {
                RasUtils.logException(th, tc, CLASS_NAME, "doCleanup", "381", this);
                Tr.warning(tc, "ADMJ0004W", new Object[]{th, this._tmpArchive});
            }
            this._adController = null;
            this._tmpArchive = null;
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/j2ee/deploy/spi/DeploymentConfigurationImpl.java, WAS.admin.installapp, WAS70.SERV1, q0834.18, ver. 1.8");
        }
        CLASS_NAME = DeploymentConfigurationImpl.class.getName();
        gCounter = 1;
    }
}

