/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.dfltbndngs.utils;

import com.ibm.ejs.models.base.bindings.commonbnd.MessageDestinationRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.impl.CommonbndFactoryImpl;
import com.ibm.ejs.models.base.bindings.ejbbnd.EnterpriseBeanBinding;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.ClientModuleRef;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.EJBModuleRef;
import com.ibm.etools.commonarchive.WARFile;
import com.ibm.etools.commonarchive.WebModuleRef;
import com.ibm.websphere.management.application.AppDeploymentUtil;
import com.ibm.ws.management.application.dfltbndngs.utils.MessageDestinationRefPkg;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.MessageDestinationRef;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class GetMessageDestinationRefs {
    static TraceComponent tc = Tr.register(GetMessageDestinationRefs.class, null, "com.ibm.ws.management.application.dfltbndngs.utils.GetMessageDestinationRefs");
    protected EARFile earFile;
    protected boolean created = false;

    public GetMessageDestinationRefs(EARFile earFile) {
        this.earFile = earFile;
    }

    public GetMessageDestinationRefs(EARFile earFile, boolean create) {
        this.earFile = earFile;
        this.created = create;
    }

    public Collection execute() throws Exception {
        boolean isEE5;
        Vector result = new Vector();
        List wars = this.earFile.getWebModuleRefs();
        for (int i = 0; i < wars.size(); ++i) {
            WebModuleRef webModuleRef = (WebModuleRef)wars.get(i);
            WARFile warFile = (WARFile)webModuleRef.getModuleFile();
            WebApp webApp = webModuleRef.getWebApp();
            isEE5 = AppDeploymentUtil.isEE5SchemaDD(warFile);
            if (webApp == null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "procssing " + webApp);
            }
            EList mdRefs = webApp.getMessageDestinationRefs();
            EList mdRefBindings = webModuleRef.getWebAppBinding().getMessageDestinationRefBindings();
            this.addMDRefs(mdRefs, mdRefBindings, webModuleRef.getModule().getUri(), null, isEE5, result);
        }
        List ejbjars = this.earFile.getEJBModuleRefs();
        for (int i = 0; i < ejbjars.size(); ++i) {
            EJBModuleRef ejbModuleRef = (EJBModuleRef)ejbjars.get(i);
            EJBJarFile ejbJarFile = (EJBJarFile)ejbModuleRef.getModuleFile();
            if (ejbModuleRef.getEJBJar() != null && tc.isDebugEnabled()) {
                Tr.debug(tc, "DD version: " + AppDeploymentUtil.getModuleVersion(ejbJarFile));
            }
            isEE5 = AppDeploymentUtil.isEE5SchemaDD(ejbJarFile);
            EJBJar ejbJar = ejbModuleRef.getEJBJar();
            if (ejbJar == null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "processing " + ejbModuleRef.getEJBJar());
            }
            EList ejbs = ejbJar.getEnterpriseBeans();
            for (int j = 0; j < ejbs.size(); ++j) {
                EnterpriseBean ejb = (EnterpriseBean)ejbs.get(j);
                EList mdRefs = ejb.getMessageDestinationRefs();
                EnterpriseBeanBinding ejbBindings = ejbModuleRef.getEJBJarBinding().getEJBBinding(ejb);
                EList mdRefBindings = ejbBindings.getMessageDestinationRefBindings();
                this.addMDRefs(mdRefs, mdRefBindings, ejbModuleRef.getModule().getUri(), ejb.getName(), isEE5, result);
            }
        }
        List clientJars = this.earFile.getClientModuleRefs();
        for (int i = 0; i < clientJars.size(); ++i) {
            ClientModuleRef clientModuleRef = (ClientModuleRef)clientJars.get(i);
            EList mdRefs = clientModuleRef.getApplicationClient().getMessageDestinationRefs();
            EList mdRefBindings = clientModuleRef.getApplicationClientBinding().getMessageDestinationRefs();
            this.addMDRefs(mdRefs, mdRefBindings, clientModuleRef.getModule().getUri(), null, false, result);
        }
        return result;
    }

    void addMDRefs(Collection refs, Collection refBindings, String moduleName, String componentName, boolean isEE5, Vector result) {
        for (MessageDestinationRef ref : refs) {
            if (isEE5 && ref.getLink() != null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "skipping msg dest ref in ee5 module with msg dest link: " + ref.getName());
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "look for matching binding for msg dest ref: " + ref.getName());
            }
            Iterator mdRefBindings = refBindings.iterator();
            MessageDestinationRefBinding found = null;
            while (mdRefBindings.hasNext()) {
                MessageDestinationRefBinding mdrb = (MessageDestinationRefBinding)mdRefBindings.next();
                if (mdrb.getBindingMessageDestinationRef() == null || !mdrb.getBindingMessageDestinationRef().equals(ref)) continue;
                found = mdrb;
                break;
            }
            if (found == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "create binding for msg dest ref: " + ref.getName());
                }
                found = CommonbndFactoryImpl.getActiveFactory().createMessageDestinationRefBinding();
                found.setBindingMessageDestinationRef(ref);
                refBindings.add(found);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found matching binding for msg dest ref: " + ref.getName());
            }
            if (this.created) continue;
            MessageDestinationRefPkg pkg = new MessageDestinationRefPkg();
            pkg.setRefBinding(found);
            pkg.setModule(moduleName);
            pkg.setComponent(componentName);
            result.addElement(pkg);
        }
    }
}

