/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.dfltbndngs.utils;

import com.ibm.ejs.models.base.bindings.clientbnd.ApplicationClientBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.CommonbndFactory;
import com.ibm.ejs.models.base.bindings.commonbnd.EjbRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.impl.CommonbndFactoryImpl;
import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EnterpriseBeanBinding;
import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.ClientModuleRef;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.EJBModuleRef;
import com.ibm.etools.commonarchive.ModuleRef;
import com.ibm.etools.commonarchive.WebModuleRef;
import com.ibm.websphere.management.application.AppDeploymentUtil;
import com.ibm.ws.management.application.dfltbndngs.utils.EJBRefPkg;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.common.EjbRef;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.webapplication.WebApp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetEjbRefs {
    private static final TraceComponent tc = Tr.register(GetEjbRefs.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    protected final EARFile earFile;
    protected final boolean create;
    protected List<EJBRefPkg> ejbRefPkgs = new ArrayList<EJBRefPkg>();

    public GetEjbRefs(EARFile earFile) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", "earFile=" + earFile);
        }
        this.earFile = earFile;
        this.create = false;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public GetEjbRefs(EARFile earFile, boolean create) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new String[]{"earFile=" + earFile, "create=" + create});
        }
        this.earFile = earFile;
        this.create = create;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public Collection execute() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        this.ejbRefPkgs = new ArrayList<EJBRefPkg>();
        List wars = this.earFile.getWebModuleRefs();
        for (WebModuleRef webModuleRef : wars) {
            this.addRefs(webModuleRef);
        }
        List ejbJars = this.earFile.getEJBModuleRefs();
        for (EJBModuleRef ejbModuleRef : ejbJars) {
            this.addRefs(ejbModuleRef);
        }
        List clientJars = this.earFile.getClientModuleRefs();
        for (ClientModuleRef clientModuleRef : clientJars) {
            this.addRefs(clientModuleRef);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute", this.ejbRefPkgs);
        }
        return this.ejbRefPkgs;
    }

    protected void addRefs(WebModuleRef webModuleRef) throws Exception {
        boolean ee5;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRefs", "webModuleRef=" + webModuleRef);
        }
        if (!(ee5 = AppDeploymentUtil.isEE5SchemaDD(webModuleRef.getModuleFile()))) {
            WebAppBinding webAppBinding = webModuleRef.getWebAppBinding();
            EList ejbRefBindings = webAppBinding.getEjbRefBindings();
            WebApp webApp = webModuleRef.getWebApp();
            EList ejbRefs = webApp.getEjbRefs();
            this.addRefs(webModuleRef, (List<EjbRef>)ejbRefs, (List<EjbRefBinding>)ejbRefBindings);
            EList ejbLocalRefs = webApp.getEjbLocalRefs();
            this.addRefs(webModuleRef, (List<EjbRef>)ejbLocalRefs, (List<EjbRefBinding>)ejbRefBindings);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addRefs", "EE5: not adding ejbRefPkg");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRefs");
        }
    }

    protected void addRefs(EJBModuleRef ejbModuleRef) throws Exception {
        EJBJar ejbJar;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRefs", "ejbModuleRef=" + ejbModuleRef);
        }
        if ((ejbJar = ejbModuleRef.getEJBJar()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "addRefs", "ejbJar=" + ejbJar);
            }
            EJBJarFile ejbJarFile = (EJBJarFile)ejbModuleRef.getModuleFile();
            boolean ejb3 = AppDeploymentUtil.isEE5SchemaDD(ejbJarFile);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "addRefs", "ejb3=" + ejb3);
            }
            if (!ejb3) {
                EJBJarBinding ejbJarBinding = ejbModuleRef.getEJBJarBinding();
                EList ejbs = ejbJar.getEnterpriseBeans();
                for (EnterpriseBean ejb : ejbs) {
                    EnterpriseBeanBinding ejbBindings = ejbJarBinding.getEJBBinding(ejb);
                    EList ejbRefBindings = ejbBindings.getEjbRefBindings();
                    EList ejbRefs = ejb.getEjbRefs();
                    this.addRefs(ejbModuleRef, ejbJar, ejb, ejbRefs, ejbRefBindings);
                    EList ejbLocalRefs = ejb.getEjbLocalRefs();
                    this.addRefs(ejbModuleRef, ejbJar, ejb, ejbLocalRefs, ejbRefBindings);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "addRefs", "EJB3: not adding ejbRefPkg");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addRefs", "ejbJar is null for " + ejbModuleRef.getUri());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRefs");
        }
    }

    protected void addRefs(ClientModuleRef clientModuleRef) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRefs", "clientModuleRef=" + clientModuleRef);
        }
        ApplicationClientBinding appClientBinding = clientModuleRef.getApplicationClientBinding();
        EList ejbRefBindings = appClientBinding.getEjbRefs();
        ApplicationClient appClient = clientModuleRef.getApplicationClient();
        EList ejbRefs = appClient.getEjbReferences();
        this.addRefs(clientModuleRef, (List<EjbRef>)ejbRefs, (List<EjbRefBinding>)ejbRefBindings);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRefs");
        }
    }

    protected void addRefs(WebModuleRef webModuleRef, List<EjbRef> ejbRefs, List<EjbRefBinding> ejbRefBindings) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRefs", new String[]{"webModuleRef=" + webModuleRef, "ejbRefs=" + ejbRefs, "ejbRefBindings=" + ejbRefBindings});
        }
        for (EjbRef ejbRef : ejbRefs) {
            EjbRefBinding binding = this.ensureBinding(ejbRefBindings, ejbRef);
            if (this.create) continue;
            String qualifier = this.qualify(webModuleRef);
            EJBRefPkg ejbRefPkg = new EJBRefPkg(binding, qualifier);
            this.ejbRefPkgs.add(ejbRefPkg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRefs");
        }
    }

    protected void addRefs(EJBModuleRef ejbModuleRef, EJBJar ejbJar, EnterpriseBean ejb, List<EjbRef> ejbRefs, List<EjbRefBinding> ejbRefBindings) {
        for (EjbRef ejbRef : ejbRefs) {
            EjbRefBinding binding = this.ensureBinding(ejbRefBindings, ejbRef);
            if (this.create) continue;
            String qualifier = this.qualify(ejbModuleRef, ejbJar, ejb);
            EJBRefPkg ejbRefPkg = new EJBRefPkg(binding, qualifier);
            this.ejbRefPkgs.add(ejbRefPkg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRefs");
        }
    }

    protected void addRefs(ClientModuleRef clientModuleRef, List<EjbRef> ejbRefs, List<EjbRefBinding> ejbRefBindings) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRefs", new String[]{"clientModuleRef=" + clientModuleRef, "ejbRefs=" + ejbRefs, "ejbRefBindings=" + ejbRefBindings});
        }
        for (EjbRef ejbRef : ejbRefs) {
            EjbRefBinding binding = this.ensureBinding(ejbRefBindings, ejbRef);
            if (this.create) continue;
            String qualifier = this.qualify(clientModuleRef);
            EJBRefPkg ejbRefPkg = new EJBRefPkg(binding, qualifier);
            this.ejbRefPkgs.add(ejbRefPkg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRefs");
        }
    }

    protected EjbRefBinding ensureBinding(List<EjbRefBinding> ejbRefBindings, EjbRef ejbRef) {
        EjbRefBinding ejbRefBinding;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ensureBinding", new String[]{"ejbRefBindings=" + ejbRefBindings, "ejbRef=" + ejbRef});
        }
        if ((ejbRefBinding = this.locateBinding(ejbRefBindings, ejbRef)) == null) {
            ejbRefBinding = this.createBinding(ejbRef);
            ejbRefBindings.add(ejbRefBinding);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ensureBinding", ejbRefBinding);
        }
        return ejbRefBinding;
    }

    protected EjbRefBinding locateBinding(List<EjbRefBinding> ejbRefBindings, EjbRef ejbRef) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "locateBinding", new String[]{"ejbRefBindings=" + ejbRefBindings, "ejbRef=" + ejbRef});
        }
        EjbRefBinding binding = null;
        Iterator<EjbRefBinding> i = ejbRefBindings.iterator();
        while (binding == null && i.hasNext()) {
            EjbRefBinding ejbRefBinding = i.next();
            EjbRef ref = ejbRefBinding.getBindingEjbRef();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "locateBinding", "ref=" + ref);
            }
            if (ref == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "locateBinding", "WARNING: EjbRefBinding has no binding EJB reference!");
                continue;
            }
            if (!ref.equals(ejbRef)) continue;
            binding = ejbRefBinding;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "locateBinding", binding);
        }
        return binding;
    }

    protected EjbRefBinding createBinding(EjbRef ejbRef) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createBinding", "ejbRef=" + ejbRef);
        }
        CommonbndFactory factory = CommonbndFactoryImpl.getActiveFactory();
        EjbRefBinding ejbRefBinding = factory.createEjbRefBinding();
        ejbRefBinding.setBindingEjbRef(ejbRef);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createBinding", ejbRefBinding);
        }
        return ejbRefBinding;
    }

    protected String qualify(ModuleRef moduleRef) {
        Module module = moduleRef.getModule();
        String uri = module.getUri();
        return uri;
    }

    protected String qualify(EJBModuleRef ejbModuleRef, EJBJar ejbJar, EnterpriseBean ejb) {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.qualify(ejbModuleRef, ejbJar));
        stringBuilder.append(':');
        stringBuilder.append(this.qualify(ejb));
        return stringBuilder.toString();
    }

    protected String qualify(EJBModuleRef ejbModuleRef, EJBJar ejbJar) {
        String qualifier = ejbJar.getDisplayName();
        if (qualifier == null) {
            qualifier = this.qualify(ejbModuleRef);
        }
        return qualifier;
    }

    protected String qualify(EnterpriseBean ejb) {
        String qualifier = ejb.getDisplayName();
        if (qualifier == null) {
            qualifier = ejb.getEjbClassName();
        }
        return qualifier;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        stringBuilder.append("[earFile=");
        stringBuilder.append(this.earFile);
        stringBuilder.append(", create=");
        stringBuilder.append(this.create);
        stringBuilder.append(", ejbRefPkgs=");
        stringBuilder.append(this.ejbRefPkgs);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/dfltbndngs/utils/GetEjbRefs.java, WAS.admin.installapp.client, WAS70.SERV1, q0834.18, ver. 1.8.1.8");
        }
        CLASS_NAME = GetEjbRefs.class.getName();
    }
}

