/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.dfltbndngs.utils;

import com.ibm.ejs.models.base.bindings.commonbnd.ResourceEnvRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.impl.CommonbndFactoryImpl;
import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EnterpriseBeanBinding;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.ClientModuleRef;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.EJBModuleRef;
import com.ibm.etools.commonarchive.WebModuleRef;
import com.ibm.websphere.management.application.AppDeploymentUtil;
import com.ibm.ws.management.application.client.MapResEnvRefToResHelper;
import com.ibm.ws.management.application.dfltbndngs.utils.ResEnvRef;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.ResourceEnvRef;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;

public class GetAllResourceEnvRefs {
    static TraceComponent tc = Tr.register(GetAllResourceEnvRefs.class, null, "com.ibm.ws.management.application.dfltbndngs.utils.GetAllResourceEnvRefs");
    private EARFile ear = null;
    private boolean created = false;

    public GetAllResourceEnvRefs(EARFile ear) {
        this.ear = ear;
    }

    public GetAllResourceEnvRefs(EARFile ear, boolean create) {
        this.ear = ear;
        this.created = create;
    }

    public Vector execute() throws Exception {
        Vector result = new Vector();
        List wars = this.ear.getWebModuleRefs();
        for (int i = 0; i < wars.size(); ++i) {
            WebModuleRef webModuleRef = (WebModuleRef)wars.get(i);
            EList resEnvRefBindings = webModuleRef.getWebAppBinding().getResourceEnvRefBindings();
            EList resEnvRefs = webModuleRef.getWebApp().getResourceEnvRefs();
            this.addResEnvRefs(resEnvRefs, resEnvRefBindings, webModuleRef.getModule().getUri(), null, result);
        }
        List ejbjars = this.ear.getEJBModuleRefs();
        for (int i = 0; i < ejbjars.size(); ++i) {
            EJBModuleRef ejbModuleRef = (EJBModuleRef)ejbjars.get(i);
            EJBJarFile ejbJarFile = (EJBJarFile)ejbModuleRef.getModuleFile();
            EJBJar ejbJar = ejbModuleRef.getEJBJar();
            if (ejbJar != null && tc.isDebugEnabled()) {
                Tr.debug(tc, "DD version: " + AppDeploymentUtil.getModuleVersion(ejbJarFile));
            }
            if (ejbJar != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "processing " + ejbJar);
                }
                EJBJarBinding ejbJarBinding = ejbModuleRef.getEJBJarBinding();
                EList ejbs = ejbJar.getEnterpriseBeans();
                for (int j = 0; j < ejbs.size(); ++j) {
                    EnterpriseBean ejb = (EnterpriseBean)ejbs.get(j);
                    EnterpriseBeanBinding ejbBindings = ejbJarBinding.getEJBBinding(ejb);
                    EList resEnvRefBindings = ejbBindings.getResourceEnvRefBindings();
                    EList resEnvRefs = ejb.getResourceEnvRefs();
                    this.addResEnvRefs(resEnvRefs, resEnvRefBindings, ejbModuleRef.getModule().getUri(), ejb.getName(), result);
                }
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "GetAllResourceEnvRefs.execute(): ejbModuleRef.getEJBJar() is null");
        }
        List clientJars = this.ear.getClientModuleRefs();
        for (int i = 0; i < clientJars.size(); ++i) {
            ClientModuleRef clientModuleRef = (ClientModuleRef)clientJars.get(i);
            EList resEnvRefBindings = clientModuleRef.getApplicationClientBinding().getResourceEnvRefBindings();
            EList resEnvRefs = clientModuleRef.getApplicationClient().getResourceEnvRefs();
            this.addResEnvRefs(resEnvRefs, resEnvRefBindings, clientModuleRef.getModule().getUri(), null, result);
        }
        return result;
    }

    void addResEnvRefs(Collection resEnvRefs, Collection resEnvRefBindings, String module, String component2, Vector result) {
        Iterator resourceEnvRefs = resEnvRefs.iterator();
        while (resourceEnvRefs.hasNext()) {
            ResourceEnvRefBinding rrb;
            ResEnvRef pkg = new ResEnvRef();
            ResourceEnvRef ref = (ResourceEnvRef)resourceEnvRefs.next();
            if (this.isInjectionType(ref)) continue;
            Iterator resRefBindings = resEnvRefBindings.iterator();
            boolean found = false;
            while (resRefBindings.hasNext()) {
                rrb = (ResourceEnvRefBinding)resRefBindings.next();
                if (rrb.getBindingResourceEnvRef() == null || !rrb.getBindingResourceEnvRef().equals(ref)) continue;
                found = true;
                pkg.setBinding(rrb);
            }
            if (!found) {
                rrb = CommonbndFactoryImpl.getActiveFactory().createResourceEnvRefBinding();
                rrb.setBindingResourceEnvRef(ref);
                resEnvRefBindings.add(rrb);
                pkg.setBinding(rrb);
            }
            if (this.created) continue;
            pkg.setModule(module);
            pkg.setComponent(component2);
            result.addElement(pkg);
        }
    }

    boolean isInjectionType(ResourceEnvRef ref) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isInjectionType", new Object[]{ref});
        }
        boolean ret = false;
        if (MapResEnvRefToResHelper.injectionTypeNames.contains(ref.getTypeName())) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ignoring resource env ref is created by injection engine with SessionContext types");
            }
            ret = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isInjectionType", new Object[]{new Boolean(ret)});
        }
        return ret;
    }
}

