/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client;

import com.ibm.ejs.models.base.resources.J2EEResourceFactory;
import com.ibm.ejs.models.base.resources.J2EEResourceProvider;
import com.ibm.ejs.models.base.resources.j2c.J2CActivationSpec;
import com.ibm.ejs.models.base.resources.j2c.J2CAdminObject;
import com.ibm.ejs.models.base.resources.j2c.J2CConnectionFactory;
import com.ibm.ejs.models.base.resources.j2c.J2CResourceAdapter;
import com.ibm.ejs.models.base.resources.jdbc.DataSource;
import com.ibm.ejs.models.base.resources.jms.JMSConnectionFactory;
import com.ibm.ejs.models.base.resources.jms.internalmessaging.WASQueue;
import com.ibm.ejs.models.base.resources.jms.internalmessaging.WASQueueConnectionFactory;
import com.ibm.ejs.models.base.resources.jms.internalmessaging.WASTopic;
import com.ibm.ejs.models.base.resources.jms.internalmessaging.WASTopicConnectionFactory;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQConnectionFactory;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQQueue;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQQueueConnectionFactory;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQTopic;
import com.ibm.ejs.models.base.resources.jms.mqseries.MQTopicConnectionFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.ResourceMapper;
import com.ibm.websphere.management.application.client.ResourceValidationHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.InvalidAttributeNameException;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.configservice.MOFUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMLResource;

public class ResourceMapperDefaultImpl
extends ResourceMapper {
    private static TraceComponent tc = Tr.register(ResourceMapperDefaultImpl.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    private Hashtable _resTaskTypeInfoTable;
    private static final List _dataSourceMapping;
    private static final Hashtable _resRefTypeMappingTable;

    public ResourceMapperDefaultImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ResourceMapperDefaultImpl");
        }
        this._populateTaskTypeInfoTable();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ResourceMapperDefaultImpl");
        }
    }

    public List getConfigFilesToLoad(String operation) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigFiles", new Object[]{operation});
        }
        ArrayList<String> configFiles = new ArrayList<String>();
        configFiles.add("resources.xml");
        configFiles.add("virtualhosts.xml");
        configFiles.add("libraries.xml");
        configFiles.add("resources-pme.xml");
        configFiles.add("resources-pme502.xml");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigFiles", new Object[]{configFiles});
        }
        return configFiles;
    }

    public List getInAppConfigFilesToLoad(String operation) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInAppConfigFiles", new Object[]{operation});
        }
        ArrayList<String> configFiles = new ArrayList<String>();
        configFiles.add("resources.xml");
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInAppConfigFiles", new Object[]{configFiles});
        }
        return configFiles;
    }

    public Hashtable getChildTypesAndObjects(EObject ob) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getChildTypesAndObjects", new Object[]{ob});
        }
        Hashtable tbl = new Hashtable();
        if (ob instanceof J2EEResourceProvider) {
            EList factories = ((J2EEResourceProvider)ob).getFactories();
            for (J2EEResourceFactory factory : factories) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "child is type: " + factory.eClass().getName());
                }
                ResourceValidationHelper.addToScopeResultTable(factory.eClass().getName(), factory, tbl);
            }
        }
        if (ob instanceof J2CResourceAdapter) {
            EList adminObjects = ((J2CResourceAdapter)ob).getJ2cAdminObjects();
            for (J2CAdminObject adminObject : adminObjects) {
                ResourceValidationHelper.addToScopeResultTable(adminObject.eClass().getName(), adminObject, tbl);
            }
            EList activationSpecObjects = ((J2CResourceAdapter)ob).getJ2cActivationSpec();
            for (J2CActivationSpec activationSpecObject : activationSpecObjects) {
                ResourceValidationHelper.addToScopeResultTable(activationSpecObject.eClass().getName(), activationSpecObject, tbl);
            }
        }
        if (ob instanceof ServerCluster) {
            EList members = ((ServerCluster)ob).getMembers();
            for (ClusterMember clusterMember : members) {
                ResourceValidationHelper.addToScopeResultTable(clusterMember.eClass().getName(), clusterMember, tbl);
            }
        }
        return tbl;
    }

    public List getSubtypes(EObject ob) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSubTypes", new Object[]{ob});
        }
        ArrayList subtype = new ArrayList();
        if (ob != null) {
            if (ob instanceof J2CAdminObject) {
                if (((J2CAdminObject)ob).getAdminObject() != null) {
                    String aoInterface = ((J2CAdminObject)ob).getAdminObject().getAdminObjectInterface();
                    List mapping = this._getResRefTypeMapping(aoInterface);
                    for (int i = 0; i < mapping.size(); ++i) {
                        subtype.add(mapping.get(i));
                    }
                }
            } else if (ob instanceof J2CConnectionFactory) {
                if (((J2CConnectionFactory)ob).getConnectionDefinition() != null) {
                    String cfInterface = ((J2CConnectionFactory)ob).getConnectionDefinition().getConnectionFactoryInterface();
                    List mapping = this._getResRefTypeMapping(cfInterface);
                    for (int i = 0; i < mapping.size(); ++i) {
                        subtype.add(mapping.get(i));
                    }
                }
            } else if (ob instanceof WASQueue || ob instanceof MQQueue) {
                subtype.add("Queue");
            } else if (ob instanceof WASQueueConnectionFactory || ob instanceof MQQueueConnectionFactory) {
                subtype.add("QueueConnectionFactory");
            } else if (ob instanceof WASTopic || ob instanceof MQTopic) {
                subtype.add("Topic");
            } else if (ob instanceof WASTopicConnectionFactory || ob instanceof MQTopicConnectionFactory) {
                subtype.add("TopicConnectionFactory");
            } else if (ob instanceof DataSource) {
                subtype.add("WAS50DataSource");
            } else if (ob instanceof JMSConnectionFactory || ob instanceof MQConnectionFactory) {
                subtype.add("ConnectionFactory");
            } else if (ob instanceof J2CResourceAdapter && ((XMLResource)ob.eResource()).getID(ob).equals("builtin_rra")) {
                subtype.add("CMPConnectorFactory");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSubTypes", new Object[]{subtype});
        }
        return subtype;
    }

    public List getTypesForTask(String taskName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTypesForTask", new Object[]{taskName});
        }
        List<Object> types2 = new ArrayList<Object>();
        if (taskName != null && taskName.trim().length() > 0) {
            ResourceTaskTypeInfo taskTypeInfo = (ResourceTaskTypeInfo)this._resTaskTypeInfoTable.get(taskName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "taskTypeInfo: " + taskTypeInfo);
            }
            if (taskTypeInfo != null) {
                Object type = taskTypeInfo.getResType();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "tasktypeinfo.getResType: " + type);
                }
                if (type instanceof String) {
                    types2 = new ArrayList();
                    types2.add(type);
                } else if (type instanceof List) {
                    types2 = (List)type;
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No type defined for task " + taskName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTypesForTask", new Object[]{types2});
        }
        return types2;
    }

    public List getTypesForTask(AppDeploymentTask task, String[] taskData) {
        ArrayList types2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTypesForTask", new Object[]{task, taskData});
        }
        if ((types2 = this.getTypesForTask(task.getName())).size() > 1) {
            ArrayList newTypes = new ArrayList();
            String colName = new String();
            if (task.getName().equals("MapResRefToEJB")) {
                colName = "resRef.type";
            } else if (task.getName().equals("MapResEnvRefToRes")) {
                colName = "resEnvRef.type";
            }
            int colIndex = ResourceValidationHelper.getMatchingColIndex(task, colName);
            if (colIndex != -1 && colIndex < taskData.length) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "type data: " + taskData[colIndex]);
                }
                List mapping = this._getResRefTypeMapping(taskData[colIndex]);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "mapping to: " + mapping);
                }
                for (int i = 0; i < mapping.size(); ++i) {
                    if (types2.contains(mapping.get(i))) {
                        newTypes.add(mapping.get(i));
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "type maps to: " + mapping.get(i));
                        continue;
                    }
                    if (task.getName().equals("MapResEnvRefToRes")) {
                        if (!newTypes.contains("ResourceEnvEntry")) {
                            newTypes.add("ResourceEnvEntry");
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "type maps to: ResourceEnvEntry");
                        continue;
                    }
                    if (!newTypes.contains(taskData[colIndex])) {
                        newTypes.add(taskData[colIndex]);
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "type maps to: " + taskData[colIndex]);
                }
                types2 = newTypes;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTypesForTask", new Object[]{types2});
        }
        return types2;
    }

    public List getResourceTypeAttr(String resType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceTypeAttr", new Object[]{resType});
        }
        ArrayList<Object> typeAttrs = new ArrayList<Object>();
        Enumeration elements = this._resTaskTypeInfoTable.elements();
        while (elements.hasMoreElements()) {
            Object typeAttr;
            ResourceTaskTypeInfo taskTypeInfo = (ResourceTaskTypeInfo)elements.nextElement();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "taskTypeInfo: " + taskTypeInfo);
            }
            if (taskTypeInfo == null) continue;
            Object type = taskTypeInfo.getResType();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "type: " + type);
            }
            if (type == null) continue;
            boolean found = false;
            if (type instanceof String) {
                if (((String)type).equals(resType)) {
                    found = true;
                }
            } else if (type instanceof List && ((List)type).contains(resType)) {
                found = true;
            }
            if (!found) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found the first match in " + taskTypeInfo.getTaskName());
            }
            if ((typeAttr = taskTypeInfo.getTypeAttr()) instanceof String) {
                if (typeAttrs.contains((String)typeAttr)) continue;
                typeAttrs.add(typeAttr);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "adding type attr: " + typeAttr);
                continue;
            }
            if (!(typeAttr instanceof List)) continue;
            for (int i = 0; i < ((List)typeAttr).size(); ++i) {
                if (typeAttrs.contains(((List)typeAttr).get(i))) continue;
                typeAttrs.add(((List)typeAttr).get(i));
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "adding type attr: " + ((List)typeAttr).get(i));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceTypeAttr", new Object[]{typeAttrs});
        }
        return typeAttrs;
    }

    public Hashtable getColumnValue(AppDeploymentTask task, String[] data) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getColumnValue", new Object[]{task, data});
        }
        Hashtable<Integer, String> valueTbl = new Hashtable<Integer, String>();
        ResourceTaskTypeInfo taskTypeInfo = (ResourceTaskTypeInfo)this._resTaskTypeInfoTable.get(task.getName());
        if (taskTypeInfo != null) {
            List colIndex = this._getTaskColumnIndex(task, taskTypeInfo.getTaskAttr());
            for (int i = 0; i < colIndex.size(); ++i) {
                if ((Integer)colIndex.get(i) >= data.length) continue;
                String value = data[(Integer)colIndex.get(i)];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "data[" + (Integer)colIndex.get(i) + "]: " + data[(Integer)colIndex.get(i)]);
                }
                if (value != null && value.trim().length() != 0) {
                    valueTbl.put((Integer)colIndex.get(i), value);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Skipping null or empty value");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getColumnValue", new Object[]{valueTbl});
        }
        return valueTbl;
    }

    public Hashtable getResourceValuesWithAttrsAndObjects(String resType, List refO) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourcesValuesWithAttrsAndObjects", new Object[]{resType, refO});
        }
        Hashtable values = this._getResourceValues(resType, refO, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourcesValuesWithAttrsAndObjects", new Object[]{values});
        }
        return values;
    }

    public Hashtable getResourceValuesWithObjects(String resType, List refO) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourcesValuesWithObjects", new Object[]{resType, refO});
        }
        Hashtable values = this._getResourceValues(resType, refO, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourcesValuesWithObjects", new Object[]{values});
        }
        return values;
    }

    private Hashtable _getResourceValues(String resType, List refO, boolean includeAttr) throws AppDeploymentException {
        ArrayList<String> defaultAttrNames = new ArrayList<String>();
        defaultAttrNames.add("jndiName");
        defaultAttrNames.add("name");
        Hashtable values = new Hashtable();
        if (refO != null) {
            ArrayList<String> attrName = this.getResourceTypeAttr(resType);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "attrName: " + attrName);
            }
            if (attrName.size() == 0) {
                attrName = defaultAttrNames;
            }
            for (int i = 0; i < refO.size(); ++i) {
                ArrayList empty;
                ArrayList<Object> value;
                ArrayList<Object> refObjectValues = new ArrayList<Object>();
                for (int j = 0; j < attrName.size(); ++j) {
                    Object value2 = null;
                    String attr = (String)attrName.get(j);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getting value for attr: " + attr + " for EObject " + refO.get(i));
                    }
                    try {
                        Object ob = refO.get(i);
                        value2 = ob instanceof String ? (Object)ob : MOFUtil.getAttribute((EObject)((EObject)refO.get(i)), (String)attr, (boolean)false);
                    }
                    catch (InvalidAttributeNameException iane) {
                        if (attrName != defaultAttrNames) {
                            throw new AppDeploymentException("", iane);
                        }
                    }
                    catch (ConfigServiceException cse) {
                        throw new AppDeploymentException("", cse);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "attr value: " + value2);
                    }
                    if (value2 == null) continue;
                    if (includeAttr) {
                        Hashtable attrValues;
                        if (refObjectValues.size() == 0) {
                            attrValues = new Hashtable();
                            refObjectValues.add(attrValues);
                        } else {
                            attrValues = (Hashtable)refObjectValues.get(0);
                        }
                        attrValues.put(attr, value2);
                    } else {
                        refObjectValues.add(value2);
                    }
                    if (attrName == defaultAttrNames) break;
                }
                if (((Object)(value = refObjectValues.size() == 1 ? refObjectValues.get(0) : refObjectValues)).equals(empty = new ArrayList())) continue;
                if (!values.containsKey(value)) {
                    values.put(value, refO.get(i));
                    continue;
                }
                List list = new ArrayList();
                if (values.get(value) instanceof EObject) {
                    list.add(values.get(value));
                } else {
                    list = (List)values.get(value);
                }
                if (!list.contains(refO.get(i))) {
                    list.add(refO.get(i));
                }
                values.put(value, list);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "resource object list is empty");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourcesValuesWithObjects", new Object[]{values});
        }
        return values;
    }

    public void addValidationTypes(List types2) {
        if (types2.contains("DataSource") && !types2.contains("J2CConnectionFactory")) {
            types2.add("J2CConnectionFactory");
        }
    }

    public String[] validateInScopeResource(AppDeploymentTask task, String[] taskData, Hashtable resObjTbl, boolean searchInAllScope, List targets, List outOfScopeResInfo) throws AppDeploymentException {
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateInScopeResource", new Object[]{task, taskData, resObjTbl, targets, new Boolean(searchInAllScope), outOfScopeResInfo});
        }
        ResourceTaskTypeInfo taskTypeInfo = (ResourceTaskTypeInfo)this._resTaskTypeInfoTable.get(task.getName());
        List matchingColIndex = this._getTaskColumnIndex(task, taskTypeInfo.getTaskAttr());
        String[] saveTaskData = new String[taskData.length];
        for (i = 0; i < taskData.length; ++i) {
            saveTaskData[i] = taskData[i];
        }
        for (i = 0; i < matchingColIndex.size(); ++i) {
            List info;
            if (this._isResourceInScope(task, saveTaskData, (Integer)matchingColIndex.get(i), resObjTbl, targets, searchInAllScope, outOfScopeResInfo)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "resource " + saveTaskData[(Integer)matchingColIndex.get(i)] + " not in scope");
            }
            if ((info = this._buildOutOfScopeResInfo(task, saveTaskData, targets, outOfScopeResInfo)) == null || info.size() <= 0) continue;
            outOfScopeResInfo.addAll(info);
        }
        if (outOfScopeResInfo.size() == 0) {
            saveTaskData = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateInScopeResource", new Object[]{saveTaskData});
        }
        return saveTaskData;
    }

    public String[] validateMisTypeResource(AppDeploymentTask task, String[] taskData, Hashtable resValueTbl, List targets, List outOfScopeMsgs, List misTypeMsgs) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateMisTypeResource", new Object[]{task, taskData, resValueTbl, targets, outOfScopeMsgs, misTypeMsgs});
        }
        String[] saveTaskData = new String[taskData.length];
        for (int i = 0; i < taskData.length; ++i) {
            saveTaskData[i] = taskData[i];
        }
        boolean moreToValidateMisType = false;
        List types2 = this.getTypesForTask(task, taskData);
        Hashtable colValueTbl = this.getColumnValue(task, taskData);
        Enumeration colValueEnum = colValueTbl.keys();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "colValueEnum: " + colValueEnum);
        }
        while (colValueEnum.hasMoreElements()) {
            Integer colIndex = (Integer)colValueEnum.nextElement();
            String value = (String)colValueTbl.get(colIndex);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "processing value: " + value);
            }
            ArrayList<Object> colValues = new ArrayList<Object>();
            if ("MapSharedLibForMod".equals(task.getName())) {
                Hashtable libData = AppUtils.getSharedLibData(value);
                Enumeration libNames = libData.keys();
                while (libNames.hasMoreElements()) {
                    colValues.add(libNames.nextElement());
                }
            } else {
                colValues.add(value);
            }
            StringBuffer notFoundValue = new StringBuffer();
            for (int i = 0; i < colValues.size(); ++i) {
                String colValue = (String)colValues.get(i);
                Enumeration keys = resValueTbl.keys();
                Hashtable misType = null;
                String misScope = null;
                while (keys.hasMoreElements()) {
                    String scope = (String)keys.nextElement();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "scope: " + scope);
                    }
                    misType = null;
                    misScope = null;
                    Hashtable valueTbl = (Hashtable)resValueTbl.get(scope);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "valueTbl: " + valueTbl);
                    }
                    if (valueTbl.containsKey(colValue)) {
                        List misTypeObjList = (List)valueTbl.get(colValue);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "misTypeObjList: " + misTypeObjList);
                        }
                        for (int j = 0; j < misTypeObjList.size(); ++j) {
                            Hashtable misTypeObj = (Hashtable)misTypeObjList.get(j);
                            if (types2.contains((String)misTypeObj.get("resource.type"))) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found mis type: " + misTypeObj + " in list index " + j);
                            }
                            misType = misTypeObj;
                            misScope = scope;
                            break;
                        }
                        if (misType == null) continue;
                        break;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "value is not in table... no mistype yet");
                }
                if (misType != null) {
                    List info = this._buildMisTypeResInfo(task, taskData, colValue, targets, misType, misScope, outOfScopeMsgs);
                    if (info.size() <= 0) continue;
                    misTypeMsgs.addAll(info);
                    continue;
                }
                if (notFoundValue.length() > 0) {
                    notFoundValue.append("+");
                }
                notFoundValue.append(colValue);
            }
            if (notFoundValue.length() > 0) {
                saveTaskData[colIndex.intValue()] = notFoundValue.toString();
                moreToValidateMisType = true;
            } else {
                saveTaskData[colIndex.intValue()] = "";
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Changing saveTaskData[" + colIndex + "] to " + saveTaskData[colIndex]);
        }
        if (!moreToValidateMisType) {
            saveTaskData = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateMisTypeResource", new Object[]{saveTaskData});
        }
        return saveTaskData;
    }

    public String[] postDataToValidate(AppDeploymentTask task, String[] data) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "postDataToValidate", new Object[]{task, data});
        }
        if (tc.isDebugEnabled()) {
            for (int i = 0; i < data.length; ++i) {
                Tr.debug(tc, "data[" + i + "]: " + data[i]);
            }
        }
        String[] postData = null;
        if ("MapSharedLibForMod".equals(task.getName())) {
            String[][] taskData = ResourceValidationHelper.getExpandedTaskData(task);
            String[] appScopeData = null;
            int urlColumn = ResourceValidationHelper.getMatchingColIndex(task, "uri");
            for (int j = 1; urlColumn != -1 && j < taskData.length; ++j) {
                if (taskData[j][urlColumn].indexOf("application.xml") == -1) continue;
                appScopeData = taskData[j];
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "app scope library data: " + appScopeData.toString());
                break;
            }
            int sharedLibColumn = ResourceValidationHelper.getMatchingColIndex(task, "sharedLibName");
            if (appScopeData != null && appScopeData[sharedLibColumn] != null && appScopeData[sharedLibColumn].length() > 0) {
                int i;
                postData = new String[data.length];
                for (i = 0; i < data.length; ++i) {
                    postData[i] = data[i];
                }
                postData[sharedLibColumn] = appScopeData[sharedLibColumn];
                if (tc.isDebugEnabled()) {
                    for (i = 0; i < postData.length; ++i) {
                        Tr.debug(tc, "postData[" + i + "]: " + postData[i]);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "postDataToValidate", new Object[]{postData});
        }
        return postData;
    }

    public String buildWarningMsg(String taskName, Hashtable invalidResInfo) {
        String misType;
        String[] warningMsgInfo;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildWarningMsg", new Object[]{taskName, invalidResInfo});
        }
        String msg = null;
        ResourceTaskTypeInfo taskTypeInfo = (ResourceTaskTypeInfo)this._resTaskTypeInfoTable.get(taskName);
        if (taskTypeInfo != null && (warningMsgInfo = (misType = (String)invalidResInfo.get("MisType")) != null ? taskTypeInfo.getMisTypeWarningMsgInfo() : taskTypeInfo.getValidationWarningMsgInfo()) != null && warningMsgInfo.length > 1) {
            String msgId = warningMsgInfo[0];
            int len = warningMsgInfo.length;
            if (misType != null) {
                len += 2;
            }
            Object[] msgParam = new String[len];
            for (int i = 1; i < warningMsgInfo.length; ++i) {
                msgParam[i - 1] = (String)invalidResInfo.get(warningMsgInfo[i]);
            }
            msgParam[warningMsgInfo.length - 1] = (String)invalidResInfo.get("Targets");
            if (misType != null) {
                msgParam[len - 2] = misType;
                msgParam[len - 1] = (String)invalidResInfo.get("ResourceType");
            }
            msg = AppUtils.getMessage(AppUtils.getBundle(null), msgId, msgParam);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildWarningMsg", new Object[]{msg});
        }
        return msg;
    }

    public Hashtable getInAppTaskResource(AppDeploymentController controller) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInAppTaskResources", new Object[]{controller});
        }
        Hashtable tbl = new Hashtable();
        AppDeploymentTask task = controller.getTaskByName("EmbeddedRar", false);
        if (!task.isTaskEmpty()) {
            String[][] taskData = ResourceValidationHelper.getExpandedTaskData(task);
            for (int i = 1; i < taskData.length; ++i) {
                String type = taskData[i][2];
                String jndi = taskData[i][5];
                List<String> values = new ArrayList();
                if (tbl.containsKey(type)) {
                    values = (List)tbl.get(type);
                }
                if (!values.contains(jndi)) {
                    values.add(jndi);
                }
                tbl.put(type, values);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInAppTaskResources", new Object[]{tbl});
        }
        return tbl;
    }

    public void resourceObjectsPostProcessing(Hashtable targetToNodeTbl, String resType, Hashtable valuesToObjectTbl) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resourcObjectsPostProcessing", new Object[]{targetToNodeTbl, resType, valuesToObjectTbl});
        }
        if ("WAS50DataSource".equals(resType) || "DataSource".equals(resType)) {
            boolean hasV5Node = false;
            if (targetToNodeTbl != null) {
                Enumeration nodes = targetToNodeTbl.elements();
                while (nodes.hasMoreElements()) {
                    String nodeVersion = (String)nodes.nextElement();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "node version: " + nodeVersion);
                    }
                    if (Integer.parseInt(nodeVersion) >= 6) continue;
                    hasV5Node = true;
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug(tc, "Found v5 node");
                    break;
                }
                if (hasV5Node) {
                    Enumeration values = valuesToObjectTbl.keys();
                    while (values.hasMoreElements()) {
                        Object value = values.nextElement();
                        Object refO = valuesToObjectTbl.get(value);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "refO: " + refO);
                        }
                        ArrayList<Integer> toBeRemoved = new ArrayList<Integer>();
                        if (refO instanceof List) {
                            int i;
                            List refList = (List)refO;
                            for (i = 0; i < refList.size(); ++i) {
                                try {
                                    String attrValue = (String)MOFUtil.getAttribute((EObject)((EObject)refList.get(i)), (String)"datasourceHelperClassname", (boolean)false);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "attrValue: " + attrValue);
                                    }
                                    if (attrValue == null || !attrValue.equals("com.ibm.websphere.rsadapter.DerbyDataStoreHelper") && !attrValue.equals("com.ibm.websphere.rsadapter.DerbyNetworkServerDataStoreHelper")) continue;
                                    toBeRemoved.add(new Integer(i));
                                    if (!tc.isDebugEnabled()) continue;
                                    Tr.debug(tc, "Mark index " + i + " for deletion");
                                    continue;
                                }
                                catch (ConfigServiceException cse) {
                                    throw new AppDeploymentException("", cse);
                                }
                            }
                            for (i = 0; i < toBeRemoved.size(); ++i) {
                                refList.remove((Integer)toBeRemoved.get(i));
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "refO: " + refO + " after deleting indices " + toBeRemoved);
                            }
                            if (refList.size() != 0) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "no refO left - removing the entry for " + value);
                            }
                            valuesToObjectTbl.remove(value);
                            continue;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "single refO");
                        }
                        try {
                            String attrValue = (String)MOFUtil.getAttribute((EObject)((EObject)refO), (String)"datasourceHelperClassname", (boolean)false);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "attrValue: " + attrValue);
                            }
                            if (attrValue == null || !attrValue.equals("com.ibm.websphere.rsadapter.DerbyDataStoreHelper") && !attrValue.equals("com.ibm.websphere.rsadapter.DerbyNetworkServerDataStoreHelper")) continue;
                            valuesToObjectTbl.remove(value);
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "removed entry for " + value);
                        }
                        catch (ConfigServiceException cse) {
                            throw new AppDeploymentException("", cse);
                        }
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resourcObjectsPostProcessing", new Object[]{valuesToObjectTbl});
        }
    }

    private List _getResRefTypeMapping(String interfaceName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getResRefTypeMapping", new Object[]{interfaceName});
        }
        ArrayList<String> mapping = new ArrayList<String>();
        Object ob = _resRefTypeMappingTable.get(interfaceName);
        if (ob == null) {
            mapping.add(interfaceName);
        } else if (ob instanceof String) {
            mapping.add((String)ob);
        } else if (ob instanceof List) {
            mapping.addAll((List)ob);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getResRefTypeMapping", new Object[]{mapping});
        }
        return mapping;
    }

    private List _getResourceKeyValues(String resType, List refO) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getResourceKeyValues", new Object[]{resType, refO});
        }
        ArrayList values = new ArrayList();
        Hashtable valuesWithObjectTbl = this.getResourceValuesWithObjects(resType, refO);
        Enumeration valueKeys = valuesWithObjectTbl.keys();
        while (valueKeys.hasMoreElements()) {
            values.add(valueKeys.nextElement());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getResourcesKeyValues", new Object[]{values});
        }
        return values;
    }

    private boolean _isResourceInScope(AppDeploymentTask task, String[] taskData, int colIndex, Hashtable resObjTbl, List targets, boolean searchInAllScope, List outOfScopeMsgs) throws AppDeploymentException {
        boolean inScope;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_isResourceInScope", new Object[]{task, taskData, new Integer(colIndex), resObjTbl, targets, new Boolean(searchInAllScope), outOfScopeMsgs});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Data to be validated: " + taskData[colIndex] + "---");
        }
        Enumeration scopes = resObjTbl.keys();
        if (searchInAllScope && scopes.hasMoreElements()) {
            inScope = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Init inScope to true");
            }
        } else {
            inScope = false;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Init inScope to false");
            }
        }
        if (taskData[colIndex] == null || taskData[colIndex].trim().length() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "empty data - skipping");
            }
            inScope = true;
        } else {
            while ((searchInAllScope && inScope || !searchInAllScope && !inScope) && scopes.hasMoreElements()) {
                String scope = (String)scopes.nextElement();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "scope: " + scope);
                }
                Hashtable typeObjectTbl = (Hashtable)resObjTbl.get(scope);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "typeObjectTbl: " + typeObjectTbl);
                }
                if (typeObjectTbl == null || typeObjectTbl.size() == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "no type object for scope " + scope);
                    }
                    if (!searchInAllScope) continue;
                    inScope = false;
                    continue;
                }
                Enumeration types2 = typeObjectTbl.keys();
                while ((searchInAllScope && inScope || !searchInAllScope && !inScope) && types2.hasMoreElements()) {
                    String inType = (String)types2.nextElement();
                    Hashtable objectKeyTbl = (Hashtable)typeObjectTbl.get(inType);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "objectKeyTbl: " + objectKeyTbl);
                    }
                    if ("MapSharedLibForMod".equals(task.getName())) {
                        Hashtable libData = AppUtils.getSharedLibData(taskData[colIndex]);
                        inScope = true;
                        StringBuffer outOfScopeLib = new StringBuffer();
                        Enumeration libNames = libData.keys();
                        while (libNames.hasMoreElements()) {
                            String libName = (String)libNames.nextElement();
                            if (!objectKeyTbl.containsKey(libName)) {
                                inScope = false;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "library name " + libName + " not in scope");
                                }
                                if (outOfScopeLib.length() > 0) {
                                    outOfScopeLib.append('+');
                                }
                                outOfScopeLib.append(libName);
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "Adding library name " + libName + " to buffer: " + outOfScopeLib.toString());
                                continue;
                            }
                            this._searchForOutOfScopeMsg(outOfScopeMsgs, task, taskData, colIndex, libName, targets, true);
                        }
                        if (outOfScopeLib.length() <= 0) continue;
                        taskData[colIndex] = outOfScopeLib.toString();
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Setting task data to out of scope lib: " + taskData[colIndex]);
                        continue;
                    }
                    String backportData = null;
                    if (taskData[colIndex].startsWith("eis/") && taskData[colIndex].endsWith("_CMP")) {
                        backportData = taskData[colIndex].substring(4, taskData[colIndex].length() - 4);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "backportData: " + backportData);
                        }
                    }
                    if (objectKeyTbl.containsKey(taskData[colIndex]) || backportData != null && objectKeyTbl.containsKey(backportData)) {
                        if (searchInAllScope) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found in scope for not all scope search");
                        }
                        inScope = true;
                        this._searchForOutOfScopeMsg(outOfScopeMsgs, task, taskData, colIndex, taskData[colIndex], targets, true);
                        continue;
                    }
                    if (!searchInAllScope) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Not found in scope for all scopes search");
                    }
                    inScope = false;
                }
            }
        }
        if (searchInAllScope && inScope) {
            this._searchForOutOfScopeMsg(outOfScopeMsgs, task, taskData, colIndex, taskData[colIndex], targets, true);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_isResourceInScope", new Object[]{new Boolean(inScope)});
        }
        return inScope;
    }

    private List _buildTaskDataInfo(AppDeploymentTask task, String[] taskData, List outOfScopeMsgs, List targets) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_buildTaskDataInfo", new Object[]{task, taskData, outOfScopeMsgs});
        }
        ArrayList dataTbl = new ArrayList();
        ResourceTaskTypeInfo taskTypeInfo = (ResourceTaskTypeInfo)this._resTaskTypeInfoTable.get(task.getName());
        boolean supportMultiValues = false;
        List matchColumnIndexList = new ArrayList();
        if (taskTypeInfo != null) {
            supportMultiValues = taskTypeInfo.getSupportMultipleValues();
            matchColumnIndexList = this._getTaskColumnIndex(task, taskTypeInfo.getTaskAttr());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "supportMultiValues: " + supportMultiValues + ", matchColIndexList: " + matchColumnIndexList);
            }
        }
        for (int j = 0; j < matchColumnIndexList.size(); ++j) {
            int matchColumnIndex = (Integer)matchColumnIndexList.get(j);
            if (taskData[matchColumnIndex] == null || taskData[matchColumnIndex].length() <= 0) continue;
            String[] colNames = task.getColumnNames();
            StringTokenizer tokens = supportMultiValues ? new StringTokenizer(taskData[matchColumnIndex], "+") : new StringTokenizer(taskData[matchColumnIndex], "");
            while (tokens.hasMoreTokens()) {
                Hashtable foundMsg;
                String token = tokens.nextToken();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "token: " + token);
                }
                if ((foundMsg = this._searchForOutOfScopeMsg(outOfScopeMsgs, task, taskData, matchColumnIndex, token, targets, false)) != null) continue;
                Hashtable<String, String> taskDataTbl = new Hashtable<String, String>();
                for (int i = 0; i < colNames.length; ++i) {
                    if (task.isHiddenColumn(i)) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Skipping hidden " + i + " column");
                        continue;
                    }
                    if (taskData[i] == null) {
                        taskDataTbl.put(colNames[i], "");
                    } else if (i == matchColumnIndex) {
                        taskDataTbl.put(colNames[i], token);
                    } else {
                        taskDataTbl.put(colNames[i], taskData[i]);
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "added col: " + colNames[i] + ",  data: " + taskDataTbl.get(colNames[i]));
                }
                dataTbl.add(taskDataTbl);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_buildTaskDataInfo", new Object[]{dataTbl});
        }
        return dataTbl;
    }

    private List _buildOutOfScopeResInfo(AppDeploymentTask task, String[] taskData, List targets, List outOfScopeMsgs) {
        List outOfScopeResInfo;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_buildOutOfScopeResInfo", new Object[]{task, taskData, targets, outOfScopeMsgs});
        }
        if ((outOfScopeResInfo = this._buildTaskDataInfo(task, taskData, outOfScopeMsgs, targets)).size() > 0) {
            String types2 = this.getTypesForTask(task, taskData).toString();
            types2 = types2.substring(1, types2.length() - 1);
            for (int i = 0; i < outOfScopeResInfo.size(); ++i) {
                Hashtable tbl = (Hashtable)outOfScopeResInfo.get(i);
                tbl.put("ResourceType", types2);
                tbl.put("Targets", ResourceValidationHelper.buildTargetString(targets));
                tbl.put("outOfScope", "true");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_buildOutOfScopeResInfo", new Object[]{outOfScopeResInfo});
        }
        return outOfScopeResInfo;
    }

    private List _buildMisTypeResInfo(AppDeploymentTask task, String[] taskData, String matchValue, List targets, Hashtable misTypeInfo, String scope, List outOfScopeMsgs) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_buildMisTypeResInfo", new Object[]{task, taskData, matchValue, targets, misTypeInfo, scope, outOfScopeMsgs});
        }
        ArrayList<Hashtable> misTypeResInfoList = new ArrayList<Hashtable>();
        ResourceTaskTypeInfo taskTypeInfo = (ResourceTaskTypeInfo)this._resTaskTypeInfoTable.get(task.getName());
        List matchColumnIndexList = this._getTaskColumnIndex(task, taskTypeInfo.getTaskAttr());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "matching col index: " + matchColumnIndexList);
        }
        for (int i = 0; i < matchColumnIndexList.size(); ++i) {
            int matchColumnIndex = (Integer)matchColumnIndexList.get(i);
            Hashtable misTypeResInfo = this._searchForOutOfScopeMsg(outOfScopeMsgs, task, taskData, matchColumnIndex, matchValue, targets, true);
            if (misTypeResInfo == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "something is wrong - cannot find out of scope message to build a mistype message");
                continue;
            }
            misTypeResInfo.put("MisType", (String)misTypeInfo.get("resource.type"));
            misTypeResInfo.put("Scope", scope);
            misTypeResInfoList.add(misTypeResInfo);
            misTypeResInfo.remove("outOfScope");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_buildMisTypeResInfo", new Object[]{misTypeResInfoList});
        }
        return misTypeResInfoList;
    }

    private Hashtable _searchForOutOfScopeMsg(List outOfScopeMsgs, AppDeploymentTask task, String[] taskData, int matchColumnIndex, String matchValue, List targets, boolean deleteMsg) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_searchForOutOfScopeMsg", new Object[]{task, taskData, new Integer(matchColumnIndex), matchValue, new Boolean(deleteMsg)});
        }
        Hashtable foundMsg = null;
        if (outOfScopeMsgs.size() > 0) {
            String[] colNames = task.getColumnNames();
            int foundMsgIndex = -1;
            block0: for (int j = 0; foundMsgIndex == -1 && j < outOfScopeMsgs.size(); ++j) {
                Hashtable msg = (Hashtable)outOfScopeMsgs.get(j);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "processing msg: " + msg);
                }
                if (!((String)msg.get("Targets")).equals(ResourceValidationHelper.buildTargetString(targets))) {
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug(tc, "Mismatch is found for target " + targets);
                    break;
                }
                foundMsgIndex = j;
                for (int i = 0; i < colNames.length; ++i) {
                    if (task.isHiddenColumn(i)) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Skipping hidden " + i + " column");
                        continue;
                    }
                    String colValue = (String)msg.get(colNames[i]);
                    if (colValue == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Column " + colNames[i] + " is not found in the msg");
                        }
                        foundMsgIndex = -1;
                        continue block0;
                    }
                    if (i == matchColumnIndex) {
                        if (colValue.equals(matchValue)) continue;
                        foundMsgIndex = -1;
                        if (!tc.isDebugEnabled()) continue block0;
                        Tr.debug(tc, "Mismatch is found for value " + matchValue);
                        continue block0;
                    }
                    if (taskData[i] != null) {
                        if (colValue.equals(taskData[i])) continue;
                        foundMsgIndex = -1;
                        if (!tc.isDebugEnabled()) continue block0;
                        Tr.debug(tc, "Mismatch is found for value " + taskData[i]);
                        continue block0;
                    }
                    if (colValue.equals("")) continue;
                    foundMsgIndex = -1;
                    if (!tc.isDebugEnabled()) continue block0;
                    Tr.debug(tc, "A mismatch is found for empty value");
                    continue block0;
                }
            }
            if (foundMsgIndex == -1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No matching msg found");
                }
            } else {
                foundMsg = (Hashtable)outOfScopeMsgs.get(foundMsgIndex);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found matching out of scope msg: " + foundMsg);
                }
                if (deleteMsg) {
                    outOfScopeMsgs.remove(foundMsgIndex);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Remove msg from outOfScopeMsgs: " + outOfScopeMsgs);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_searchForOutOfScopeMsg", new Object[]{foundMsg});
        }
        return foundMsg;
    }

    private void _populateTaskTypeInfoTable() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_populateTaskTypeInfoTable");
        }
        ArrayList<Object> resRefType = new ArrayList<Object>();
        Enumeration resTypes = _resRefTypeMappingTable.elements();
        while (resTypes.hasMoreElements()) {
            Object type = resTypes.nextElement();
            if (type instanceof String) {
                if (resRefType.contains(type)) continue;
                resRefType.add(type);
                continue;
            }
            if (!(type instanceof List)) continue;
            List types2 = (List)type;
            for (int i = 0; i < types2.size(); ++i) {
                if (resRefType.contains(types2.get(i))) continue;
                resRefType.add(types2.get(i));
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "constructed resRefType: " + resRefType);
        }
        ArrayList<Object> resEnvRefType = new ArrayList<Object>();
        resEnvRefType.addAll(resRefType);
        resEnvRefType.add("ResourceEnvEntry");
        this._resTaskTypeInfoTable = new Hashtable();
        this._resTaskTypeInfoTable.put("DataSourceFor10CMPBeans", new ResourceTaskTypeInfo("DataSourceFor10CMPBeans", "WAS40DataSource", "JNDI", "jndiName", new String[]{"ADMA0114W", "JNDI", "EJBModule", "uri"}, new String[]{"ADMA0138W", "JNDI", "EJBModule", "uri"}));
        this._resTaskTypeInfoTable.put("DataSourceFor20CMPBeans", new ResourceTaskTypeInfo("DataSourceFor20CMPBeans", "DataSource", "JNDI", "jndiName", new String[]{"ADMA0114W", "JNDI", "EJBModule", "uri"}, new String[]{"ADMA0138W", "JNDI", "EJBModule", "uri"}));
        this._resTaskTypeInfoTable.put("DataSourceFor10EJBModules", new ResourceTaskTypeInfo("DataSourceFor10EJBModules", "WAS40DataSource", "JNDI", "jndiName", new String[]{"ADMA0114W", "JNDI", "EJBModule", "uri"}, new String[]{"ADMA0138W", "JNDI", "EJBModule", "uri"}));
        this._resTaskTypeInfoTable.put("DataSourceFor20EJBModules", new ResourceTaskTypeInfo("DataSourceFor20EJBModules", "DataSource", "JNDI", "jndiName", new String[]{"ADMA0114W", "JNDI", "EJBModule", "uri"}, new String[]{"ADMA0138W", "JNDI", "EJBModule", "uri"}));
        this._resTaskTypeInfoTable.put("MapResRefToEJB", new ResourceTaskTypeInfo("MapResRefToEJB", resRefType, "JNDI", "jndiName", new String[]{"ADMA0115W", "referenceBinding", "resRef.type", "JNDI", "module", "uri"}, new String[]{"ADMA0139W", "referenceBinding", "resRef.type", "JNDI", "module", "uri"}));
        this._resTaskTypeInfoTable.put("MapResEnvRefToRes", new ResourceTaskTypeInfo("MapResEnvRefToRes", resEnvRefType, "JNDI", "jndiName", new String[]{"ADMA0115W", "referenceBinding", "resEnvRef.type", "JNDI", "module", "uri"}, new String[]{"ADMA0139W", "referenceBinding", "resEnvRef.type", "JNDI", "module", "uri"}));
        this._resTaskTypeInfoTable.put("MapMessageDestinationRefToEJB", new ResourceTaskTypeInfo("MapMessageDestinationRefToEJB", "J2CAdminObject", "JNDI", "jndiName", new String[]{"ADMA0114W", "JNDI", "module", "uri"}, new String[]{"ADMA0138W", "JNDI", "module", "uri"}));
        ArrayList<String> embeddedRarTaskTypes = new ArrayList<String>();
        embeddedRarTaskTypes.add("J2CActivationSpec");
        embeddedRarTaskTypes.add("J2CAdminObject");
        embeddedRarTaskTypes.add("J2CConnectionFactory");
        this._resTaskTypeInfoTable.put("EmbeddedRar", new ResourceTaskTypeInfo("EmbeddedRar", embeddedRarTaskTypes, "j2c.jndiName", "jndiName", new String[]{"ADMA0114W", "j2c.jndiName", "RARModule", "uri"}, new String[]{"ADMA0138W", "j2c.jndiName", "RARModule", "uri"}));
        ArrayList<String> taskAttrs = new ArrayList<String>();
        taskAttrs.add("JNDI");
        ArrayList<String> typeAttrs = new ArrayList<String>();
        typeAttrs.add("jndiName");
        this._resTaskTypeInfoTable.put("BindJndiForEJBMessageBinding", new ResourceTaskTypeInfo("BindJndiForEJBMessageBinding", "J2CActivationSpec", taskAttrs, typeAttrs, new String[]{"ADMA0114W", "JNDI", "EJBModule", "uri"}, new String[]{"ADMA0138W", "JNDI", "EJBModule", "uri"}));
        this._resTaskTypeInfoTable.put("MapWebModToVH", new ResourceTaskTypeInfo("MapWebModToVH", "VirtualHost", "virtualHost", "name", new String[]{"ADMA0161W", "virtualHost", "webModule", "uri"}, new String[]{"ADMA0162W", "virtualHost", "webModule", "uri"}));
        this._resTaskTypeInfoTable.put("MapSharedLibForMod", new ResourceTaskTypeInfo("MapSharedLibForMod", "Library", "sharedLibName", "name", true, new String[]{"ADMA0161W", "sharedLibName", "module", "uri"}, new String[]{"ADMA0162W", "sharedLibName", "module", "uri"}));
        ArrayList<String> clusterAttrs = new ArrayList<String>();
        clusterAttrs.add("nodeName");
        clusterAttrs.add("memberName");
        this._resTaskTypeInfoTable.put("DummyCluster", new ResourceTaskTypeInfo("DummyCluster", "ClusterMember", "", clusterAttrs, null, null));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_populateTaskTypeInfoTable");
        }
    }

    private List _getTaskColumnIndex(AppDeploymentTask task, Object taskAttr) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getTaskColumnIndex", new Object[]{task, taskAttr});
        }
        ArrayList<Integer> colIndex = new ArrayList<Integer>();
        if (taskAttr instanceof String) {
            colIndex.add(new Integer(ResourceValidationHelper.getMatchingColIndex(task, (String)taskAttr)));
        } else if (taskAttr instanceof List) {
            for (int i = 0; i < ((List)taskAttr).size(); ++i) {
                colIndex.add(new Integer(ResourceValidationHelper.getMatchingColIndex(task, (String)((List)taskAttr).get(i))));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getTaskColumnIndex", new Object[]{colIndex});
        }
        return colIndex;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/client/ResourceMapperDefaultImpl.java, WAS.admin.installapp.validation, WAS70.SERV1, q0834.18, ver. 1.12.1.5");
        }
        CLASS_NAME = ResourceMapperDefaultImpl.class.getName();
        _dataSourceMapping = new ArrayList();
        _resRefTypeMappingTable = new Hashtable();
        _dataSourceMapping.add("DataSource");
        _dataSourceMapping.add("WAS40DataSource");
        _resRefTypeMappingTable.put("javax.sql.DataSource", _dataSourceMapping);
        _resRefTypeMappingTable.put("javax.mail.Session", "MailSession");
        _resRefTypeMappingTable.put("java.net.URL", "URL");
        _resRefTypeMappingTable.put("javax.jms.QueueConnectionFactory", "QueueConnectionFactory");
        _resRefTypeMappingTable.put("javax.jms.TopicConnectionFactory", "TopicConnectionFactory");
        _resRefTypeMappingTable.put("javax.jms.ConnectionFactory", "ConnectionFactory");
        _resRefTypeMappingTable.put("javax.jms.Queue", "Queue");
        _resRefTypeMappingTable.put("javax.jms.Topic", "Topic");
        _resRefTypeMappingTable.put("javax.resource.cci.ConnectionFactory", "J2CConnectionFactory");
        _resRefTypeMappingTable.put("com.ibm.websphere.asynchbeans.WorkManager", "WorkManagerInfo");
        _resRefTypeMappingTable.put("commonj.work.WorkManager", "WorkManagerInfo");
        _resRefTypeMappingTable.put("commonj.timers.TimerManager", "TimerManagerInfo");
        _resRefTypeMappingTable.put("com.ibm.websphere.cache.DistributedMap", "ObjectCacheInstance");
        _resRefTypeMappingTable.put("com.ibm.websphere.cache.DistributedObjectCache", "ObjectCacheInstance");
        _resRefTypeMappingTable.put("com.ibm.websphere.scheduler.Scheduler", "SchedulerConfiguration");
        _resRefTypeMappingTable.put("com.ibm.websphere.asynchbeans.pool.ObjectPoolManager", "ObjectPoolManagerInfo");
    }

    public static class ResourceTaskTypeInfo {
        private String _taskName;
        private Object _resType;
        private Object _taskAttr;
        private Object _typeAttr;
        private boolean _supportMultipleValues;
        private String[] _validationWarningMsgInfo;
        private String[] _misTypeWarningMsgInfo;

        public ResourceTaskTypeInfo(String taskName, Object resType, Object taskAttr, Object typeAttr, String[] warningMsgInfo, String[] misTypeWarningMsgInfo) {
            this._init(taskName, resType, taskAttr, typeAttr, false, warningMsgInfo, misTypeWarningMsgInfo);
        }

        public ResourceTaskTypeInfo(String taskName, Object resType, Object taskAttr, Object typeAttr, boolean supportMultipleValues, String[] warningMsgInfo, String[] misTypeWarningMsgInfo) {
            this._init(taskName, resType, taskAttr, typeAttr, supportMultipleValues, warningMsgInfo, misTypeWarningMsgInfo);
        }

        private void _init(String taskName, Object resType, Object taskAttr, Object typeAttr, boolean supportMultipleValues, String[] warningMsgInfo, String[] misTypeWarningMsgInfo) {
            this._taskName = taskName;
            this._resType = resType;
            this._taskAttr = taskAttr;
            this._typeAttr = typeAttr;
            this._supportMultipleValues = supportMultipleValues;
            this._validationWarningMsgInfo = warningMsgInfo;
            this._misTypeWarningMsgInfo = misTypeWarningMsgInfo;
        }

        public String getTaskName() {
            return this._taskName;
        }

        public Object getResType() {
            return this._resType;
        }

        public Object getTaskAttr() {
            return this._taskAttr;
        }

        public Object getTypeAttr() {
            return this._typeAttr;
        }

        public boolean getSupportMultipleValues() {
            return this._supportMultipleValues;
        }

        public String[] getValidationWarningMsgInfo() {
            return this._validationWarningMsgInfo;
        }

        public String[] getMisTypeWarningMsgInfo() {
            return this._misTypeWarningMsgInfo;
        }
    }
}

