/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.ws.management.application.client.AppDeploymentOptions;
import com.ibm.ws.management.application.client.util;
import java.text.MessageFormat;
import java.util.Vector;

public class MapEJBRefToEJB
extends AppDeploymentTask {
    private static final long serialVersionUID = 4801108767148192808L;
    private static TraceComponent tc = Tr.register(MapEJBRefToEJB.class);
    private static final int totalColumns = 7;
    private static final int prev7TotalColumns = 6;
    public static final int moduleColumn = 0;
    public static final int ejbColumn = 1;
    public static final int uriColumn = 2;
    public static final int refBindingColumn = 3;
    public static final int classColumn = 4;
    public static final int jndiColumn = 5;
    public static final int moduleVersionColumn = 6;
    public static final String TaskName = "MapEJBRefToEJB";

    public MapEJBRefToEJB(AppDeploymentController flowController) {
        super(flowController);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, TaskName);
        }
        this.name = TaskName;
        String clientVersion = this.getCallerVersion();
        if ("5".equals(clientVersion) || "6".equals(clientVersion)) {
            this.colNames = new String[6];
            this.mutables = new boolean[6];
            this.requiredColumns = new boolean[6];
            this.hiddenColumns = new boolean[6];
        } else {
            this.colNames = new String[7];
            this.mutables = new boolean[7];
            this.requiredColumns = new boolean[7];
            this.hiddenColumns = new boolean[7];
        }
        this.colNames[0] = "module";
        this.colNames[1] = "EJB";
        this.colNames[2] = "uri";
        this.colNames[3] = "referenceBinding";
        this.colNames[4] = "class";
        this.colNames[5] = "JNDI";
        this.mutables[0] = false;
        this.mutables[1] = false;
        this.mutables[2] = false;
        this.mutables[3] = false;
        this.mutables[4] = false;
        this.mutables[5] = true;
        this.requiredColumns[0] = false;
        this.requiredColumns[1] = false;
        this.requiredColumns[2] = false;
        this.requiredColumns[3] = false;
        this.requiredColumns[4] = false;
        this.requiredColumns[5] = false;
        this.hiddenColumns[0] = false;
        this.hiddenColumns[1] = false;
        this.hiddenColumns[2] = false;
        this.hiddenColumns[3] = false;
        this.hiddenColumns[4] = false;
        this.hiddenColumns[5] = false;
        if (!"5".equals(clientVersion) && !"6".equals(clientVersion)) {
            this.colNames[6] = "ModuleVersion";
            this.mutables[6] = false;
            this.requiredColumns[6] = false;
            this.hiddenColumns[6] = true;
            this.hasHiddenColumns = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, TaskName);
        }
    }

    public String[] validate() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        Vector<String> errorMessages = new Vector<String>();
        this.taskValidateErrorMessages = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isSufficientlyDone: " + this.isSufficientlyDone);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "requiredColumns[jndiColumn]: " + this.requiredColumns[5]);
        }
        if (this.taskData != null) {
            AppDeploymentOptions optionsTask = null;
            try {
                optionsTask = (AppDeploymentOptions)this.appController.getTaskByName("AppDeploymentOptions", false);
            }
            catch (Exception ex) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception when calling getTaskByName: " + ex);
                }
                optionsTask = null;
            }
            if (optionsTask != null) {
                boolean autoLink = optionsTask.getAutoLinkOption();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "autolink is " + autoLink);
                }
                for (int i = 1; i < this.taskData.length; ++i) {
                    if (autoLink || this.taskData[i][5] != null && !this.taskData[i][5].trim().equals("")) continue;
                    int moduleVersion = Integer.valueOf(this.taskData[i][6]);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "module version is " + moduleVersion);
                    }
                    if (!(this.taskData[i][2].matches(".*.jar.*") && moduleVersion < 30 || this.taskData[i][2].matches(".*.war.*") && moduleVersion < 24) && !this.taskData[i][2].matches(".*.rar.*")) continue;
                    String error = MessageFormat.format(util.getMessage(this, "ADMA0007E"), util.getGoalTitle(this, this.name), this.taskData[i][3], this.taskData[i][0], this.taskData[i][1]);
                    errorMessages.addElement(error);
                }
                this.buildErrorMessages(errorMessages);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
        return this.taskValidateErrorMessages;
    }

    public void refreshRequiredColumns(boolean autoLinkValue) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refreshRequiredColumns", new Object[]{new Boolean(autoLinkValue)});
        }
        boolean bl = this.requiredColumns[5] = !autoLinkValue;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshRequiredColumns", new Object[]{!autoLinkValue});
        }
    }
}

