/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client;

import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EnterpriseBeanBinding;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.util.BackendUtil;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.PartialDeploymentInfo;
import com.ibm.ws.management.application.client.BackendIdSelection;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.application.j2ee.deploy.spi.DConfigBeanImpl;
import com.ibm.ws.management.application.j2ee.deploy.spi.J2EEDeployUtil;
import com.ibm.ws.management.application.j2ee.deploy.spi.J2EEDeploymentHelper;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.enterprise.deploy.shared.ModuleType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.internal.common.XMLResource;

public class BackendIdSelectionHelper
implements AppDeploymentTaskHelper,
J2EEDeploymentHelper {
    private static TraceComponent tc = Tr.register(BackendIdSelectionHelper.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");

    public AppDeploymentTask createTask(AppDeploymentController appController, String taskName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTask");
        }
        try {
            String helperClass = this.getClass().getName();
            int index = helperClass.lastIndexOf("Helper");
            Class<?> taskClass = Class.forName(helperClass.substring(0, index));
            Constructor<?> constructor = taskClass.getDeclaredConstructor(AppDeploymentController.class);
            return (AppDeploymentTask)constructor.newInstance(appController);
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error instantiating task" + ex);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTask");
            }
            return null;
        }
    }

    public void prepareTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTask");
        }
        if (t.getTaskData() != null) {
            return;
        }
        AppDeploymentController appController = t.getAppDeploymentController();
        Vector ejbJars = appInstallInfo.getModuleConfig("JAR_DD");
        Vector ejbJarBindings = appInstallInfo.getModuleConfig("JAR_BND");
        Vector<String> data = new Vector<String>();
        String[] colNames = t.getColumnNames();
        for (int i = 0; i < colNames.length; ++i) {
            data.addElement(colNames[i]);
            Tr.debug(tc, "colNames[" + i + "] " + colNames[i]);
        }
        if (appInstallInfo instanceof PartialDeploymentInfo) {
            t.setTaskData(util.buildTaskData(data, colNames.length));
            return;
        }
        int appVersion = ((XMLResource)appInstallInfo.getApplication().eResource()).getVersionID();
        block1: for (int i = 0; i < ejbJarBindings.size(); ++i) {
            EJBJarBinding ejbJarBinding = (EJBJarBinding)ejbJarBindings.elementAt(i);
            EJBJar jar = (EJBJar)ejbJars.elementAt(i);
            EList ejbBindings = ejbJarBinding.getEjbBindings();
            int jarVersion = ((XMLResource)jar.eResource()).getVersionID();
            for (int j = 0; j < ejbBindings.size(); ++j) {
                EnterpriseBeanBinding ejbBinding = (EnterpriseBeanBinding)ejbBindings.get(j);
                EnterpriseBean ejb = ejbBinding.getEnterpriseBean();
                if (ejb == null) continue;
                if (ejb.eIsProxy()) {
                    Tr.warning(tc, "ADMA0091E", new String[]{ejbBindings.get(j).toString(), ejbJarBinding.eResource().getURI().toString(), appInstallInfo.getModuleFileForDD(jar).getURI(), ejb.toString()});
                    continue;
                }
                if (!ejb.isEntity()) continue;
                ModuleFile moduleFile = ArchiveUtil.getModuleFile(jar);
                List backendIds = BackendUtil.getAllBackendIDs((EJBJarFile)moduleFile, true);
                if (backendIds.size() == 0) {
                    Tr.debug(tc, "No backend Ids found under META-INF/backends directory");
                    continue block1;
                }
                StringBuffer buf = new StringBuffer();
                buf.setLength(0);
                for (int l = 0; l < backendIds.size(); ++l) {
                    if (l != 0) {
                        buf.append(" + ");
                    }
                    String backendID = backendIds.get(l).toString();
                    Tr.debug(tc, "BackendID: " + backendID);
                    buf.append(backendID);
                }
                Tr.debug(tc, "BackendID list: " + buf.toString());
                String currentBackendId = ejbJarBinding.getCurrentBackendId();
                Tr.debug(tc, "currentBackendId:" + currentBackendId);
                if (currentBackendId == null) {
                    currentBackendId = "";
                }
                data.addElement(Integer.toString(appVersion));
                data.addElement(Integer.toString(jarVersion));
                data.addElement(util.getModuleName(appInstallInfo, jar));
                Tr.debug(tc, "ejb module name " + util.getModuleName(appInstallInfo, jar));
                data.addElement(util.formUriString(appInstallInfo, jar));
                Tr.debug(tc, "uri " + util.formUriString(appInstallInfo, jar));
                data.addElement(buf.toString());
                data.addElement(currentBackendId);
                continue block1;
            }
        }
        t.setTaskData(util.buildTaskData(data, colNames.length));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTask");
        }
    }

    public void completeTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeTask");
        }
        if (!t.isTaskEmpty()) {
            Vector ejbJarBindings = appInstallInfo.getModuleConfig("JAR_BND");
            for (int i = 0; i < ejbJarBindings.size(); ++i) {
                EJBJarBinding ejbJarBinding = (EJBJarBinding)ejbJarBindings.elementAt(i);
                EJBJar jar = (EJBJar)appInstallInfo.getModuleConfig("JAR_DD").elementAt(i);
                String[] matchingTaskData = null;
                String[][] taskData = t.getTaskData();
                String moduleName = null;
                for (int j = 0; j < taskData.length; ++j) {
                    moduleName = util.getModuleName(appInstallInfo, jar);
                    BackendIdSelection cfr_ignored_0 = (BackendIdSelection)t;
                    if (taskData[j].length <= 3) continue;
                    BackendIdSelection cfr_ignored_1 = (BackendIdSelection)t;
                    if (!util.compareUriString(appInstallInfo, jar, taskData[j][3])) continue;
                    BackendIdSelection cfr_ignored_2 = (BackendIdSelection)t;
                    if (!moduleName.equals(taskData[j][2])) continue;
                    matchingTaskData = taskData[j];
                    break;
                }
                if (matchingTaskData == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Not matching task data for ejbModule " + moduleName);
                    continue;
                }
                BackendIdSelection cfr_ignored_3 = (BackendIdSelection)t;
                if (matchingTaskData.length <= 5) continue;
                BackendIdSelection cfr_ignored_4 = (BackendIdSelection)t;
                void currentBackendId = matchingTaskData[5];
                if (!AppUtils.isEmpty((String)currentBackendId)) {
                    BackendIdSelection cfr_ignored_5 = (BackendIdSelection)t;
                    String allBackendId = " + " + (String)matchingTaskData[4] + " + ";
                    if (allBackendId.indexOf(" + " + (String)currentBackendId + " + ") == -1) {
                        Tr.debug(tc, "Current Backend Id does not exist in BackendId list under META-INF/backends directory");
                        Object[] objectArray = new Object[2];
                        BackendIdSelection cfr_ignored_6 = (BackendIdSelection)t;
                        objectArray[0] = matchingTaskData[5];
                        BackendIdSelection cfr_ignored_7 = (BackendIdSelection)t;
                        objectArray[1] = matchingTaskData[4];
                        throw new AppDeploymentException(MessageFormat.format(util.getMessage(t, "ADMA0098E"), objectArray), null);
                    }
                    ejbJarBinding.setCurrentBackendId((String)currentBackendId);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.warning(tc, "No current backend id specify in ibm-ejb-jar-bnd.xmi");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTask");
        }
    }

    public Hashtable getXPathInfo(Vector allTypes) {
        if (!allTypes.contains(ModuleType.EJB)) {
            return null;
        }
        Hashtable<String, String> tbl = new Hashtable<String, String>();
        tbl.put(ModuleType.EJB.toString(), "/");
        return tbl;
    }

    public void taskData2DCBean(AppDeploymentTask task, DConfigBeanImpl dcImpl, String uri) {
        J2EEDeployUtil.moduleTask2DC(task, dcImpl, uri, 3);
    }

    public void dcBean2TaskData(AppDeploymentTask task, Hashtable keys, Hashtable props) {
        J2EEDeployUtil.dcBean2TaskData(task, keys, props);
    }
}

