/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.cdfj2eebridge;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.Scheduler;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.EarWrapperTask;
import com.ibm.websphere.management.deployment.core.DeployableObject;
import com.ibm.websphere.management.deployment.core.DeploymentContext;
import com.ibm.websphere.management.deployment.core.DeploymentStep;
import com.ibm.websphere.management.deployment.exception.DeploymentException;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.UpdateSchedulerImpl;
import com.ibm.ws.management.application.cdfj2eebridge.CDFStepWrapper;
import com.ibm.ws.management.deployment.j2ee.J2EEToCDFBridge;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;

public class CDFBridgeExtensionHelper {
    private static final TraceComponent tc = Tr.register(CDFBridgeExtensionHelper.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;

    public static void processServerInstallExtensions(Hashtable prefs, Vector installTasks, InstallScheduler scheduler) throws AppDeploymentException {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "processServerInstallExtensions", new Object[]{prefs, installTasks, scheduler});
            }
            try {
                CDFBridgeExtensionHelper.provideServerExtensions(1L, installTasks, scheduler, prefs);
            }
            catch (Throwable th) {
                AppUtils.dbg(tc, "xxxException in getting CDF server extensions for install" + th);
                if (!(th instanceof AppDeploymentException)) break block4;
                throw (AppDeploymentException)th;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processServerInstallExtensions", new Object[]{prefs, installTasks, scheduler});
        }
    }

    public static void processServerExtensionsForEdit(Hashtable prefs, Vector tasks, Scheduler scheduler) throws AppDeploymentException {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "processServerExtensionsForEdit", new Object[]{prefs, tasks, scheduler});
            }
            try {
                CDFBridgeExtensionHelper.provideServerExtensions(2L, tasks, scheduler, prefs);
            }
            catch (Throwable th) {
                AppUtils.dbg(tc, "xxxException in getting CDF server extensions for edit: " + th);
                if (!(th instanceof AppDeploymentException)) break block4;
                throw (AppDeploymentException)th;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processServerExtensionsForEdit", new Object[]{prefs, tasks, scheduler});
        }
    }

    public static void processServerUpdateExtensions(Hashtable prefs, Vector installTasks, UpdateSchedulerImpl scheduler) throws AppDeploymentException {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "processServerUpdateExtensions", new Object[]{prefs, installTasks, scheduler});
            }
            try {
                CDFBridgeExtensionHelper.provideServerExtensions(4L, installTasks, scheduler, prefs);
            }
            catch (Throwable th) {
                AppUtils.dbg(tc, "xxxException in getting CDF server extensions for update: " + th);
                if (!(th instanceof AppDeploymentException)) break block4;
                throw (AppDeploymentException)th;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processServerUpdateExtensions", new Object[]{prefs, installTasks, scheduler});
        }
    }

    public static void processServerUninstallExtensions(Hashtable prefs, Vector installTasks, Scheduler scheduler) throws AppDeploymentException {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "processServerUninstallExtensions", new Object[]{prefs, installTasks, scheduler});
            }
            try {
                CDFBridgeExtensionHelper.provideServerExtensions(8L, installTasks, scheduler, prefs);
            }
            catch (Throwable th) {
                if (tc.isDebugEnabled()) {
                    AppUtils.dbg(tc, "Exception in getting CDF server extensions for uninstall: " + th);
                }
                if (!(th instanceof AppDeploymentException)) break block5;
                throw (AppDeploymentException)th;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processServerUninstallExtensions", new Object[]{prefs, installTasks, scheduler});
        }
    }

    public static void processEarWrapperExtension(Vector earWrapperSteps, Archive archive, String newFileName, String newModuleUri, Hashtable prefs) throws AppDeploymentException {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "processEarWrapperExtension", new Object[]{archive, newFileName, newModuleUri, prefs});
            }
            Object newEarPath = null;
            Object earWrapperStep = null;
            boolean success = false;
            try {
                J2EEToCDFBridge.addCDFServerPluginToJ2EE(16L, earWrapperSteps, null, prefs);
            }
            catch (Throwable th) {
                AppUtils.dbg(tc, "Exception in getting CDF create ear wrapper extensions: " + th);
                if (!(th instanceof AppDeploymentException)) break block4;
                throw (AppDeploymentException)th;
            }
        }
        AppUtils.dbg(tc, "tasks.size() == " + earWrapperSteps.size());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processEarWrapperExtension", new Object[]{prefs, earWrapperSteps});
        }
    }

    public static String executeEarWrapperExtension(Vector earWrapperTasks, Archive archive, String newFileName, String newModuleUri, Hashtable prefs) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "executeEarWrapperTasks", new Object[]{earWrapperTasks});
        }
        String newEarPath = null;
        int taskSize = earWrapperTasks.size();
        AppUtils.dbg(tc, "earWrapperTasks.size() = " + taskSize);
        if (taskSize == 0) {
            return null;
        }
        Object task = null;
        for (int i = 0; i < taskSize; ++i) {
            newEarPath = null;
            task = earWrapperTasks.get(i);
            if (task instanceof DeploymentStep) {
                newEarPath = CDFBridgeExtensionHelper.executeCDFEarWrapperStep((DeploymentStep)task, archive, newFileName, newModuleUri, prefs);
            } else if (task instanceof EarWrapperTask) {
                newEarPath = ((EarWrapperTask)task).executeTask(archive, newFileName, newModuleUri, prefs);
            }
            if (newEarPath != null) break;
        }
        if (newEarPath != null) {
            AppUtils.dbg(tc, AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0156I", new String[]{task.toString()}));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "executeEarWrapperTasks", new Object[]{newEarPath});
        }
        return newEarPath;
    }

    private static String executeCDFEarWrapperStep(DeploymentStep earWrapperStep, Archive archive, String newFileName, String newModuleUri, Hashtable prefs) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "executeCDFEarWrapperStep", new Object[]{earWrapperStep, archive, newFileName, newModuleUri, prefs});
        }
        String newEarPath = null;
        boolean success = false;
        try {
            DeployableObject deplObj = J2EEToCDFBridge.createDO(archive);
            earWrapperStep.getContext().getContextData().put(DeploymentContext.EARWRAPPER_NewFileName_key, newFileName);
            earWrapperStep.getContext().getContextData().put(DeploymentContext.EARWRAPPER_NewModuleUri_key, newModuleUri);
            earWrapperStep.getContext().getContextData().put(DeploymentContext.PREFS_Hashtable_key, prefs);
            AppUtils.dbg(tc, "executing step " + earWrapperStep.getClass().toString());
            success = earWrapperStep.execute(deplObj);
            newEarPath = (String)earWrapperStep.getContext().getContextData().get(DeploymentContext.RETURN_Object_key);
            AppUtils.dbg(tc, "newEarPath = " + newEarPath);
        }
        catch (DeploymentException dex) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "executeCDFEarWrapperStep", new Object[]{newEarPath});
        }
        return newEarPath;
    }

    private static void provideServerExtensions(long op, Vector j2eeTasks, Scheduler scheduler, Hashtable prefs) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "provideServerExtensions", new Object[]{j2eeTasks, scheduler});
        }
        int origSize = j2eeTasks.size();
        AppUtils.dbg(tc, "..... orig j2eeTasks size:  " + origSize);
        try {
            J2EEToCDFBridge.addCDFServerPluginToJ2EE(op, j2eeTasks, scheduler, prefs);
        }
        catch (Throwable t) {
            throw new AppDeploymentException(t.getMessage(), t);
        }
        int newSize = j2eeTasks.size();
        AppUtils.dbg(tc, "..... new j2eeTasks size " + newSize);
        if (newSize > origSize) {
            for (int i = 0; i < newSize; ++i) {
                Object taskO = j2eeTasks.get(i);
                if (!(taskO instanceof DeploymentStep)) continue;
                AppUtils.dbg(tc, "converting " + taskO.getClass().getName() + " to CDFStepWrapper tht");
                j2eeTasks.set(i, new CDFStepWrapper((DeploymentStep)taskO));
            }
        } else {
            AppUtils.dbg(tc, "No new CDF steps were found");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "provideServerExtensions", new Object[]{j2eeTasks, scheduler});
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/cdfj2eebridge/CDFBridgeExtensionHelper.java, WAS.admin.installapp, WAS70.SERV1, q0834.18, ver. 1.10");
        }
        CLASS_NAME = CDFBridgeExtensionHelper.class.getName();
    }
}

