/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.SchedulerImpl;
import com.ibm.ws.management.application.sync.AppBinaryProcessor;
import com.ibm.ws.management.application.task.UpdateClusterTask;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class UpdateClusterScheduler
extends SchedulerImpl {
    private static TraceComponent tc = Tr.register(UpdateClusterScheduler.class);
    private static final String CLASS_NAME;
    private String[] appNames;
    public static final String LAUNCH_TIMEOUT = "LAUNCH_TIMEOUT";
    public static final Integer DEFAULT_LAUNCH_TIMEOUT;
    public static final String APPLICATION_ROLLOUT_PAUSERESUME = "com.ibm.websphere.zos.rollout.pauseresume";

    public UpdateClusterScheduler(String[] aNames, String concAppNames, Hashtable tbl, AppManagement appM, AppNotification.Listener notf) {
        super(concAppNames, tbl, appM, notf);
        this.appNames = aNames;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "UpdateClusterScheduler");
        }
        this.appTaskName = "UpdateCluster";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "UpdateClusterScheduler");
        }
    }

    protected void setupTasks() throws AdminException {
        boolean done;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setupTasks");
        }
        if (!(done = this.ensureAppsAreSaved())) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "App is not saved to config ");
            }
            AppNotification notf = new AppNotification(this.appTaskName, "", "Failed", "", AppUtils.getMessage(this.resBundle, "ADMA8001E", new Object[]{this.appName}) + " Applications are not yet saved to the config repository.");
            this.propagateTaskEvent(notf);
            throw new AdminException(null, "Applications are not yet saved to config repository");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Applications are saved to config repository");
        }
        this.tasks = new Vector();
        this.tasks.addElement(new UpdateClusterTask());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The tasks are: " + this.tasks);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setupTasks");
        }
    }

    private boolean ensureAppsAreSaved() throws AdminException {
        boolean done;
        block14: {
            long poll_interval;
            long wait_time;
            block13: {
                done = true;
                wait_time = 180000L;
                poll_interval = 500L;
                if (System.getProperty("com.ibm.websphere.application.updateapponcluster.waitforappsave") != null) {
                    String appsavetout = System.getProperty("com.ibm.websphere.application.updateapponcluster.waitforappsave");
                    try {
                        wait_time = Long.parseLong(appsavetout) * 1000L;
                    }
                    catch (Exception ex) {
                        if (!tc.isDebugEnabled()) break block13;
                        Tr.debug(tc, "Invalid App Save time out value - " + appsavetout);
                        Tr.debug(tc, "Using default App Save time out: " + wait_time);
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Applications Save max_wait_time: " + wait_time / 1000L + "secs");
            }
            try {
                while (true) {
                    block15: {
                        List appsinprogress = AppBinaryProcessor.getAppsInProgress();
                        done = true;
                        for (int i = 0; i < this.appNames.length && done; done &= !appsinprogress.contains(this.appNames[i]), ++i) {
                        }
                        if (done || wait_time <= 0L) break block14;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Waiting for applications to be saved in the config repository");
                        }
                        try {
                            Thread.sleep(poll_interval);
                        }
                        catch (InterruptedException ie) {
                            if (!tc.isDebugEnabled()) break block15;
                            Tr.debug(tc, "Wait interrupted");
                        }
                    }
                    wait_time -= poll_interval;
                }
            }
            catch (Throwable th) {
                RasUtils.logException(th, tc, CLASS_NAME, "ensureAppsAreSaved", "148", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception: ", th.getMessage());
                }
                if (th instanceof AdminException) {
                    throw (AdminException)th;
                }
                throw new AdminException(th, "");
            }
        }
        return done;
    }

    public String[] getAppNames() {
        return this.appNames;
    }

    protected String getJMXEventType() {
        return "websphere.admin.appmgmt.updatecluster";
    }

    protected AppNotification createCompletionEvent(boolean bSuccess) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCompletionEvent");
        }
        String msg = "";
        if (this.resBundle != null) {
            msg = AppUtils.getMessage(this.resBundle, bSuccess ? "ADMA8000I" : "ADMA8001E", new String[]{this.appName});
        }
        AppNotification notf = new AppNotification("UpdateCluster", "", bSuccess ? "Completed" : "Failed", "", msg);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCompletionEvent");
        }
        return notf;
    }

    protected AppNotification createStartEvent() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createStartEvent");
        }
        String msg = "";
        if (this.resBundle != null) {
            msg = AppUtils.getMessage(this.resBundle, "ADMA8002I", new String[]{this.appName});
        }
        AppNotification notf = new AppNotification("UpdateCluster", "", "InProgress", "", msg);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createStartEvent");
        }
        return notf;
    }

    protected void performCleanup(boolean bSuccess) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performCleanup");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performCleanup");
        }
    }

    public RepositoryContext getCellContext() throws Exception {
        RepositoryContext rc;
        if (this.cellContext != null) {
            return this.cellContext;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellContext");
        }
        if ((rc = AppUtils.findAppContextFromConfig(this.appNames[0], this.getWorkSpace(), this.getProperties())) == null) {
            throw new AdminException(null, AppUtils.getMessage(this.resBundle, "ADMA5045E", new Object[]{this.appName}));
        }
        this.cellContext = rc.getParentContext().getParentContext();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellContext:" + this.cellContext);
        }
        return this.cellContext;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/UpdateClusterScheduler.java, WAS.admin.installapp.server, WAS70.SERV1, q0834.18, ver. 1.4.1.2");
        }
        CLASS_NAME = UpdateClusterScheduler.class.getName();
        DEFAULT_LAUNCH_TIMEOUT = new Integer(1200);
    }
}

