/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.Scheduler;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.application.AppManagementImpl;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.ExtensionHelper;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.security.auth.Subject;

public abstract class SchedulerImpl
implements Scheduler {
    private static TraceComponent tc = Tr.register(SchedulerImpl.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    protected Vector tasks;
    protected int nextTaskNum = 0;
    protected String appName;
    protected String appTaskName = "xxx";
    protected AppManagement appManagement;
    protected Hashtable properties;
    protected String id;
    protected AppNotification.Listener notifier;
    protected WorkSpace workSpace;
    protected boolean amIWorkSpaceOwner = false;
    protected Locale locale;
    protected ResourceBundle resBundle;
    protected RepositoryContext cellContext = null;
    protected boolean setupDone = false;
    protected Subject subject = null;
    protected Throwable lastEx = null;
    protected String profileKey = null;

    public SchedulerImpl(String aName, Hashtable tbl, AppManagement appM, AppNotification.Listener notf) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SchedulerImpl");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "appName: " + aName + ", options: " + tbl);
        }
        this.properties = tbl;
        this.notifier = notf;
        if (!AppUtils.isEmpty(aName)) {
            this.appName = aName;
            this.appName = this.appName.trim();
        }
        this.appManagement = appM;
        if (this.properties != null) {
            this.locale = (Locale)this.properties.get("app.client.locale");
        }
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        this.id = Long.toHexString(System.currentTimeMillis());
        this.resBundle = AppUtils.getBundle("com.ibm.ws.management.resources.AppDeploymentMessages", this.locale);
        if (!AdminHelper.getPlatformHelper().isZOS() && !AppManagementImpl.isLocalMode()) {
            this.subject = SecurityHelper.retrieveSubject();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "subject: " + this.subject);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Uniquie id: " + this.id);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SchedulerImpl");
        }
    }

    public void setLocale(Locale loc) {
        this.locale = loc;
        this.resBundle = AppUtils.getBundle("com.ibm.ws.management.resources.AppDeploymentMessages", loc);
    }

    public void setWorkSpaceID(String wID) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setWorkSpaceID: " + wID);
        }
        if (wID == null) {
            this.amIWorkSpaceOwner = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Create workspace");
        }
        this.workSpace = ConfigRepoHelper.getWorkSpace(wID == null ? "" + this.id : wID);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "WorkSpace root path: " + this.workSpace.getRootContext().getPath());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setWorkSpaceID: " + wID);
        }
    }

    public WorkSpace getWorkSpace() {
        return this.workSpace;
    }

    public String getID() {
        return this.id;
    }

    public AppManagement getAppManagement() {
        return this.appManagement;
    }

    public Hashtable getProperties() {
        return this.properties;
    }

    public String getAppName() {
        return this.appName;
    }

    public void propagateTaskEvent(AppNotification e) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "propagateTaskEvent");
        }
        if (e == null) {
            return;
        }
        Properties props = null;
        if (e.props != null) {
            props = e.props;
        } else {
            props = new Properties();
            e.setProperties(props);
        }
        props.put("appname", this.appName);
        props.putAll((Map<?, ?>)e.props);
        Object hback = this.getProperties().get("HandBackForClient");
        if (hback != null) {
            props.put("HandBackForClient", hback);
        }
        if (this.notifier != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Sending notification: " + e);
            }
            this.notifier.appEventReceived(e);
        }
        this.appManagement.sendJMXEvent(this.getJMXEventType(), e);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "propagateTaskEvent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block18: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "run");
            }
            boolean bSuccess = true;
            ClassLoader origClassLoader = null;
            boolean pushedProfile = false;
            try {
                try {
                    block21: {
                        block20: {
                            if (this.profileKey != null) {
                                pushedProfile = AdminContext.push(this.profileKey);
                            }
                            origClassLoader = Thread.currentThread().getContextClassLoader();
                            ClassLoader ccl = ExtClassLoader.getInstance();
                            if (ccl == null) {
                                ccl = this.getClass().getClassLoader();
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "switching CCL to = " + ccl);
                            }
                            Thread.currentThread().setContextClassLoader(ccl);
                            if (!AdminHelper.getPlatformHelper().isZOS()) break block20;
                            if (!AppManagementImpl.isLocalMode()) {
                                this.subject = SecurityHelper.getOwnedSubject();
                                if (null != this.subject) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Pushing Server Subject: " + this.subject.toString());
                                    }
                                    this.subject = SecurityHelper.pushInvocationSubject(this.subject);
                                }
                            }
                            break block21;
                        }
                        if (!AppManagementImpl.isLocalMode() && this.subject != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Push creds: " + this.subject);
                            }
                            this.subject = SecurityHelper.pushInvocationSubject(this.subject);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "After push: " + this.subject);
                            }
                        }
                    }
                    this.setupTasks();
                    this.setupDone = true;
                    AbstractTask task = this.getNextTask();
                    this.propagateTaskEvent(this.createStartEvent());
                    while (task != null && bSuccess) {
                        task.setScheduler(this);
                        task.setLocale(this.locale);
                        task.setAppTaskName(this.appTaskName);
                        Tr.debug(tc, "Executing: " + task);
                        bSuccess = task.performTask();
                        if (!bSuccess) break;
                        task = this.getNextTask();
                    }
                    Object var7_7 = null;
                    this.cleanup(bSuccess);
                    this.propagateTaskEvent(this.createCompletionEvent(bSuccess));
                    Thread.currentThread().setContextClassLoader(origClassLoader);
                    if (!pushedProfile) break block18;
                }
                catch (Throwable th) {
                    bSuccess = false;
                    this.lastEx = th;
                    RasUtils.logException(th, tc, CLASS_NAME, "run", "297", this);
                    AppUtils.dbg(tc, AppUtils.getMessage(this.resBundle, "ADMA6012I", new Object[]{th}));
                    AppUtils.printEx(th, true);
                    Object var7_8 = null;
                    this.cleanup(bSuccess);
                    this.propagateTaskEvent(this.createCompletionEvent(bSuccess));
                    Thread.currentThread().setContextClassLoader(origClassLoader);
                    if (pushedProfile) {
                        AdminContext.pop();
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                this.cleanup(bSuccess);
                this.propagateTaskEvent(this.createCompletionEvent(bSuccess));
                Thread.currentThread().setContextClassLoader(origClassLoader);
                if (pushedProfile) {
                    AdminContext.pop();
                }
                throw throwable;
            }
            AdminContext.pop();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "run");
        }
    }

    protected AbstractTask getNextTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNextTask");
        }
        if (this.nextTaskNum >= this.tasks.size()) {
            return null;
        }
        int taskNum = this.nextTaskNum++;
        Object taskO = this.tasks.elementAt(taskNum);
        Object taskClass = null;
        if (taskO instanceof AbstractTask) {
            Tr.exit(tc, "getNextTask: " + taskO);
            return (AbstractTask)taskO;
        }
        if (taskO instanceof String) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "XXXX Task list should contain a task instance and not a string, needs to be changed: " + this + ", " + taskO);
            }
            try {
                Class c = ExtensionHelper.loadExtension(null, (String)taskO);
                return (AbstractTask)c.newInstance();
            }
            catch (Throwable th) {
                RasUtils.logException(th, tc, CLASS_NAME, "getNextTask", "343", this);
                if (this.resBundle != null) {
                    throw new AdminException(th, AppUtils.getMessage(this.resBundle, "ADMA0055E", new Object[]{taskClass}));
                }
                throw new AdminException(th);
            }
        }
        throw new AdminException("Unexpected task in the list: " + taskO);
    }

    private void cleanup(boolean bSuccess) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanup", "bSuccess=" + bSuccess);
        }
        Throwable throwable = null;
        try {
            this.performCleanup(bSuccess);
        }
        catch (Throwable t) {
            RasUtils.logException(t, tc, CLASS_NAME, "cleanup", "361", this);
            throwable = t;
        }
        String message = "";
        if (this.resBundle != null) {
            message = throwable == null ? AppUtils.getMessage(this.resBundle, "ADMA5011I", new String[]{this.appName}) : AppUtils.getMessage(this.resBundle, "ADMA5012I", new String[]{this.appName, throwable.toString()});
        }
        String subtaskStatus = throwable == null ? "Completed" : "Failed";
        AppNotification notification = new AppNotification(this.appTaskName, "Cleanup", "InProgress", subtaskStatus, message);
        this.propagateTaskEvent(notification);
        if (this.amIWorkSpaceOwner && this.workSpace != null) {
            try {
                ConfigRepoHelper.removeWorkSpace(bSuccess, this.workSpace);
            }
            catch (Throwable t) {
                RasUtils.logException(t, tc, CLASS_NAME, "cleanup", "388", this);
            }
        }
        if (!AppManagementImpl.isLocalMode() && this.subject != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cleanup", "subject=" + this.subject);
            }
            try {
                SecurityHelper.popInvocationSubject(this.subject);
                this.subject = null;
            }
            catch (Throwable t) {
                RasUtils.logException(t, tc, CLASS_NAME, "cleanup", "401", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanup");
        }
    }

    public RepositoryContext getCellContext() throws Exception {
        RepositoryContext rc;
        if (this.cellContext != null) {
            return this.cellContext;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellContext");
        }
        if ((rc = AppUtils.findAppContextFromConfig(this.appName, this.getWorkSpace(), this.getProperties())) == null) {
            throw new AdminException(null, AppUtils.getMessage(this.resBundle, "ADMA5045E", new Object[]{this.appName}));
        }
        this.cellContext = AdminHelper.getPlatformHelper().isZOS() ? rc.getParentContext().getParentContext() : rc.getParent().getParent();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellContext:" + this.cellContext);
        }
        return this.cellContext;
    }

    protected String getJMXEventType() {
        return "websphere.admin.appmgmt";
    }

    protected abstract void setupTasks() throws Exception;

    protected abstract void performCleanup(boolean var1) throws Exception;

    protected abstract AppNotification createCompletionEvent(boolean var1);

    protected abstract AppNotification createStartEvent();

    public String getClientVersion() {
        return AppUtils.getClientVersion();
    }

    public String getTempDir() {
        return AppUtils.getAppTempDir(this);
    }

    public void setProfileKey(String pKey) {
        this.profileKey = pKey;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/SchedulerImpl.java, WAS.admin.installapp.server, WAS70.SERV1, q0834.18, ver. 1.60");
        }
        CLASS_NAME = SchedulerImpl.class.getName();
    }
}

