/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.logging.MessageConverter;
import com.ibm.ws.logging.ConvertLogConfig;
import java.io.CharArrayWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

public class ConvertLog {
    private static String svBundle = "com.ibm.ejs.resources.RasMessages";
    private static final int MESSAGE_ID_LENGTH_V5 = 9;
    private static final int MESSAGE_ID_LENGTH_V6 = 10;

    private ConvertLog() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] args) {
        block31: {
            ConvertLogConfig config = new ConvertLogConfig(args);
            boolean configOK = config.isValid();
            if (!configOK) {
                return;
            }
            InputStreamReader inputStreamReader = null;
            OutputStreamWriter outputStreamWriter = null;
            try {
                inputStreamReader = new InputStreamReader(new FileInputStream(config.iInputFilename));
            }
            catch (FileNotFoundException e4) {
                String s1 = TraceNLS.getFormattedMessage(svBundle, "CONVERTLOG_INPUTFILENOTFOUND", new Object[]{config.iInputFilename}, "TRAS0025E: Unable to load source file " + config.iInputFilename, true);
                System.err.println(s1);
                Object var8_14 = null;
                try {
                    if (outputStreamWriter != null) {
                        outputStreamWriter.flush();
                        outputStreamWriter.close();
                    }
                    if (inputStreamReader != null) {
                        inputStreamReader.close();
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                return;
            }
            try {
                outputStreamWriter = new OutputStreamWriter(new FileOutputStream(config.iOutputFilename));
            }
            catch (FileNotFoundException e5) {
                String s1 = TraceNLS.getFormattedMessage(svBundle, "CONVERTLOG_OUTPUTFILENOTFOUND", new Object[]{config.iOutputFilename}, "TRAS0026E: Unable to open destination file " + config.iOutputFilename, true);
                System.err.println(s1);
                Object var8_15 = null;
                try {
                    if (outputStreamWriter != null) {
                        outputStreamWriter.flush();
                        outputStreamWriter.close();
                    }
                    if (inputStreamReader != null) {
                        inputStreamReader.close();
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                return;
            }
            char[] inputChars = ConvertLog.read(inputStreamReader);
            char[] outputChars = config.ibConvertWAS5toWAS6 ? ConvertLog.doConversion(inputChars, 9, MessageConverter.CONVERSION_TYPE_WASV5_TO_WASV6) : (config.ibConvertWAS6toWAS5 ? ConvertLog.doConversion(inputChars, 10, MessageConverter.CONVERSION_TYPE_WASV6_TO_WASV5) : inputChars);
            outputStreamWriter.write(outputChars);
            Object var8_16 = null;
            try {
                if (outputStreamWriter != null) {
                    outputStreamWriter.flush();
                    outputStreamWriter.close();
                }
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
                break block31;
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            break block31;
            {
                catch (OutOfMemoryError e5) {
                    String s1 = TraceNLS.getFormattedMessage(svBundle, "CONVERTLOG_OUTOFMEMORY", new Object[]{config.iInputFilename}, "TRAS0027E: Insufficient memory to process source file " + config.iInputFilename, true);
                    System.err.println(s1);
                    e5.printStackTrace();
                    Object var8_17 = null;
                    try {
                        if (outputStreamWriter != null) {
                            outputStreamWriter.flush();
                            outputStreamWriter.close();
                        }
                        if (inputStreamReader != null) {
                            inputStreamReader.close();
                        }
                        break block31;
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    break block31;
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                    Object var8_18 = null;
                    try {
                        if (outputStreamWriter != null) {
                            outputStreamWriter.flush();
                            outputStreamWriter.close();
                        }
                        if (inputStreamReader != null) {
                            inputStreamReader.close();
                        }
                        break block31;
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_19 = null;
                try {
                    if (outputStreamWriter != null) {
                        outputStreamWriter.flush();
                        outputStreamWriter.close();
                    }
                    if (inputStreamReader != null) {
                        inputStreamReader.close();
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    private static char[] doConversion(char[] in, int messageIdLength, short conversionType) throws IOException {
        char[] messageIdEndTag_colon = ":".toCharArray();
        char[] messageIdEndTag_msgId = "</msgId>".toCharArray();
        char[] out = ConvertLog.doConversion(in, messageIdLength, messageIdEndTag_colon, conversionType);
        in = out;
        out = ConvertLog.doConversion(in, messageIdLength, messageIdEndTag_msgId, conversionType);
        return out;
    }

    private static char[] doConversion(char[] in, int messageIdLength, char[] messageIdEndTag, short conversionType) throws IOException {
        int inputSize = in.length;
        if (inputSize == 0) {
            return null;
        }
        CharArrayWriter out = new CharArrayWriter();
        int inputIndex = 0;
        int colonIndex = 0;
        int charsToWrite = 0;
        while (inputIndex <= inputSize - 1) {
            colonIndex = ConvertLog.indexOf(in, inputIndex, messageIdEndTag);
            if (colonIndex < 0) {
                charsToWrite = in.length - inputIndex;
                out.write(in, inputIndex, charsToWrite);
                inputIndex += charsToWrite;
                continue;
            }
            if (colonIndex - inputIndex >= messageIdLength + 1) {
                charsToWrite = colonIndex - inputIndex - messageIdLength - 1;
                out.write(in, inputIndex, charsToWrite);
                inputIndex += charsToWrite;
                char precedingChar = in[colonIndex - messageIdLength - 1];
                if (precedingChar == ' ' || precedingChar == '\"' || precedingChar == '>') {
                    out.write(precedingChar);
                    ++inputIndex;
                    int unconvertedLength = messageIdLength + 1;
                    String unconverted = new String(in, colonIndex - messageIdLength, unconvertedLength);
                    String converted = MessageConverter.convert(unconverted, conversionType);
                    out.write(converted);
                    inputIndex += unconvertedLength;
                    continue;
                }
                charsToWrite = messageIdLength + 1;
                out.write(in, inputIndex, charsToWrite);
                inputIndex += charsToWrite;
                continue;
            }
            charsToWrite = colonIndex - inputIndex + 1;
            out.write(in, inputIndex, charsToWrite);
            inputIndex += charsToWrite;
        }
        return out.toCharArray();
    }

    private static final int indexOf(char[] in, int offset, char[] c) {
        if (c == null || c.length == 0) {
            return -1;
        }
        int cLen = c.length;
        int inLen = in.length;
        for (int i = offset; i < inLen; ++i) {
            int matchedChars = 0;
            if (in[i] != c[matchedChars]) continue;
            for (int j = i; j < inLen && in[j] == c[matchedChars]; ++j) {
                if (++matchedChars != cLen) continue;
                return i;
            }
        }
        return -1;
    }

    private static char[] read(InputStreamReader in) throws IOException {
        char[] buffer = new char[8192];
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        int charsread = 1;
        while (charsread > 0) {
            charsread = in.read(buffer);
            if (charsread <= 0) continue;
            charArrayWriter.write(buffer, 0, charsread);
        }
        charArrayWriter.flush();
        charArrayWriter.close();
        char[] out = charArrayWriter.toCharArray();
        charArrayWriter = null;
        return out;
    }
}

