/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.logging.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.logging.LogFile;
import com.ibm.ws.timeutils.QuickApproxTime;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;

public class LoggerOnThread
implements LogFile {
    private static final TraceComponent tc = Tr.register(LoggerOnThread.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private File myFile = null;
    private String myName = null;
    private String myFullName = null;
    private FileChannel myChannel = null;
    private State state = State.IDLE;
    private long maxFileSize = -1L;
    private int maxBackupFiles = 1;
    private LinkedList<File> backups = null;
    private String fileinfo = null;
    private String extensioninfo = null;
    private SimpleDateFormat myFormat = null;

    public LoggerOnThread(String name) throws FileNotFoundException {
        this.myFullName = name;
        this.myFile = new File(name);
        this.myName = this.myFile.getName();
        this.myChannel = new FileOutputStream(this.myFile, true).getChannel();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, this.getFileName() + ": New logger-on-thread created");
        }
    }

    public String getFileName() {
        return this.myName;
    }

    public boolean isStarted() {
        return State.RUNNING == this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean log(WsByteBuffer data) {
        if (null == data) {
            return false;
        }
        if (State.RUNNING != this.state) {
            data.release();
            return false;
        }
        int length = data.remaining();
        if (this.isOverFileLimit(length)) {
            this.rotate();
        }
        boolean rc = true;
        try {
            ByteBuffer buffer = data.getWrappedByteBuffer();
            for (int bytesWritten = 0; bytesWritten < length; bytesWritten += this.myChannel.write(buffer)) {
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, this.getClass().getName() + ".log", "166", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, this.getFileName() + ": error writing to log; " + e);
            }
            rc = false;
        }
        finally {
            data.release();
        }
        return rc;
    }

    public synchronized boolean start() {
        if (State.IDLE != this.state) {
            return false;
        }
        if (0 < this.getMaximumBackupFiles()) {
            this.myFormat = new SimpleDateFormat("_yy.MM.dd_HH.mm.ss", Locale.US);
            this.backups = new LinkedList();
            int index = this.getFileName().lastIndexOf(46);
            if (-1 != index) {
                this.fileinfo = this.myFullName.substring(0, index += this.myFullName.length() - this.myName.length());
                this.extensioninfo = this.myFullName.substring(index);
            } else {
                this.fileinfo = this.myFullName;
                this.extensioninfo = "";
            }
        }
        this.state = State.RUNNING;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, this.getFileName() + ": started\n" + this);
        }
        return true;
    }

    public synchronized boolean stop() {
        if (State.RUNNING != this.state) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, this.getFileName() + ": Logger already stopped");
            }
            return true;
        }
        this.myFormat = null;
        this.backups = null;
        this.state = State.IDLE;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, this.getFileName() + ": stopped");
        }
        return true;
    }

    public synchronized boolean disable() {
        block7: {
            if (State.RUNNING == this.state) {
                this.stop();
            } else if (State.DISABLED == this.state) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, this.getFileName() + ": attempt to double destroy");
                }
                return false;
            }
            try {
                this.myChannel.close();
            }
            catch (IOException ioe) {
                FFDCFilter.processException((Throwable)ioe, this.getClass().getName() + ".disable", "124", this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block7;
                Tr.event(tc, this.getFileName() + ": Failed to close the output file; " + ioe);
            }
        }
        this.state = State.DISABLED;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, this.getFileName() + ": disabled");
        }
        return true;
    }

    public boolean setMaximumSize(long size) {
        if (-1L > size) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, this.getFileName() + ": Invalid file size-> " + size);
            }
            return false;
        }
        this.maxFileSize = 0L == size ? -1L : size;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, this.getFileName() + ": Set maximum size to " + this.maxFileSize);
        }
        return true;
    }

    public long getMaximumSize() {
        return this.maxFileSize;
    }

    public int getMaximumBackupFiles() {
        return this.maxBackupFiles;
    }

    public boolean setMaximumBackupFiles(int number) {
        if (0 > number) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, this.getFileName() + ": Invalid negative number of backup files-> " + number);
            }
            return false;
        }
        this.maxBackupFiles = number;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, this.getFileName() + ": Set maximum files to " + this.maxBackupFiles);
        }
        return true;
    }

    private boolean isOverFileLimit(int addition) {
        if (-1L == this.getMaximumSize()) {
            return false;
        }
        long newlen = this.myFile.length() + (long)addition;
        return newlen > this.getMaximumSize() || 0L > newlen;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append(super.toString());
        sb.append("\n  FilePathName: ");
        sb.append(this.myFullName);
        sb.append("\n  FileName: ");
        sb.append(this.myName);
        sb.append("\n  MaxFileSize: ");
        sb.append(this.maxFileSize);
        sb.append("\n  CurrentFileSize: ");
        sb.append(this.myFile.length());
        sb.append("\n  MaxBackupFiles: ");
        sb.append(this.maxBackupFiles);
        sb.append("\n  Number of backups: ");
        sb.append(null != this.backups ? this.backups.size() : 0);
        sb.append("\n  State: ");
        sb.append((Object)this.state);
        return sb.toString();
    }

    private void renameFile(File source, File target) {
        boolean rc;
        if (!source.exists()) {
            return;
        }
        if (target.exists()) {
            target.delete();
        }
        if (!(rc = source.renameTo(target)) && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, this.getFileName() + ": Unable to rename " + source + " to " + target);
        }
    }

    private void addBackup() {
        File oldest;
        String newname = this.fileinfo + this.myFormat.format(new Date(QuickApproxTime.getRef().getApproxTime())) + this.extensioninfo;
        File newFile = new File(newname);
        this.renameFile(this.myFile, newFile);
        if (this.backups.size() == this.getMaximumBackupFiles() && null != (oldest = this.backups.removeLast()) && oldest.exists()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, this.getFileName() + ": Purging oldest backup-> " + oldest.getName());
            }
            oldest.delete();
        }
        this.backups.addFirst(newFile);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, this.getFileName() + ": number of backup files-> " + this.backups.size());
        }
    }

    private void rotate() {
        block9: {
            block8: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, this.getFileName() + ": Rotating output log");
                }
                try {
                    this.myChannel.close();
                }
                catch (IOException ioe) {
                    FFDCFilter.processException((Throwable)ioe, this.getClass().getName() + ".rotate", "424", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block8;
                    Tr.event(tc, this.getFileName() + ": Failed to close the output file; " + ioe);
                }
            }
            try {
                if (0 < this.getMaximumBackupFiles()) {
                    this.addBackup();
                }
                this.myChannel = new FileOutputStream(this.myFile, true).getChannel();
            }
            catch (SecurityException se) {
                FFDCFilter.processException((Throwable)se, this.getClass().getName() + ".rotate", "436", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, this.getFileName() + ": security error in rotate; " + se);
                }
            }
            catch (Throwable t) {
                FFDCFilter.processException(t, this.getClass().getName() + ".rotate", "441", this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block9;
                Tr.event(tc, this.getFileName() + ": error in rotate; " + t);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        IDLE,
        RUNNING,
        DISABLED;

    }
}

