/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.outbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.http.channel.impl.CallbackIDs;
import com.ibm.ws.http.channel.outbound.impl.HttpOutboundServiceContextImpl;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.io.IOException;

public class HttpOSCWriteCallback
implements TCPWriteCompletedCallback {
    private static final TraceComponent tc = Tr.register(HttpOSCWriteCallback.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static final HttpOSCWriteCallback myInstance = new HttpOSCWriteCallback();

    private HttpOSCWriteCallback() {
    }

    public static final HttpOSCWriteCallback getRef() {
        return myInstance;
    }

    public void complete(VirtualConnection vc, TCPWriteRequestContext wsc) {
        HttpOutboundServiceContextImpl mySC;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "complete() called: vc=" + vc);
        }
        if ((mySC = (HttpOutboundServiceContextImpl)vc.getStateMap().get(CallbackIDs.CALLBACK_HTTPOSC)).isEarlyRead()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Notifying app channel of write complete");
            }
            mySC.getAppWriteCallback().complete(vc);
            return;
        }
        if (mySC.isHeadersSentState() && 0 == mySC.getNumBytesWritten() && mySC.shouldReadResponseImmediately()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Sent headers, reading for response");
            }
            mySC.startResponseRead();
            return;
        }
        if (!mySC.isMessageSent()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Calling write complete callback of app channel.");
            }
            mySC.getAppWriteCallback().complete(vc);
        } else if (mySC.shouldReadResponseImmediately()) {
            mySC.readAsyncResponse();
        } else {
            mySC.startResponseRead();
        }
    }

    public void error(VirtualConnection vc, TCPWriteRequestContext wsc, IOException ioe) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "error() called: vc=" + vc + " ioe=" + ioe);
        }
        HttpOutboundServiceContextImpl mySC = (HttpOutboundServiceContextImpl)vc.getStateMap().get(CallbackIDs.CALLBACK_HTTPOSC);
        mySC.setPersistent(false);
        mySC.reConnect(vc, ioe);
    }
}

