/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.cookies.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.channel.impl.HttpDateFormat;
import com.ibm.ws.timeutils.QuickApproxTime;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import java.util.Date;
import javax.servlet.http.Cookie;

public class CookieUtils {
    private static final TraceComponent tc = Tr.register(CookieUtils.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static final String TSPECIALS = "\"()<>@,;:\\/[]?={} \t";
    private static final String longAgo = "; Expires=Thu, 01-Dec-94 16:00:00 GMT";

    private CookieUtils() {
    }

    public static String toString(Cookie cookie, HeaderKeys hdr) {
        if (null == cookie) {
            throw new NullPointerException("Null cookie input");
        }
        if (null == hdr) {
            throw new NullPointerException("Null header input");
        }
        try {
            if (0 == cookie.getVersion()) {
                if (HttpHeaderKeys.HDR_COOKIE.equals(hdr)) {
                    return CookieUtils.convertV0Cookie(cookie);
                }
                if (HttpHeaderKeys.HDR_SET_COOKIE.equals(hdr)) {
                    return CookieUtils.convertV0SetCookie(cookie);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invalid header: " + hdr);
                }
            } else if (1 == cookie.getVersion()) {
                if (HttpHeaderKeys.HDR_COOKIE.equals(hdr)) {
                    return CookieUtils.convertV1Cookie(cookie);
                }
                if (HttpHeaderKeys.HDR_COOKIE2.equals(hdr)) {
                    return CookieUtils.convertV1Cookie2(cookie);
                }
                if (HttpHeaderKeys.HDR_SET_COOKIE.equals(hdr)) {
                    return CookieUtils.convertV1SetCookie(cookie);
                }
                if (HttpHeaderKeys.HDR_SET_COOKIE2.equals(hdr)) {
                    return CookieUtils.convertV1SetCookie2(cookie);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invalid header: " + hdr);
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid Cookie version: " + cookie.getVersion());
            }
            return CookieUtils.convertV0Cookie(cookie);
        }
        catch (Exception e) {
            FFDCFilter.processException(e, CookieUtils.class.getName() + ".toString", "1");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception while converting the cookie; " + cookie);
            }
            return null;
        }
    }

    private static boolean needsQuote(String value) {
        int len;
        int n = len = null == value ? 0 : value.length();
        if (0 == len) {
            return true;
        }
        if ('\"' == value.charAt(0)) {
            return '\"' != value.charAt(len - 1);
        }
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c >= ' ' && c < '\u007f' && TSPECIALS.indexOf(c) == -1) continue;
            return true;
        }
        return false;
    }

    private static void maybeQuote(StringBuffer buff, String value) {
        if (null == value || 0 == value.length()) {
            buff.append("\"\"");
        } else if (CookieUtils.needsQuote(value)) {
            buff.append('\"');
            buff.append(value);
            buff.append('\"');
        } else {
            buff.append(value);
        }
    }

    private static String convertV0Cookie(Cookie cookie) {
        StringBuffer buffer = new StringBuffer(40);
        buffer.append(cookie.getName());
        String value = cookie.getValue();
        if (null != value && 0 != value.length()) {
            buffer.append('=');
            buffer.append(value);
        } else {
            buffer.append("=\"\"");
        }
        value = cookie.getPath();
        if (null != value && 0 != value.length()) {
            buffer.append("; $Path=");
            buffer.append(value);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Created v0 Cookie: [" + buffer.toString() + "]");
        }
        return buffer.toString();
    }

    private static String convertV1Cookie(Cookie cookie) {
        StringBuffer buffer = new StringBuffer(40);
        buffer.append(cookie.getName());
        buffer.append('=');
        CookieUtils.maybeQuote(buffer, cookie.getValue());
        buffer.append("; $Version=1");
        String value = cookie.getPath();
        if (null != value && 0 != value.length()) {
            buffer.append("; $Path=");
            CookieUtils.maybeQuote(buffer, value);
        }
        if (null != (value = cookie.getDomain()) && 0 != value.length()) {
            buffer.append("; $Domain=");
            CookieUtils.maybeQuote(buffer, value);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Created v1 Cookie: [" + buffer.toString() + "]");
        }
        return buffer.toString();
    }

    private static String convertV1Cookie2(Cookie cookie) {
        StringBuffer buffer = new StringBuffer(40);
        buffer.append(cookie.getName());
        buffer.append('=');
        CookieUtils.maybeQuote(buffer, cookie.getValue());
        buffer.append("; $Version=1");
        String value = cookie.getPath();
        if (null != value && 0 != value.length()) {
            buffer.append("; $Path=");
            CookieUtils.maybeQuote(buffer, value);
        }
        if (null != (value = cookie.getDomain()) && 0 != value.length()) {
            buffer.append("; $Domain=");
            CookieUtils.maybeQuote(buffer, value);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Created v1 Cookie2: [" + buffer.toString() + "]");
        }
        return buffer.toString();
    }

    private static String convertV0SetCookie(Cookie cookie) {
        StringBuffer buffer = new StringBuffer(40);
        buffer.append(cookie.getName());
        String value = cookie.getValue();
        if (null != value && 0 != value.length()) {
            buffer.append('=');
            buffer.append(value);
        } else {
            buffer.append("=\"\"");
        }
        int expires = cookie.getMaxAge();
        if (-1 < expires) {
            if (0 == expires) {
                buffer.append(longAgo);
            } else {
                buffer.append("; Expires=");
                buffer.append(HttpDateFormat.getRef().getRFC2109Time(new Date(QuickApproxTime.getRef().getApproxTime() + (long)expires * 1000L)));
            }
        }
        if (null != (value = cookie.getPath()) && 0 != value.length()) {
            buffer.append("; Path=");
            buffer.append(value);
        }
        if (null != (value = cookie.getDomain()) && 0 != value.length()) {
            buffer.append("; Domain=");
            buffer.append(value);
        }
        if (cookie.getSecure()) {
            buffer.append("; Secure");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Created v0 Set-Cookie: [" + buffer.toString() + "]");
        }
        return buffer.toString();
    }

    private static String convertV1SetCookie(Cookie cookie) {
        int maxAge;
        StringBuffer buffer = new StringBuffer(40);
        buffer.append(cookie.getName());
        buffer.append('=');
        CookieUtils.maybeQuote(buffer, cookie.getValue());
        buffer.append("; Version=1");
        String value = cookie.getComment();
        if (null != value && 0 != value.length()) {
            buffer.append("; Comment=");
            CookieUtils.maybeQuote(buffer, value);
        }
        if (null != (value = cookie.getDomain()) && 0 != value.length()) {
            buffer.append("; Domain=");
            CookieUtils.maybeQuote(buffer, value);
        }
        if (-1 < (maxAge = cookie.getMaxAge())) {
            buffer.append("; Max-Age=");
            buffer.append(maxAge);
        }
        if (null != (value = cookie.getPath()) && 0 != value.length()) {
            buffer.append("; Path=");
            CookieUtils.maybeQuote(buffer, value);
        }
        if (cookie.getSecure()) {
            buffer.append("; Secure");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Created v1 Set-Cookie: [" + buffer.toString() + "]");
        }
        return buffer.toString();
    }

    private static String convertV1SetCookie2(Cookie cookie) {
        int maxAge;
        StringBuffer buffer = new StringBuffer(40);
        buffer.append(cookie.getName());
        buffer.append('=');
        CookieUtils.maybeQuote(buffer, cookie.getValue());
        buffer.append("; Version=1");
        String value = cookie.getComment();
        if (null != value && 0 != value.length()) {
            buffer.append("; Comment=");
            CookieUtils.maybeQuote(buffer, value);
        }
        if (null != (value = cookie.getDomain()) && 0 != value.length()) {
            buffer.append("; Domain=");
            CookieUtils.maybeQuote(buffer, value);
        }
        if (-1 < (maxAge = cookie.getMaxAge())) {
            buffer.append("; Max-Age=");
            buffer.append(maxAge);
        }
        if (null != (value = cookie.getPath()) && 0 != value.length()) {
            buffer.append("; Path=");
            CookieUtils.maybeQuote(buffer, value);
        }
        if (cookie.getSecure()) {
            buffer.append("; Secure");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Created v1 Set-Cookie2: [" + buffer.toString() + "]");
        }
        return buffer.toString();
    }
}

