/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.compression;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.ws.genericbnf.impl.GenericUtils;
import com.ibm.ws.http.channel.compression.CompressionHandler;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.http.channel.values.ContentEncodingValues;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.Deflater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeflateOutputHandler
implements CompressionHandler {
    private static final TraceComponent tc = Tr.register(DeflateOutputHandler.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private Deflater deflater = null;
    private byte[] buf = new byte[32768];

    public DeflateOutputHandler() {
        this.deflater = new Deflater(-1, false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Created a deflate output handler; " + this);
        }
    }

    public DeflateOutputHandler(byte[] useragent) {
        if (null != useragent && this.isIEBrowser(useragent)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "User-Agent indicates IE browser [" + GenericUtils.getEnglishString(useragent) + "]");
            }
            this.deflater = new Deflater(-1, true);
        } else {
            this.deflater = new Deflater(-1, false);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Created a deflate output handler; " + this);
        }
    }

    private boolean isIEBrowser(byte[] agent) {
        int end = agent.length - 4;
        int i = 0;
        while (i < end) {
            if (77 == agent[i]) {
                if (83 != agent[++i] || 73 != agent[++i] || 69 != agent[++i]) continue;
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public List<WsByteBuffer> compress(WsByteBuffer buffer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "compress, input=" + buffer);
        }
        List<WsByteBuffer> list = new LinkedList<WsByteBuffer>();
        list = this.compress(list, buffer);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "compress, return list of size " + list.size());
        }
        return list;
    }

    @Override
    public List<WsByteBuffer> compress(WsByteBuffer[] buffers) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "compress, input=" + buffers);
        }
        List<WsByteBuffer> list = new LinkedList<WsByteBuffer>();
        if (null != buffers) {
            for (int i = 0; i < buffers.length; ++i) {
                list = this.compress(list, buffers[i]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "compress, return list of size " + list.size());
        }
        return list;
    }

    @Override
    public ContentEncodingValues getContentEncoding() {
        return ContentEncodingValues.DEFLATE;
    }

    @Override
    public List<WsByteBuffer> finish() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "finish");
        }
        LinkedList<WsByteBuffer> list = new LinkedList<WsByteBuffer>();
        if (this.isFinished()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "finish, previously finished");
            }
            return list;
        }
        WsByteBuffer buffer = null;
        this.deflater.finish();
        while (!this.deflater.finished()) {
            int num = this.deflater.deflate(this.buf, 0, this.buf.length);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Compressed amount=" + num + " read=" + this.deflater.getBytesRead() + " written=" + this.deflater.getBytesWritten());
            }
            if (0 >= num) continue;
            buffer = this.makeBuffer(num);
            list.add(buffer);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "finish, return list of size " + list.size());
        }
        return list;
    }

    @Override
    public boolean isFinished() {
        return this.deflater.finished();
    }

    protected List<WsByteBuffer> compress(List<WsByteBuffer> list, WsByteBuffer buffer) {
        int dataSize;
        int n = dataSize = null != buffer ? buffer.remaining() : 0;
        if (0 == dataSize) {
            return list;
        }
        byte[] input = null;
        int initOffset = 0;
        if (buffer.hasArray()) {
            input = buffer.array();
            initOffset = buffer.arrayOffset() + buffer.position();
            buffer.position(buffer.limit());
        } else {
            input = new byte[dataSize];
            buffer.get(input);
        }
        this.deflater.setInput(input, initOffset, dataSize);
        int offset = 0;
        while (!this.deflater.needsInput()) {
            int len = this.deflater.deflate(this.buf, offset, this.buf.length - offset);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Compressed amount=" + len + " read=" + this.deflater.getBytesRead() + " written=" + this.deflater.getBytesWritten());
            }
            if (0 == len) break;
            if ((offset += len) != this.buf.length) continue;
            list.add(this.makeBuffer(offset));
            offset = 0;
        }
        if (0 < offset) {
            list.add(this.makeBuffer(offset));
        }
        return list;
    }

    private WsByteBuffer makeBuffer(int len) {
        WsByteBuffer buffer = WsByteBufferPoolManagerImpl.getRef().allocateDirect(len);
        buffer.put(this.buf, 0, len);
        buffer.flip();
        return buffer;
    }

    @Override
    public long getBytesRead() {
        return this.deflater.getBytesRead();
    }

    @Override
    public long getBytesWritten() {
        return this.deflater.getBytesWritten();
    }
}

