/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.genericbnf.impl;

import com.ibm.ws.genericbnf.impl.BNFHeadersImpl;
import com.ibm.ws.genericbnf.impl.BinaryHeaderNode;
import com.ibm.ws.genericbnf.impl.QuickGenericMatcher;
import com.ibm.wsspi.genericbnf.GenericKeys;

public class QuickCaseInsensitiveMatcher
extends QuickGenericMatcher {
    protected boolean shouldMakeLower = true;
    protected BinaryHeaderNode[] charNodes = new BinaryHeaderNode[26];

    public QuickCaseInsensitiveMatcher(boolean makeLower) {
        this.shouldMakeLower = makeLower;
    }

    public BinaryHeaderNode getNode(GenericKeys key) {
        return this.getNode(key.getName().charAt(0), true);
    }

    public BinaryHeaderNode getNode(String s) {
        return this.getNode(s.charAt(0), true);
    }

    protected BinaryHeaderNode getNode(int c, boolean createNew) {
        int firstChar = QuickCaseInsensitiveMatcher.normalizeToLower(c);
        if (QuickCaseInsensitiveMatcher.isLower(firstChar)) {
            if (createNew && null == this.charNodes[firstChar -= 97]) {
                this.charNodes[firstChar] = new BinaryHeaderNode((char)firstChar, this.shouldMakeLower);
            }
            return this.charNodes[firstChar];
        }
        return null;
    }

    public void init() {
        for (int i = 0; i < this.charNodes.length; ++i) {
            if (null == this.charNodes[i]) continue;
            this.charNodes[i].init();
        }
    }

    public Object match(char[] c, int startPosition, int length) {
        BinaryHeaderNode node = this.getNode(c[startPosition], false);
        return null != node ? node.match(c, startPosition, length) : null;
    }

    public Object match(byte[] b, int startPosition, int length) {
        BinaryHeaderNode node = this.getNode(b[startPosition], false);
        return null != node ? node.match(b, startPosition, length) : null;
    }

    public Object match(BNFHeadersImpl headersImpl, byte[] b, int startPosition, int length) {
        return this.match(b, startPosition, length);
    }
}

