/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.extension.thinregistry;

import com.ibm.ws.bootstrap.LoggingServices;
import com.ibm.ws.extension.thinregistry.Constants;
import com.ibm.ws.extension.thinregistry.Extension;
import com.ibm.ws.extension.thinregistry.ExtensionPoint;
import com.ibm.ws.extension.thinregistry.PluginDescriptor;
import com.ibm.ws.extension.thinregistry.RegistryLoader;
import com.ibm.ws.extension.thinregistry.RegistryResolver;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeListener;

public class ExtensionRegistry
implements IExtensionRegistry {
    private static final String srcClass = "ExtensionRegistry";
    private Map _plugins = new HashMap();
    private List _pluginList = new ArrayList();
    private Map _extPoints = new HashMap();
    private Map _extensions = new HashMap();
    private transient RegistryLoader _loader = null;
    private transient RegistryResolver _resolver = null;
    private static ClassLoader _classLoader = ExtensionRegistry.class.getClassLoader();

    public ExtensionRegistry() {
        if (LoggingServices.debugEnabled) {
            LoggingServices.trace("Creating thin registry");
        }
        this._loader = new RegistryLoader(this);
        this._resolver = new RegistryResolver(this);
        this._loader.addToRegistry(_classLoader);
        this._resolver.resolve();
        this._loader.releaseLoader();
        this._loader = null;
        this._resolver = null;
    }

    public void addRegistryChangeListener(IRegistryChangeListener listener, String namespace) {
    }

    public void addRegistryChangeListener(IRegistryChangeListener listener) {
    }

    public IConfigurationElement[] getConfigurationElementsFor(String extensionPointId) {
        IConfigurationElement[] result;
        IExtensionPoint point = this.getExtensionPoint(extensionPointId);
        if (point == null) {
            result = Constants.EMPTY_CONFIGELEM_ARRAY;
        } else {
            result = point.getConfigurationElements();
            if (result == null) {
                result = Constants.EMPTY_CONFIGELEM_ARRAY;
            }
        }
        return result;
    }

    public IConfigurationElement[] getConfigurationElementsFor(String namespace, String extensionPointName) {
        IConfigurationElement[] result = this.getConfigurationElementsFor(namespace + "." + extensionPointName);
        return result;
    }

    public IConfigurationElement[] getConfigurationElementsFor(String namespace, String extensionPointName, String extensionId) {
        IConfigurationElement[] result;
        Extension extension2 = (Extension)this.getExtension(namespace, extensionPointName, extensionId);
        if (extension2 == null) {
            result = Constants.EMPTY_CONFIGELEM_ARRAY;
        } else {
            result = extension2.getConfigurationElements();
            if (result == null) {
                result = Constants.EMPTY_CONFIGELEM_ARRAY;
            }
        }
        return result;
    }

    public IExtension getExtension(String extensionId) {
        Extension result = (Extension)this._extensions.get(extensionId);
        return result;
    }

    public IExtension getExtension(String extensionPointId, String extensionId) {
        IExtension result = null;
        int lastdot = extensionPointId.lastIndexOf(46);
        result = lastdot == -1 ? null : this.getExtension(extensionPointId.substring(0, lastdot), extensionPointId.substring(lastdot + 1), extensionId);
        return result;
    }

    public IExtension getExtension(String namespace, String extensionPointName, String extensionId) {
        IExtensionPoint xpt = this.getExtensionPoint(namespace, extensionPointName);
        IExtension result = xpt != null ? xpt.getExtension(extensionId) : null;
        return result;
    }

    public IExtensionPoint getExtensionPoint(String extensionPointId) {
        IExtensionPoint result = (IExtensionPoint)this._extPoints.get(extensionPointId);
        return result;
    }

    public IExtensionPoint getExtensionPoint(String namespace, String extensionPointName) {
        IExtensionPoint result = this.getExtensionPoint(namespace + "." + extensionPointName);
        return result;
    }

    public IExtensionPoint[] getExtensionPoints() {
        IExtensionPoint[] result = this._extPoints.values().toArray(new IExtensionPoint[0]);
        return result;
    }

    public IExtensionPoint[] getExtensionPoints(String namespace) {
        PluginDescriptor pd = (PluginDescriptor)this._plugins.get(namespace);
        IExtensionPoint[] result = pd != null ? pd.getExtensionPoints() : Constants.EMPTY_EXTENSIONPOINT_ARRAY;
        return result;
    }

    public IExtension[] getExtensions(String namespace) {
        IExtensionPoint xpt = (IExtensionPoint)this._extPoints.get(namespace);
        IExtension[] result = xpt != null ? xpt.getExtensions() : Constants.EMPTY_EXTENSION_ARRAY;
        return result;
    }

    public String[] getNamespaces() {
        String[] result = this._plugins.keySet().toArray(new String[0]);
        return result;
    }

    public void removeRegistryChangeListener(IRegistryChangeListener listener) {
    }

    void addPlugin(PluginDescriptor plugin) {
        if (LoggingServices.debugEnabled) {
            LoggingServices.trace("Adding " + plugin);
        }
        this._pluginList.add(plugin);
        String id = plugin.getUniqueIdentifier();
        PluginDescriptor oldPlugin = this._plugins.put(id, plugin);
        if (oldPlugin != null && LoggingServices.debugEnabled) {
            LoggingServices.trace("  plugin conflict (" + id + "): " + oldPlugin.getInstallURL());
        }
        ExtensionPoint[] extPts = (ExtensionPoint[])plugin.getExtensionPoints();
        for (int i = 0; i < extPts.length; ++i) {
            id = extPts[i].getUniqueIdentifier();
            ExtensionPoint oldExtPt = this._extPoints.put(id, extPts[i]);
            if (oldExtPt == null || !LoggingServices.debugEnabled) continue;
            LoggingServices.trace("  extension point conflict (" + id + "): " + oldExtPt.getDeclaringPluginDescriptor().getInstallURL());
        }
        Extension[] extensions = (Extension[])plugin.getExtensions();
        for (int i = 0; i < extensions.length; ++i) {
            id = extensions[i].getUniqueIdentifier();
            Extension oldExt = this._extensions.put(id, extensions[i]);
            if (oldExt == null || !LoggingServices.debugEnabled) continue;
            LoggingServices.trace("  extension conflict (" + id + "): " + oldExt.getDeclaringPluginDescriptor().getInstallURL());
        }
    }

    Collection getAllPlugins() {
        return this._pluginList;
    }

    PluginDescriptor getPlugin(String pluginId) {
        return (PluginDescriptor)this._plugins.get(pluginId);
    }

    static ClassLoader getClassLoader() {
        return _classLoader;
    }

    public boolean addContribution(InputStream arg0, IContributor arg1, boolean arg2, String arg3, ResourceBundle arg4, Object arg5) throws IllegalArgumentException {
        return false;
    }

    public boolean removeExtension(IExtension arg0, Object arg1) throws IllegalArgumentException {
        return false;
    }

    public boolean removeExtensionPoint(IExtensionPoint arg0, Object arg1) throws IllegalArgumentException {
        return false;
    }

    public void stop(Object arg0) throws IllegalArgumentException {
    }
}

