/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.crypto.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.crypto.KeyException;
import com.ibm.websphere.models.config.ipc.ssl.KeySet;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.crypto.config.KeyReference;
import com.ibm.ws.crypto.config.WSKeyPairReference;
import com.ibm.ws.crypto.config.WSKeyReference;
import com.ibm.ws.crypto.config.WSKeyReferenceVersionComparator;
import com.ibm.ws.security.config.SecurityConfigObject;
import com.ibm.ws.security.config.SecurityConfigObjectList;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;

public class WSKeySet {
    private static final WebSphereRuntimePermission GET_KEYPASSWORD = new WebSphereRuntimePermission("GetKeyPassword");
    private static final TraceComponent tc = Tr.register(WSKeySet.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private String name = null;
    private String aliasPrefix = null;
    private String password = null;
    private int maxKeyReferences = 3;
    private boolean deleteOldKeys = false;
    private boolean isKeyPair = false;
    private String keyGenerationClass = null;
    private String keyStoreName = null;
    private String keyStoreScopeName = null;
    private WSKeyStore keyStore = null;
    private String scope = ManagementScopeManager.getInstance().getCellScopeName();
    private Properties additionalProps = null;
    private TreeSet keyReferenceSet = new TreeSet(new WSKeyReferenceVersionComparator());

    public WSKeySet(SecurityConfigObject kset) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSKeySet");
        }
        this.name = kset.getString("name");
        this.aliasPrefix = kset.getString("aliasPrefix");
        this.password = kset.getDecodedString("password");
        this.maxKeyReferences = kset.getInteger("maxKeyReferences");
        this.deleteOldKeys = kset.getBoolean("deleteOldKeys");
        this.isKeyPair = kset.getBoolean("isKeyPair");
        this.keyGenerationClass = kset.getString("keyGenerationClass");
        this.keyStoreName = kset.getObject("keyStore").getString("name");
        this.keyStore = KeyStoreManager.getInstance().getKeyStore(this.keyStoreName);
        this.scope = kset.getObject("managementScope").getString("scopeName");
        this.additionalProps = kset.getProperties("additionalKeySetAttrs");
        this.convertToWSKeyReferences(kset.getObjectList("keyReference"), this.keyStore);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSKeySet", new Object[]{this.toString()});
        }
    }

    public WSKeySet(KeySet kset) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSKeySet");
        }
        this.name = kset.getName();
        this.aliasPrefix = kset.getAliasPrefix();
        this.password = kset.getPassword();
        this.maxKeyReferences = kset.getMaxKeyReferences();
        this.deleteOldKeys = kset.isDeleteOldKeys();
        this.isKeyPair = kset.isIsKeyPair();
        this.keyGenerationClass = kset.getKeyGenerationClass();
        this.keyStoreName = kset.getKeyStore().getName();
        this.keyStore = KeyStoreManager.getInstance().getKeyStore(this.keyStoreName);
        this.scope = kset.getManagementScope().getScopeName();
        this.additionalProps = this.getProperties(kset.getAdditionalKeySetAttrs());
        this.convertToWSKeyReferences(kset.getKeyReference(), this.keyStore);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSKeySet", new Object[]{this.toString()});
        }
    }

    public WSKeySet(KeySet kset, Object sessionObject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSKeySet");
        }
        this.name = kset.getName();
        this.aliasPrefix = kset.getAliasPrefix();
        this.password = kset.getPassword();
        this.maxKeyReferences = kset.getMaxKeyReferences();
        this.deleteOldKeys = kset.isDeleteOldKeys();
        this.isKeyPair = kset.isIsKeyPair();
        this.keyGenerationClass = kset.getKeyGenerationClass();
        this.keyStoreName = kset.getKeyStore().getName();
        this.keyStoreScopeName = kset.getKeyStore().getManagementScope().getScopeName();
        this.keyStore = KeyStoreManager.getInstance().getKeyStore(this.keyStoreName, this.keyStoreScopeName, sessionObject);
        this.scope = kset.getManagementScope().getScopeName();
        this.additionalProps = this.getProperties(kset.getAdditionalKeySetAttrs());
        this.convertToWSKeyReferences(kset.getKeyReference(), this.keyStore);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSKeySet", new Object[]{this.toString()});
        }
    }

    private void convertToWSKeyReferences(SecurityConfigObjectList keyReferences, WSKeyStore ks) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertToKeyReferences");
        }
        if (keyReferences != null && keyReferences.size() > 0) {
            for (int i = 0; i < keyReferences.size(); ++i) {
                KeyReference wskr;
                SecurityConfigObject ref = keyReferences.get(i);
                if (this.isKeyPair) {
                    wskr = new WSKeyPairReference(ref, this, ks);
                    this.keyReferenceSet.add(wskr);
                    continue;
                }
                wskr = new WSKeyReference(ref, this, ks);
                this.keyReferenceSet.add(wskr);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertToKeyReferences");
        }
    }

    private void convertToWSKeyReferences(List keyReferences, WSKeyStore ks) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertToKeyReferences");
        }
        if (keyReferences != null && keyReferences.size() > 0) {
            for (int i = 0; i < keyReferences.size(); ++i) {
                KeyReference wskr;
                com.ibm.websphere.models.config.ipc.ssl.KeyReference ref = (com.ibm.websphere.models.config.ipc.ssl.KeyReference)keyReferences.get(i);
                if (this.isKeyPair) {
                    wskr = new WSKeyPairReference(ref, this, ks);
                    this.keyReferenceSet.add(wskr);
                    continue;
                }
                wskr = new WSKeyReference(ref, this, ks);
                this.keyReferenceSet.add(wskr);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertToKeyReferences");
        }
    }

    public void addKeyReference(KeyReference keyRef) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addKeyReference", new Object[]{keyRef});
        }
        this.keyReferenceSet.add(keyRef);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addKeyReference");
        }
    }

    public Object getLatestKey() throws KeyException {
        KeyReference kref;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLatestKey");
        }
        if ((kref = this.getLatestKeyReference()) instanceof WSKeyReference) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getLatestKey (key)");
            }
            return ((WSKeyReference)kref).getKey();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLatestKey (key pair)");
        }
        return ((WSKeyPairReference)kref).getKeyPair();
    }

    public KeyReference getLatestKeyReference() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLatestKeyReference");
        }
        KeyReference kref = null;
        if (this.keyReferenceSet.size() > 0) {
            kref = (KeyReference)this.keyReferenceSet.last();
        }
        int version = -1;
        if (kref != null) {
            version = kref.getVersion();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLatestKeyReference -> " + version);
        }
        return kref;
    }

    public KeyReference getOldestKeyReference() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOldestKeyReference");
        }
        KeyReference kref = null;
        if (this.keyReferenceSet.size() > 0) {
            kref = (KeyReference)this.keyReferenceSet.first();
        }
        int version = -1;
        if (kref != null) {
            version = kref.getVersion();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOldestKeyReference -> " + version);
        }
        return kref;
    }

    public void removeOldestReference() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeOldestReference");
        }
        KeyReference kref = null;
        if (this.keyReferenceSet.size() > 0) {
            kref = (KeyReference)this.keyReferenceSet.first();
            this.keyReferenceSet.remove(kref);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeOldestReference -> " + kref.getVersion());
        }
    }

    public Map getAllKeys() throws KeyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllKeys");
        }
        KeyReference[] krefArray = this.getAllKeyReferences();
        HashMap<String, Serializable> keys = new HashMap<String, Serializable>();
        for (int i = 0; i < krefArray.length; ++i) {
            if (krefArray[i] != null && krefArray[i] instanceof WSKeyReference) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding key alias " + krefArray[i].getKeyAlias() + " of type WSKeyReference.");
                }
                keys.put(krefArray[i].getKeyAlias(), ((WSKeyReference)krefArray[i]).getKey());
                continue;
            }
            if (krefArray[i] == null || !(krefArray[i] instanceof WSKeyPairReference)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding key alias " + krefArray[i].getKeyAlias() + " of type WSKeyPairReference.");
            }
            keys.put(krefArray[i].getKeyAlias(), ((WSKeyPairReference)krefArray[i]).getKeyPair());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllKeys");
        }
        return keys;
    }

    public KeyReference[] getAllKeyReferences() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllKeyReferences");
        }
        KeyReference[] krefArray = this.keyReferenceSet.toArray(new KeyReference[this.keyReferenceSet.size()]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllKeyReferences");
        }
        return krefArray;
    }

    public TreeSet getKeyReferenceTreeSet() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyReferenceTreeSet");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyReferenceTreeSet");
        }
        return this.keyReferenceSet;
    }

    private Properties getProperties(List props) {
        Properties oProps = new Properties();
        if (props != null) {
            for (int i = 0; i < props.size(); ++i) {
                Property p = (Property)props.get(i);
                oProps.put(p.getName(), p.getValue());
            }
        }
        return oProps;
    }

    public String toString() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "toString");
        }
        StringBuffer buf = new StringBuffer();
        buf.append("WSKeySet.toString() {\n");
        buf.append("name = ");
        buf.append(this.name);
        buf.append("\n");
        buf.append("aliasPrefix = ");
        buf.append(this.aliasPrefix);
        buf.append("\n");
        if (this.password != null && !this.password.equals("")) {
            buf.append("password = ");
            buf.append(SSLConfigManager.mask(this.password));
            buf.append("\n");
        }
        buf.append("maxKeyReferences = ");
        buf.append(this.maxKeyReferences);
        buf.append("\n");
        buf.append("deleteOldKeys = ");
        buf.append(this.deleteOldKeys);
        buf.append("\n");
        buf.append("isKeyPair = ");
        buf.append(this.isKeyPair);
        buf.append("\n");
        buf.append("keyGenerationClass = ");
        buf.append(this.keyGenerationClass);
        buf.append("\n");
        buf.append("keyStoreName = ");
        buf.append(this.keyStoreName);
        buf.append("\n");
        buf.append("scope = ");
        buf.append(this.scope);
        buf.append("\n}");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "toString");
        }
        return buf.toString();
    }

    public String getName() {
        return this.name;
    }

    public String getAliasPrefix() {
        return this.aliasPrefix;
    }

    public String getPassword() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GET_KEYPASSWORD.toString());
            }
            try {
                sm.checkPermission(GET_KEYPASSWORD);
            }
            catch (SecurityException e) {
                Manager.Ffdc.log(e, this, "com.ibm.ws.crypto.config.WSKeySet.getPassword", "461", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Permission exception: ", new Object[]{e});
                }
                throw e;
            }
        }
        return this.password;
    }

    public int getMaxKeyReferences() {
        return this.maxKeyReferences;
    }

    public boolean getDeleteOldKeys() {
        return this.deleteOldKeys;
    }

    public boolean getIsKeyPair() {
        return this.isKeyPair;
    }

    public String getKeyGenerationClass() {
        return this.keyGenerationClass;
    }

    public String getKeyStoreName() {
        return this.keyStoreName;
    }

    public WSKeyStore getWSKeyStore() {
        return this.keyStore;
    }

    public String getManagementScopeName() {
        return this.scope;
    }

    public Properties getCustomProperties() {
        return this.additionalProps;
    }
}

