/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloader;

import com.ibm.ejs.models.base.extensions.webappext.WebAppExtension;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.ModuleRef;
import com.ibm.ffdc.Manager;
import com.ibm.ws.classloader.ClassGraph;
import com.ibm.ws.classloader.ClassGraphState;
import com.ibm.ws.classloader.ClassLoaderDump;
import com.ibm.ws.classloader.ClassLoaderListener;
import com.ibm.ws.classloader.JarClassLoader;
import com.ibm.ws.classloader.ReloadableClassLoader;
import com.ibm.ws.classloader.SingleServerClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.RuntimeClasspathEntry;

public class ClassLoaderManager {
    private static TraceComponent tc = Tr.register(ClassLoaderManager.class.getName(), "Websphere ClassLoader", null);
    protected ClassLoader parent = null;
    protected ReloadableClassLoader applicationClassLoader;
    protected EARFile earFile = null;
    protected Map moduleClassLoaderLookup = Collections.synchronizedMap(new HashMap());
    protected Map listenerListLookup = new HashMap();
    protected boolean disposed = false;
    protected Set timers = new HashSet();
    protected boolean overrideReload = false;
    protected long overrideReloadInterval = 0L;
    protected boolean processFarFiles = false;
    protected String specifiedWasPolicy = null;
    protected boolean specifiedLibraryDelegation;
    protected ClassLoader warParent = null;
    protected ClassGraphState classGraphState = null;
    private static boolean singleServerClassLoader = false;
    protected boolean singleWarClassLoader = false;
    private static boolean defaultDelegationMode = true;
    protected static JarClassLoader serverClassLoader = null;

    public static void setSingleServerClassLoader(boolean single) {
        singleServerClassLoader = single;
    }

    public static boolean getSingleServerClassLoader() {
        return singleServerClassLoader;
    }

    public static void setDefaultDelegationMode(boolean defaultDelegationMode) {
        ClassLoaderManager.defaultDelegationMode = defaultDelegationMode;
    }

    public static boolean getDefaultDelegationMode() {
        return defaultDelegationMode;
    }

    public ClassLoaderManager(ClassLoader parent, EARFile earFile, boolean singleWarClassLoader, Map sharedLibClassPathMap, Map sharedLibNativeLibPathMap, boolean libraryDelegation, String wasPolicy, boolean overrideReload, long overrideReloadInterval, boolean processFarFiles) {
        this(parent, earFile, singleWarClassLoader, sharedLibClassPathMap, sharedLibNativeLibPathMap, new HashMap(), libraryDelegation, wasPolicy, overrideReload, overrideReloadInterval, processFarFiles);
    }

    public ClassLoaderManager(ClassLoader parent, EARFile earFile, boolean singleWarClassLoader, Map sharedLibClassPathMap, Map sharedLibNativeLibPathMap, Map libraryClassLoaderMap, boolean libraryDelegation, String wasPolicy, boolean overrideReload, long overrideReloadInterval, boolean processFarFiles) {
        this(parent, earFile, singleWarClassLoader, new HashMap(), sharedLibClassPathMap, sharedLibNativeLibPathMap, libraryClassLoaderMap, libraryDelegation, wasPolicy, overrideReload, overrideReloadInterval, processFarFiles);
    }

    public ClassLoaderManager(ClassLoader parent, EARFile earFile, boolean singleWarClassLoader, Map localClassPathMap, Map sharedLibClassPathMap, Map sharedLibNativeLibPathMap, Map libraryClassLoaderMap, boolean libraryDelegation, String wasPolicy, boolean overrideReload, long overrideReloadInterval, boolean processFarFiles) {
        this.overrideReload = overrideReload;
        this.overrideReloadInterval = overrideReloadInterval;
        this.processFarFiles = processFarFiles;
        this.specifiedLibraryDelegation = libraryDelegation;
        this.specifiedWasPolicy = wasPolicy;
        this.initialize(parent, earFile, singleWarClassLoader, localClassPathMap, sharedLibClassPathMap, sharedLibNativeLibPathMap, libraryClassLoaderMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize(ClassLoader parent, EARFile earFile, boolean singleWarClassLoader, Map localClassPathMap, Map sharedLibClassPathMap, Map sharedLibNativeLibPathMap, Map libraryClassLoaderMap) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        this.parent = parent;
        this.earFile = earFile;
        this.singleWarClassLoader = singleWarClassLoader;
        if (singleServerClassLoader) {
            ClassLoader classLoader = parent;
            synchronized (classLoader) {
                if (serverClassLoader == null) {
                    serverClassLoader = new SingleServerClassLoader(parent, defaultDelegationMode);
                    serverClassLoader.setName("app");
                }
            }
        }
        ClassGraph classGraph = new ClassGraph(parent, localClassPathMap, sharedLibClassPathMap, sharedLibNativeLibPathMap, libraryClassLoaderMap, this.specifiedLibraryDelegation, singleWarClassLoader);
        for (ModuleRef mr : earFile.getModuleRefs()) {
            classGraph.addModule(mr);
        }
        if (this.processFarFiles) {
            this.processFARFiles(earFile, classGraph);
        }
        this.warParent = classGraph.calculate(earFile, this.specifiedWasPolicy);
        this.classGraphState = classGraph.getState();
        for (ModuleRef mr : earFile.getModuleRefs()) {
            ReloadableClassLoader cl = classGraph.lookupClassLoader(mr);
            if (cl == null) continue;
            this.moduleClassLoaderLookup.put(mr, cl);
            if (cl != serverClassLoader) {
                this.createTimer(mr);
            }
            ClassLoaderDump.addModule(mr.getUri(), cl);
        }
        this.applicationClassLoader = classGraph.lookupClassLoader(null);
        this.moduleClassLoaderLookup.put(null, this.applicationClassLoader);
        this.createTimer(null);
        ClassLoaderDump.addApplication(earFile.getURI(), this.applicationClassLoader);
        classGraph.dispose();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "ClassLoaderManager");
        }
    }

    public void addNewModule(ModuleRef moduleRef) {
        ClassGraph classGraph = new ClassGraph(this.classGraphState);
        classGraph.addModule(moduleRef);
        classGraph.updateClassLoaders((EARFile)moduleRef.getEarFile(), this.specifiedWasPolicy, this.warParent);
        ReloadableClassLoader cl = classGraph.lookupClassLoader(moduleRef);
        String moduleRefUri = moduleRef != null ? moduleRef.getUri() : null;
        Iterator it = null;
        ModuleRef currModuleRef = null;
        Object obj2 = null;
        if (cl != null) {
            for (Object obj2 : this.moduleClassLoaderLookup.keySet()) {
                if (obj2 == null || !(currModuleRef = (ModuleRef)obj2).getUri().equals(moduleRefUri)) continue;
                this.moduleClassLoaderLookup.remove(currModuleRef);
                break;
            }
            this.moduleClassLoaderLookup.put(moduleRef, cl);
            if (cl != serverClassLoader) {
                this.createTimer(moduleRef);
            }
            ClassLoaderDump.addModule(moduleRef.getUri(), cl);
        }
        it = this.listenerListLookup.keySet().iterator();
        Vector listenerList = (Vector)this.listenerListLookup.get(null);
        while (it.hasNext()) {
            obj2 = it.next();
            if (obj2 == null || !(currModuleRef = (ModuleRef)obj2).getUri().equals(moduleRefUri)) continue;
            listenerList = (Vector)this.listenerListLookup.get(currModuleRef);
            this.listenerListLookup.remove(currModuleRef);
            break;
        }
        this.listenerListLookup.put(moduleRef, listenerList);
    }

    protected void processFARFiles(EARFile earFile, ClassGraph classGraph) {
        List farfiles = earFile.getFARFiles();
        ArrayList<String> farPaths = new ArrayList<String>();
        int n = farfiles.size();
        for (int i = 0; i < n; ++i) {
            Archive m = (Archive)farfiles.get(i);
            RuntimeClasspathEntry[] rcpe = m.getLocalRuntimeClassPath();
            for (int j = 0; j < rcpe.length; ++j) {
                farPaths.add(rcpe[j].getAbsolutePath());
            }
            RuntimeClasspathEntry[] dcpe = m.getDependencyClassPath();
            for (int j = 0; j < dcpe.length; ++j) {
                farPaths.add(dcpe[j].getAbsolutePath());
            }
        }
        if (farPaths.size() > 0) {
            String[] paths = farPaths.toArray(new String[farPaths.size()]);
            classGraph.addUtilityJars(paths);
        }
    }

    public void dispose() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "dispose " + this.earFile.getURI());
        }
        this.disposed = true;
        this.cancelAllTimers();
        this.parent = null;
        this.earFile = null;
        if (this.applicationClassLoader != serverClassLoader) {
            ClassLoaderDump.removeClassLoader(this.applicationClassLoader);
            this.applicationClassLoader.dispose(false);
        }
        this.classGraphState.dispose(serverClassLoader);
        this.moduleClassLoaderLookup.clear();
        this.listenerListLookup.clear();
        this.applicationClassLoader = null;
    }

    public ReloadableClassLoader lookupClassLoader(ModuleRef moduleRef) {
        ReloadableClassLoader classLoader = (ReloadableClassLoader)this.moduleClassLoaderLookup.get(moduleRef);
        return classLoader;
    }

    public void removeClassLoader(ModuleRef moduleRef) {
        ReloadableClassLoader classLoader = (ReloadableClassLoader)this.moduleClassLoaderLookup.remove(moduleRef);
        if (classLoader != null && classLoader != this.applicationClassLoader) {
            classLoader.setRemoved(true);
            ClassLoaderDump.removeClassLoader(classLoader);
            classLoader.dispose(false);
            this.cancelTimer(moduleRef);
        }
    }

    public ClassLoader getApplicationClassLoader() {
        return this.applicationClassLoader;
    }

    public void setDelegationMode(ModuleRef moduleRef, boolean delegationMode) {
        ReloadableClassLoader classLoader;
        if (!this.singleWarClassLoader && (classLoader = (ReloadableClassLoader)this.moduleClassLoaderLookup.get(moduleRef)) != null && classLoader != serverClassLoader) {
            classLoader.setDelegationMode(delegationMode);
        }
    }

    public void addClassLoaderListener(ClassLoaderListener listener, ModuleRef moduleRef) {
        Vector<ClassLoaderListener> listenerList;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addClassLoaderListener", new Object[]{listener, moduleRef != null ? moduleRef.getUri() : "appClassLoader"});
        }
        if ((listenerList = (Vector<ClassLoaderListener>)this.listenerListLookup.get(moduleRef)) == null) {
            listenerList = new Vector<ClassLoaderListener>();
            this.listenerListLookup.put(moduleRef, listenerList);
        }
        listenerList.addElement(listener);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addClassLoaderListener");
        }
    }

    public void removeClassLoaderListener(ClassLoaderListener listener, ModuleRef moduleRef) {
        Vector listenerList;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "removeClassLoaderListener", moduleRef.getUri());
        }
        if ((listenerList = (Vector)this.listenerListLookup.get(moduleRef)) != null) {
            listenerList.removeElement(listener);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeClassLoaderListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "reload");
        }
        Map map = this.moduleClassLoaderLookup;
        synchronized (map) {
            for (ReloadableClassLoader classLoader : this.moduleClassLoaderLookup.values()) {
                if (classLoader == serverClassLoader) continue;
                classLoader.reload();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "reload");
        }
    }

    public void reloadClassLoader(ModuleRef moduleRef) {
        ReloadableClassLoader classLoader;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "reloadClassLoader");
        }
        if ((classLoader = (ReloadableClassLoader)this.moduleClassLoaderLookup.get(moduleRef)) != null && classLoader != serverClassLoader) {
            classLoader.reload();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "reloadClassLoader");
        }
    }

    public void createTimer(ModuleRef moduleRef) {
        long reloadInterval = 0L;
        if (this.overrideReload) {
            reloadInterval = this.overrideReloadInterval * 1000L;
        } else if (moduleRef != null && moduleRef.isWeb()) {
            WebAppExtension extension2 = null;
            try {
                extension2 = (WebAppExtension)moduleRef.getExtensions();
            }
            catch (Exception ex) {
                Manager.Ffdc.log(ex, this, "com.ibm.ws.classloader.ClassLoaderManager.createTimer", "278", this);
                Tr.error(tc, "Error loading web application extension {0}", ex);
            }
            if (extension2 != null && extension2.isReloadingEnabled()) {
                reloadInterval = extension2.getReloadInterval() * 1000;
            }
        } else {
            reloadInterval = this.earFile.getExtensions().getReloadInterval() * 1000L;
        }
        if (reloadInterval > 0L) {
            ReloadableClassLoader rcl = null;
            rcl = (ReloadableClassLoader)this.moduleClassLoaderLookup.get(moduleRef);
            if (rcl != serverClassLoader) {
                rcl.enableReloading();
                ReloadTimerTask rtt = new ReloadTimerTask(moduleRef, reloadInterval);
                rtt.alarm = AlarmManager.createDeferrable(reloadInterval, rtt);
                this.timers.add(rtt);
            }
        }
    }

    public synchronized void cancelTimer(ModuleRef moduleRef) {
        for (ReloadTimerTask rtt : this.timers) {
            if (rtt.moduleRef != moduleRef || rtt.alarm == null) continue;
            rtt.alarm.cancel();
            this.timers.remove(rtt);
            return;
        }
    }

    public void cancelAllTimers() {
        for (ReloadTimerTask rtt : this.timers) {
            if (rtt.alarm == null) continue;
            rtt.alarm.cancel();
        }
        this.timers.clear();
    }

    private boolean checkAndNotify(ReloadableClassLoader classLoader, ModuleRef moduleRef) {
        boolean isUpdatedAndNotified = false;
        if (classLoader.checkForUpdate()) {
            Vector listeners;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "class has chanaged");
            }
            if ((listeners = (Vector)this.listenerListLookup.get(moduleRef)) != null) {
                for (int i = 0; i < listeners.size(); ++i) {
                    ClassLoaderListener listener = (ClassLoaderListener)listeners.elementAt(i);
                    listener.classChanged(moduleRef);
                }
                isUpdatedAndNotified = !this.moduleClassLoaderLookup.containsKey(moduleRef);
            }
        }
        return isUpdatedAndNotified;
    }

    private class ReloadTimerTask
    implements AlarmListener {
        public ModuleRef moduleRef;
        public long reloadInterval;
        Alarm alarm;

        public ReloadTimerTask(ModuleRef moduleRef, long reloadInterval) {
            this.moduleRef = moduleRef;
            this.reloadInterval = reloadInterval;
        }

        public void alarm(Object arg0) {
            boolean isUpdatedAndNotified;
            ReloadableClassLoader classLoader;
            if (!ClassLoaderManager.this.disposed && (classLoader = (ReloadableClassLoader)ClassLoaderManager.this.moduleClassLoaderLookup.get(this.moduleRef)) != null && !(isUpdatedAndNotified = ClassLoaderManager.this.checkAndNotify(classLoader, this.moduleRef))) {
                this.alarm = AlarmManager.createDeferrable(this.reloadInterval, this);
            }
        }
    }
}

