/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.client;

import com.ibm.CORBA.iiop.ExtendedClientRequestInfo;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.JTS.TaskIdPropagationData;
import com.ibm.ws.Transaction.JTS.TaskIdPropagationDataHelper;
import com.ibm.ws.Transaction.JTS.TxInterceptorHelper;
import com.ibm.ws.Transaction.client.NonRecoverableTranManagerSet;
import com.ibm.ws.Transaction.client.NonRecoverableTransactionImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.util.WSThreadLocal;
import org.omg.CORBA.Any;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.TRANSACTION_REQUIRED;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.Terminator;
import org.omg.CosTransactions.TransIdentity;
import org.omg.CosTransactions.otid_t;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;

public final class NonRecoverableClientInterceptor
extends LocalObject
implements ClientRequestInterceptor {
    private static final TraceComponent tc = Tr.register(NonRecoverableClientInterceptor.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static WSThreadLocal _contextTable = new WSThreadLocal();
    private static final NonRecoverableClientInterceptor _instance = new NonRecoverableClientInterceptor();
    private static final PlatformHelper ph = PlatformHelperFactory.getPlatformHelper();
    private static otid_t _deferredBeginOtid = new otid_t(1463898947, 0, new byte[0]);

    private NonRecoverableClientInterceptor() {
    }

    public static NonRecoverableClientInterceptor instance() {
        return _instance;
    }

    public void receive_exception(ClientRequestInfo info) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "receive_exception", info);
        }
        NonRecoverableClientInterceptor.getContextTable().set(null);
        this.receive_reply(info);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "receive_exception");
        }
    }

    public static byte[] send_request(String operation) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "send_request", operation);
        }
        ORB orb = ph.getGlobalORB();
        byte[] marshaledContext = _instance.send_request(operation, orb);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "send_request", marshaledContext);
        }
        return marshaledContext;
    }

    public void send_request(ClientRequestInfo info) {
        byte[] marshaledContext;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "send_request", info);
        }
        if ((marshaledContext = this.send_request(info.operation(), (ORB)((LocalObject)info)._orb())) != null) {
            ServiceContext serviceContext = new ServiceContext(0, marshaledContext);
            info.add_request_service_context(serviceContext, true);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "send_request");
        }
    }

    private byte[] send_request(String operation, ORB orb) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "send_request", new Object[]{operation, orb});
        }
        byte[] marshaledContext = null;
        if (TxInterceptorHelper.isTransactional(operation)) {
            NonRecoverableTransactionImpl transaction = null;
            try {
                transaction = (NonRecoverableTransactionImpl)NonRecoverableTranManagerSet.instance().getTransaction();
                if (transaction != null) {
                    int status = transaction.getStatus();
                    if (status == 3 || status == 4) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "send_request");
                        }
                        throw new TRANSACTION_REQUIRED();
                    }
                    if (status == 1) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "send_request");
                        }
                        throw new TRANSACTION_ROLLEDBACK();
                    }
                    PropagationContext propagationContext = (PropagationContext)NonRecoverableClientInterceptor.getContextTable().get();
                    if (propagationContext == null) {
                        long expirationTime = transaction.getExpirationTime();
                        int timeout = 0;
                        if (expirationTime > 0L && (timeout = (int)((expirationTime - System.currentTimeMillis()) / 1000L)) <= 0) {
                            transaction.setRollbackOnly();
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "send_request");
                            }
                            throw new TRANSACTION_ROLLEDBACK();
                        }
                        TransIdentity current = null;
                        Any any = orb.create_any();
                        Terminator terminator = transaction.getTerminator();
                        if (terminator == null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "First remote request. Sending deferred begin context");
                            }
                            current = new TransIdentity(null, null, _deferredBeginOtid);
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Transaction has already gone remote. Sending interop context");
                            }
                            current = new TransIdentity(transaction.getCoordinator(), terminator, transaction.getOtid());
                        }
                        String taskId = transaction.getTaskId();
                        if (taskId != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Non-null taskId. Propagating in ISD", taskId);
                            }
                            TaskIdPropagationData taskIdPropagationData = new TaskIdPropagationData(taskId);
                            TaskIdPropagationDataHelper.insert(any, taskIdPropagationData);
                        }
                        propagationContext = new PropagationContext(timeout, current, new TransIdentity[0], any);
                    }
                    _contextTable.set(propagationContext);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Marshalling transaction context", propagationContext);
                    }
                    marshaledContext = TxInterceptorHelper.marshalContext(propagationContext, orb);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No transaction active on thread.");
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.Transaction.client.NonRecoverableClientInterceptor.send_request", "238", (Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Exception encountered marshaling context and adding it to the request", e);
                }
                if (transaction != null) {
                    transaction.setRollbackOnly();
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "send_request");
                }
                throw new TRANSACTION_ROLLEDBACK();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "send_request", marshaledContext);
        }
        return marshaledContext;
    }

    public void send_poll(ClientRequestInfo info) {
    }

    public static void receive_reply(String operation, byte[] contextData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "receive_reply", new Object[]{operation, contextData});
        }
        ORB orb = ph.getGlobalORB();
        _instance.receive_reply(operation, contextData, orb);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "receive_reply");
        }
    }

    public void receive_reply(ClientRequestInfo info) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "receive_reply", info);
        }
        ServiceContext serviceContext = null;
        serviceContext = ((ExtendedClientRequestInfo)info).getReplyServiceContext(0);
        byte[] contextData = null;
        if (serviceContext != null) {
            contextData = serviceContext.context_data;
        }
        this.receive_reply(info.operation(), contextData, (ORB)((LocalObject)info)._orb());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "receive_reply");
        }
    }

    private void receive_reply(String operation, byte[] serviceContextData, ORB orb) {
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "receive_reply", new Object[]{operation, serviceContextData, orb});
            }
            NonRecoverableTransactionImpl transaction = null;
            if (TxInterceptorHelper.isTransactional(operation)) {
                try {
                    transaction = (NonRecoverableTransactionImpl)NonRecoverableTranManagerSet.instance().getTransaction();
                    if (transaction == null) break block11;
                    if (serviceContextData != null) {
                        _contextTable.set(null);
                        if (transaction.getTerminator() == null) {
                            PropagationContext propagationContext = TxInterceptorHelper.demarshalContext(serviceContextData, orb);
                            transaction.setTerminator(propagationContext.current.term);
                            transaction.setCoordinator(propagationContext.current.coord);
                            transaction.setOtid(propagationContext.current.otid);
                        }
                        break block11;
                    }
                    transaction.setRollbackOnly();
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "receive_reply");
                    }
                    throw new TRANSACTION_ROLLEDBACK();
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.Transaction.client.NonRecoverableClientInterceptor.receive_reply", "351", (Object)this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Exception encountered processing reply", e);
                    }
                    if (transaction != null) {
                        transaction.setRollbackOnly();
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "receive_reply");
                    }
                    throw new TRANSACTION_ROLLEDBACK();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "receive_reply");
        }
    }

    public void receive_other(ClientRequestInfo info) {
    }

    public String name() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void destroy() {
    }

    private static final WSThreadLocal getContextTable() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getContextTable");
        }
        if (_contextTable == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Null context table. Creating");
            }
            _contextTable = new WSThreadLocal();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getContextTable", _contextTable);
        }
        return _contextTable;
    }
}

