/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.security.auth.callback;

import com.ibm.ISecurityL13SupportImpl.LoginPanel;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.auth.callback.WSRealmNameCallbackImpl;
import com.ibm.ws.security.auth.WSLoginHelperImpl;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.swing.JFrame;

public class WSGUICallbackHandlerImpl
implements CallbackHandler {
    private static int stdinRetry = 0;
    private String userName = "";
    private String password = "";
    private String realmName = "";
    private String krbRealmName = "";
    private String userNamePrompt = "";
    private String passwordPrompt = "";
    private boolean passwordEcho = false;
    private int result = 0;
    private static final TraceComponent tc = Tr.register(WSGUICallbackHandlerImpl.class, null, "com.ibm.ejs.resources.security");

    public WSGUICallbackHandlerImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSGUICallbackHandlerImpl()");
        }
        this.realmName = WSLoginHelperImpl.getDefaultRealmName();
        if (this.realmName == null || this.realmName.length() == 0) {
            this.realmName = "<default>";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSGUICallbackHandlerImpl() " + this.realmName);
        }
    }

    public WSGUICallbackHandlerImpl(String r_name) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSGUICallbackHandlerImpl(r_name) " + r_name);
        }
        if (r_name != null && r_name.length() != 0) {
            this.realmName = r_name;
        } else {
            this.realmName = WSLoginHelperImpl.getDefaultRealmName();
            if (this.realmName == null || this.realmName.length() == 0) {
                this.realmName = "<default>";
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Realm Name: " + this.realmName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSGUICallbackHandlerImpl(realmName)");
        }
    }

    public WSGUICallbackHandlerImpl(String r_name, String t_input) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSGUICallbackHandlerImpl(String, String)", new Object[]{"Default realm: " + r_name});
        }
        if (r_name != null && r_name.length() != 0) {
            this.realmName = r_name;
        } else {
            this.realmName = WSLoginHelperImpl.getDefaultRealmName();
            if (this.realmName == null || this.realmName.length() == 0) {
                this.realmName = "<default>";
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Realm Name: " + this.realmName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSGUICallbackHandlerImpl(String, String)");
        }
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handle");
        }
        int len = 0;
        if (callbacks == null || (len = callbacks.length) == 0) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "handle(callbacks = \"{ }\")");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handle(callbacks)");
            }
            return;
        }
        if (this.userName == null || this.userName.length() == 0 || this.password == null || this.password.length() == 0) {
            if (tc.isEntryEnabled()) {
                StringBuffer sb = new StringBuffer();
                sb.append("{ ");
                for (int i = 0; i < len; ++i) {
                    sb.append(callbacks[i].getClass().getName());
                    if (i >= len - 1) continue;
                    sb.append(", ");
                }
                sb.append(" }");
                Tr.entry(tc, "handle(callbacks = \"" + sb.toString() + "\")");
            }
            boolean done = false;
            int retries = 0;
            for (int i = 0; i < len; ++i) {
                Callback c = callbacks[i];
                if (c instanceof NameCallback) {
                    this.userNamePrompt = ((NameCallback)c).getPrompt();
                    this.userName = ((NameCallback)c).getDefaultName();
                    continue;
                }
                if (c instanceof PasswordCallback) {
                    this.passwordPrompt = ((PasswordCallback)c).getPrompt();
                    this.passwordEcho = ((PasswordCallback)c).isEchoOn();
                    continue;
                }
                if (!(c instanceof WSRealmNameCallbackImpl) || this.realmName != null && this.realmName.length() != 0) continue;
                this.realmName = ((WSRealmNameCallbackImpl)c).getRealmName();
                if (this.realmName != null && !this.realmName.equals("")) continue;
                this.realmName = ((WSRealmNameCallbackImpl)c).getDefaultRealmName();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Realm Name: " + this.realmName);
            }
            LoginPanel lgpanel = null;
            JFrame tmpFrame = null;
            while (!done) {
                tmpFrame = new JFrame();
                lgpanel = new LoginPanel(this.userName, this.realmName, "", tmpFrame);
                this.result = lgpanel.showPanel();
                if (this.result == 2) {
                    String sn = lgpanel.getId();
                    if (sn != null && sn.length() > 0) {
                        this.userName = new String(sn.trim());
                        if (this.userName != null && this.userName.length() > 0) {
                            String pw = lgpanel.getPassword();
                            this.password = pw != null && pw.length() > 0 ? new String(pw) : "";
                            lgpanel.dispose();
                            lgpanel = null;
                            tmpFrame.dispose();
                            tmpFrame = null;
                            done = true;
                        } else {
                            this.userName = "";
                            this.password = "";
                        }
                    } else {
                        this.userName = "";
                        this.password = "";
                    }
                    if (!done) {
                        lgpanel.dispose();
                        lgpanel = null;
                        tmpFrame.dispose();
                        tmpFrame = null;
                        if (retries < 1) {
                            ++retries;
                        } else {
                            done = true;
                        }
                    }
                } else {
                    lgpanel.dispose();
                    lgpanel = null;
                    tmpFrame.dispose();
                    tmpFrame = null;
                    this.userName = null;
                    this.password = null;
                    done = true;
                }
                if (tmpFrame == null) continue;
                tmpFrame.dispose();
                tmpFrame = null;
            }
        }
        for (int i = 0; i < len; ++i) {
            Callback c = callbacks[i];
            if (c instanceof NameCallback) {
                ((NameCallback)c).setName(this.userName);
                continue;
            }
            if (c instanceof PasswordCallback) {
                ((PasswordCallback)c).setPassword(this.password == null ? new char[]{} : this.password.toCharArray());
                continue;
            }
            if (c instanceof WSRealmNameCallbackImpl) {
                ((WSRealmNameCallbackImpl)c).setRealmName(this.realmName);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Un-use handle(callbacks = \"" + callbacks[i].getClass().getName() + "\")");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handle(callbacks)");
        }
    }
}

