/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.security.auth.callback;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import javax.security.auth.callback.Callback;

public class WSAuthMechOidCallbackImpl
implements Callback {
    private static final TraceComponent tc = Tr.register(WSAuthMechOidCallbackImpl.class);
    private SecurityConfig _security = SecurityObjectLocator.getSecurityConfig();
    private String _defaultAuthMechOid;
    private String _authMechOid;
    private String _prompt;

    public WSAuthMechOidCallbackImpl(String prompt) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSAuthMechOidCallbackImpl(prompt = \"" + prompt + "\")");
        }
        this._prompt = prompt;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSAuthMechOidCallbackImpl(prompt)");
        }
    }

    public WSAuthMechOidCallbackImpl(String prompt, String authMechOid) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSAuthMechOidCallbackImpl(prompt = \"" + prompt + "\", authMechOid = \"" + authMechOid + "\")");
        }
        this._prompt = prompt;
        this._authMechOid = authMechOid == null || authMechOid.length() == 0 ? this.getdefaultAuthMechOid() : authMechOid;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSAuthMechOidCallbackImpl(prompt, authMechOid)");
        }
    }

    public void setAuthMechOid(String authMechOid) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAuthMechOid(oid = \"" + authMechOid + "\")");
        }
        this._authMechOid = authMechOid == null || authMechOid.length() == 0 ? this.getdefaultAuthMechOid() : authMechOid;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAuthMechOid(authMechOid)");
        }
    }

    public String getAuthMechOid() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuthMechOid()");
        }
        if (this._authMechOid == null || this._authMechOid.equals("")) {
            this._authMechOid = this.getdefaultAuthMechOid();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAuthMechOid() -> " + this._authMechOid);
        }
        return this._authMechOid;
    }

    public String getdefaultAuthMechOid() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getdefaultAuthMechOid()");
        }
        if (this._defaultAuthMechOid == null || this._defaultAuthMechOid.equals("")) {
            this._defaultAuthMechOid = this._security.getActiveAuthMechanism().getString("OID");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getdefaultAuthMechOid() -> " + this._defaultAuthMechOid);
        }
        return this._defaultAuthMechOid;
    }

    public String getPrompt() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPrompt()");
            Tr.exit(tc, "getPrompt() -> " + this._prompt);
        }
        return this._prompt;
    }

    public String toString() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "toString()");
            Tr.exit(tc, "toString() -> " + this.getClass().getName());
        }
        return this.getClass().getName();
    }
}

