/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.security.auth.callback;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.auth.callback.WSRealmNameCallbackImpl;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class NonPromptCallbackHandler
implements CallbackHandler {
    private static final TraceComponent tc = Tr.register(NonPromptCallbackHandler.class, null, "com.ibm.ejs.resources.security");
    private String _realm = "";
    private String _username = "";
    private String _password = null;

    public NonPromptCallbackHandler() {
    }

    public NonPromptCallbackHandler(String realmName, String userid, String password) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "NonPromptCallbackHandler(String, String, String, String)", new Object[]{"Default realm: " + realmName + " user: " + userid});
        }
        this._realm = realmName;
        this._username = userid;
        this._password = password;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "NonPromptCallbackHandler(String, String, String, String)");
        }
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handle(Callback[] callbacks)");
        }
        int len = 0;
        if (callbacks == null || (len = callbacks.length) == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "handle(callbacks = \"{ }\")");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handle(Callback[] callbacks)");
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("{ ");
            for (int i = 0; i < len; ++i) {
                sb.append(callbacks[i].getClass().getName());
                if (i >= len - 1) continue;
                sb.append(", ");
            }
            sb.append(" }");
            Tr.debug(tc, "handle(callbacks = \"" + sb.toString() + "\")");
        }
        for (int i = 0; i < len; ++i) {
            Callback c = callbacks[i];
            if (c instanceof NameCallback) {
                ((NameCallback)c).setName(this._username);
                continue;
            }
            if (c instanceof PasswordCallback) {
                ((PasswordCallback)c).setPassword(this._password == null ? new char[]{} : this._password.toCharArray());
                continue;
            }
            if (c instanceof WSRealmNameCallbackImpl) {
                ((WSRealmNameCallbackImpl)c).setRealmName(this._realm);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Un-use handle(callbacks = \"" + callbacks[i].getClass().getName() + "\")");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handle(Callback[] callbacks)");
        }
    }
}

