/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product.xml;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;

public abstract class BaseWriter {
    public static final String pgmVersion = "1.5";
    public static final String pgmUpdate = "8/8/08";
    protected Exception boundException;
    public static final String DEFAULT_ENCODING = "UTF8";
    protected String encoding;
    protected String encodingTag;
    protected String docTypeString;
    protected String outputFileName;
    protected FileOutputStream outputStream;
    protected PrintWriter outputWriter;
    protected static final int INDENT_WIDTH = 80;
    protected static final String indentLine = "                                                                                ";
    public static final int INDENT_GAP = 2;
    protected int indent;
    public static final boolean IS_COMPLETE = true;
    public static final boolean IS_INCOMPLETE = false;
    public static final int MAX_TEXT_WITH_ELEMENT = 40;
    protected static final boolean CLOSE_WHOLLY = true;
    protected static final boolean CLOSE_PARTIALLY = false;

    public Exception getBoundException() {
        return this.boundException;
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public void print(String text) {
        this.outputWriter.print(text);
    }

    public void println() {
        this.outputWriter.println();
    }

    public void println(String text) {
        this.outputWriter.println(text);
    }

    public void flush() {
        this.outputWriter.flush();
    }

    public void openWriter(String encoding, String encodingTag, String docTypeString, String outputFileName) throws FileNotFoundException, UnsupportedEncodingException {
        this.encoding = encoding;
        this.encodingTag = encodingTag;
        this.docTypeString = docTypeString;
        this.outputFileName = outputFileName;
        this.outputStream = new FileOutputStream(outputFileName);
        String useEncoding = encoding == null ? DEFAULT_ENCODING : encoding;
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)this.outputStream, useEncoding);
        this.outputWriter = new PrintWriter(new BufferedWriter(writer));
        this.indent = 0;
    }

    public void closeWriter() throws IOException {
        this.outputWriter.flush();
        this.outputWriter = null;
        FileOutputStream useOutputStream = this.outputStream;
        this.outputStream = null;
        ((OutputStream)useOutputStream).close();
    }

    public void indentIn() {
        this.indent += 2;
    }

    public void indentOut() {
        this.indent -= 2;
    }

    public void printIndent() {
        int remainingIndent;
        for (remainingIndent = this.indent; remainingIndent >= 80; remainingIndent -= 80) {
            this.print(indentLine);
        }
        if (remainingIndent > 0) {
            this.print(indentLine.substring(0, remainingIndent));
        }
    }

    public void beginDocument() {
        if (this.encodingTag != null && !this.encodingTag.equals("")) {
            this.println("<?xml version=\"1.0\" encoding=\"" + this.encodingTag + "\"?>");
        }
        if (this.docTypeString != null && !this.docTypeString.equals("")) {
            this.println(this.docTypeString);
        }
    }

    public void emitElement(String elementName, Iterator attributes, boolean isComplete) {
        this.printIndent();
        this.beginElementOpening(elementName);
        while (attributes.hasNext()) {
            String[] attributeInfo = (String[])attributes.next();
            String attributeName = attributeInfo[0];
            String attributeValue = attributeInfo[1];
            if (attributeValue == null) continue;
            this.print(" ");
            this.emitAttribute(attributeName, attributeValue);
        }
        this.endElementOpening(isComplete);
        this.println();
    }

    public void emitElement(String elementName, Iterator attributes, String elementText) {
        this.printIndent();
        this.beginElementOpening(elementName);
        while (attributes.hasNext()) {
            String[] attributeInfo = (String[])attributes.next();
            String attributeName = attributeInfo[0];
            String attributeValue = attributeInfo[1];
            if (attributeValue == null) continue;
            this.print(" ");
            this.emitAttribute(attributeName, attributeValue);
        }
        this.endElementOpening(false);
        this.println();
        this.indentIn();
        this.println(elementText);
        this.indentOut();
        this.printIndent();
        this.emitElementClosure(elementText);
        this.println();
    }

    public void emitAttributeOnLine(String attributeName, String attributeValue) {
        if (attributeValue != null) {
            this.printIndent();
            this.emitAttribute(attributeName, attributeValue);
            this.println();
        }
    }

    public void emitElement(String elementName, String elementText) {
        this.printIndent();
        this.beginElementOpening(elementName);
        this.endElementOpening(false);
        elementText = this.normalize(elementText);
        if (elementText.length() > 40) {
            this.println();
            this.indentIn();
            this.printIndent();
            this.println(elementText);
            this.indentOut();
            this.printIndent();
        } else {
            this.print(elementText);
        }
        this.emitElementClosure(elementName);
        this.println();
    }

    public void beginElementOpening(String elementName) {
        this.print("<" + elementName);
    }

    public void endElementOpening(boolean completeClosure) {
        if (completeClosure) {
            this.print("/>");
        } else {
            this.print(">");
        }
    }

    public void emitElementClosure(String elementName) {
        this.print("</" + elementName + ">");
    }

    public void emitAttribute(String attributeName, String attributeValue) {
        if (attributeValue == null) {
            attributeValue = "";
        }
        attributeValue = BaseWriter.formatToXMLCompatibleData(attributeValue);
        this.print(attributeName + "=\"" + attributeValue + "\"");
    }

    private static String formatToXMLCompatibleData(String text) {
        if (text == null || text.trim().equalsIgnoreCase("")) {
            return new String("");
        }
        String temp1 = BaseWriter.replaceAll(text, "&", "&amp;");
        String temp2 = BaseWriter.replaceAll(temp1, "<", "&lt;");
        String temp3 = BaseWriter.replaceAll(temp2, ">", "&gt;");
        String temp4 = BaseWriter.replaceAll(temp3, "'", "&apos;");
        String newStr = BaseWriter.replaceAll(temp4, "\"", "&quot;");
        return newStr;
    }

    private static final String replaceAll(String source, String pattern, String replacement) {
        if (source == null) {
            return null;
        }
        if (pattern == null) {
            pattern = "";
        }
        if (replacement == null) {
            replacement = "";
        }
        int pos = source.indexOf(pattern);
        while (pos != -1) {
            source = source.substring(0, pos) + replacement + source.substring(pos + pattern.length());
            pos = source.indexOf(pattern, pos + replacement.length());
        }
        return source;
    }

    public String normalize(String text) {
        if (text == null) {
            return "";
        }
        text = text.trim();
        int numChars = text.length();
        StringBuffer normalizedText = new StringBuffer();
        for (int charNo = 0; charNo < numChars; ++charNo) {
            char nextChar = text.charAt(charNo);
            if (nextChar == '<') {
                normalizedText.append("&lt;");
                continue;
            }
            if (nextChar == '>') {
                normalizedText.append("&gt;");
                continue;
            }
            if (nextChar == '&') {
                normalizedText.append("&amp;");
                continue;
            }
            if (nextChar == '\"') {
                normalizedText.append("&quot;");
                continue;
            }
            if (nextChar == '\r' || nextChar == '\n') continue;
            normalizedText.append(nextChar);
        }
        return normalizedText.toString();
    }

    public String getDefaultDocTypeString(List rootElements) {
        return null;
    }

    public void emit(List rootElements, String outputFileName) {
        this.emit(rootElements, null, null, null, outputFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emit(List rootElements, String encoding, String encodingTag, String docTypeString, String outputFileName) {
        if (docTypeString == null) {
            docTypeString = this.getDefaultDocTypeString(rootElements);
        }
        this.boundException = null;
        try {
            this.openWriter(encoding, encodingTag, docTypeString, outputFileName);
        }
        catch (FileNotFoundException e) {
            this.boundException = e;
        }
        catch (UnsupportedEncodingException e) {
            this.boundException = e;
        }
        if (this.boundException != null) {
            return;
        }
        try {
            this.baseEmit(rootElements);
        }
        finally {
            try {
                this.closeWriter();
            }
            catch (IOException e) {
                this.boundException = e;
            }
        }
    }

    public abstract void baseEmit(List var1);
}

