/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product.xml;

import com.ibm.websphere.product.xml.BaseHandlerException;
import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class BaseHandler
extends DefaultHandler {
    public static final String pgmVersion = "1.3";
    public static final String pgmUpdate = "8/8/08";
    protected ArrayList rootElements;
    protected ArrayList elementNameTrain;
    protected ArrayList elementTrain;
    protected ArrayList captureFlagTrain;
    protected ArrayList captureTrain;
    protected String currentElementName;
    protected Object currentElement;
    protected boolean currentCaptureFlag;
    protected StringBuffer currentCaptureBuffer;
    protected Locator locator;

    public Object getObject() {
        return this.rootElements;
    }

    public void startDocument() throws SAXException {
        this.initializeElements();
    }

    public void endDocument() throws SAXException {
        if (this.elementNameTrain.size() != 0) {
            throw new SAXException(BaseHandler.getString("WVER0203E", new Object[0]));
        }
    }

    public void startElement(String documentUri, String elementName, String qualifiedName, Attributes attributes) throws SAXException {
        Object element;
        try {
            element = this.createElement(elementName, this.currentElementName, this.currentElement, attributes);
        }
        catch (Throwable th) {
            System.out.println("Throwable: " + th);
            th.printStackTrace(System.out);
            element = null;
        }
        this.pushElement(elementName, element);
    }

    public void endElement(String documentUri, String elementName, String qualifiedName) throws SAXException {
        this.popElement(elementName);
    }

    protected void startCapturing() {
        this.currentCaptureFlag = true;
    }

    protected String stopCapturing() {
        String result;
        if (!this.currentCaptureFlag) {
            result = "";
        } else {
            this.currentCaptureFlag = false;
            if (this.currentCaptureBuffer == null) {
                result = "";
            } else {
                result = this.currentCaptureBuffer.toString();
                this.currentCaptureBuffer.setLength(0);
            }
        }
        return result;
    }

    public void characters(char[] buffer, int offset, int length) throws SAXException {
        if (!this.currentCaptureFlag) {
            return;
        }
        if (this.currentCaptureBuffer == null) {
            this.currentCaptureBuffer = new StringBuffer();
            this.captureTrain.set(this.captureTrain.size() - 1, this.currentCaptureBuffer);
        }
        this.currentCaptureBuffer.append(buffer, offset, length);
    }

    protected abstract Object createElement(String var1, String var2, Object var3, Attributes var4) throws SAXParseException;

    protected String getAttribute(Attributes attributes, String attributeName, String elementName, String defaultValue) throws SAXParseException {
        String attributeValue = attributes.getValue(attributeName);
        if (attributeValue == null) {
            if (defaultValue == null) {
                throw this.newException("WVER0201E", new Object[]{attributeName, elementName});
            }
            return defaultValue;
        }
        return attributeValue;
    }

    protected String getCurrentElementName() {
        return this.currentElementName;
    }

    protected Object getCurrentElement() {
        return this.currentElement;
    }

    protected void initializeElements() {
        this.rootElements = new ArrayList();
        this.elementNameTrain = new ArrayList();
        this.elementTrain = new ArrayList();
        this.captureFlagTrain = new ArrayList();
        this.captureTrain = new ArrayList();
        this.currentElementName = null;
        this.currentElement = null;
        this.currentCaptureFlag = false;
        this.currentCaptureBuffer = null;
    }

    protected void pushElement(String elementName, Object element) {
        if (this.elementTrain.size() == 0) {
            this.rootElements.add(element);
        }
        this.elementNameTrain.add(elementName);
        this.elementTrain.add(element);
        this.captureFlagTrain.add(new Boolean(false));
        this.captureTrain.add(this.currentCaptureBuffer);
        this.currentElementName = elementName;
        this.currentElement = element;
        this.currentCaptureFlag = false;
        this.currentCaptureBuffer = null;
    }

    protected Object popElement(String elementName) throws SAXParseException {
        int trainLength = this.elementTrain.size();
        if (trainLength == 0) {
            throw this.newException("WVER0202E", new Object[0]);
        }
        int lastElementOffset = trainLength - 1;
        Object lastElement = this.elementTrain.get(lastElementOffset);
        String lastElementName = (String)this.elementNameTrain.get(lastElementOffset);
        if (!lastElementName.equals(elementName)) {
            throw this.newException("WVER0206E", new Object[]{elementName, lastElementName});
        }
        this.elementNameTrain.remove(lastElementOffset);
        this.elementTrain.remove(lastElementOffset);
        if (lastElementOffset == 0) {
            this.currentElementName = null;
            this.currentElement = null;
            this.currentCaptureFlag = false;
            this.currentCaptureBuffer = null;
        } else {
            this.currentElementName = (String)this.elementNameTrain.get(--lastElementOffset);
            this.currentElement = this.elementTrain.get(lastElementOffset);
            this.currentCaptureFlag = (Boolean)this.captureFlagTrain.get(lastElementOffset);
            this.currentCaptureBuffer = (StringBuffer)this.captureTrain.get(lastElementOffset);
        }
        return lastElement;
    }

    protected SAXParseException newInvalidElementException(String parentElementName, String childElementName) {
        if (parentElementName == null) {
            return this.newException("WVER0204E", new Object[]{childElementName});
        }
        return this.newException("WVER0205E", new Object[]{childElementName, parentElementName});
    }

    protected SAXParseException newException(String exceptionId, Object[] args) {
        return new SAXParseException(BaseHandler.getString(exceptionId, args), this.getDocumentLocator());
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public Locator getDocumentLocator() {
        return this.locator;
    }

    protected static String getString(String msgCode) {
        return BaseHandlerException.getString(msgCode);
    }

    protected static String getString(String msgCode, Object[] msgArgs) {
        return BaseHandlerException.getString(msgCode, msgArgs);
    }
}

