/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product.history;

import com.ibm.websphere.product.WASProduct;
import com.ibm.websphere.product.WASProductException;
import com.ibm.websphere.product.history.WASHistoryException;
import com.ibm.websphere.product.history.filters.EFixAppliedFilenameFilter;
import com.ibm.websphere.product.history.filters.EFixDriverFilenameFilter;
import com.ibm.websphere.product.history.filters.PTFAppliedFilenameFilter;
import com.ibm.websphere.product.history.filters.PTFDriverFilenameFilter;
import com.ibm.websphere.product.history.xml.AppliedHandler;
import com.ibm.websphere.product.history.xml.EventHandler;
import com.ibm.websphere.product.history.xml.EventWriter;
import com.ibm.websphere.product.history.xml.componentApplied;
import com.ibm.websphere.product.history.xml.efixApplied;
import com.ibm.websphere.product.history.xml.efixDriver;
import com.ibm.websphere.product.history.xml.eventHistory;
import com.ibm.websphere.product.history.xml.ptfApplied;
import com.ibm.websphere.product.history.xml.ptfDriver;
import com.ibm.websphere.product.logger.WASDirectoryLogger;
import com.ibm.websphere.product.metadata.WASMaintenancePackage;
import com.ibm.websphere.product.metadata.WASMetadata;
import com.ibm.websphere.product.metadata.WASMetadataHelper;
import com.ibm.websphere.product.utils.HistoryInfoGenerator;
import com.ibm.websphere.product.xml.BaseFactory;
import com.ibm.websphere.product.xml.BaseHandlerException;
import com.ibm.websphere.product.xml.efix.ptf;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import org.xml.sax.SAXParseException;

public class WASHistory {
    public static final String pgmVersion = "1.22";
    public static final String pgmUpdate = "8/8/08";
    public static final String bundleIdMsg = "com.ibm.websphere.product.history.WASHistoryNLS";
    public static final String bundleIdText = "com.ibm.websphere.product.history.WASHistoryNLSText";
    public static ResourceBundle msgs = null;
    public static ResourceBundle texts = null;
    private WASMetadata metadataInstance = null;
    private WASDirectoryLogger logger = null;
    protected ArrayList boundExceptions;
    protected ArrayList recoverableErrors;
    protected ArrayList warnings;
    public static final String HISTORY_DIR_PROPERTY_NAME = "was.history.dir";
    public static final String DEFAULT_LOCAL_HISTORY_DIR_NAME = "history";
    protected static final int PRODUCT_DIR_OFFSET = 0;
    protected static final int VERSION_DIR_OFFSET = 1;
    protected static final int HISTORY_DIR_OFFSET = 2;
    public static final String HISTORY_FILE_NAME = "event.history";
    public static final String BACKUP_SUFFIX = ".backup";
    protected eventHistory history;
    public static final int MAX_BACKUPS = 10;
    protected ArrayList efixDrivers = null;
    protected ArrayList efixDriverNames = null;
    protected ArrayList ptfDrivers = null;
    protected ArrayList ptfDriverNames = null;
    protected ArrayList efixApplieds = null;
    protected HashMap efixAppliedMapping = null;
    protected ArrayList efixAppliedNames = null;
    protected ArrayList ptfApplieds = null;
    protected HashMap ptfAppliedMapping = null;
    protected ArrayList ptfAppliedNames = null;
    protected HashMap historyInfo;
    public static final String EFIX_DRIVER_TYPE = "efixDriver";
    public static final String EFIX_APPLIED_TYPE = "efixApplied";
    public static final String PTF_DRIVER_TYPE = "ptfDriver";
    public static final String PTF_APPLIED_TYPE = "ptfApplied";
    protected File productDir;
    protected String productDirName;
    protected File versionDir;
    protected String versionDirName;
    protected File dtdDir;
    protected String dtdDirName;
    protected File historyDir;
    protected String historyDirName;
    protected File historyFile;
    protected String historyFileName;
    protected File backupFile;
    protected String backupFileName;
    private long lastModifyHistoryFile = 0L;

    public static void InitResourceBundle() {
        ResourceBundle retrievedBundleMsg = null;
        ResourceBundle retrievedBundleText = null;
        try {
            retrievedBundleMsg = ResourceBundle.getBundle(bundleIdMsg);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        try {
            retrievedBundleText = ResourceBundle.getBundle(bundleIdText);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        msgs = retrievedBundleMsg;
        texts = retrievedBundleText;
    }

    protected static String getString(String msgCode) {
        if (msgs == null || texts == null) {
            WASHistory.InitResourceBundle();
        }
        String sReturn = "com.ibm.websphere.product.history.WASHistoryNLS:" + msgCode;
        if (msgs != null) {
            try {
                return msgs.getString(msgCode);
            }
            catch (MissingResourceException ex) {
                // empty catch block
            }
        }
        if (texts != null) {
            try {
                return texts.getString(msgCode);
            }
            catch (MissingResourceException ex) {
                sReturn = "com.ibm.websphere.product.history.WASHistoryNLSText:" + msgCode;
            }
        }
        return sReturn;
    }

    protected static String getString(String msgCode, Object arg) {
        String rawMessage = WASHistory.getString(msgCode);
        Object[] msgArgs = new Object[]{arg};
        return MessageFormat.format(rawMessage, msgArgs);
    }

    protected static String getString(String msgCode, Object arg1, Object arg2) {
        String rawMessage = WASHistory.getString(msgCode);
        Object[] msgArgs = new Object[]{arg1, arg2};
        return MessageFormat.format(rawMessage, msgArgs);
    }

    protected static String getString(String msgCode, Object[] msgArgs) {
        String rawMessage = WASHistory.getString(msgCode);
        return MessageFormat.format(rawMessage, msgArgs);
    }

    protected void addException(WASHistoryException e) {
        this.boundExceptions.add(e);
    }

    public int numExceptions() {
        return this.boundExceptions.size();
    }

    public Iterator getExceptions() {
        return this.boundExceptions.iterator();
    }

    protected void addRecoverableError(SAXParseException e) {
        this.recoverableErrors.add(e);
    }

    public int numRecoverableErrors() {
        return this.recoverableErrors.size();
    }

    public Iterator getRecoverableErrors() {
        return this.recoverableErrors.iterator();
    }

    protected void addWarning(SAXParseException e) {
        this.warnings.add(e);
    }

    public int numWarnings() {
        return this.warnings.size();
    }

    public Iterator getWarnings() {
        return this.warnings.iterator();
    }

    protected void transferErrors(BaseFactory factory) {
        Iterator errors = factory.getRecoverableErrors();
        while (errors.hasNext()) {
            SAXParseException nextError = (SAXParseException)errors.next();
            this.addRecoverableError(nextError);
        }
        Iterator warnings = factory.getWarnings();
        while (warnings.hasNext()) {
            SAXParseException nextWarning = (SAXParseException)warnings.next();
            this.addWarning(nextWarning);
        }
    }

    protected void clearExceptions() {
        this.boundExceptions = new ArrayList();
        this.recoverableErrors = new ArrayList();
        this.warnings = new ArrayList();
    }

    protected void addException(String msgKey) {
        this.addException(WASHistory.createException(msgKey, null, null));
    }

    protected void addException(String msgKey, Exception e) {
        this.addException(WASHistory.createException(msgKey, null, e));
    }

    protected void addException(String msgKey, Object[] msgArgs, Exception e) {
        this.addException(WASHistory.createException(msgKey, msgArgs, e));
    }

    protected static WASHistoryException createException(String msgKey, Object[] msgArgs, Exception e) {
        return new WASHistoryException(msgKey, msgArgs, e);
    }

    public static String[] determineHistoryDirNames() throws WASHistoryException {
        String productDirName;
        try {
            productDirName = WASProduct.computeProductDirName();
        }
        catch (WASProductException e) {
            throw WASHistory.createException("WVER201e", null, e);
        }
        String versionDirName = WASProduct.computeVersionDirName(productDirName);
        String historyDirName = WASHistory.determineHistoryDirName(versionDirName);
        return new String[]{productDirName, versionDirName, historyDirName};
    }

    public static String determineHistoryDirName(String versionDirName) {
        String historyDirName = System.getProperty(HISTORY_DIR_PROPERTY_NAME);
        historyDirName = historyDirName == null ? WASHistory.getHistoryDirName(versionDirName) : WASProduct.preparePath(historyDirName, false);
        return historyDirName;
    }

    public static String getHistoryDirName(String versionDirName) {
        versionDirName = WASProduct.preparePath(versionDirName, false);
        return versionDirName + File.separator + DEFAULT_LOCAL_HISTORY_DIR_NAME;
    }

    public WASHistory() {
        this.clearExceptions();
        try {
            String[] dirNames = WASHistory.determineHistoryDirNames();
            this.initialize(dirNames[0], dirNames[1], dirNames[2]);
        }
        catch (WASHistoryException e) {
            this.addException(e);
        }
    }

    public WASHistory(String productDirName, String versionDirName, String historyDirName) {
        this.clearExceptions();
        this.initialize(productDirName, versionDirName, historyDirName);
    }

    protected void initialize(String useProductDirName, String useVersionDirName, String useHistoryDirName) {
        this.productDir = new File(useProductDirName);
        this.productDirName = this.productDir.getAbsolutePath();
        this.versionDir = new File(useVersionDirName);
        this.versionDirName = this.versionDir.getAbsolutePath();
        this.dtdDirName = WASProduct.getDTDDirName(this.versionDirName);
        this.dtdDir = new File(this.dtdDirName);
        this.dtdDirName = this.dtdDir.getAbsolutePath();
        this.historyDir = new File(useHistoryDirName);
        this.historyDirName = this.historyDir.getAbsolutePath();
        String useFileName = this.historyDirName + File.separator + HISTORY_FILE_NAME;
        this.historyFile = new File(useFileName);
        this.historyFileName = this.historyFile.getAbsolutePath();
        String useBackupName = useFileName + BACKUP_SUFFIX;
        this.backupFile = new File(useBackupName);
        this.backupFileName = this.backupFile.getAbsolutePath();
        this.historyInfo = new HashMap();
        this.logger = WASDirectoryLogger.getWASDirectoryLogger(this.productDirName);
    }

    public eventHistory getHistory() {
        this.history = new eventHistory();
        if (this.initMetadataInstance()) {
            try {
                this.history = this.metadataInstance.getEventHistory();
            }
            catch (Exception e) {
                this.addException("WVER0242E", e);
            }
        }
        return this.history;
    }

    protected void loadHistory() {
        if (!this.ensureHistoryDirectory()) {
            this.addException("WVER0204E", new Object[]{this.historyDirName}, null);
            return;
        }
        String sBackupDirFullPath = WASProduct.getBackupDirName(this.versionDirName);
        try {
            HistoryInfoGenerator.transformHistoryXmls(sBackupDirFullPath, WASProduct.getLogDirName(this.productDirName), this.historyDirName, this.versionDirName);
        }
        catch (Exception e) {
            this.addException("WVER0203E", new Object[]{e.getMessage()}, e);
            return;
        }
        if (!this.historyFile.exists()) {
            this.history = new eventHistory();
        } else {
            BaseFactory factory = new BaseFactory(new EventHandler(), null);
            List loaded = null;
            try {
                loaded = factory.load(this.getDTDDirName(), this.getHistoryDirName(), HISTORY_FILE_NAME);
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
            this.history = (eventHistory)loaded.iterator().next();
            this.transferErrors(factory);
            BaseHandlerException handlerException = factory.getException();
            if (handlerException != null) {
                this.history = null;
                this.addException("WVER0202E", new Object[]{this.historyFileName}, handlerException);
            }
        }
    }

    public String loadHistoryInfoAsXMLString() {
        return this.loadHistoryInfoAsXMLString(HISTORY_FILE_NAME);
    }

    public boolean save(boolean createBackup) {
        return true;
    }

    public boolean ensureHistoryDirectory() {
        return this.historyDir.exists() || this.historyDir.mkdirs();
    }

    public void backupHistoryFile() throws IOException {
    }

    protected BaseHandlerException saveHistory() {
        return BaseFactory.saveSingleton(this.getHistory(), new EventWriter(), this.getHistoryFileName());
    }

    public efixDriver getEFixDriverByFilename(String basename) {
        if (!AppliedHandler.acceptsEFixDriverFileName(basename)) {
            return null;
        }
        return (efixDriver)this.getHistoryInfo(basename);
    }

    public efixDriver getEFixDriverById(String id) {
        efixDriver selectedEFixDriver = null;
        Iterator efixDrivers = this.getEFixDrivers();
        while (selectedEFixDriver == null && efixDrivers.hasNext()) {
            efixDriver nextEFixDriver = (efixDriver)efixDrivers.next();
            if (!nextEFixDriver.getId().equals(id)) continue;
            selectedEFixDriver = nextEFixDriver;
        }
        return selectedEFixDriver;
    }

    public boolean efixDriverPresent(String id) {
        return this.getEFixDriverById(id) != null;
    }

    public ptfDriver getPTFDriverByFilename(String basename) {
        if (!AppliedHandler.acceptsPTFDriverFileName(basename)) {
            return null;
        }
        if (this.initMetadataInstance()) {
            try {
                WASMaintenancePackage mpThis = this.metadataInstance.getInstalledMaintenancePackageByID(basename.substring(0, basename.lastIndexOf(".")));
                if (mpThis != null) {
                    return mpThis.getPTFDriverForThisMaintenancePackage();
                }
            }
            catch (Exception e) {
                this.addException("WVER0242E", e);
            }
        }
        return null;
    }

    public ptfDriver getPTFDriverById(String id) {
        if (this.initMetadataInstance()) {
            try {
                WASMaintenancePackage mpThis = this.metadataInstance.getInstalledMaintenancePackageByID(id);
                if (mpThis != null) {
                    return mpThis.getPTFDriverForThisMaintenancePackage();
                }
            }
            catch (Exception e) {
                this.addException("WVER0242E", e);
            }
        }
        return null;
    }

    public boolean ptfDriverPresent(String id) {
        return this.getPTFDriverById(id) != null;
    }

    public boolean saveEFixDriver(efixDriver anEFixDriver) {
        return true;
    }

    public boolean removeEFixDriver(efixDriver anEFixDriver) {
        return true;
    }

    protected void addEFixDriver(efixDriver anEFixDriver) {
        if (this.efixDrivers == null) {
            this.efixDrivers = this.basicGetEFixDrivers();
        }
        this.efixDrivers.add(anEFixDriver);
    }

    protected void basicRemoveEFixDriver(efixDriver anEFixDriver) {
        if (this.efixDrivers == null) {
            this.efixDrivers = this.basicGetEFixDrivers();
        }
        this.efixDrivers.remove(this.efixDrivers.indexOf(anEFixDriver));
    }

    public Iterator getEFixDrivers() {
        if (this.efixDrivers == null) {
            this.efixDrivers = this.basicGetEFixDrivers();
        }
        return this.efixDrivers.iterator();
    }

    protected ArrayList basicGetEFixDrivers() {
        Iterator efixDriverNames = this.getEFixDriverNames();
        return this.collectHistoryInfo(efixDriverNames);
    }

    protected void addEFixDriverName(String efixDriverName) {
        if (this.efixDriverNames == null) {
            this.efixDriverNames = this.basicGetEFixDriverNames();
        }
        this.efixDriverNames.add(efixDriverName);
    }

    protected void removeEFixDriverName(String efixDriverName) {
        if (this.efixDriverNames == null) {
            this.efixDriverNames = this.basicGetEFixDriverNames();
        }
        this.efixDriverNames.remove(this.efixDriverNames.indexOf(efixDriverName));
    }

    public Iterator getEFixDriverNames() {
        if (this.efixDriverNames == null) {
            this.efixDriverNames = this.basicGetEFixDriverNames();
        }
        return this.efixDriverNames.iterator();
    }

    public int getEFixDriverCount() {
        if (this.efixDriverNames == null) {
            this.efixDriverNames = this.basicGetEFixDriverNames();
        }
        return this.efixDriverNames.size();
    }

    protected ArrayList basicGetEFixDriverNames() {
        return this.listFileNames(new EFixDriverFilenameFilter());
    }

    public boolean savePTFDriver(ptfDriver aPTFDriver) {
        return true;
    }

    public boolean removePTFDriver(ptfDriver aPTFDriver) {
        return true;
    }

    protected void addPTFDriver(ptfDriver aPTFDriver) {
        if (this.ptfDrivers == null) {
            this.ptfDrivers = this.basicGetPTFDrivers();
        }
        this.ptfDrivers.add(aPTFDriver);
    }

    protected void basicRemovePTFDriver(ptfDriver aPTFDriver) {
        if (this.ptfDrivers == null) {
            this.ptfDrivers = this.basicGetPTFDrivers();
        }
        this.ptfDrivers.remove(this.ptfDrivers.indexOf(aPTFDriver));
    }

    public Iterator getPTFDrivers() {
        Vector ptfDriverVector = new Vector(0);
        if (this.initMetadataInstance()) {
            try {
                return this.metadataInstance.getPTFDriverVector().iterator();
            }
            catch (Exception e) {
                this.addException("WVER0015E", e);
            }
        }
        return ptfDriverVector.iterator();
    }

    protected ArrayList basicGetPTFDrivers() {
        Iterator ptfDriverNames = this.getPTFDriverNames();
        return this.collectHistoryInfo(ptfDriverNames);
    }

    protected void addPTFDriverName(String ptfDriverName) {
        if (this.ptfDriverNames == null) {
            this.ptfDriverNames = this.basicGetPTFDriverNames();
        }
        this.ptfDriverNames.add(ptfDriverName);
    }

    protected void removePTFDriverName(String ptfDriverName) {
        if (this.ptfDriverNames == null) {
            this.ptfDriverNames = this.basicGetPTFDriverNames();
        }
        this.ptfDriverNames.remove(this.ptfDriverNames.indexOf(ptfDriverName));
    }

    public Iterator getPTFDriverNames() {
        Vector ptfDriverVector = new Vector(0);
        if (this.initMetadataInstance()) {
            try {
                ptfDriverVector = this.metadataInstance.getPTFDriverVector();
            }
            catch (Exception e) {
                this.addException("WVER0242E", e);
            }
        }
        Vector<String> ptfDriverNames = new Vector<String>();
        for (int i = 0; i < ptfDriverVector.size(); ++i) {
            ptfDriverNames.add(((ptf)ptfDriverVector.elementAt(i)).getId() + ".ptfDriver");
        }
        return ptfDriverNames.iterator();
    }

    public int getPTFDriverCount() {
        if (this.initMetadataInstance()) {
            try {
                return this.metadataInstance.getPTFDriverVector().size();
            }
            catch (Exception e) {
                this.addException("WVER0242E", e);
            }
        }
        return 0;
    }

    protected ArrayList basicGetPTFDriverNames() {
        return this.listFileNames(new PTFDriverFilenameFilter());
    }

    public efixApplied getEFixAppliedByFilename(String basename) {
        if (!AppliedHandler.acceptsEFixAppliedFileName(basename)) {
            return null;
        }
        return (efixApplied)this.getHistoryInfo(basename);
    }

    public efixApplied getEFixAppliedById(String efixId) {
        return (efixApplied)this.getEFixAppliedMapping().get(efixId);
    }

    public componentApplied getEFixComponentAppliedById(String efixId, String componentName) {
        efixApplied selectedEFixApplied = this.getEFixAppliedById(efixId);
        if (selectedEFixApplied != null) {
            return selectedEFixApplied.selectComponentApplied(componentName);
        }
        return null;
    }

    public boolean efixAppliedPresent(String efixId) {
        return this.getEFixAppliedById(efixId) != null;
    }

    public boolean efixComponentAppliedPresent(String efixId, String componentName) {
        return this.getEFixComponentAppliedById(efixId, componentName) != null;
    }

    public ptfApplied getPTFAppliedById(String ptfId) {
        if (this.initMetadataInstance()) {
            try {
                WASMaintenancePackage mpThis = this.metadataInstance.getInstalledMaintenancePackageByID(ptfId);
                if (mpThis != null) {
                    return mpThis.getPTFAppliedForThisMaintenancePackage();
                }
            }
            catch (Exception e) {
                this.addException("WVER0242E", e);
            }
        }
        return null;
    }

    public componentApplied getPTFComponentAppliedById(String ptfId, String componentName) {
        if (this.initMetadataInstance()) {
            try {
                ptfApplied selectedPTFApplied;
                WASMaintenancePackage mpThis = this.metadataInstance.getInstalledMaintenancePackageByID(ptfId);
                if (mpThis != null && (selectedPTFApplied = mpThis.getPTFAppliedForThisMaintenancePackage()) != null) {
                    return selectedPTFApplied.selectComponentApplied(componentName);
                }
            }
            catch (Exception e) {
                this.addException("WVER0242E", e);
            }
        }
        return null;
    }

    public ptfApplied getPTFAppliedByFilename(String basename) {
        if (!AppliedHandler.acceptsPTFAppliedFileName(basename)) {
            return null;
        }
        if (this.initMetadataInstance()) {
            try {
                WASMaintenancePackage mpThis = this.metadataInstance.getInstalledMaintenancePackageByID(basename.substring(0, basename.lastIndexOf(".")));
                if (mpThis != null) {
                    return mpThis.getPTFAppliedForThisMaintenancePackage();
                }
            }
            catch (Exception e) {
                this.addException("WVER0242E", e);
            }
        }
        return null;
    }

    public boolean ptfAppliedPresent(String ptfId) {
        return this.getPTFAppliedById(ptfId) != null;
    }

    public boolean ptfComponentAppliedPresent(String ptfId, String componentName) {
        return this.getPTFComponentAppliedById(ptfId, componentName) != null;
    }

    public boolean recordEFixApplication(String efixId, componentApplied childApplied) {
        return true;
    }

    public boolean clearEFixApplication(String efixId, componentApplied childApplied) {
        return true;
    }

    public Iterator getEFixApplieds() {
        this.ensureEFixApplieds();
        return this.efixApplieds.iterator();
    }

    protected HashMap getEFixAppliedMapping() {
        this.ensureEFixApplieds();
        return this.efixAppliedMapping;
    }

    protected void ensureEFixApplieds() {
        if (this.efixApplieds == null) {
            this.efixApplieds = this.basicGetEFixApplieds();
            this.computeEFixAppliedMapping(this.efixApplieds.iterator());
        }
    }

    protected void mapEFixApplied(efixApplied anApplied) {
        this.efixAppliedMapping.put(anApplied.getEFixId(), anApplied);
    }

    protected void unmapEFixApplied(efixApplied anApplied) {
        this.efixAppliedMapping.remove(anApplied.getEFixId());
    }

    protected void computeEFixAppliedMapping(Iterator efixApplieds) {
        this.efixAppliedMapping = new HashMap();
        while (efixApplieds.hasNext()) {
            efixApplied nextApplied = (efixApplied)efixApplieds.next();
            this.efixAppliedMapping.put(nextApplied.getEFixId(), nextApplied);
        }
    }

    protected ArrayList basicGetEFixApplieds() {
        Iterator efixAppliedNames = this.getEFixAppliedNames();
        return this.collectHistoryInfo(efixAppliedNames);
    }

    protected void addEFixAppliedName(String filename) {
        this.efixAppliedNames.add(filename);
    }

    protected void removeEFixAppliedName(String filename) {
        this.efixAppliedNames.remove(this.efixAppliedNames.indexOf(filename));
    }

    public Iterator getEFixAppliedNames() {
        if (this.efixAppliedNames == null) {
            this.efixAppliedNames = this.basicGetEFixAppliedNames();
        }
        return this.efixAppliedNames.iterator();
    }

    protected ArrayList basicGetEFixAppliedNames() {
        return this.listFileNames(new EFixAppliedFilenameFilter());
    }

    public boolean recordPTFApplication(String ptfId, componentApplied childApplied) {
        return true;
    }

    public boolean clearPTFApplication(String ptfId, componentApplied childApplied) {
        return true;
    }

    public Iterator getPTFApplieds() {
        Vector ptfAppliedVector = new Vector(0);
        if (this.initMetadataInstance()) {
            try {
                return this.metadataInstance.getPTFAppliedVector().iterator();
            }
            catch (Exception e) {
                this.addException("WVER0242E", e);
            }
        }
        return ptfAppliedVector.iterator();
    }

    protected HashMap getPTFAppliedMapping() {
        this.ensurePTFApplieds();
        return this.ptfAppliedMapping;
    }

    protected void ensurePTFApplieds() {
        if (this.ptfApplieds == null) {
            this.computePTFAppliedMapping(this.getPTFApplieds());
        }
    }

    protected void mapPTFApplied(ptfApplied anApplied) {
        this.ptfAppliedMapping.put(anApplied.getPTFId(), anApplied);
    }

    protected void unmapPTFApplied(ptfApplied anApplied) {
        this.ptfAppliedMapping.remove(anApplied.getPTFId());
    }

    protected void computePTFAppliedMapping(Iterator ptfApplieds) {
        this.ptfAppliedMapping = new HashMap();
        while (ptfApplieds.hasNext()) {
            ptfApplied nextApplied = (ptfApplied)ptfApplieds.next();
            this.ptfAppliedMapping.put(nextApplied.getPTFId(), nextApplied);
        }
    }

    protected ArrayList basicGetPTFApplieds() {
        Iterator ptfAppliedNames = this.getPTFAppliedNames();
        return this.collectHistoryInfo(ptfAppliedNames);
    }

    protected void addPTFAppliedName(String filename) {
        this.ptfAppliedNames.add(filename);
    }

    protected void removePTFAppliedName(String filename) {
        this.ptfAppliedNames.remove(this.ptfAppliedNames.indexOf(filename));
    }

    public Iterator getPTFAppliedNames() {
        Vector ptfAppliedVector = new Vector(0);
        if (this.initMetadataInstance()) {
            try {
                ptfAppliedVector = this.metadataInstance.getPTFAppliedVector();
            }
            catch (Exception e) {
                this.addException("WVER0242E", e);
            }
        }
        Vector<String> ptfAppliedNames = new Vector<String>();
        for (int i = 0; i < ptfAppliedVector.size(); ++i) {
            ptfAppliedNames.add(((ptfApplied)ptfAppliedVector.elementAt(i)).getPTFId() + ".ptfApplied");
        }
        return ptfAppliedNames.iterator();
    }

    protected ArrayList basicGetPTFAppliedNames() {
        return this.listFileNames(new PTFAppliedFilenameFilter());
    }

    protected ArrayList collectHistoryInfo(Iterator names) {
        ArrayList<Object> collectedInfo = new ArrayList<Object>();
        boolean encounteredError = false;
        while (!encounteredError && names.hasNext()) {
            String nextName = (String)names.next();
            Object nextInfo = this.getHistoryInfo(nextName);
            if (nextInfo == null) continue;
            collectedInfo.add(nextInfo);
        }
        return collectedInfo;
    }

    protected Object getHistoryInfo(String filename) {
        Object info = this.historyInfo.get(filename);
        if (info == null && (info = this.loadHistoryInfo(filename)) != null) {
            this.historyInfo.put(filename, info);
        }
        return info;
    }

    protected Object loadHistoryInfo(String filename) {
        if (!(AppliedHandler.acceptsEFixDriverFileName(filename) || AppliedHandler.acceptsEFixAppliedFileName(filename) || AppliedHandler.acceptsPTFDriverFileName(filename) || AppliedHandler.acceptsPTFAppliedFileName(filename))) {
            this.addException("WVER0271E", new Object[]{filename}, null);
            return null;
        }
        AppliedHandler handler = new AppliedHandler();
        BaseFactory factory = new BaseFactory(handler, null);
        List loaded = null;
        try {
            loaded = factory.load(this.getDTDDirName(), this.getHistoryDirName(), filename);
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        this.transferErrors(factory);
        BaseHandlerException handlerException = factory.getException();
        if (handlerException != null) {
            this.addException("WVER0272E", new Object[]{filename}, handlerException);
            return null;
        }
        return loaded.iterator().next();
    }

    protected ArrayList listFileNames(FilenameFilter filter) {
        File[] files = this.listFiles(filter);
        return this.listFileNames(files);
    }

    protected ArrayList listFileNames(File[] files) {
        ArrayList<String> fileNames = new ArrayList<String>();
        for (int fileNo = 0; fileNo < files.length; ++fileNo) {
            fileNames.add(files[fileNo].getName());
        }
        return fileNames;
    }

    protected File[] listFiles(FilenameFilter filter) {
        return this.getHistoryDir().listFiles(filter);
    }

    public String[] loadAllHistoryInfoByType(String type) {
        FilenameFilter filter;
        Object sBackupDirFullPath;
        if (this.isMetadataFileModified(this.productDirName)) {
            sBackupDirFullPath = WASProduct.getBackupDirName(this.versionDirName);
            try {
                HistoryInfoGenerator.transformHistoryXmls((String)sBackupDirFullPath, WASProduct.getLogDirName(this.productDirName), this.historyDirName, this.versionDirName);
            }
            catch (Exception e) {
                this.addException("WVER0203E", new Object[]{e.getMessage()}, e);
            }
        }
        if (type.equalsIgnoreCase(EFIX_APPLIED_TYPE)) {
            sBackupDirFullPath = new EFixAppliedFilenameFilter();
        }
        if ((filter = type.equalsIgnoreCase(EFIX_DRIVER_TYPE) ? new EFixDriverFilenameFilter() : (type.equalsIgnoreCase(PTF_DRIVER_TYPE) ? new PTFDriverFilenameFilter() : (type.equalsIgnoreCase(PTF_APPLIED_TYPE) ? new PTFAppliedFilenameFilter() : null))) == null) {
            return null;
        }
        File[] files = this.listFiles(filter);
        if (files == null) {
            return new String[0];
        }
        String[] data = new String[files.length];
        for (int fileNo = 0; fileNo < files.length; ++fileNo) {
            data[fileNo] = this.loadHistoryInfoAsXMLString(files[fileNo].getName(), false);
        }
        return data;
    }

    public String loadHistoryInfoAsXMLString(String filename) {
        if (this.isMetadataFileModified(this.productDirName)) {
            return this.loadHistoryInfoAsXMLString(filename, true);
        }
        return this.loadHistoryInfoAsXMLString(filename, false);
    }

    protected String loadHistoryInfoAsXMLString(String filename, boolean doXSLTransform) {
        File historyFile;
        if (doXSLTransform) {
            String sBackupDirFullPath = WASProduct.getBackupDirName(this.versionDirName);
            try {
                HistoryInfoGenerator.transformHistoryXmls(sBackupDirFullPath, WASProduct.getLogDirName(this.productDirName), this.historyDirName, this.versionDirName);
            }
            catch (Exception e) {
                this.addException("WVER0203E", new Object[]{e.getMessage()}, e);
                return null;
            }
        }
        if ((historyFile = new File(this.getHistoryDir(), filename)) == null || !historyFile.exists()) {
            return "";
        }
        try {
            return this.loadFile(historyFile, filename);
        }
        catch (FileNotFoundException e) {
            this.addException("WVER0203E", new Object[]{filename}, e);
            return "";
        }
        catch (IOException e) {
            this.addException("WVER0203E", new Object[]{filename}, e);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String loadFile(File file, String fileName) throws FileNotFoundException, IOException {
        StringWriter writer = new StringWriter();
        PrintWriter pwriter = new PrintWriter(writer);
        FileReader fileReader = new FileReader(file);
        BufferedReader reader = new BufferedReader(fileReader);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                pwriter.println(line);
            }
        }
        finally {
            reader.close();
        }
        pwriter.close();
        return writer.toString();
    }

    public String toString() {
        return "WASHistory: " + this.getProductDirName() + " :: " + this.getVersionDirName() + " :: " + this.getHistoryDirName();
    }

    public String getProductDirName() {
        return this.productDirName;
    }

    public String getVersionDirName() {
        return this.versionDirName;
    }

    public String getDTDDirName() {
        return this.dtdDirName;
    }

    protected File getHistoryDir() {
        return this.historyDir;
    }

    public String getHistoryDirName() {
        return this.historyDirName;
    }

    public String getHistoryFileName() {
        return this.historyFileName;
    }

    public String getBackupFileName() {
        return this.backupFileName;
    }

    public String getHistoryFileName(String baseName) {
        String fullName = this.getHistoryDirName() + File.separator + baseName;
        File fullFile = new File(fullName);
        return fullFile.getAbsolutePath();
    }

    protected boolean initMetadataInstance() {
        if (this.metadataInstance != null) {
            return true;
        }
        this.logger.logThisMessage(Level.INFO, this.getClass().getName(), "initialize", "About to init metadata instance.");
        try {
            this.metadataInstance = WASMetadata.getWASMetadataInstance(this.productDirName);
            if (this.metadataInstance != null) {
                this.logger.logThisMessage(Level.INFO, this.getClass().getName(), "initialize", "Metadata instance initialized.");
                return true;
            }
            this.logger.logThisMessage(Level.WARNING, this.getClass().getName(), "initialize", "Metadata instance is null.");
            this.history = new eventHistory();
        }
        catch (Exception e) {
            this.addException("WVER0242E", e);
        }
        return false;
    }

    private boolean isMetadataFileModified(String installRoot) {
        try {
            File historyXmlFile = new File(WASMetadataHelper.getHistoryXmlPath(installRoot));
            if (!historyXmlFile.exists()) {
                return false;
            }
            if (this.lastModifyHistoryFile != 0L && this.lastModifyHistoryFile == historyXmlFile.lastModified()) {
                return false;
            }
            this.lastModifyHistoryFile = historyXmlFile.lastModified();
            return true;
        }
        catch (SecurityException se) {
            return false;
        }
    }
}

