/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product.formatters;

import com.ibm.websphere.product.formatters.PrintFormatter;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Vector;

public class TextPrintFormatter
implements PrintFormatter {
    public static final String pgmVersion = "1.4";
    public static final String pgmUpdate = "9/3/02";
    protected PrintWriter out = new PrintWriter(System.out);
    public static final String PAD_TEXT = "                                                                                ";
    public static final int MAX_PAD_WIDTH = "                                                                                ".length();
    public static final String SEPARATOR_LINE = "--------------------------------------------------------------------------------";
    public static final int REPORT_WIDTH = "--------------------------------------------------------------------------------".length();
    public static final int INDENT_GAP = 3;

    public void setPrintWriter(PrintWriter out) {
        this.out = out;
    }

    public String paddingFor(String partialText, int desiredWidth) {
        int partialWidth = partialText.length();
        int completingWidth = partialWidth > desiredWidth ? 0 : desiredWidth - partialWidth;
        if (completingWidth > MAX_PAD_WIDTH) {
            completingWidth = MAX_PAD_WIDTH;
        }
        return PAD_TEXT.substring(0, completingWidth);
    }

    public String embolden(String text) {
        return text;
    }

    public void println(String text, boolean isBold) {
        this.println(text, 0, isBold);
    }

    public void println(String text, int indent, boolean isBold) {
        this.println(isBold ? this.embolden(text) : text, indent);
    }

    public void println(String text) {
        this.println(text, 0);
    }

    public void println(String text, int indent) {
        if (indent < 0) {
            indent = 0;
        } else if ((indent *= 3) > REPORT_WIDTH) {
            indent = REPORT_WIDTH;
        }
        this.out.print(PAD_TEXT.substring(0, indent));
        this.out.println(text);
    }

    public void blankLine() {
        this.out.println("");
    }

    public void separator() {
        this.separator(0, false);
    }

    public void separator(boolean isBold) {
        this.separator(0, isBold);
    }

    public void separator(int indent) {
        this.separator(indent, false);
    }

    public void separator(int indent, boolean isBold) {
        int remaining;
        if (indent < 0) {
            indent = 0;
        }
        String separatorText = (remaining = REPORT_WIDTH - indent * 3) > 0 ? SEPARATOR_LINE.substring(0, remaining) : "";
        this.println(separatorText, indent, isBold);
    }

    public void printHeader(String text) {
        this.separator(true);
        this.println(text, true);
        this.separator(true);
    }

    public void printFooter(String text) {
        this.separator(true);
        this.println(text, true);
        this.separator(true);
    }

    public void printList(Iterator iterator, int indent) {
        while (iterator.hasNext()) {
            Object nextItem = iterator.next();
            String nextText = nextItem == null ? "" : nextItem.toString();
            this.println(nextText, indent);
        }
    }

    public void printTable(Vector table) {
        this.printTable(table, 0);
    }

    public void printTable(Vector table, int indent) {
        this.printTable(STANDARD_WIDTHS, table, indent);
    }

    public void printTable(int[] allocation, Vector table, int indent) {
        Vector<int[]> allocations = new Vector<int[]>();
        allocations.add(allocation);
        this.printTable(allocations, table, indent);
    }

    public void printTable(Vector allocations, Vector table, int indent) {
        StringBuffer buffer = new StringBuffer();
        Iterator tableWeights = allocations.iterator();
        Iterator tableRows = table.iterator();
        int[] nextWeights = null;
        while (tableRows.hasNext()) {
            if (tableWeights.hasNext()) {
                nextWeights = (int[])tableWeights.next();
            }
            Object[] nextRow = (Object[])tableRows.next();
            int supColumnNo = nextRow.length;
            int lastColumnNo = supColumnNo - 1;
            for (int columnNo = 0; columnNo < supColumnNo; ++columnNo) {
                int nextWeight = nextWeights[columnNo];
                Object nextColumnValue = nextRow[columnNo];
                String nextColumnText = nextColumnValue == null ? "" : nextColumnValue.toString();
                buffer.append(nextColumnText);
                if (columnNo == lastColumnNo) continue;
                String padText = this.paddingFor(nextColumnText, nextWeight);
                if (padText.length() == 0) {
                    padText = " ";
                }
                buffer.append(padText);
            }
            this.println(buffer.toString(), indent);
            buffer.setLength(0);
        }
    }
}

