/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product;

import com.ibm.websphere.product.WASDirectory;
import com.ibm.websphere.product.WASDirectoryException;
import com.ibm.websphere.product.WASProduct;
import com.ibm.websphere.product.WASProductInfo;
import com.ibm.websphere.product.formatters.HTMLPrintFormatter;
import com.ibm.websphere.product.formatters.PrintFormatter;
import com.ibm.websphere.product.formatters.TextPrintFormatter;
import com.ibm.websphere.product.history.WASHistory;
import com.ibm.websphere.product.history.xml.aparInfo;
import com.ibm.websphere.product.history.xml.componentApplied;
import com.ibm.websphere.product.history.xml.componentUpdate;
import com.ibm.websphere.product.history.xml.componentVersion;
import com.ibm.websphere.product.history.xml.customProperty;
import com.ibm.websphere.product.history.xml.efixApplied;
import com.ibm.websphere.product.history.xml.efixDriver;
import com.ibm.websphere.product.history.xml.efixPrereq;
import com.ibm.websphere.product.history.xml.enumUpdateType;
import com.ibm.websphere.product.history.xml.includedEFix;
import com.ibm.websphere.product.history.xml.platformPrereq;
import com.ibm.websphere.product.history.xml.productPrereq;
import com.ibm.websphere.product.history.xml.ptfApplied;
import com.ibm.websphere.product.history.xml.ptfDriver;
import com.ibm.websphere.product.logger.WASDirectoryLogger;
import com.ibm.websphere.product.metadata.WASComponent;
import com.ibm.websphere.product.metadata.WASComponentUpdate;
import com.ibm.websphere.product.metadata.WASMaintenancePackage;
import com.ibm.websphere.product.utils.WASDirectoryHelper;
import com.ibm.websphere.product.utils.WASDirectoryResourceBundleUtils;
import com.ibm.websphere.product.xml.component.component;
import com.ibm.websphere.product.xml.efix.efix;
import com.ibm.websphere.product.xml.efix.ptf;
import com.ibm.websphere.product.xml.extension.extension;
import com.ibm.websphere.product.xml.product.product;
import com.ibm.websphere.product.xml.websphere.websphere;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class VersionInfo {
    public static final String pgmVersion = "1.15.1.26";
    public static final String pgmUpdate = "8/9/08";
    public static final String TEXT_MODE = "text";
    public static final String HTML_MODE = "html";
    public static final String DEFAULT_REPORT_MODE = "text";
    protected boolean printStack;
    protected WASProduct wasProduct;
    protected WASHistory wasHistory;
    protected WASDirectory wasDirectory;
    protected boolean exceptionThrown = false;
    protected PrintFormatter formatter;
    protected boolean displayEFixes;
    protected boolean displayEFixDetail;
    protected boolean displayPTFs;
    protected boolean displayPTFDetail;
    protected boolean displayComponents;
    protected boolean displayComponentDetail;
    protected boolean isText;
    private static final String S_EMPTY_STRING = "";
    private static final String S_LICENSE_COMPONENT_FILENAME = "install.license.runtime.component";

    protected static String getDefaultedString(String msgCode, String defaultMsg) {
        String msgReturn = WASDirectoryResourceBundleUtils.getVersionLocaleString(msgCode);
        if (msgReturn.equals(msgCode)) {
            return defaultMsg;
        }
        return msgReturn;
    }

    protected static String getDefaultedString(String msgCode, String defaultMsg, Object[] msgArgs) {
        String rawMessage = VersionInfo.getDefaultedString(msgCode, defaultMsg);
        return MessageFormat.format(rawMessage, msgArgs);
    }

    protected static String getString(String msgCode) {
        return WASDirectoryResourceBundleUtils.getVersionLocaleString(msgCode);
    }

    protected static String getString(String msgCode, Object arg) {
        return WASDirectoryResourceBundleUtils.getVersionLocaleString(msgCode, arg);
    }

    protected static String getString(String msgCode, Object arg1, Object arg2) {
        Object[] objectList = new Object[]{arg1, arg2};
        return WASDirectoryResourceBundleUtils.getVersionLocaleString(msgCode, objectList);
    }

    protected static String getString(String msgCode, Object[] args) {
        return WASDirectoryResourceBundleUtils.getVersionLocaleString(msgCode, args);
    }

    protected static void handleRecoverableErrors(Iterator recoverableErrors, PrintStream output, boolean printStack) {
        while (recoverableErrors.hasNext()) {
            SAXParseException nextError = (SAXParseException)recoverableErrors.next();
            String errorText = VersionInfo.getString("WVER0022E", new Object[]{nextError.getSystemId(), nextError.getPublicId(), new Integer(nextError.getLineNumber()), new Integer(nextError.getColumnNumber()), nextError.toString()});
            output.println(errorText);
            if (!printStack) continue;
            nextError.printStackTrace(output);
        }
    }

    protected static void handleWarnings(Iterator warnings, PrintStream output, boolean printStack) {
        while (warnings.hasNext()) {
            SAXParseException nextWarning = (SAXParseException)warnings.next();
            String warningText = VersionInfo.getString("WVER0024E", new Object[]{nextWarning.getSystemId(), nextWarning.getPublicId(), new Integer(nextWarning.getLineNumber()), new Integer(nextWarning.getColumnNumber()), nextWarning.toString()});
            output.println(warningText);
            if (!printStack) continue;
            nextWarning.printStackTrace(output);
        }
    }

    protected static int handleFatalExceptions(int errorNo, Iterator fatalExceptions, PrintStream output, boolean printStack) {
        while (fatalExceptions.hasNext()) {
            Exception nextFatalException = (Exception)fatalExceptions.next();
            String errorMessage = VersionInfo.getString("listing.nested.error", Integer.toString(++errorNo), nextFatalException.toString());
            output.println(errorMessage);
            if (!printStack) continue;
            nextFatalException.printStackTrace(output);
        }
        return errorNo;
    }

    public static boolean handleErrors(WASProduct wasProduct, WASHistory wasHistory, PrintStream output, boolean printStack) {
        int numHistoryFatalExceptions;
        int numProductFatalExceptions;
        int numFatalExceptions;
        int numProductErrors = wasProduct.numRecoverableErrors();
        int numHistoryErrors = wasHistory.numRecoverableErrors();
        if (numProductErrors > 0 || numHistoryErrors > 0) {
            output.println(VersionInfo.getString("WVER0021E"));
            VersionInfo.handleRecoverableErrors(wasProduct.getRecoverableErrors(), output, printStack);
            VersionInfo.handleRecoverableErrors(wasHistory.getRecoverableErrors(), output, printStack);
        }
        int numProductWarnings = wasProduct.numWarnings();
        int numHistoryWarnings = wasHistory.numWarnings();
        if (numProductWarnings > 0 || numHistoryWarnings > 0) {
            output.println(VersionInfo.getString("WVER0023E"));
            VersionInfo.handleWarnings(wasProduct.getWarnings(), output, printStack);
            VersionInfo.handleWarnings(wasHistory.getWarnings(), output, printStack);
        }
        if ((numFatalExceptions = (numProductFatalExceptions = wasProduct.numExceptions()) + (numHistoryFatalExceptions = wasHistory.numExceptions())) == 0) {
            return true;
        }
        String errorMessage = VersionInfo.getString(numFatalExceptions == 1 ? "WVER0015E" : "WVER0016E");
        output.println(errorMessage);
        int errorNo = 0;
        errorNo = VersionInfo.handleFatalExceptions(errorNo, wasProduct.getExceptions(), output, printStack);
        errorNo = VersionInfo.handleFatalExceptions(errorNo, wasHistory.getExceptions(), output, printStack);
        return false;
    }

    public static void printCopyright() {
        System.out.println(VersionInfo.getDefaultedString("WVER0010I", "WVER0010I: Copyright (c) IBM Corporation 2002, 2008; All rights reserved."));
        System.out.println(VersionInfo.getDefaultedString("WVER0012I", "WVER0012I: VersionInfo Reporter Version {0}, Dated {1}", new Object[]{pgmVersion, pgmUpdate}));
        System.out.println();
    }

    public static void main(String[] args) {
        VersionInfo.main(args, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int main(String[] args, boolean allowExit) {
        VersionInfo.printCopyright();
        boolean isComplete = false;
        String errorArg = null;
        String errorCode = null;
        boolean showHelp = false;
        boolean showUsage = false;
        String format = null;
        String filename = null;
        boolean displayEFixes = false;
        boolean displayEFixDetail = false;
        boolean displayPTFs = false;
        boolean displayPTFDetail = false;
        boolean displayComponents = false;
        boolean displayComponentDetail = false;
        boolean printStack = false;
        for (int argNo = 0; !isComplete && argNo < args.length; ++argNo) {
            String nextArg = args[argNo];
            if (nextArg.equalsIgnoreCase("-format")) {
                if (++argNo < args.length) {
                    nextArg = args[argNo];
                    if (nextArg.equalsIgnoreCase("text") || nextArg.equalsIgnoreCase(HTML_MODE)) {
                        format = nextArg;
                        continue;
                    }
                    isComplete = true;
                    errorArg = nextArg;
                    errorCode = "WVER0006E";
                    continue;
                }
                isComplete = true;
                errorArg = nextArg;
                errorCode = "WVER0005E";
                continue;
            }
            if (nextArg.equalsIgnoreCase("-file")) {
                if (++argNo < args.length) {
                    filename = args[argNo];
                    continue;
                }
                isComplete = true;
                errorArg = nextArg;
                errorCode = "WVER0005E";
                continue;
            }
            if (nextArg.equalsIgnoreCase("-maintenancePackages")) {
                displayPTFs = true;
                continue;
            }
            if (nextArg.equalsIgnoreCase("-maintenancePackageDetail")) {
                displayPTFs = true;
                displayPTFDetail = true;
                continue;
            }
            if (nextArg.equalsIgnoreCase("-components")) {
                displayComponents = true;
                continue;
            }
            if (nextArg.equalsIgnoreCase("-componentDetail")) {
                displayComponents = true;
                displayComponentDetail = true;
                continue;
            }
            if (nextArg.equalsIgnoreCase("-long")) {
                displayEFixes = true;
                displayEFixDetail = true;
                displayPTFs = true;
                displayPTFDetail = true;
                displayComponents = true;
                displayComponentDetail = true;
                continue;
            }
            if (nextArg.equalsIgnoreCase("-help") || nextArg.equalsIgnoreCase("-?") || nextArg.equalsIgnoreCase("/?") || nextArg.equalsIgnoreCase("/help")) {
                isComplete = true;
                showHelp = true;
                continue;
            }
            if (nextArg.equalsIgnoreCase("-usage")) {
                isComplete = true;
                showUsage = true;
                continue;
            }
            if (nextArg.equalsIgnoreCase("-printStack")) {
                printStack = true;
                continue;
            }
            isComplete = true;
            errorArg = nextArg;
            errorCode = "WVER0007E";
        }
        if (showHelp) {
            System.out.println(VersionInfo.getString("WVER0008I"));
            if (!allowExit) return 0;
            System.exit(0);
            return -1;
        }
        if (showUsage) {
            System.out.println(VersionInfo.getString("WVER0003I"));
            if (!allowExit) return 0;
            System.exit(0);
            return -1;
        }
        if (errorArg != null) {
            System.err.println(VersionInfo.getString(errorCode, errorArg));
            if (!allowExit) return -1;
            System.exit(-1);
            return -1;
        }
        Throwable boundError = null;
        boolean hasErrorOccured = false;
        try {
            VersionInfo vi = new VersionInfo();
            vi.setPrintStack(printStack);
            vi.runReport(format, filename, displayEFixes, displayEFixDetail, displayPTFs, displayPTFDetail, displayComponents, displayComponentDetail);
            hasErrorOccured = vi.hasExceptionThrown();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace(System.out);
            boundError = e;
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
            boundError = e;
        }
        catch (Throwable th) {
            th.printStackTrace(System.out);
            boundError = th;
        }
        if (boundError != null) {
            String errorMessage;
            String useFilename = filename == null ? VersionInfo.getString("label.standard.out") : filename;
            try {
                String exceptionText = boundError.toString();
                errorMessage = VersionInfo.getString("WVER0004E", useFilename, exceptionText);
            }
            catch (Throwable th) {
                errorMessage = VersionInfo.getString("WVER0009E", new Object[]{useFilename, boundError.getClass().getName(), th.getClass().getName()});
            }
            System.err.println(errorMessage);
            if (printStack) {
                boundError.printStackTrace();
            }
            if (!allowExit) return -1;
            System.exit(-1);
            return -1;
        }
        if (hasErrorOccured) {
            if (!allowExit) return -1;
            System.exit(-1);
            return -1;
        } else {
            if (!allowExit) return 0;
            System.exit(0);
        }
        return -1;
    }

    public VersionInfo() {
        this.setPrintStack(false);
        this.clearProduct();
        this.clearPrintMode();
        this.clearFormatter();
    }

    protected void setPrintStack(boolean printStack) {
        this.printStack = printStack;
    }

    protected boolean getPrintStack() {
        return this.printStack;
    }

    protected boolean setProduct() {
        this.wasProduct = new WASProduct();
        this.wasHistory = new WASHistory();
        boolean handleWASProductHistoryError = VersionInfo.handleErrors(this.wasProduct, this.wasHistory, System.err, this.getPrintStack());
        return handleWASProductHistoryError;
    }

    protected WASProduct getProduct() {
        return this.wasProduct;
    }

    protected WASHistory getHistory() {
        return this.wasHistory;
    }

    protected void clearProduct() {
        this.wasProduct = null;
        this.wasHistory = null;
        this.wasDirectory = null;
    }

    protected boolean setWASDirectory() throws FileNotFoundException, IOException, ParserConfigurationException, SAXException, WASDirectoryException {
        String installRoot = WASDirectoryHelper.getInstallRootPath();
        if (this.getPrintStack()) {
            WASDirectoryLogger.getWASDirectoryLogger(installRoot, Level.FINEST);
        }
        this.wasDirectory = new WASDirectory();
        return true;
    }

    protected boolean isText() {
        return this.isText;
    }

    protected void setFormatter(String format, PrintWriter out) {
        if (format == null || !format.equalsIgnoreCase("text") && !format.equalsIgnoreCase(HTML_MODE)) {
            format = "text";
        }
        if (format.equalsIgnoreCase(HTML_MODE)) {
            this.isText = false;
            this.formatter = new HTMLPrintFormatter();
        } else {
            this.isText = true;
            this.formatter = new TextPrintFormatter();
        }
        this.formatter.setPrintWriter(out);
    }

    protected PrintFormatter getFormatter() {
        return this.formatter;
    }

    protected void clearFormatter() {
        this.formatter = null;
    }

    protected void setPrintMode(boolean displayEFixes, boolean displayEFixDetail, boolean displayPTFs, boolean displayPTFDetail, boolean displayComponents, boolean displayComponentDetail) {
        this.displayEFixes = displayEFixes;
        this.displayEFixDetail = displayEFixDetail;
        this.displayPTFs = displayPTFs;
        this.displayPTFDetail = displayPTFDetail;
        this.displayComponents = displayComponents;
        this.displayComponentDetail = displayComponentDetail;
    }

    protected boolean displayEFixes() {
        return this.displayEFixes;
    }

    protected boolean displayEFixDetail() {
        return this.displayEFixDetail;
    }

    protected boolean displayPTFs() {
        return this.displayPTFs;
    }

    protected boolean displayPTFDetail() {
        return this.displayPTFDetail;
    }

    protected boolean displayComponents() {
        return this.displayComponents;
    }

    protected boolean displayComponentDetail() {
        return this.displayComponentDetail;
    }

    protected void clearPrintMode() {
        this.displayEFixes = false;
        this.displayEFixDetail = false;
        this.displayPTFs = false;
        this.displayPTFDetail = false;
        this.displayComponents = false;
        this.displayComponentDetail = false;
    }

    public void runReport(String format, String filename) throws FileNotFoundException, IOException {
        this.runReport(format, filename, false, false, false, false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runReport(String format, String filename, boolean displayEFixes, boolean displayEFixDetail, boolean displayPTFs, boolean displayPTFDetail, boolean displayComponents, boolean displayComponentDetail) throws FileNotFoundException, IOException {
        if (filename == null) {
            this.runReport(format, System.out, displayEFixes, displayEFixDetail, displayPTFs, displayPTFDetail, displayComponents, displayComponentDetail);
        } else {
            FileOutputStream out = new FileOutputStream(filename);
            try {
                this.runReport(format, out, displayEFixes, displayEFixDetail, displayPTFs, displayPTFDetail, displayComponents, displayComponentDetail);
            }
            finally {
                out.close();
            }
        }
    }

    public void runReport(String format, OutputStream out) {
        this.runReport(format, out, false, false, false, false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runReport(String format, OutputStream out, boolean displayEFixes, boolean displayEFixDetail, boolean displayPTFs, boolean displayPTFDetail, boolean displayComponents, boolean displayComponentDetail) {
        PrintWriter writer = new PrintWriter(out);
        try {
            this.runReport(format, writer, displayEFixes, displayEFixDetail, displayPTFs, displayPTFDetail, displayComponents, displayComponentDetail);
        }
        finally {
            writer.flush();
        }
    }

    public void runReport(String format, PrintWriter out) {
        this.runReport(format, out, false, false, false, false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runReport(String format, PrintWriter out, boolean displayEFixes, boolean displayEFixDetail, boolean displayPTFs, boolean displayPTFDetail, boolean displayComponents, boolean displayComponentDetail) {
        this.setFormatter(format, out);
        this.setPrintMode(displayEFixes, displayEFixDetail, displayPTFs, displayPTFDetail, displayComponents, displayComponentDetail);
        try {
            if (this.setWASDirectory() && this.setProduct()) {
                this.printReport();
            }
        }
        catch (Exception e) {
            this.exceptionThrown = true;
            out.close();
            this.printException(e, System.err, this.getPrintStack());
        }
        finally {
            this.clearProduct();
            this.clearPrintMode();
            this.clearFormatter();
        }
    }

    protected boolean hasExceptionThrown() {
        return this.exceptionThrown;
    }

    protected String getTimeStamp() {
        Date dateCurrentDate = new Date(System.currentTimeMillis());
        return DateFormat.getDateTimeInstance(1, 1).format(dateCurrentDate);
    }

    protected void printReport() throws Exception {
        int i;
        PrintFormatter useFormatter = this.getFormatter();
        useFormatter.printHeader(VersionInfo.getString("report.header"));
        this.printTimeStamp();
        this.printSource();
        this.printChecklist();
        WASProductInfo[] productInfoList = this.wasDirectory.getWASProductInfoInstances();
        for (int i2 = 0; i2 < productInfoList.length; ++i2) {
            this.printProductInfo(productInfoList[i2]);
        }
        if (this.displayComponents()) {
            WASComponent[] componentList = this.wasDirectory.getInstalledComponentList();
            for (i = 0; i < componentList.length; ++i) {
                this.printComponentInfo(componentList[i]);
            }
        }
        if (this.displayPTFs()) {
            WASMaintenancePackage[] maintenancePackageList = this.wasDirectory.getInstalledMaintenancePackageList();
            for (i = 0; i < maintenancePackageList.length; ++i) {
                this.printMaintenancePackage(maintenancePackageList[i]);
            }
        }
        useFormatter.blankLine();
        useFormatter.printFooter(VersionInfo.getString("report.footer"));
    }

    protected Iterator getCorrectedProducts(WASProduct useProduct) {
        boolean sawBaseProduct = false;
        boolean sawNDProduct = false;
        Iterator products = useProduct.getProducts();
        while (products.hasNext()) {
            product nextProduct = (product)products.next();
            String nextProductId = nextProduct.getId();
            if (nextProductId == null) continue;
            if (nextProductId.equalsIgnoreCase("BASE")) {
                sawBaseProduct = true;
                continue;
            }
            if (!nextProductId.equalsIgnoreCase("ND")) continue;
            sawNDProduct = true;
        }
        Vector<product> correctedProducts = new Vector<product>();
        products = useProduct.getProducts();
        while (products.hasNext()) {
            product nextProduct = (product)products.next();
            String nextProductId = nextProduct.getId();
            boolean keepThisProduct = !sawBaseProduct || nextProductId == null || !nextProductId.equalsIgnoreCase("ND");
            if (!keepThisProduct) continue;
            correctedProducts.addElement(nextProduct);
        }
        return correctedProducts.iterator();
    }

    protected void separator(int indent) {
        if (this.isText()) {
            this.getFormatter().separator(indent);
        }
    }

    protected void separator() {
        if (this.isText()) {
            this.getFormatter().separator();
        }
    }

    protected void printTimeStamp() {
        PrintFormatter useFormatter = this.getFormatter();
        useFormatter.blankLine();
        useFormatter.println(VersionInfo.getString("info.report.on", WASDirectoryHelper.getCurrentTimestamp()));
    }

    protected String unsub(String innerText, String outerText, String subVariable) {
        int subLoc = outerText.indexOf(innerText);
        if (subLoc == -1) {
            return outerText;
        }
        return outerText.substring(0, subLoc) + subVariable + outerText.substring(subLoc + innerText.length());
    }

    protected void printSource() {
        PrintFormatter useFormatter = this.getFormatter();
        useFormatter.blankLine();
        useFormatter.println(VersionInfo.getString("info.source"), true);
        this.separator();
        String productDirName = this.wasDirectory.getWasLocation();
        String versionDirName = WASDirectoryHelper.getVersionDirPath(productDirName);
        String dtdDirName = WASDirectoryHelper.getDTDDirPath(productDirName);
        String logDirName = WASDirectoryHelper.getLogDirPath(productDirName);
        String backupDirName = WASDirectoryHelper.getBackupDirPath(productDirName);
        String tmpDirName = WASDirectoryHelper.getTmpDirPath();
        Vector<String[]> table = new Vector<String[]>();
        table.add(new String[]{VersionInfo.getString("label.product.dir"), productDirName});
        table.add(new String[]{VersionInfo.getString("label.version.dir"), versionDirName});
        table.add(new String[]{VersionInfo.getString("label.version.dtd.dir"), dtdDirName});
        table.add(new String[]{VersionInfo.getString("label.version.log.dir"), logDirName});
        File fileBackupFile = new File(backupDirName);
        if (fileBackupFile.exists()) {
            table.add(new String[]{VersionInfo.getString("label.version.backup.dir"), backupDirName});
        }
        table.add(new String[]{VersionInfo.getString("label.version.tmp.dir"), tmpDirName});
        int[] allocations = new int[]{25, 75};
        useFormatter.printTable(allocations, table, 0);
    }

    protected void printPlatform(websphere platform) {
        if (platform == null) {
            return;
        }
        PrintFormatter useFormatter = this.getFormatter();
        useFormatter.blankLine();
        useFormatter.println(VersionInfo.getString("info.platform"), true);
        this.separator();
        Vector<String[]> table = new Vector<String[]>();
        table.add(new String[]{VersionInfo.getString("label.name"), platform.getName()});
        table.add(new String[]{VersionInfo.getString("label.version"), platform.getVersion()});
        useFormatter.printTable(table);
    }

    protected void printChecklist() {
        PrintFormatter useFormatter = this.getFormatter();
        useFormatter.blankLine();
        useFormatter.println(VersionInfo.getString("info.technology"), true);
        this.separator();
        Vector<String[]> table = new Vector<String[]>();
        String labelInstalled = VersionInfo.getString("label.installed");
        WASProductInfo[] wasProductInfoList = this.wasDirectory.getWASProductInfoInstances();
        for (int i = 0; i < wasProductInfoList.length; ++i) {
            String sProductID = this.normalizeProductIDForTrialEdition(wasProductInfoList[i].getId());
            table.add(new String[]{sProductID, labelInstalled});
        }
        useFormatter.printTable(table);
    }

    protected void printProduct(product prod) {
        PrintFormatter useFormatter = this.getFormatter();
        useFormatter.blankLine();
        useFormatter.println(VersionInfo.getString("info.product"), true);
        this.separator();
        String sProductId = this.normalizeProductIDForTrialEdition(prod.getId());
        String arch = new WASDirectory(this.wasProduct.getProductDirName()).getOfficialArchNameFromNativeFile();
        Vector<String[]> table = new Vector<String[]>();
        table.add(new String[]{VersionInfo.getString("label.name"), prod.getName()});
        table.add(new String[]{VersionInfo.getString("label.version"), prod.getVersion()});
        table.add(new String[]{VersionInfo.getString("label.id"), sProductId});
        table.add(new String[]{VersionInfo.getString("label.build.level"), prod.getBuildInfo().getLevel()});
        table.add(new String[]{VersionInfo.getString("label.build.date"), prod.getBuildInfo().getDate()});
        if (arch != null) {
            table.add(new String[]{VersionInfo.getString("label.architecture"), arch});
        }
        useFormatter.printTable(table);
    }

    protected void printComponent(component comp) {
        String componentName = comp.getName();
        PrintFormatter useFormatter = this.getFormatter();
        useFormatter.blankLine();
        useFormatter.println(VersionInfo.getString("info.component"), true);
        this.separator();
        Vector<String[]> table = new Vector<String[]>();
        table.add(new String[]{VersionInfo.getString("label.component.name"), componentName});
        table.add(new String[]{VersionInfo.getString("label.spec.version"), comp.getSpecVersion()});
        table.add(new String[]{VersionInfo.getString("label.build.version"), comp.getBuildVersion()});
        table.add(new String[]{VersionInfo.getString("label.build.date"), comp.getBuildDate()});
        useFormatter.printTable(table);
        if (this.displayComponentDetail()) {
            this.printComponentDetail(comp);
        }
    }

    protected void printComponentDetail(component comp) {
        String componentName = comp.getName();
        Vector matchingComponentApplieds = this.selectApplications(componentName);
        int matchCount = matchingComponentApplieds.size();
        if (matchCount == 0) {
            return;
        }
        PrintFormatter useFormatter = this.getFormatter();
        useFormatter.blankLine();
        useFormatter.println(VersionInfo.getString("info.update.on.component"), 1, true);
        this.separator(1);
        Vector appliedRows = new Vector();
        for (int matchNo = 0; matchNo < matchCount; ++matchNo) {
            Object[] applicationData = (Object[])matchingComponentApplieds.elementAt(matchNo);
            this.printApplication(applicationData);
            if (matchNo >= matchCount - 1) continue;
            useFormatter.blankLine();
        }
    }

    protected Vector selectApplications(String componentName) {
        Vector<Object[]> matchingComponentApplieds = new Vector<Object[]>();
        Iterator parentEFixApplieds = this.getHistory().getEFixApplieds();
        while (parentEFixApplieds.hasNext()) {
            efixApplied parentApplied = (efixApplied)parentEFixApplieds.next();
            int childCount = parentApplied.getComponentAppliedCount();
            for (int childNo = 0; childNo < childCount; ++childNo) {
                componentApplied childApplied = parentApplied.getComponentApplied(childNo);
                if (!childApplied.getComponentName().equals(componentName)) continue;
                matchingComponentApplieds.add(new Object[]{parentApplied, childApplied});
            }
        }
        Iterator parentPTFApplieds = this.getHistory().getPTFApplieds();
        while (parentPTFApplieds.hasNext()) {
            ptfApplied parentApplied = (ptfApplied)parentPTFApplieds.next();
            int childCount = parentApplied.getComponentAppliedCount();
            for (int childNo = 0; childNo < childCount; ++childNo) {
                componentApplied childApplied = parentApplied.getComponentApplied(childNo);
                if (!childApplied.getComponentName().equals(componentName)) continue;
                matchingComponentApplieds.add(new Object[]{parentApplied, childApplied});
            }
        }
        return matchingComponentApplieds;
    }

    protected void printApplication(Object[] applicationData) {
        componentVersion finalVersion;
        componentApplied nextComponentApplied = (componentApplied)applicationData[1];
        Vector<String[]> appliedRows = new Vector<String[]>();
        appliedRows.add(new String[]{VersionInfo.getString("label.component.name"), nextComponentApplied.getComponentName()});
        if (applicationData[0] instanceof efixApplied) {
            efixApplied nextEFixApplied = (efixApplied)applicationData[0];
            appliedRows.add(new String[]{VersionInfo.getString("label.update.type"), VersionInfo.getString("label.update.type.efix")});
            appliedRows.add(new String[]{VersionInfo.getString("label.efix.id"), nextEFixApplied.getEFixId()});
        } else {
            ptfApplied nextPTFApplied = (ptfApplied)applicationData[0];
            appliedRows.add(new String[]{VersionInfo.getString("label.update.type"), VersionInfo.getString("label.update.type.ptf")});
            appliedRows.add(new String[]{VersionInfo.getString("label.ptf.id"), nextPTFApplied.getPTFId()});
        }
        enumUpdateType updateType = nextComponentApplied.getUpdateTypeAsEnum();
        String updateEffectText = this.updateEffectText(updateType);
        appliedRows.add(new String[]{VersionInfo.getString("label.update.effect"), updateEffectText});
        if (!nextComponentApplied.getLogName().equalsIgnoreCase(S_EMPTY_STRING)) {
            appliedRows.add(new String[]{VersionInfo.getString("label.log.file.name"), nextComponentApplied.getLogName()});
        }
        if (!nextComponentApplied.getBackupName().equalsIgnoreCase(S_EMPTY_STRING)) {
            appliedRows.add(new String[]{VersionInfo.getString("label.backup.file.name"), nextComponentApplied.getBackupName()});
        }
        appliedRows.add(new String[]{VersionInfo.getString("label.install.date"), nextComponentApplied.getTimeStamp()});
        componentVersion initialVersion = nextComponentApplied.getInitialVersion();
        if (initialVersion != null) {
            appliedRows.add(new String[]{VersionInfo.getString("label.initial.spec.version"), initialVersion.getSpecVersion()});
            appliedRows.add(new String[]{VersionInfo.getString("label.initial.build.version"), initialVersion.getBuildVersion()});
            appliedRows.add(new String[]{VersionInfo.getString("label.initial.build.date"), initialVersion.getBuildDate()});
        }
        if ((finalVersion = nextComponentApplied.getFinalVersion()) != null) {
            appliedRows.add(new String[]{VersionInfo.getString("label.final.spec.version"), finalVersion.getSpecVersion()});
            appliedRows.add(new String[]{VersionInfo.getString("label.final.build.version"), finalVersion.getBuildVersion()});
            appliedRows.add(new String[]{VersionInfo.getString("label.final.build.date"), finalVersion.getBuildDate()});
        }
        this.getFormatter().printTable(appliedRows, 1);
    }

    protected void printExtension(extension ext) {
        PrintFormatter useFormatter = this.getFormatter();
        useFormatter.blankLine();
        useFormatter.println(VersionInfo.getString("info.extension"), true);
        this.separator();
        Vector<String[]> table = new Vector<String[]>();
        table.add(new String[]{VersionInfo.getString("label.name"), ext.getName()});
        table.add(new String[]{VersionInfo.getString("label.id"), ext.getId()});
        useFormatter.printTable(table);
    }

    protected void printEFix(efix fix) {
        efixDriver driver = this.printEFixHeader(fix);
        if (driver == null) {
            return;
        }
        this.printEFixApars(driver);
        this.printEFixPlatformPrereqs(driver);
        this.printEFixProductPrereqs(driver);
        this.printEFixPrereqs(driver);
        this.printEFixComponents(driver);
        this.printEFixCustomProperties(driver);
    }

    protected efixDriver printEFixHeader(efix fix) {
        efixDriver driver;
        PrintFormatter useFormatter = this.getFormatter();
        WASProduct useProduct = this.getProduct();
        useFormatter.blankLine();
        useFormatter.println(VersionInfo.getString("info.efix"), true);
        this.separator();
        Vector<String[]> table = new Vector<String[]>();
        table.add(new String[]{VersionInfo.getString("label.id"), fix.getId()});
        table.add(new String[]{VersionInfo.getString("label.short.description"), fix.getShortDescription()});
        table.add(new String[]{VersionInfo.getString("label.build.date"), fix.getBuildDate()});
        table.add(new String[]{VersionInfo.getString("label.build.version"), fix.getBuildVersion()});
        if (this.displayEFixDetail()) {
            driver = this.getHistory().getEFixDriverById(fix.getId());
            boolean isTrial = driver.getIsTrialAsBoolean();
            String isTrialText = this.booleanText(isTrial);
            table.add(new String[]{VersionInfo.getString("label.is.trial"), isTrialText});
            table.add(new String[]{VersionInfo.getString("label.expiration.date"), driver.getExpirationDate()});
            table.add(new String[]{VersionInfo.getString("label.long.description"), driver.getLongDescription()});
        } else {
            driver = null;
        }
        useFormatter.printTable(table);
        return driver;
    }

    protected void printEFixApars(efixDriver driver) {
        int numApars = driver.getAparInfoCount();
        if (numApars == 0) {
            return;
        }
        PrintFormatter useFormatter = this.getFormatter();
        useFormatter.blankLine();
        useFormatter.println(VersionInfo.getString("label.apar"), 1, true);
        this.separator(1);
        Vector<String[]> aparRows = new Vector<String[]>();
        for (int aparNo = 0; aparNo < numApars; ++aparNo) {
            aparInfo nextApar = driver.getAparInfo(aparNo);
            aparRows.add(new String[]{VersionInfo.getString("label.apar.number"), nextApar.getNumber()});
            aparRows.add(new String[]{VersionInfo.getString("label.apar.date"), nextApar.getDate()});
            aparRows.add(new String[]{VersionInfo.getString("label.apar.short.description"), nextApar.getShortDescription()});
            aparRows.add(new String[]{VersionInfo.getString("label.apar.long.description"), nextApar.getLongDescription()});
        }
        useFormatter.printTable(aparRows, 1);
    }

    protected void printEFixPlatformPrereqs(efixDriver driver) {
        int numPlatformPrereqs = driver.getPlatformPrereqCount();
        if (numPlatformPrereqs == 0) {
            return;
        }
        PrintFormatter useFormatter = this.getFormatter();
        useFormatter.blankLine();
        useFormatter.println(VersionInfo.getString("label.supported.platforms"), 1, true);
        this.separator(1);
        Vector<Object[]> platformPrereqs = new Vector<Object[]>();
        for (int platformPrereqNo = 0; platformPrereqNo < numPlatformPrereqs; ++platformPrereqNo) {
            platformPrereq nextPlatformPrereq = driver.getPlatformPrereq(platformPrereqNo);
            Object[] nextRow = new Object[]{nextPlatformPrereq.getArchitecture(), nextPlatformPrereq.getOSPlatform(), nextPlatformPrereq.getOSVersion()};
            platformPrereqs.add(nextRow);
        }
        int[] weights = new int[]{15, 15, 70};
        useFormatter.printTable(weights, platformPrereqs, 1);
    }

    protected void printEFixProductPrereqs(efixDriver driver) {
        int numProductPrereqs = driver.getProductPrereqCount();
        if (numProductPrereqs == 0) {
            return;
        }
        PrintFormatter useFormatter = this.getFormatter();
        useFormatter.blankLine();
        useFormatter.println(VersionInfo.getString("label.supported.products"), 1, true);
        this.separator(1);
        Vector<Object[]> productPrereqs = new Vector<Object[]>();
        for (int productPrereqNo = 0; productPrereqNo < numProductPrereqs; ++productPrereqNo) {
            productPrereq nextProductPrereq = driver.getProductPrereq(productPrereqNo);
            String sProductId = this.normalizeProductIDForTrialEdition(nextProductPrereq.getProductId());
            Object[] nextRow = new Object[]{sProductId, nextProductPrereq.getBuildVersion(), nextProductPrereq.getBuildDate(), nextProductPrereq.getBuildLevel()};
            productPrereqs.add(nextRow);
        }
        int[] weights = new int[]{15, 15, 15, 15, 40};
        useFormatter.printTable(weights, productPrereqs, 1);
    }

    protected void printEFixPrereqs(efixDriver driver) {
        int numEFixPrereqs = driver.getEFixPrereqCount();
        if (numEFixPrereqs == 0) {
            return;
        }
        PrintFormatter useFormatter = this.getFormatter();
        useFormatter.println(VersionInfo.getString("label.efix.efix.prereqs"), 1, true);
        this.separator(1);
        Vector<Object[]> efixPrereqs = new Vector<Object[]>();
        for (int efixPrereqNo = 0; efixPrereqNo < numEFixPrereqs; ++efixPrereqNo) {
            efixPrereq nextEFixPrereq = driver.getEFixPrereq(efixPrereqNo);
            boolean nextIsNegative = nextEFixPrereq.getIsNegativeAsBoolean();
            String isNegativeText = this.isNegativeText(nextIsNegative);
            String installIndex = nextEFixPrereq.getInstallIndex();
            if (installIndex == null) {
                installIndex = S_EMPTY_STRING;
            }
            Object[] nextRow = new Object[]{nextEFixPrereq.getEFixId(), isNegativeText, installIndex};
            efixPrereqs.add(nextRow);
        }
        int[] weights = new int[]{15, 15, 15, 55};
        useFormatter.printTable(weights, efixPrereqs, 1);
    }

    protected void printEFixComponents(efixDriver driver) {
        int componentCount = driver.getComponentUpdateCount();
        if (componentCount == 0) {
            return;
        }
        WASHistory useHistory = this.getHistory();
        PrintFormatter useFormatter = this.getFormatter();
        useFormatter.blankLine();
        useFormatter.println(VersionInfo.getString("label.component.updates"), 1, true);
        this.separator(1);
        int[] componentWeights = new int[]{15, 15, 15, 55};
        int[] contentWeights = new int[]{5, 15, 15, 65};
        int[] nestedWeights = new int[]{5, 95, 0, 0};
        Vector<int[]> allocations = new Vector<int[]>();
        Vector<Object[]> componentRows = new Vector<Object[]>();
        for (int compNo = 0; compNo < componentCount; ++compNo) {
            componentUpdate nextUpdate = driver.getComponentUpdate(compNo);
            enumUpdateType updateType = nextUpdate.getUpdateTypeAsEnum();
            String updateEffectText = this.updateEffectText(updateType);
            String isRequiredText = this.isRequiredText(nextUpdate.getIsRequiredAsBoolean(), nextUpdate.getIsOptionalAsBoolean(), nextUpdate.getIsRecommendedAsBoolean());
            Object[] nextRow = new Object[]{nextUpdate.getComponentName(), updateEffectText, isRequiredText};
            allocations.add(componentWeights);
            componentRows.add(nextRow);
            boolean nextIsCustom = nextUpdate.getIsCustomAsBoolean();
            String isCustomText = this.isCustomText(nextIsCustom);
            allocations.add(contentWeights);
            Object[] contentRow = new Object[]{S_EMPTY_STRING, isCustomText, nextUpdate.getPrimaryContent()};
            componentRows.add(contentRow);
            componentApplied nextApplied = useHistory.getEFixComponentAppliedById(driver.getId(), nextUpdate.getComponentName());
            String isInstalledText = this.isInstalledText(nextApplied);
            Object[] installedRow = new Object[]{S_EMPTY_STRING, isInstalledText, S_EMPTY_STRING, S_EMPTY_STRING};
            allocations.add(nestedWeights);
            componentRows.add(installedRow);
            int prereqCount = nextUpdate.getComponentPrereqCount();
            for (int prereqNo = 0; prereqNo < prereqCount; ++prereqNo) {
                componentVersion nextPrereq = nextUpdate.getComponentPrereq(prereqNo);
                String requirementText = VersionInfo.getString("label.component.requires", nextPrereq.getComponentName(), nextPrereq.getSpecVersion());
                Object[] nextPrereqRow = new Object[]{S_EMPTY_STRING, requirementText, S_EMPTY_STRING, S_EMPTY_STRING};
                allocations.add(nestedWeights);
                componentRows.add(nextPrereqRow);
            }
            componentVersion finalVersion = nextUpdate.getFinalVersion();
            if (finalVersion == null) continue;
            Object[] becomesData = new Object[]{finalVersion.getSpecVersion(), finalVersion.getBuildVersion(), finalVersion.getBuildDate()};
            String becomesText = VersionInfo.getString("label.becomes", becomesData);
            Object[] nextBecomesRow = new Object[]{S_EMPTY_STRING, becomesText, S_EMPTY_STRING, S_EMPTY_STRING};
            allocations.add(nestedWeights);
            componentRows.add(nextBecomesRow);
        }
        useFormatter.printTable(allocations, componentRows, 1);
    }

    protected void printEFixCustomProperties(efixDriver driver) {
        int numProperties = driver.getCustomPropertyCount();
        if (numProperties == 0) {
            return;
        }
        PrintFormatter useFormatter = this.getFormatter();
        useFormatter.blankLine();
        useFormatter.println(VersionInfo.getString("label.custom.properties"), 1, true);
        this.separator(1);
        Vector<Object[]> propertyData = new Vector<Object[]>();
        for (int propertyNo = 0; propertyNo < numProperties; ++propertyNo) {
            customProperty nextProperty = driver.getCustomProperty(propertyNo);
            Object[] nextPropertyData = new Object[]{nextProperty.getPropertyName(), nextProperty.getPropertyType(), nextProperty.getPropertyValue()};
            propertyData.addElement(nextPropertyData);
        }
        int[] weights = new int[]{20, 20, 60};
        this.getFormatter().printTable(weights, propertyData, 1);
    }

    protected void printPTF(ptf aPTF) {
        ptfDriver driver = this.printPTFHeader(aPTF);
        if (driver == null) {
            return;
        }
        this.printPTFPlatformPrereqs(driver);
        this.printPTFProductPrereqs(driver);
        this.printPTFIncludedEFixes(driver);
        this.printPTFComponents(driver);
        this.printPTFCustomProperties(driver);
    }

    protected ptfDriver printPTFHeader(ptf aPTF) {
        PrintFormatter useFormatter = this.getFormatter();
        useFormatter.blankLine();
        useFormatter.println(VersionInfo.getString("info.ptf"), true);
        this.separator();
        Vector<String[]> table = new Vector<String[]>();
        table.add(new String[]{VersionInfo.getString("label.ptf.id"), aPTF.getId()});
        table.add(new String[]{VersionInfo.getString("label.short.description"), aPTF.getShortDescription()});
        table.add(new String[]{VersionInfo.getString("label.build.date"), aPTF.getBuildDate()});
        ptfDriver driver = this.displayPTFDetail() ? this.getHistory().getPTFDriverById(aPTF.getId()) : null;
        useFormatter.printTable(table);
        return driver;
    }

    protected void printPTFPlatformPrereqs(ptfDriver driver) {
        int numPlatformPrereqs = driver.getPlatformPrereqCount();
        if (numPlatformPrereqs == 0) {
            return;
        }
        PrintFormatter useFormatter = this.getFormatter();
        useFormatter.blankLine();
        useFormatter.println(VersionInfo.getString("label.supported.platforms"), 1, true);
        this.separator(1);
        Vector<Object[]> platformPrereqs = new Vector<Object[]>();
        for (int platformPrereqNo = 0; platformPrereqNo < numPlatformPrereqs; ++platformPrereqNo) {
            platformPrereq nextPlatformPrereq = driver.getPlatformPrereq(platformPrereqNo);
            Object[] nextRow = new Object[]{nextPlatformPrereq.getArchitecture(), nextPlatformPrereq.getOSPlatform(), nextPlatformPrereq.getOSVersion()};
            platformPrereqs.add(nextRow);
        }
        int[] weights = new int[]{15, 15, 70};
        useFormatter.printTable(weights, platformPrereqs, 1);
    }

    protected void printPTFProductPrereqs(ptfDriver driver) {
        int numProductPrereqs = driver.getProductPrereqCount();
        if (numProductPrereqs == 0) {
            return;
        }
        PrintFormatter useFormatter = this.getFormatter();
        useFormatter.blankLine();
        useFormatter.println(VersionInfo.getString("label.supported.products"), 1, true);
        this.separator(1);
        Vector<Object[]> productPrereqs = new Vector<Object[]>();
        for (int productPrereqNo = 0; productPrereqNo < numProductPrereqs; ++productPrereqNo) {
            productPrereq nextProductPrereq = driver.getProductPrereq(productPrereqNo);
            String sProductId = this.normalizeProductIDForTrialEdition(nextProductPrereq.getProductId());
            Object[] nextRow = new Object[]{sProductId, nextProductPrereq.getBuildVersion(), nextProductPrereq.getBuildDate(), nextProductPrereq.getBuildLevel()};
            productPrereqs.add(nextRow);
        }
        int[] weights = new int[]{15, 15, 15, 15, 40};
        useFormatter.printTable(weights, productPrereqs, 1);
    }

    protected void printPTFIncludedEFixes(ptfDriver driver) {
        int numIncludedEFixes = driver.getIncludedEFixCount();
        if (numIncludedEFixes == 0) {
            return;
        }
        PrintFormatter useFormatter = this.getFormatter();
        useFormatter.blankLine();
        useFormatter.println(VersionInfo.getString("label.included.efixes"), 1, true);
        this.separator(1);
        Vector<Object[]> includedEFixs = new Vector<Object[]>();
        for (int includedEFixNo = 0; includedEFixNo < numIncludedEFixes; ++includedEFixNo) {
            includedEFix nextIncludedEFix = driver.getIncludedEFix(includedEFixNo);
            Object[] nextRow = new Object[]{nextIncludedEFix.getEFixId()};
            includedEFixs.add(nextRow);
        }
        int[] weights = new int[]{100};
        useFormatter.printTable(weights, includedEFixs, 1);
    }

    protected void printPTFComponents(ptfDriver driver) {
        int componentCount = driver.getComponentUpdateCount();
        if (componentCount == 0) {
            return;
        }
        WASHistory useHistory = this.getHistory();
        PrintFormatter useFormatter = this.getFormatter();
        useFormatter.blankLine();
        useFormatter.println(VersionInfo.getString("label.component.updates"), 1, true);
        this.separator(1);
        int[] componentWeights = new int[]{15, 15, 15, 55};
        int[] contentWeights = new int[]{5, 15, 15, 65};
        int[] nestedWeights = new int[]{5, 95, 0, 0};
        Vector<int[]> allocations = new Vector<int[]>();
        Vector<Object[]> componentRows = new Vector<Object[]>();
        for (int compNo = 0; compNo < componentCount; ++compNo) {
            componentUpdate nextUpdate = driver.getComponentUpdate(compNo);
            String nextComponentName = nextUpdate.getComponentName();
            enumUpdateType updateType = nextUpdate.getUpdateTypeAsEnum();
            String updateEffectText = this.updateEffectText(updateType);
            Object[] nextRow = new Object[]{nextComponentName, updateEffectText};
            allocations.add(componentWeights);
            componentRows.add(nextRow);
            componentApplied nextApplied = useHistory.getPTFComponentAppliedById(driver.getId(), nextComponentName);
            String isInstalledText = this.isInstalledText(nextApplied);
            Object[] installedRow = new Object[]{S_EMPTY_STRING, isInstalledText, S_EMPTY_STRING, S_EMPTY_STRING};
            allocations.add(nestedWeights);
            componentRows.add(installedRow);
            componentVersion finalVersion = nextUpdate.getFinalVersion();
            if (finalVersion == null) continue;
            Object[] becomesData = new Object[]{finalVersion.getSpecVersion(), finalVersion.getBuildVersion(), finalVersion.getBuildDate()};
            String becomesText = VersionInfo.getString("label.becomes", becomesData);
            Object[] nextBecomesRow = new Object[]{S_EMPTY_STRING, becomesText, S_EMPTY_STRING, S_EMPTY_STRING};
            allocations.add(nestedWeights);
            componentRows.add(nextBecomesRow);
        }
        useFormatter.printTable(allocations, componentRows, 1);
    }

    protected void printPTFCustomProperties(ptfDriver driver) {
        int numProperties = driver.getCustomPropertyCount();
        if (numProperties == 0) {
            return;
        }
        PrintFormatter useFormatter = this.getFormatter();
        useFormatter.blankLine();
        useFormatter.println(VersionInfo.getString("label.custom.properties"), 1, true);
        this.separator(1);
        Vector<Object[]> propertyData = new Vector<Object[]>();
        for (int propertyNo = 0; propertyNo < numProperties; ++propertyNo) {
            customProperty nextProperty = driver.getCustomProperty(propertyNo);
            Object[] nextPropertyData = new Object[]{nextProperty.getPropertyName(), nextProperty.getPropertyType(), nextProperty.getPropertyValue()};
            propertyData.addElement(nextPropertyData);
        }
        int[] weights = new int[]{20, 20, 60};
        useFormatter.printTable(weights, propertyData, 1);
    }

    protected String booleanText(boolean value) {
        return VersionInfo.getString(value ? "label.true" : "label.false");
    }

    protected String isInstalledText(componentApplied anApplied) {
        if (anApplied == null) {
            return VersionInfo.getString("label.is.absent");
        }
        String installDate = anApplied.getTimeStamp();
        return VersionInfo.getString("label.is.installed", installDate);
    }

    protected String updateEffectText(enumUpdateType updateType) {
        String tagText = updateType == enumUpdateType.ADD_UPDATE_TYPE ? "label.update.effect.add" : (updateType == enumUpdateType.REPLACE_UPDATE_TYPE ? "label.update.effect.replace" : (updateType == enumUpdateType.REMOVE_UPDATE_TYPE ? "label.update.effect.remove" : (updateType == enumUpdateType.PATCH_UPDATE_TYPE ? "label.update.effect.patch" : "label.update.effect.unknown")));
        return VersionInfo.getString(tagText);
    }

    protected String isNegativeText(boolean isNegative) {
        return VersionInfo.getString(isNegative ? "label.is.negative" : "label.is.positive");
    }

    protected String isRequiredText(boolean isRequired, boolean isOptional, boolean isRecommended) {
        if (isRequired) {
            return VersionInfo.getString("label.is.required.tag");
        }
        if (!isOptional) {
            return VersionInfo.getString("label.if.possible.tag");
        }
        if (!isRecommended) {
            return VersionInfo.getString("label.is.optional.tag");
        }
        return VersionInfo.getString("label.is.recommended.tag");
    }

    protected String isCustomText(boolean isCustom) {
        return VersionInfo.getString(isCustom ? "label.is.custom.tag" : "label.is.standard.tag");
    }

    protected String normalizeProductIDForTrialEdition(String sProductID) {
        String sLicenseComponentFilePath;
        if ((sProductID.equals("BASE") || sProductID.equals("EXPRESS")) && !new File(sLicenseComponentFilePath = WASDirectoryHelper.getVersionDirPath(this.wasDirectory.getWasLocation()) + File.separator + S_LICENSE_COMPONENT_FILENAME).exists()) {
            if (sProductID.equals("BASE")) {
                return "BASETRIAL";
            }
            return "EXPRESSTRIAL";
        }
        return sProductID;
    }

    protected String getUpdateEffectText(String updateEffect) {
        String updateTypeTag = "replace".equals(updateEffect) ? "label.update.effect.replace" : "label.update.effect.unknown";
        return VersionInfo.getString(updateTypeTag);
    }

    protected void printException(Exception e, PrintStream output, boolean printStack) {
        String errorMessage;
        if (!e.getClass().getName().equals(WASDirectoryException.class.getName())) {
            errorMessage = VersionInfo.getString("WVER0015E");
            output.println(errorMessage);
        }
        errorMessage = e.getMessage();
        output.println(errorMessage);
        if (printStack) {
            e.printStackTrace(output);
        }
    }

    protected void printProductInfo(WASProductInfo wasProductInfo) {
        PrintFormatter useFormatter = this.getFormatter();
        useFormatter.blankLine();
        useFormatter.println(VersionInfo.getString("info.product"), true);
        this.separator();
        String sProductId = this.normalizeProductIDForTrialEdition(wasProductInfo.getId());
        String arch = this.wasDirectory.getOfficialArchNameFromNativeFile();
        Vector<String[]> table = new Vector<String[]>();
        table.add(new String[]{VersionInfo.getString("label.name"), wasProductInfo.getName()});
        table.add(new String[]{VersionInfo.getString("label.version"), wasProductInfo.getVersion()});
        table.add(new String[]{VersionInfo.getString("label.id"), sProductId});
        table.add(new String[]{VersionInfo.getString("label.build.level"), wasProductInfo.getBuildLevel()});
        table.add(new String[]{VersionInfo.getString("label.build.date"), wasProductInfo.getBuildDate()});
        if (arch != null) {
            table.add(new String[]{VersionInfo.getString("label.architecture"), arch});
        }
        useFormatter.printTable(table);
    }

    protected void printComponentInfo(WASComponent comp) {
        if (comp == null) {
            return;
        }
        String componentName = comp.getComponentName();
        PrintFormatter useFormatter = this.getFormatter();
        useFormatter.blankLine();
        useFormatter.println(VersionInfo.getString("info.component"), true);
        this.separator();
        Vector<String[]> table = new Vector<String[]>();
        table.add(new String[]{VersionInfo.getString("label.component.name"), componentName});
        table.add(new String[]{VersionInfo.getString("label.spec.version"), comp.getSpecVersion()});
        table.add(new String[]{VersionInfo.getString("label.build.version"), comp.getBuildVersion()});
        table.add(new String[]{VersionInfo.getString("label.build.date"), comp.getBuildDate()});
        useFormatter.printTable(table);
        if (this.displayComponentDetail()) {
            this.printComponentUpdateListForThisComponent(comp);
        }
    }

    protected void printComponentUpdateListForThisComponent(WASComponent comp) {
        if (comp == null) {
            return;
        }
        WASComponentUpdate[] componentUpdateList = comp.getComponentUpdateList();
        int count = componentUpdateList.length;
        if (count == 0) {
            return;
        }
        PrintFormatter useFormatter = this.getFormatter();
        useFormatter.blankLine();
        useFormatter.println(VersionInfo.getString("info.update.on.component"), 1, true);
        this.separator(1);
        for (int i = 0; i < count; ++i) {
            this.printComponentUpdateForComponent(componentUpdateList[i]);
            if (i >= count - 1) continue;
            useFormatter.blankLine();
        }
    }

    protected void printComponentUpdateForComponent(WASComponentUpdate componentUpdate2) {
        if (componentUpdate2 == null) {
            return;
        }
        Vector<String[]> table = new Vector<String[]>();
        String updateEffectText = this.getUpdateEffectText(componentUpdate2.getUpdateEffect());
        table.add(new String[]{VersionInfo.getString("label.component.name"), componentUpdate2.getComponentName()});
        table.add(new String[]{VersionInfo.getString("label.update.type"), VersionInfo.getString("label.update.type.ptf")});
        table.add(new String[]{VersionInfo.getString("label.ptf.id"), componentUpdate2.getMaintenancePackageID()});
        table.add(new String[]{VersionInfo.getString("label.update.effect"), updateEffectText});
        if (!S_EMPTY_STRING.equals(componentUpdate2.getLogFileName())) {
            table.add(new String[]{VersionInfo.getString("label.log.file.name"), componentUpdate2.getLogFileName()});
        }
        if (!componentUpdate2.getBackupFileName().equalsIgnoreCase(S_EMPTY_STRING)) {
            table.add(new String[]{VersionInfo.getString("label.backup.file.name"), componentUpdate2.getBackupFileName()});
        } else if ("install".equals(componentUpdate2.getAction())) {
            table.add(new String[]{VersionInfo.getString("label.backup.file.name"), VersionInfo.getString("label.backup.file.name.notapplicable")});
        }
        table.add(new String[]{VersionInfo.getString("label.install.date"), componentUpdate2.getTimestamp()});
        int[] allocations = new int[]{35, 85};
        this.getFormatter().printTable(allocations, table, 1);
    }

    protected void printMaintenancePackage(WASMaintenancePackage mp) {
        if (mp == null) {
            return;
        }
        this.printMaintenancePackageHeader(mp);
        if (this.displayPTFDetail) {
            this.printMaintenancePackageAPARList(mp);
            this.printComponentListForMaintenancePackage(mp);
        }
    }

    protected void printMaintenancePackageHeader(WASMaintenancePackage mp) {
        PrintFormatter useFormatter = this.getFormatter();
        useFormatter.blankLine();
        useFormatter.println(VersionInfo.getString("info.ptf"), true);
        this.separator();
        Vector<String[]> table = new Vector<String[]>();
        table.add(new String[]{VersionInfo.getString("label.ptf.id"), mp.getMaintenancePackageID()});
        table.add(new String[]{VersionInfo.getString("label.short.description"), mp.getDescription()});
        table.add(new String[]{VersionInfo.getString("label.build.date"), mp.getBuildDate()});
        useFormatter.printTable(table);
    }

    protected void printMaintenancePackageAPARList(WASMaintenancePackage mp) {
        String[] aparList = mp.getAparList();
        if (aparList.length == 0) {
            return;
        }
        PrintFormatter useFormatter = this.getFormatter();
        useFormatter.blankLine();
        useFormatter.println(VersionInfo.getString("label.included.efixes"), 1, true);
        this.separator(1);
        Vector<Object[]> table = new Vector<Object[]>();
        for (int i = 0; i < aparList.length; ++i) {
            Object[] nextRow = new Object[]{aparList[i]};
            table.add(nextRow);
        }
        int[] weights = new int[]{100};
        useFormatter.printTable(weights, table, 1);
    }

    protected void printComponentListForMaintenancePackage(WASMaintenancePackage mp) {
        WASComponentUpdate[] componentUpdateList = mp.getComponentUpdateList();
        int componentCount = componentUpdateList.length;
        if (componentCount == 0) {
            return;
        }
        PrintFormatter useFormatter = this.getFormatter();
        useFormatter.blankLine();
        useFormatter.println(VersionInfo.getString("label.component.updates"), 1, true);
        this.separator(1);
        int[] componentWeights = new int[]{15, 15, 15, 55};
        int[] contentWeights = new int[]{5, 15, 15, 65};
        int[] nestedWeights = new int[]{5, 95, 0, 0};
        Vector<int[]> allocations = new Vector<int[]>();
        Vector<Object[]> table = new Vector<Object[]>();
        for (int compNo = 0; compNo < componentCount; ++compNo) {
            WASComponentUpdate nextUpdate = componentUpdateList[compNo];
            String nextComponentName = nextUpdate.getComponentName();
            String updateEffectText = this.getUpdateEffectText(nextUpdate.getUpdateEffect());
            Object[] nextRow = new Object[]{nextComponentName, updateEffectText, S_EMPTY_STRING, S_EMPTY_STRING};
            allocations.add(componentWeights);
            table.add(nextRow);
            String isInstalledText = VersionInfo.getString("label.is.installed", nextUpdate.getTimestamp());
            Object[] installedRow = new Object[]{S_EMPTY_STRING, isInstalledText, S_EMPTY_STRING, S_EMPTY_STRING};
            allocations.add(nestedWeights);
            table.add(installedRow);
        }
        useFormatter.printTable(allocations, table, 1);
    }
}

