/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.pmi.stat;

import com.ibm.websphere.management.statistics.RangeStatistic;
import com.ibm.websphere.pmi.stat.Statistic;
import com.ibm.websphere.pmi.stat.StatisticImpl;

public class RangeStatisticImpl
extends StatisticImpl
implements RangeStatistic {
    private static final long serialVersionUID = -571042361091383094L;
    protected long highWaterMark = 0L;
    protected long lowWaterMark = 0L;
    protected long current = 0L;
    protected long integral = 0L;
    protected boolean initWaterMark = false;
    private RangeStatisticImpl baseValue = null;

    public RangeStatisticImpl(int dataId) {
        super(dataId);
    }

    public RangeStatisticImpl(int id, String name, String unit, String description, long startTime, long lastSampleTime) {
        super(id, name, unit, description, startTime, lastSampleTime);
    }

    public RangeStatisticImpl(int id, long lowWaterMark, long highWaterMark, long current, long integral, long startTime, long lastSampleTime) {
        super(id, null, null, null, startTime, lastSampleTime);
        this.lowWaterMark = lowWaterMark;
        this.highWaterMark = highWaterMark;
        this.current = current;
        this.integral = integral;
    }

    public long getLowWaterMark() {
        return this.lowWaterMark;
    }

    public long getHighWaterMark() {
        return this.highWaterMark;
    }

    public long getCurrent() {
        return this.current;
    }

    public long getIntegral() {
        return this.integral;
    }

    public double getMean() {
        long timeDiff = this.lastSampleTime - this.startTime;
        if (timeDiff > 0L) {
            return (double)this.integral * 1.0 / (double)timeDiff;
        }
        return 0.0;
    }

    public void reset() {
        this.reset(true);
    }

    public void reset(boolean resetAll) {
        if (resetAll) {
            super.reset();
        }
        this.integral = 0L;
        this.lowWaterMark = 0L;
        this.highWaterMark = 0L;
        this.initWaterMark = false;
    }

    public void setWaterMark(long val) {
        this.setWaterMark(val, System.currentTimeMillis());
    }

    protected void setWaterMark(long val, long curTime) {
        this.lastSampleTime = curTime;
        if (!this.initWaterMark) {
            this.lowWaterMark = this.highWaterMark = val;
            this.initWaterMark = true;
        } else {
            if (val < this.lowWaterMark) {
                this.lowWaterMark = val;
            }
            if (val > this.highWaterMark) {
                this.highWaterMark = val;
            }
        }
        this.current = val;
    }

    public void set(long lowWaterMark, long highWaterMark, long current, long integral, long startTime, long lastSampleTime) {
        this.current = current;
        this.integral = integral;
        this.lowWaterMark = lowWaterMark;
        this.highWaterMark = highWaterMark;
        this.startTime = startTime;
        this.lastSampleTime = lastSampleTime;
    }

    public void add(long val) {
        if (this.current == val) {
            return;
        }
        if (this.enabled) {
            long curTime = this.myupdate();
            this.setWaterMark(val, curTime);
        } else {
            this.current = val;
        }
    }

    public void add(long curTime, long val) {
        if (this.current == val) {
            return;
        }
        if (this.enabled) {
            this.myupdate(curTime);
            this.setWaterMark(val, curTime);
        } else {
            this.current = val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increment() {
        if (this.enabled) {
            Object object = this.syncObj;
            synchronized (object) {
                long curTime = this.myupdate();
                this.setWaterMark(this.current + 1L, curTime);
            }
        } else {
            ++this.current;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increment(long incVal) {
        if (this.enabled) {
            Object object = this.syncObj;
            synchronized (object) {
                long curTime = this.myupdate();
                this.setWaterMark(this.current + incVal, curTime);
            }
        } else {
            this.current += incVal;
        }
    }

    public void increment(long curTime, long val) {
        if (this.enabled) {
            this.myupdate(curTime);
            this.setWaterMark(this.current + val, curTime);
        } else {
            this.current += val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrement() {
        if (this.enabled) {
            Object object = this.syncObj;
            synchronized (object) {
                long curTime = this.myupdate();
                this.setWaterMark(this.current - 1L, curTime);
            }
        } else {
            --this.current;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrement(long decVal) {
        if (this.enabled) {
            Object object = this.syncObj;
            synchronized (object) {
                long curTime = this.myupdate();
                this.setWaterMark(this.current - decVal, curTime);
            }
        } else {
            this.current -= decVal;
        }
    }

    public void decrement(long curTime, long val) {
        if (this.enabled) {
            this.myupdate(curTime);
            this.setWaterMark(this.current - val, curTime);
        } else {
            this.current -= val;
        }
    }

    public long myupdate() {
        long curTime = System.currentTimeMillis();
        long timeDiff = curTime - this.lastSampleTime;
        this.integral += timeDiff * this.current;
        return curTime;
    }

    public long myupdate(long curTime) {
        long timeDiff = curTime - this.lastSampleTime;
        this.integral += timeDiff * this.current;
        return curTime;
    }

    public void setLastValue(long val) {
        this.current = val;
    }

    public void combine(Statistic otherStat) {
        if (!this.validate(otherStat)) {
            return;
        }
        RangeStatisticImpl other = (RangeStatisticImpl)otherStat;
        this.current += other.current;
        long curTime = other.myupdate();
        other.setLastSampleTime(curTime);
        if (this.lastSampleTime - this.startTime == 0L) {
            this.myupdate(curTime);
            this.setLastSampleTime(curTime);
        }
        double otherAvg = (double)other.getIntegral() * 1.0 / (double)(curTime - other.getStartTime());
        this.integral += (long)(otherAvg * (double)(this.lastSampleTime - this.startTime));
        if (other.lowWaterMark < this.lowWaterMark) {
            this.lowWaterMark = other.lowWaterMark;
        }
        if (other.highWaterMark > this.highWaterMark) {
            this.highWaterMark = other.highWaterMark;
        }
    }

    public void update(Statistic otherStat) {
        if (!this.validate(otherStat)) {
            return;
        }
        RangeStatisticImpl other = (RangeStatisticImpl)otherStat;
        if (this.baseValue == null) {
            this.integral = other.integral;
            this.startTime = other.startTime;
        } else {
            this.integral = other.integral - this.baseValue.integral;
            this.startTime = this.baseValue.lastSampleTime;
        }
        this.current = other.current;
        this.lowWaterMark = other.lowWaterMark;
        this.highWaterMark = other.highWaterMark;
        this.lastSampleTime = other.lastSampleTime;
    }

    public Statistic delta(Statistic otherStat) {
        if (!this.validate(otherStat)) {
            return null;
        }
        RangeStatisticImpl other = (RangeStatisticImpl)otherStat;
        RangeStatisticImpl newData = new RangeStatisticImpl(this.id);
        newData.current = other.current;
        newData.integral = this.integral - other.integral;
        newData.startTime = other.lastSampleTime;
        newData.lastSampleTime = this.lastSampleTime;
        return newData;
    }

    public void resetOnClient(Statistic other) {
        if (other == null) {
            if (this.baseValue == null) {
                this.baseValue = new RangeStatisticImpl(this.id);
            }
            this.baseValue.set(this.lowWaterMark, this.highWaterMark, this.current, this.integral, this.startTime, this.lastSampleTime);
            this.update(this.baseValue);
        } else if (!this.validate(other)) {
            this.baseValue = (RangeStatisticImpl)other;
            this.update(this.baseValue);
        }
    }

    private boolean validate(Statistic other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof RangeStatisticImpl)) {
            System.out.println("WARNING: wrong data type: must be CountStatistic");
            return false;
        }
        if (other.getId() != this.id) {
            System.out.println("WARNING: wrong data Id: expect dataId=" + this.id + ", got dataId=" + other.getId());
            return false;
        }
        return true;
    }

    public void cleanup() {
        this.current = 0L;
        this.integral = 0L;
        this.lastSampleTime = System.currentTimeMillis();
        this.lowWaterMark = 0L;
        this.highWaterMark = 0L;
        this.initWaterMark = false;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuffer str = new StringBuffer();
        str.append(indent);
        str.append(super.toString(""));
        str.append(" lowWaterMark=");
        str.append(this.lowWaterMark);
        str.append(" highWaterMark=");
        str.append(this.highWaterMark);
        str.append(" current=");
        str.append(this.current);
        str.append(" integral=");
        str.append(this.integral);
        return str.toString();
    }
}

