/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.pmi.stat;

import com.ibm.websphere.management.statistics.CountStatistic;
import com.ibm.websphere.pmi.stat.Statistic;
import com.ibm.websphere.pmi.stat.StatisticImpl;

public class CountStatisticImpl
extends StatisticImpl
implements CountStatistic {
    private static final long serialVersionUID = -486127251362568257L;
    protected long count = 0L;
    private CountStatisticImpl baseValue = null;

    public CountStatisticImpl(int dataId) {
        super(dataId);
    }

    public CountStatisticImpl(int dataId, long count, long startTime, long lastSampleTime) {
        super(dataId, null, null, null, startTime, lastSampleTime);
        this.count = count;
    }

    public CountStatisticImpl(int id, String name, String unit, String description, long startTime, long lastSampleTime) {
        super(id, name, unit, description, startTime, lastSampleTime);
    }

    public long getCount() {
        return this.count;
    }

    public void reset() {
        this.reset(true);
    }

    public void reset(boolean resetAll) {
        if (resetAll) {
            super.reset();
        }
        this.count = 0L;
    }

    public void set(long count, long startTime, long lastSampleTime) {
        this.count = count;
        this.startTime = startTime;
        this.lastSampleTime = lastSampleTime;
    }

    public void combine(Statistic otherStat) {
        if (!this.validate(otherStat)) {
            return;
        }
        CountStatisticImpl other = (CountStatisticImpl)otherStat;
        this.count += other.count;
        if (other.lastSampleTime > this.lastSampleTime) {
            this.lastSampleTime = other.lastSampleTime;
        }
    }

    public void setCount(long value) {
        if (!this.enabled) {
            return;
        }
        this.lastSampleTime = System.currentTimeMillis();
        this.count = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increment() {
        if (!this.enabled) {
            return;
        }
        this.lastSampleTime = System.currentTimeMillis();
        if (!this.sync) {
            ++this.count;
        } else {
            Object object = this.syncObj;
            synchronized (object) {
                ++this.count;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increment(long val) {
        if (!this.enabled) {
            return;
        }
        this.lastSampleTime = System.currentTimeMillis();
        if (!this.sync) {
            this.count += val;
        } else {
            Object object = this.syncObj;
            synchronized (object) {
                this.count += val;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrement() {
        if (!this.enabled) {
            return;
        }
        this.lastSampleTime = System.currentTimeMillis();
        if (!this.sync) {
            --this.count;
        } else {
            Object object = this.syncObj;
            synchronized (object) {
                --this.count;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrement(long val) {
        if (!this.enabled) {
            return;
        }
        this.lastSampleTime = System.currentTimeMillis();
        if (!this.sync) {
            this.count -= val;
        } else {
            Object object = this.syncObj;
            synchronized (object) {
                this.count -= val;
            }
        }
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuffer str = new StringBuffer();
        str.append(indent);
        str.append("CountStatisticImpl: ");
        str.append(super.toString(""));
        str.append(" count=");
        str.append(this.count);
        return str.toString();
    }

    public void update(Statistic otherStat) {
        if (!this.validate(otherStat)) {
            return;
        }
        CountStatisticImpl other = (CountStatisticImpl)otherStat;
        if (this.baseValue == null) {
            this.count = other.getCount();
            this.startTime = other.getStartTime();
        } else {
            this.count = other.count - this.baseValue.count;
            this.startTime = this.baseValue.lastSampleTime;
        }
        this.lastSampleTime = other.lastSampleTime;
    }

    public Statistic delta(Statistic otherStat) {
        if (!this.validate(otherStat)) {
            return null;
        }
        CountStatisticImpl other = (CountStatisticImpl)otherStat;
        CountStatisticImpl newData = new CountStatisticImpl(this.id);
        newData.count = this.count - other.getCount();
        newData.startTime = this.startTime;
        newData.lastSampleTime = this.lastSampleTime;
        return newData;
    }

    public void resetOnClient(Statistic other) {
        if (other == null) {
            if (this.baseValue == null) {
                this.baseValue = new CountStatisticImpl(this.id);
            }
            this.baseValue.set(this.count, this.startTime, this.lastSampleTime);
            this.update(this.baseValue);
        } else if (!this.validate(other)) {
            this.baseValue = (CountStatisticImpl)other;
            this.update(this.baseValue);
        }
    }

    private boolean validate(Statistic other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof CountStatisticImpl)) {
            System.out.println("WARNING: wrong data type: must be CountStatisticImpl");
            return false;
        }
        if (other.getId() != this.id) {
            System.out.println("WARNING: wrong data Id: expect dataId=" + this.id + ", got dataId=" + other.getId());
            return false;
        }
        return true;
    }
}

