/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.pmi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.StrUtils;
import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.extutils.AdminUtil;
import com.ibm.websphere.pmi.extutils.AdminUtilSrvImpl;
import com.ibm.websphere.pmi.extutils.MultipleObjectNamesExistException;
import com.ibm.websphere.pmi.stat.MBeanLevelSpec;
import com.ibm.websphere.pmi.stat.MBeanStatDescriptor;
import com.ibm.websphere.pmi.stat.StatDescriptor;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.server.PerfLevelDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Properties;
import javax.management.ObjectName;

public class PmiJmxMapper
implements PmiConstants {
    private AdminUtil adminUtil = null;
    public static final char seperator = '+';
    public static final String ALLCHILDREN = "ALLCHILDREN";
    private static HashMap mbeanTypeToPmiModuleName = new HashMap();
    private static HashMap PmiModuleNameToMbeanType = new HashMap();
    private static HashMap moduleOnlyMap = new HashMap(20);
    private static HashMap submoduleTable = new HashMap(20);
    private static HashMap beanMap = new HashMap();
    private static final TraceComponent tc = Tr.register(PmiJmxMapper.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    static final int SUBMODULE_LENGTH = 4;

    public PmiJmxMapper(String host, String port, boolean inAppServer) throws Exception {
        this(null, inAppServer, false);
    }

    public PmiJmxMapper(Properties props, boolean inAppServer, boolean useAdminClient) throws Exception {
        try {
            if (tc.isDebugEnabled() && props != null) {
                Tr.debug(tc, "PmiJmxMapper: props=" + props.toString() + ",inserver=" + inAppServer + ",useAdminClient=" + useAdminClient);
            }
            if (useAdminClient) {
                Class<?> adminUtilClass = Class.forName("com.ibm.websphere.pmi.extutils.AdminUtilClntImpl");
                Class[] signature = new Class[]{Properties.class, Boolean.TYPE};
                Constructor<?> constructor = adminUtilClass.getConstructor(signature);
                Object[] params = new Object[]{props, new Boolean(inAppServer)};
                this.adminUtil = (AdminUtil)constructor.newInstance(params);
            } else {
                this.adminUtil = new AdminUtilSrvImpl();
            }
        }
        catch (Exception ex) {
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            FFDCFilter.processException((Throwable)ex, "com.ibm.websphere.pmi.PmiJmxMapper", "63", this);
            if (props != null) {
                Tr.warning(tc, "PMI0004W", " PmiJmxMapper: props=" + props.toString() + ",inAppServer=" + inAppServer + ", useAdminClient=" + useAdminClient + "\n" + sw.toString());
            }
            this.adminUtil = null;
            throw ex;
        }
    }

    public void setMapping(String pmiModuleName, String mbeanType) {
        this.setMapping(pmiModuleName, null, null, mbeanType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMapping(String pmiModuleName, String instanceName, String submoduleName, String mbeanType) {
        HashMap hashMap;
        if (pmiModuleName == null || mbeanType == null) {
            Tr.warning(tc, "PMI0005W", "setMapping");
        }
        String combinedName = null;
        if (submoduleName == null) {
            combinedName = pmiModuleName;
        } else {
            combinedName = pmiModuleName + '+' + submoduleName;
            submoduleTable.put(submoduleName, submoduleName);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "PmiJmxMapping.setMapping: pmiName=" + combinedName + ", mbeanType=" + mbeanType);
        }
        if (!PmiModuleNameToMbeanType.containsKey(combinedName)) {
            hashMap = PmiModuleNameToMbeanType;
            synchronized (hashMap) {
                PmiModuleNameToMbeanType.put(combinedName, mbeanType);
            }
        }
        if (!mbeanTypeToPmiModuleName.containsKey(mbeanType)) {
            hashMap = mbeanTypeToPmiModuleName;
            synchronized (hashMap) {
                mbeanTypeToPmiModuleName.put(mbeanType, combinedName);
            }
        }
    }

    public String getPmiModuleName(ObjectName mName) {
        return this.getPmiModuleName(mName, false);
    }

    public String getPmiModuleName(ObjectName mName, boolean submoduleNeeded) {
        String pmiName;
        if (mName == null) {
            return null;
        }
        String type = mName.getKeyProperty("type");
        if (type.equals("JSP")) {
            type = "Servlet";
        }
        if ((pmiName = (String)mbeanTypeToPmiModuleName.get(type)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.warning(tc, "PMI0002W", mName.toString());
            }
            return null;
        }
        String[] names = StrUtils.split((String)pmiName, (int)43);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getPmiModuleName mName=" + mName.toString() + ", moduleName=" + names[0]);
        }
        if (!submoduleNeeded) {
            return names[0];
        }
        if (names.length >= 2) {
            return names[1];
        }
        return null;
    }

    public String getMBeanType(String moduleName) {
        String mbeanType = (String)PmiModuleNameToMbeanType.get(moduleName);
        if (mbeanType == null) {
            Tr.warning(tc, "PMI0006W", moduleName);
        }
        return mbeanType;
    }

    public String getMBeanType(String[] path) {
        String mbeanType;
        if (path == null || path.length == 0) {
            return null;
        }
        String combinedName = path[0];
        if (path.length >= 4 && submoduleTable.get(path[2]) != null) {
            combinedName = combinedName + '+' + path[2];
        }
        if ((mbeanType = (String)PmiModuleNameToMbeanType.get(combinedName)) == null) {
            Tr.warning(tc, "PMI0006W", PmiJmxMapper.StringArrayToString(path));
        }
        return mbeanType;
    }

    public DataDescriptor getDataDescriptor(ObjectName mName, StatDescriptor sd) {
        return this.getDataDescriptor(new MBeanStatDescriptor(mName, sd));
    }

    public DataDescriptor getDataDescriptor(MBeanStatDescriptor msd) {
        if (msd == null || msd.getObjectName() == null) {
            return null;
        }
        DataDescriptor dd = this.adminUtil.mBeanDescToPmiDesc_get(msd);
        if (dd != null) {
            return dd;
        }
        ObjectName mName = msd.getObjectName();
        StatDescriptor sd = msd.getStatDescriptor();
        String type = mName.getKeyProperty("type");
        String name = mName.getKeyProperty("name");
        String moduleName = this.getPmiModuleName(mName);
        String submoduleName = this.getPmiModuleName(mName, true);
        if (moduleName == null) {
            if (tc.isDebugEnabled()) {
                Tr.warning(tc, "PMI0002W", mName.toString());
            }
            return null;
        }
        String instanceName = name;
        if (type.equals("EJBModule") || type.equals("WebModule")) {
            instanceName = mName.getKeyProperty("Application") + "#" + name;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "mbean=" + mName.toString() + ",moduleName=" + moduleName + ", instanceName=" + instanceName);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "moduleName=" + moduleName + ", instanceName=" + instanceName);
        }
        if (type.equals("Server")) {
            dd = this.getServerDataDescriptor(sd);
            this.setMapping(null, null, dd, msd);
            return dd;
        }
        if (submoduleName != null) {
            String mbeanIdentifier = mName.getKeyProperty("mbeanIdentifier");
            int index = mbeanIdentifier.lastIndexOf(35);
            String pName = null;
            pName = index > 0 ? mbeanIdentifier.substring(0, index) : "unknown";
            dd = new DataDescriptor(new String[]{moduleName, pName, submoduleName, name});
        } else {
            dd = this.isModuleOnlyMapping(moduleName) ? new DataDescriptor(new String[]{moduleName}) : new DataDescriptor(new String[]{moduleName, instanceName});
        }
        if (sd == null || sd.getPath() == null || sd.getPath().length == 0) {
            this.setMapping(null, null, dd, msd);
            return dd;
        }
        int ddLength = dd.getPath().length;
        String[] myPath = new String[ddLength + sd.getPath().length];
        for (int i = 0; i < myPath.length; ++i) {
            if (i < ddLength) {
                myPath[i] = dd.getPath()[i];
                continue;
            }
            if (i < ddLength) continue;
            myPath[i] = sd.getPath()[i - ddLength];
        }
        dd = new DataDescriptor(myPath);
        this.setMapping(null, null, dd, msd);
        return dd;
    }

    private DataDescriptor getServerDataDescriptor(StatDescriptor sd) {
        if (sd == null) {
            return new DataDescriptor(new String[]{"pmi"});
        }
        String[] path = sd.getPath();
        if (path == null || path.length == 0) {
            return null;
        }
        return new DataDescriptor(path);
    }

    public DataDescriptor[] getDataDescriptors(ObjectName[] mNames, StatDescriptor[] sds) {
        if (mNames == null) {
            return null;
        }
        int numSds = 0;
        if (sds != null) {
            numSds = sds.length;
        }
        DataDescriptor[] dds = new DataDescriptor[mNames.length];
        for (int i = 0; i < mNames.length; ++i) {
            dds[i] = i < numSds ? this.getDataDescriptor(mNames[i], sds[i]) : this.getDataDescriptor(mNames[i], null);
        }
        return dds;
    }

    public DataDescriptor[] getDataDescriptors(MBeanStatDescriptor[] msds) {
        if (msds == null || msds.length == 0) {
            return null;
        }
        DataDescriptor[] dds = new DataDescriptor[msds.length];
        for (int i = 0; i < msds.length; ++i) {
            dds[i] = msds[i] == null ? null : this.getDataDescriptor(msds[i]);
        }
        return dds;
    }

    private ObjectName descToObjectNameMapping(DataDescriptor dd, String nodeName, String serverName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "descToObjectNameMapping");
        }
        if (dd == null) {
            return null;
        }
        String mbeanType = this.getMBeanType(dd.getPath());
        String moduleName = dd.getModuleName();
        String[] ddPath = dd.getPath();
        String name = dd.getName();
        if (ddPath.length >= 2) {
            name = ddPath[1];
        }
        boolean isSubmodule = false;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "descToObjectNameMapping: moduleName=" + moduleName + ", mbeanType is " + mbeanType);
        }
        if (ddPath.length >= 4 && submoduleTable.get(ddPath[2]) != null) {
            isSubmodule = true;
        }
        if (moduleName.equals("beanModule")) {
            if (ddPath.length > 1) {
                String appModuleName = ddPath[1];
                int index = appModuleName.indexOf(35);
                name = appModuleName.substring(index + 1);
            }
        } else if (moduleName.equals("connectionPoolModule") || moduleName.equals("j2cModule")) {
            if (ddPath != null && ddPath.length >= 2) {
                name = ddPath[1];
            }
            if (name.equals("jmsConnections")) {
                ObjectName srv = this.findObjectName(null, "Server", nodeName, serverName);
                return srv;
            }
        }
        ObjectName mName = null;
        if (this.isModuleOnlyMapping(moduleName)) {
            mName = this.findObjectName(null, mbeanType, nodeName, serverName);
        } else if (dd.getType() == 13) {
            mName = this.findObjectName(null, "Server", nodeName, serverName);
        } else if (mbeanType == null) {
            mName = this.findObjectName(name, null, nodeName, serverName);
        } else if (mbeanType.equals("Servlet") || mbeanType.equals("EntityBean") || mbeanType.equals("StatefulSessionBean") || mbeanType.equals("StatelessSessionBean") || mbeanType.equals("MessageDrivenBean")) {
            mName = this.findObjectName(ddPath[1] + "#" + ddPath[3], nodeName, serverName);
            if (mName == null) {
                mbeanType = mbeanType.equals("Servlet") ? "WebModule" : "EJBModule";
                mName = this.findObjectName(name, mbeanType, nodeName, serverName);
            }
        } else {
            mName = isSubmodule ? this.findObjectName(ddPath[3], mbeanType, nodeName, serverName) : this.findObjectName(name, mbeanType, nodeName, serverName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "descToObjectNameMapping");
        }
        return mName;
    }

    public MBeanStatDescriptor getMBeanStatDescriptor(DataDescriptor dd) {
        return this.getMBeanStatDescriptor(dd, null, null);
    }

    public MBeanStatDescriptor getMBeanStatDescriptor(DataDescriptor origdd, String nodeName, String serverName) {
        MBeanStatDescriptor mymsd;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMBeanStatDescriptor(dd, ...)");
        }
        DataDescriptor dd = origdd;
        if (origdd == null) {
            ObjectName mName = this.findObjectName(null, "Server", nodeName, serverName);
            dd = this.getServerDataDescriptor(null);
            MBeanStatDescriptor msd = new MBeanStatDescriptor(mName, null);
            this.setMapping(nodeName, serverName, dd, msd);
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getMBeanStatDescriptor(dd, ...) - server DD");
            }
            return msd;
        }
        if (origdd.getDataIds() != null) {
            dd = new DataDescriptor(origdd.getPath());
        }
        if ((mymsd = this.adminUtil.pmiDescToMBeanDesc_get(nodeName, serverName, dd)) != null) {
            return mymsd;
        }
        ObjectName mName = this.descToObjectNameMapping(dd, nodeName, serverName);
        if (mName == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot find ObjectName for dd=" + dd.toString());
            }
            return null;
        }
        MBeanStatDescriptor msd = this.getMBeanStatDescriptor(mName, dd, nodeName, serverName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMBeanStatDescriptor(dd, ...) - not in hashmap");
        }
        return msd;
    }

    public MBeanStatDescriptor getMBeanStatDescriptor(ObjectName mName, DataDescriptor dd) {
        return this.getMBeanStatDescriptor(mName, dd, null, null);
    }

    public MBeanStatDescriptor getMBeanStatDescriptor(ObjectName mName, DataDescriptor dd, String nodeName, String serverName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMBeanStatDescriptor(ObjectName, dd, ...)");
        }
        if (mName == null) {
            mName = this.descToObjectNameMapping(dd, nodeName, serverName);
        }
        if (mName == null) {
            Tr.warning(tc, "PMI0006W", dd.toString());
            return null;
        }
        if (dd == null || dd.getPath() == null || dd.getPath().length == 0) {
            return new MBeanStatDescriptor(mName, null);
        }
        String[] ddPath = dd.getPath();
        if (ddPath.length == 1 && ddPath[0].equals("pmi")) {
            return new MBeanStatDescriptor(mName, null);
        }
        MBeanStatDescriptor mymsd = this.adminUtil.pmiDescToMBeanDesc_get(nodeName, serverName, dd);
        if (mymsd != null) {
            return mymsd;
        }
        String type = mName.getKeyProperty("type");
        String moduleName = dd.getModuleName();
        StatDescriptor sd = null;
        DataDescriptor basedd = this.getDataDescriptor(mName, null);
        if (basedd == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No PMI Module mapping found for mbean type: " + mName.getKeyProperty("type"));
            }
            return null;
        }
        String[] baseddPath = basedd.getPath();
        if (baseddPath == null || baseddPath.length == 0 || baseddPath[0].equals("pmi")) {
            sd = new StatDescriptor(ddPath);
        } else if (baseddPath.length == ddPath.length) {
            sd = null;
        } else if (ddPath == null || ddPath.length == 0) {
            Tr.warning(tc, "PMI0001W", "getMBeanStatDescriptor");
        } else {
            String[] subPath = new String[ddPath.length - baseddPath.length];
            System.arraycopy(ddPath, baseddPath.length, subPath, 0, subPath.length);
            sd = new StatDescriptor(subPath);
        }
        MBeanStatDescriptor msd = new MBeanStatDescriptor(mName, sd);
        this.setMapping(nodeName, serverName, dd, msd);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMBeanStatDescriptor(ObjectName, dd, ...)");
        }
        return msd;
    }

    public MBeanStatDescriptor[] getMBeanStatDescriptors(DataDescriptor[] dds) {
        return this.getMBeanStatDescriptors(dds, null, null);
    }

    public MBeanStatDescriptor[] getMBeanStatDescriptors(DataDescriptor[] dds, String nodeName, String serverName) {
        if (dds == null) {
            return null;
        }
        MBeanStatDescriptor[] msds = new MBeanStatDescriptor[dds.length];
        for (int i = 0; i < dds.length; ++i) {
            msds[i] = this.getMBeanStatDescriptor(dds[i], nodeName, serverName);
        }
        return msds;
    }

    public synchronized void setBeanMapping(String beanName, String beanType) {
        beanMap.put(beanName, beanType);
    }

    public String getBeanType(String beanName) {
        return (String)beanMap.get(beanName);
    }

    public MBeanLevelSpec getMBeanLevelSpec(PerfLevelDescriptor pld) {
        return this.getMBeanLevelSpec(pld, null, null);
    }

    public MBeanLevelSpec getMBeanLevelSpec(PerfLevelDescriptor pld, String nodeName, String serverName) {
        if (pld == null) {
            return null;
        }
        String[] path = pld.getPath();
        DataDescriptor dd = null;
        if (!path[0].equals("pmi")) {
            dd = new DataDescriptor(path);
        } else if (path.length > 1) {
            String[] newPath = new String[path.length - 1];
            System.arraycopy(path, 1, newPath, 0, newPath.length);
            dd = new DataDescriptor(newPath);
        }
        MBeanStatDescriptor msd = this.getMBeanStatDescriptor(dd, nodeName, serverName);
        return new MBeanLevelSpec(msd.getObjectName(), msd.getStatDescriptor(), pld.getLevel());
    }

    public PerfLevelDescriptor getPerfLevelDescriptor(MBeanLevelSpec mls) {
        DataDescriptor dd = this.getDataDescriptor(mls.getObjectName(), mls.getStatDescriptor());
        if (dd == null) {
            return null;
        }
        return new PerfLevelDescriptor(dd.getPath(), mls.getLevel());
    }

    public ObjectName findObjectName(String name, String type, String nodeName, String serverName) {
        if (this.adminUtil == null) {
            return null;
        }
        try {
            return this.adminUtil.findObjectName(name, type, nodeName, serverName);
        }
        catch (MultipleObjectNamesExistException mone) {
            FFDCFilter.processException((Throwable)mone, "com.ibm.websphere.pmi.findObjectName", "462", this);
            Tr.error(tc, "PMI0003W", "type=" + type + ",name=" + name);
            return null;
        }
    }

    public ObjectName findObjectName(String mbeanIdentifier, String nodeName, String serverName) {
        if (this.adminUtil == null) {
            return null;
        }
        return this.adminUtil.findObjectName(mbeanIdentifier, nodeName, serverName);
    }

    public ObjectName[] findObjectNames(String name, String type, String nodeName, String serverName) {
        if (this.adminUtil == null) {
            return null;
        }
        return this.adminUtil.findObjectNames(name, type, nodeName, serverName);
    }

    public Object getAttribute(ObjectName oName, String attributeName) {
        if (this.adminUtil == null) {
            return null;
        }
        return this.adminUtil.getAttribute(oName, attributeName);
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) {
        return this.adminUtil.invoke(name, operationName, params, signature);
    }

    public AdminUtil getAdminUtil() {
        return this.adminUtil;
    }

    public static String StringArrayToString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(31);
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModuleOnlyMapping(String moduleName, String mbeanType) {
        if (moduleName == null || mbeanType == null) {
            Tr.warning(tc, "PMI0005W", "setModuleOnlyMapping");
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "moduleOnlyMapping: module=" + moduleName + ", mbean=" + mbeanType);
            }
            HashMap hashMap = moduleOnlyMap;
            synchronized (hashMap) {
                moduleOnlyMap.put(moduleName, mbeanType);
            }
        }
    }

    public boolean isModuleOnlyMapping(String moduleName) {
        return moduleOnlyMap.containsKey(moduleName);
    }

    private String getEJBModuleName(String uniqueName) {
        int index = uniqueName.lastIndexOf(35);
        return uniqueName.substring(0, index);
    }

    public void setMapping(String nodeName, String serverName, DataDescriptor dd, MBeanStatDescriptor msd) {
        this.adminUtil.setMapping(nodeName, serverName, dd, msd);
    }

    static {
        beanMap.put("EntityBean", "ejb.entity");
        beanMap.put("StatefulSessionBean", "ejb.stateful");
        beanMap.put("StatelessSessionBean", "ejb.stateless");
        beanMap.put("MessageDrivenBean", "ejb.messageDriven");
    }
}

