/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.naming;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.naming.HostnameNormalizer;
import com.ibm.websphere.naming.WsnBatchCompleteResults;
import com.ibm.websphere.naming.WsnBatchModeContext;
import com.ibm.websphere.naming.WsnBatchResult;
import com.ibm.websphere.naming.WsnOptimizedJndiContext;
import com.ibm.ws.naming.jbatch.BatchModeNotSupported;
import com.ibm.ws.naming.util.CommonHelpers;
import com.ibm.ws.naming.util.NameFormatHelper;
import com.ibm.ws.naming.util.RasUtil;
import com.ibm.ws.security.util.AccessController;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingException;
import javax.naming.NotContextException;

public class JndiHelper {
    private static final TraceComponent _tc = Tr.register(JndiHelper.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String CLASS_NAME;
    private static HostnameNormalizer _hostnameNormalizer;

    protected JndiHelper() {
    }

    public static Context recursiveCreateSubcontext(Context startingContext, String name) throws NamingException {
        NameParser parser2 = startingContext.getNameParser("");
        Name n = parser2.parse(name);
        return JndiHelper.recursiveCreateSubcontext(startingContext, n);
    }

    public static Context recursiveCreateSubcontext(Context startingContext, Name name) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "recursiveCreateSubcontext", new String[]{"startingContext=" + startingContext, "name=" + name});
        }
        Context retCtx = null;
        boolean useBatch = false;
        WsnBatchModeContext batchCtx = null;
        startingContext = (Context)CommonHelpers.extractCtxImplFromInitCtx(startingContext);
        try {
            Context urlCtx = CommonHelpers.getContextIfUrlName(name, startingContext.getEnvironment());
            if (urlCtx != null) {
                startingContext = urlCtx;
                NameParser parser2 = urlCtx.getNameParser("");
                String scheme = NameFormatHelper.getUrlScheme(name);
                String nameString = name.toString();
                nameString = nameString.substring(scheme.length() + 1);
                name = parser2.parse(nameString);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "recursiveCreateSubcontext", "URL name: new starting context=" + startingContext.getNameInNamespace() + ", nameString=" + nameString);
                }
            }
        }
        catch (NamingException e) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "recursiveCreateSubcontext", "Could not process URL.  Rethrowing NamingException: " + e);
            }
            throw e;
        }
        if (startingContext instanceof WsnBatchModeContext) {
            batchCtx = (WsnBatchModeContext)startingContext;
            startingContext = batchCtx.getNonBatchModeContext();
        }
        if (startingContext instanceof WsnOptimizedJndiContext && !((WsnOptimizedJndiContext)((Object)startingContext)).isLocal()) {
            useBatch = true;
            if (batchCtx == null) {
                try {
                    batchCtx = ((WsnOptimizedJndiContext)((Object)startingContext)).getBatchModeContext();
                }
                catch (BatchModeNotSupported e) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "recursiveCreateSubcontext", new Object[]{"Batch mode not supported", e});
                    }
                    batchCtx = null;
                    useBatch = false;
                }
            }
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "recursiveCreateSubcontext", "useBatch=" + useBatch);
        }
        if (useBatch) {
            JndiHelper.batchCreateSubcontextsDriver(batchCtx, name);
            WsnBatchCompleteResults bcr = batchCtx.executeBatchedOperations();
            Enumeration<WsnBatchResult> vEnum = bcr.getResultEnumeration();
            retCtx = JndiHelper.getSubcontextFromBatchResults(startingContext, vEnum, name.size());
        } else {
            retCtx = JndiHelper.createSubcontextsDriver(startingContext, name);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "recursiveCreateSubcontext", retCtx);
        }
        return retCtx;
    }

    protected static void batchCreateSubcontextsDriver(WsnBatchModeContext startingContext, Name name) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "batchCreateSubcontextsDriver", new String[]{"startingContext=" + startingContext, "name=" + name});
        }
        Name namePrefix = null;
        startingContext.lookup(name);
        for (int i = 1; i <= name.size(); ++i) {
            namePrefix = name.getPrefix(i);
            startingContext.createSubcontext(namePrefix);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "batchCreateSubcontextsDriver");
        }
    }

    protected static Context createSubcontextsDriver(Context startingContext, Name name) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createSubcontextsDriver", new String[]{"startingContext=" + startingContext, "name=" + name});
        }
        Context retCtx = null;
        retCtx = JndiHelper.createSubcontexts(startingContext, name);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createSubcontextsDriver", retCtx);
        }
        return retCtx;
    }

    private static Context createSubcontexts(Context startingContext, Name name) throws NamingException {
        Context newSubcontext;
        block9: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "createSubcontexts", new String[]{"startingContext=" + startingContext, "name=" + name});
            }
            newSubcontext = null;
            try {
                newSubcontext = startingContext.createSubcontext(name);
            }
            catch (NameAlreadyBoundException e) {
                Object o;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "createSubcontexts", "caught NameAlreadyBoundException: " + e);
                }
                if (!((o = startingContext.lookup(name)) instanceof Context)) {
                    NotContextException nce = new NotContextException("Name \"" + name + "\", relative to context \"" + startingContext.getNameInNamespace() + "\" is already bound to an object which is not a context.");
                    nce.initCause(e);
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "createSubcontexts", "Throwing NotContextException: " + nce);
                    }
                    throw nce;
                }
                newSubcontext = (Context)o;
            }
            catch (NameNotFoundException e) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "createSubcontexts", "caught NameNotFoundException: " + e);
                }
                if (name.size() <= 1) break block9;
                Name namePrefix = name.getPrefix(name.size() - 1);
                newSubcontext = JndiHelper.createSubcontexts(startingContext, namePrefix);
                newSubcontext = startingContext.createSubcontext(name);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createSubcontexts", newSubcontext);
        }
        return newSubcontext;
    }

    public static void recursiveRebind(Context startingContext, String name, Object obj) throws NamingException {
        NameParser parser2 = startingContext.getNameParser("");
        Name n = parser2.parse(name);
        JndiHelper.recursiveBind(startingContext, n, obj, Operation.REBIND);
    }

    public static void recursiveRebind(Context startingContext, Name name, Object obj) throws NamingException {
        JndiHelper.recursiveBind(startingContext, name, obj, Operation.REBIND);
    }

    public static void recursiveBind(Context startingContext, String name, Object obj) throws NamingException {
        NameParser parser2 = startingContext.getNameParser("");
        Name n = parser2.parse(name);
        JndiHelper.recursiveBind(startingContext, n, obj, Operation.BIND);
    }

    public static void recursiveBind(Context startingContext, Name name, Object obj) throws NamingException {
        JndiHelper.recursiveBind(startingContext, name, obj, Operation.BIND);
    }

    private static void recursiveBind(Context startingContext, Name name, Object obj, Operation operation) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "recursiveBind", new String[]{"startingContext=" + startingContext, "name=" + name, "obj=" + obj, "operation=" + (Object)((Object)operation)});
        }
        boolean useBatch = false;
        WsnBatchModeContext batchCtx = null;
        startingContext = (Context)CommonHelpers.extractCtxImplFromInitCtx(startingContext);
        try {
            Context urlCtx = CommonHelpers.getContextIfUrlName(name, startingContext.getEnvironment());
            if (urlCtx != null) {
                startingContext = urlCtx;
                NameParser parser2 = urlCtx.getNameParser("");
                String scheme = NameFormatHelper.getUrlScheme(name);
                String nameString = name.toString();
                nameString = nameString.substring(scheme.length() + 1);
                name = parser2.parse(nameString);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "recursiveBind", "URL name: new starting context=" + startingContext.getNameInNamespace() + ", name=" + nameString);
                }
            }
        }
        catch (NamingException e) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "recursiveBind", "Could not process URL.  Rethrowing NamingException: " + e);
            }
            throw e;
        }
        if (startingContext instanceof WsnBatchModeContext) {
            batchCtx = (WsnBatchModeContext)startingContext;
            startingContext = batchCtx.getNonBatchModeContext();
        }
        if (startingContext instanceof WsnOptimizedJndiContext && !((WsnOptimizedJndiContext)((Object)startingContext)).isLocal()) {
            useBatch = true;
            if (batchCtx == null) {
                try {
                    batchCtx = ((WsnOptimizedJndiContext)((Object)startingContext)).getBatchModeContext();
                }
                catch (BatchModeNotSupported e) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "recursiveBind", new Object[]{"Batch mode not supported", e});
                    }
                    batchCtx = null;
                    useBatch = false;
                }
            }
        }
        Name namePrefix = name.getPrefix(name.size() - 1);
        Context retCtx = null;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "recursiveBind", "useBatch=" + useBatch);
        }
        if (useBatch) {
            WsnBatchResult result;
            if (namePrefix.size() > 0) {
                JndiHelper.batchCreateSubcontextsDriver(batchCtx, namePrefix);
            }
            if (operation == Operation.BIND) {
                batchCtx.bind(name, obj);
            } else {
                batchCtx.rebind(name, obj);
            }
            WsnBatchCompleteResults bcr = batchCtx.executeBatchedOperations();
            Enumeration<WsnBatchResult> vEnum = bcr.getResultEnumeration();
            if (namePrefix.size() > 0) {
                retCtx = JndiHelper.getSubcontextFromBatchResults(startingContext, vEnum, namePrefix.size());
            }
            if (!(result = vEnum.nextElement()).getResult()) {
                throw result.getException();
            }
        } else {
            if (namePrefix.size() > 0) {
                retCtx = JndiHelper.createSubcontextsDriver(startingContext, namePrefix);
            }
            if (operation == Operation.BIND) {
                startingContext.bind(name, obj);
            } else {
                startingContext.rebind(name, obj);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "recursiveBind");
        }
    }

    protected static Context getSubcontextFromBatchResults(Context startingContext, Enumeration vEnum, int numCtx) throws NamingException {
        Context retCtx = null;
        WsnBatchResult result = (WsnBatchResult)vEnum.nextElement();
        if (result.getResult()) {
            Object obj = result.getOutputObject();
            if (!(obj instanceof Context)) {
                throw new NotContextException("Name \"" + result.getName() + "\", relative to context \"" + startingContext.getNameInNamespace() + "\" is already bound to an object which is not a context.");
            }
            retCtx = (Context)obj;
            for (int i = 0; i < numCtx; ++i) {
                result = (WsnBatchResult)vEnum.nextElement();
            }
            return retCtx;
        }
        for (int countCtx = 0; vEnum.hasMoreElements() && countCtx < numCtx; ++countCtx) {
            result = (WsnBatchResult)vEnum.nextElement();
            if (result.getResult()) continue;
            NamingException nex = result.getException();
            if (nex instanceof NameAlreadyBoundException) continue;
            throw nex;
        }
        return retCtx;
    }

    public static String normalizeHostname(Hashtable env) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "normalizeHostname", "env=" + env);
        }
        if (env == null) {
            env = CommonHelpers.getWsnJndiProperties();
        }
        JndiHelper.initializeHostnameNormalizer(env);
        boolean escapeDots = JndiHelper.needToEscapeDots(env);
        String retval = _hostnameNormalizer.normalizeHostname(escapeDots);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "normalizeHostname", retval);
        }
        return retval;
    }

    public static String normalizeHostname(Hashtable env, String hostname) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "normalizeHostname", new String[]{"env=" + env, "hostname=" + hostname});
        }
        if (hostname == null) {
            JndiHelper.nullParam("normalizeHostname", "hostname");
        }
        if (env == null) {
            env = CommonHelpers.getWsnJndiProperties();
        }
        JndiHelper.initializeHostnameNormalizer(env);
        boolean escapeDots = JndiHelper.needToEscapeDots(env);
        String retval = _hostnameNormalizer.normalizeHostname(escapeDots, hostname);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "normalizeHostname", retval);
        }
        return retval;
    }

    public static String normalizeHostname(Hashtable env, InetAddress ipAddress) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "normalizeHostname", new String[]{"env=" + env, "ipAddress=" + ipAddress});
        }
        if (ipAddress == null) {
            JndiHelper.nullParam("normalizeHostname", "ipAddress");
        }
        if (env == null) {
            env = CommonHelpers.getWsnJndiProperties();
        }
        JndiHelper.initializeHostnameNormalizer(env);
        boolean escapeDots = JndiHelper.needToEscapeDots(env);
        String retval = _hostnameNormalizer.normalizeHostname(escapeDots, ipAddress);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "normalizeHostname", retval);
        }
        return retval;
    }

    private static Hashtable nullParam(String method2, String param) throws NamingException {
        String cause = "Parameter \"" + param + "\" is null.  Null is not a valid value for this call.";
        NamingException ne = new NamingException(cause);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, method2, ne);
        }
        throw ne;
    }

    private static boolean needToEscapeDots(Hashtable env) throws NamingException {
        Object o;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "needToEscapeDots");
        }
        if (!((o = env.get("com.ibm.websphere.naming.name.syntax")) instanceof String)) {
            String cause = "Failed to get com.ibm.websphere.naming.name.syntax from environment.  Please ensure that the environment parameter  has been obtained by a getEnvironment() call on a valid Context. ";
            NamingException ne = new NamingException(cause);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "needToExcapeDots", ne);
            }
            throw ne;
        }
        String syntax = (String)o;
        boolean retval = syntax.equals("ins");
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "needToEscapeDots", Boolean.toString(retval));
        }
        return retval;
    }

    private static void initializeHostnameNormalizer(Hashtable env) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "initializeHostnameNormalizer");
        }
        if (_hostnameNormalizer == null) {
            String cause;
            Object o = env.get("com.ibm.websphere.naming.hostname.normalizer");
            if (!(o instanceof String)) {
                String cause2 = "Failed to get com.ibm.websphere.naming.hostname.normalizer from environment.  Please ensure that the environment parameter  has been obtained by a getEnvironment() call on a valid Context. ";
                NamingException ne = new NamingException(cause2);
                if (_tc.isDebugEnabled()) {
                    Tr.exit(_tc, "initializeHostnameNormalizer", ne);
                }
                throw ne;
            }
            String normalizerName = (String)o;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "initializeHostnameNormalizer", "normalizerName=" + normalizerName);
            }
            Throwable throwable = null;
            Class normalizerClass = null;
            try {
                final String tmpName = normalizerName;
                try {
                    normalizerClass = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception, LinkageError {
                            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                            if (contextClassLoader == null) {
                                throw new NullPointerException("Context class loader is null");
                            }
                            return Class.forName(tmpName, true, contextClassLoader);
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    throw pae.getException();
                }
            }
            catch (Exception e) {
                throwable = e;
            }
            catch (LinkageError e) {
                throwable = e;
            }
            if (throwable != null) {
                RasUtil.logException(throwable, _tc, CLASS_NAME, "initializeHostnameNormalizer", "917");
                Tr.warning(_tc, "cannotGetClassObj", normalizerName);
                cause = "Failed to create Class object for the class " + normalizerName + ".";
                NamingException ne = new NamingException(cause + "Please get the root cause Throwable contained in this NamingException " + "for more information.");
                ne.initCause(throwable);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "initializeHostnameNormalizer", ne);
                }
                throw ne;
            }
            try {
                Constructor implConstructor = normalizerClass.getConstructor(null);
                Object obj = implConstructor.newInstance(null);
                _hostnameNormalizer = (HostnameNormalizer)obj;
            }
            catch (Exception e) {
                throwable = e;
            }
            catch (LinkageError e) {
                throwable = e;
            }
            if (throwable != null) {
                RasUtil.logException(throwable, _tc, CLASS_NAME, "initializeHostnameNormalizer", "947");
                Tr.warning(_tc, "cannotCreateObj", normalizerName);
                cause = "Could not create an instance of the class " + normalizerName + ".";
                NamingException ne = new NamingException(cause + "Please get the root cause Throwable contained in this NamingException " + "for more information.");
                ne.initCause(throwable);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "initializeHostnameNormalizer", ne);
                }
                throw ne;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "initializeHostnameNormalizer");
        }
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming/src/com/ibm/websphere/naming/JndiHelper.java, WAS.naming, WAS70.SERV1, q0834.18, ver. 1.39");
        }
        CLASS_NAME = JndiHelper.class.getName();
        _hostnameNormalizer = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Operation {
        BIND,
        REBIND,
        CREATE_SUBCONTEXT;

    }
}

