/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.models.extensions.helpers.impl;

import com.ibm.ejs.models.base.bindings.init.BindingsInit;
import com.ibm.ejs.models.base.extensions.init.ExtensionsInit;
import com.ibm.websphere.models.extensions.helpers.impl.ResourceAndExtent;
import com.ibm.websphere.models.extensions.init.PMEClientInit;
import java.io.FileNotFoundException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DuplicateObjectException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ResourceLoadException;

public class PMEClientHelperUtils {
    private static boolean initialized = false;

    public static void init() {
        if (!initialized) {
            BindingsInit.init();
            ExtensionsInit.init();
            PMEClientInit.init();
            initialized = true;
        }
    }

    public static ResourceAndExtent getResourceAndExtent(Archive archive, String uriString, boolean tocreate) {
        ResourceAndExtent result;
        block14: {
            result = new ResourceAndExtent();
            try {
                result.resource = archive.getMofResource(uriString);
                if (result.resource != null) {
                    result.extent = result.resource.getContents();
                }
            }
            catch (FileNotFoundException ex) {
                if (!tocreate) break block14;
                try {
                    result.resource = archive.makeMofResource(uriString);
                    if (result.resource != null) {
                        result.extent = result.resource.getContents();
                    }
                }
                catch (DuplicateObjectException doe) {}
            }
            catch (ResourceLoadException ex) {
                if (!tocreate) break block14;
                try {
                    result.resource = archive.makeMofResource(uriString);
                    if (result.resource != null) {
                        result.extent = result.resource.getContents();
                    }
                }
                catch (DuplicateObjectException doe) {}
            }
            catch (RuntimeException ex) {
                if (!tocreate) break block14;
                try {
                    result.resource = archive.makeMofResource(uriString);
                    if (result.resource != null) {
                        result.extent = result.resource.getContents();
                    }
                }
                catch (DuplicateObjectException doe) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    public static ResourceAndExtent getResourceAndExtent(ResourceSet resourceSet, String uriString, boolean tocreate) {
        ResourceAndExtent result = new ResourceAndExtent();
        URI uri = URI.createURI(uriString);
        result.resource = resourceSet.getResource(uri, tocreate);
        if (result.resource != null) {
            result.extent = result.resource.getContents();
        }
        return result;
    }
}

