/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.models.config.multibroker.drsclient;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class DRSRuntimeMode
extends AbstractEnumerator {
    public static final int BOTH = 0;
    public static final int CLIENT = 1;
    public static final int SERVER = 2;
    public static final DRSRuntimeMode BOTH_LITERAL = new DRSRuntimeMode(0, "BOTH", "BOTH");
    public static final DRSRuntimeMode CLIENT_LITERAL = new DRSRuntimeMode(1, "CLIENT", "CLIENT");
    public static final DRSRuntimeMode SERVER_LITERAL = new DRSRuntimeMode(2, "SERVER", "SERVER");
    private static final DRSRuntimeMode[] VALUES_ARRAY = new DRSRuntimeMode[]{BOTH_LITERAL, CLIENT_LITERAL, SERVER_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static DRSRuntimeMode get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            DRSRuntimeMode result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static DRSRuntimeMode getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            DRSRuntimeMode result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static DRSRuntimeMode get(int value) {
        switch (value) {
            case 0: {
                return BOTH_LITERAL;
            }
            case 1: {
                return CLIENT_LITERAL;
            }
            case 2: {
                return SERVER_LITERAL;
            }
        }
        return null;
    }

    private DRSRuntimeMode(int value, String name, String literal) {
        super(value, name, literal);
    }
}

