/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.repository.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.client.ConfigRepositoryClient;
import com.ibm.ws.util.ImplFactory;
import java.util.Properties;

public class ConfigRepositoryClientFactory {
    private static TraceComponent tc = Tr.register(ConfigRepositoryClientFactory.class, "ConfigRepositoryClientFactory", "com.ibm.ws.management.resources.repository");

    public static ConfigRepository getConfigRepositoryClient(Properties rProps) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigRepositoryClient");
        }
        ConfigRepositoryClient client = null;
        if (rProps.getProperty("location") == null) {
            throw new AdminException("Repository location not specified in properties.");
        }
        try {
            String location = rProps.getProperty("location");
            client = (ConfigRepositoryClient)ImplFactory.loadImplFromKey(ConfigRepositoryClient.class.getName() + "." + location);
            client.connect(rProps);
        }
        catch (Exception ex) {
            throw new AdminException(ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigRepositoryClient", client);
        }
        return client;
    }
}

