/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.filetransfer.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.RepositoryInputStream;
import com.ibm.ws.management.repository.TempFileInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Properties;

public class FileUploadInputStream
extends RepositoryInputStream
implements Serializable {
    private static final long serialVersionUID = 6521346973672853614L;
    private static TraceComponent tc = Tr.register(FileUploadInputStream.class, "Admin", "com.ibm.ws.management.resources.fileservice");
    private transient boolean connected = false;
    boolean delete = true;

    public FileUploadInputStream() {
    }

    public FileUploadInputStream(String srcPath) {
        this();
        this.setSrcPath(srcPath);
    }

    public InputStream getStream() throws FileNotFoundException {
        try {
            this.connect();
        }
        catch (IOException ex) {
            throw new FileNotFoundException(ex.toString());
        }
        if (this.remoteStream == null) {
            this.remoteStream = this.delete ? new TempFileInputStream(this.tempfile) : new FileInputStream(this.tempfile);
        }
        return this.remoteStream;
    }

    public void connect() throws IOException {
        if (this.remoteStream == null && !this.connected) {
            String tempDir = null;
            ConfigRepository repository2 = ConfigRepositoryFactory.getConfigRepository();
            Properties repositoryProps = repository2.getConfig();
            tempDir = repositoryProps.getProperty("was.repository.temp");
            if (tempDir == null) {
                throw new IOException("Repository Temporary Directory can not be determined.");
            }
            String path = tempDir + File.separator + this.srcPath;
            path = File.separator.equals("/") ? path.replace('\\', '/') : path.replace('/', '\\');
            this.tempfile = new File(path);
            this.connected = true;
        }
    }

    public boolean getDelete() {
        return this.delete;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            out.defaultWriteObject();
        }
        catch (IOException e) {
            Manager.Ffdc.log(e, this, "com.ibm.websphere.management.filetransfer.client.FileUploadInputStream.writeObject", "239", this);
            Tr.service(tc, "ADFS0119", e);
            throw e;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, AdminException {
        try {
            in.defaultReadObject();
            this.connected = false;
        }
        catch (IOException e) {
            Manager.Ffdc.log(e, this, "com.ibm.websphere.management.filetransfer.client.FileUploadInputStream.readObject", "252", this);
            Tr.service(tc, "ADFS0119", e);
            throw e;
        }
    }
}

