/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.configservice.tasks;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementProxy;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.websphere.management.exception.AppRefException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.InvalidRAScopeException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class UninstallRARTask {
    private final String DOMAIN = "WebSphere";
    private final int CELL_LEVEL = 1;
    private final int NODE_LEVEL = 2;
    private final int SERVER_LEVEL = 3;
    private static TraceComponent tc = Tr.register(UninstallRARTask.class, "management", "com.ibm.ws.management.resources.configservice");
    private ConfigService configService;

    public UninstallRARTask(ConfigService configService) {
        this.configService = configService;
    }

    public List uninstallResourceAdapter(Session session, ObjectName on, Hashtable options) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "uninstallResourceAdapter", new Object[]{session, on, options});
        }
        AdminClient client = null;
        AdminService adminService = null;
        if (this.configService instanceof ConfigServiceProxy) {
            ConfigServiceProxy proxy = (ConfigServiceProxy)this.configService;
            client = proxy.getAdminClient();
        } else {
            adminService = AdminServiceFactory.getAdminService();
            if (adminService == null) {
                String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0036E", new Object[]{"uninstallResourceAdapter"}, null);
                throw new UnsupportedOperationException(msg);
            }
        }
        boolean force = false;
        String ss = (String)options.get("force");
        if (ss != null) {
            force = true;
        }
        String orgPath = (String)this.configService.getAttribute(session, on, "archivePath");
        Properties prop = ConfigServiceHelper.getObjectLocation(on);
        String server = prop.getProperty("server");
        String node = prop.getProperty("node");
        String cell = prop.getProperty("cell");
        String scope = "Cell";
        if (server != null) {
            scope = "Server";
            String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0040E", new Object[]{ConfigServiceHelper.getDisplayName(on), scope}, null);
            throw new InvalidRAScopeException(scope, msg);
        }
        if (node == null) {
            String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0040E", new Object[]{ConfigServiceHelper.getDisplayName(on), scope}, null);
            throw new InvalidRAScopeException(scope, msg);
        }
        String aPath = null;
        ObjectName ton = null;
        ObjectName cellObj = null;
        ObjectName nodeObj = null;
        nodeObj = this.configService.getRelationship(session, on, "parent")[0];
        cellObj = this.configService.getRelationship(session, nodeObj, "parent")[0];
        ObjectName[] raList = this.configService.getRelationship(session, cellObj, "J2CResourceAdapter");
        for (int i = 0; i < raList.length; ++i) {
            ton = raList[i];
            aPath = (String)this.configService.getAttribute(session, ton, "archivePath");
            if (!aPath.equals(orgPath)) continue;
            if (force) {
                Tr.warning(tc, "ADMG0038W", "Cell");
                continue;
            }
            String msg = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0041E", new Object[]{ConfigServiceHelper.getDisplayName(on)}, null);
            throw new InvalidRAScopeException(ConfigServiceHelper.getDisplayName(on), msg);
        }
        ArrayList<ObjectName> oList = new ArrayList<ObjectName>();
        ArrayList<String> jndiList = new ArrayList<String>(20);
        ArrayList<String> mList = new ArrayList<String>(10);
        raList = this.configService.getRelationship(session, nodeObj, "J2CResourceAdapter");
        for (int j = 0; j < raList.length; ++j) {
            ton = raList[j];
            aPath = (String)this.configService.getAttribute(session, ton, "archivePath");
            if (!aPath.equals(orgPath)) continue;
            oList.add(ton);
        }
        ObjectName[] sList = this.configService.getRelationship(session, nodeObj, "Server");
        if (sList != null) {
            ObjectName serverObj = null;
            for (int i = 0; i < sList.length; ++i) {
                serverObj = sList[i];
                this.checkRAinObject(session, serverObj, oList, orgPath);
            }
        }
        for (int indx = 0; indx < oList.size(); ++indx) {
            String path;
            Object ra = null;
            ObjectName raObj = null;
            raObj = (ObjectName)oList.get(indx);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "raObj=" + raObj);
            }
            if ((path = (String)this.configService.getAttribute(session, raObj, "archivePath")) == null || force) continue;
            String jndi = null;
            ObjectName[] cfList = null;
            List aoList = null;
            List acList = null;
            try {
                cfList = this.configService.getRelationship(session, raObj, "J2CConnectionFactory");
            }
            catch (Exception ex) {
                Tr.warning(tc, "ADMG0039W", new Object[]{"J2CConnectionFactory", raObj});
            }
            AttributeList attrList = null;
            try {
                attrList = this.configService.getAttributes(session, raObj, new String[]{"j2cAdminObjects"}, false);
                aoList = (List)ConfigServiceHelper.getAttributeValue(attrList, "j2cAdminObjects");
            }
            catch (Exception ex) {
                Tr.warning(tc, "ADMG0039W", new Object[]{"J2CAdminObject", raObj});
            }
            try {
                attrList = this.configService.getAttributes(session, raObj, new String[]{"j2cActivationSpec"}, false);
                acList = (List)ConfigServiceHelper.getAttributeValue(attrList, "j2cActivationSpec");
            }
            catch (Exception ex) {
                Tr.warning(tc, "ADMG0039W", new Object[]{"J2CActivationSpec", raObj});
            }
            if (cfList != null) {
                for (int i = 0; i < cfList.length; ++i) {
                    ObjectName ocf = cfList[i];
                    jndi = (String)this.configService.getAttribute(session, ocf, "jndiName");
                    jndiList.add(jndi);
                }
            }
            if (acList != null) {
                for (int i = 0; i < acList.size(); ++i) {
                    ObjectName oac = (ObjectName)acList.get(i);
                    jndi = (String)this.configService.getAttribute(session, oac, "jndiName");
                    jndiList.add(jndi);
                }
            }
            if (aoList == null) continue;
            for (int i = 0; i < aoList.size(); ++i) {
                ObjectName oao = (ObjectName)aoList.get(i);
                jndi = (String)this.configService.getAttribute(session, oao, "jndiName");
                jndiList.add(jndi);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "jndiList=" + jndiList);
        }
        for (int j = 0; j < oList.size(); ++j) {
            ObjectName o = (ObjectName)oList.get(j);
            String id = o.getKeyProperty("_Websphere_Config_Data_Id");
            String disp = ConfigServiceHelper.getDisplayName(o);
            mList.add(disp + "(" + id + ")");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "mList=" + mList);
        }
        Hashtable appList = new Hashtable(5);
        String nodes = "WebSphere:cell=" + cell + ",node=" + node;
        if (!force) {
            try {
                AppManagement appM = null;
                appM = client != null ? AppManagementProxy.getJMXProxyForClient(client) : AppManagementProxy.getLocalProxy();
                appList = appM.searchJNDIReferences(jndiList, nodes, null, null);
            }
            catch (Exception ex) {
                Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.tasks.uninstallRARTask", "434", this);
                throw new ConfigServiceException(ex);
            }
            if (!appList.isEmpty()) {
                throw new AppRefException(mList, appList);
            }
        }
        for (int m = 0; m < oList.size(); ++m) {
            try {
                ObjectName obj = (ObjectName)oList.get(m);
                this.configService.deleteConfigData(session, obj);
                continue;
            }
            catch (Exception ex) {
                Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.configservice.tasks.uninstallRARTask", "460", this);
                throw new ConfigServiceException(ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "uninstallResourceAdapter", mList);
        }
        return mList;
    }

    private String cleanString(String s) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanString");
        }
        if (s.startsWith("\"") && s.endsWith("\"")) {
            s = s.substring(1, s.length() - 1);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanString");
        }
        return s;
    }

    void checkRAinObject(Session session, ObjectName Obj, List oList, String aPath) throws ConfigServiceException, ConnectorException {
        try {
            ObjectName[] raList = this.configService.getRelationship(session, Obj, "J2CResourceAdapter");
            ObjectName ton = null;
            String path = null;
            for (int j = 0; j < raList.length; ++j) {
                ton = raList[j];
                path = (String)this.configService.getAttribute(session, ton, "archivePath");
                if (!aPath.equals(path)) continue;
                oList.add(ton);
            }
        }
        catch (ConfigServiceException e) {
            Manager.Ffdc.log(e, this, "com.ibm.websphere.management.configservice.tasks.uninstallRARTask", "646", this);
            throw e;
        }
        catch (ConnectorException e) {
            Manager.Ffdc.log(e, this, "com.ibm.websphere.management.configservice.tasks.uninstallRARTask", "649", this);
            throw e;
        }
    }
}

