/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.cmdframework.provider;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandHistory;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.DownloadFile;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.RequiredParameterNotFoundException;
import com.ibm.websphere.management.cmdframework.UploadFile;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commanddata.CommandDataFactory;
import com.ibm.websphere.management.cmdframework.commanddata.GenericObjectValue;
import com.ibm.websphere.management.cmdframework.commanddata.ObjectValue;
import com.ibm.websphere.management.cmdframework.commanddata.UserData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadataFactory;
import com.ibm.websphere.management.cmdframework.commandmetadata.CustomProperties;
import com.ibm.websphere.management.cmdframework.commandmetadata.ParameterMetadata;
import com.ibm.websphere.management.cmdframework.provider.CmdNotificationHandler;
import com.ibm.websphere.management.cmdframework.provider.CommandNotification;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.management.cmdframework.impl.CmdFrameworkConstants;
import com.ibm.ws.management.cmdframework.impl.CommandMetadataMgr;
import com.ibm.ws.management.cmdframework.impl.RemoteCommandMgr;
import com.ibm.ws.management.cmdframework.impl.ServerCommandMgr;
import com.ibm.ws.management.cmdframework.impl.TaskCommandSession;
import com.ibm.ws.management.cmdframework.impl.TaskCommandSessionMgr;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;

public abstract class AbstractAdminCommand
extends AbstractCommand
implements AdminCommand {
    private static TraceComponent tc = Tr.register(AbstractAdminCommand.class, "AbstractAdminCommand", "com.ibm.websphere.management.resources.cmdframework");
    public static final String ASYNC_CUSTOM_TAG = "async";
    public static final String DYNAMIC_CUSTOM_TAG = "dynamicStep";
    public static final String PRIVATE_CUSTOM_TAG = "private";
    private static final String CMDFRAMEWORK_WEBSPHERE_PREFIX = "com.ibm.websphere.management.cmdframework";
    private static final String CMDFRAMEWORK_WS_PREFIX = "com.ibm.ws.management.cmdframework";
    private CommandMetadata metadata;
    private CommandData commandData = null;
    private CommandResult cmdResult = null;
    private HashMap origParameterValue = new HashMap();
    protected CmdNotificationHandler cnh;
    protected TaskCommandSession asyncCmdSession;
    protected Integer cmdMgrType;
    private static HashMap scriptGenerators = new HashMap();
    protected HashMap<Integer, Collection<String>> listSetParamsTable;

    public AbstractAdminCommand(CommandMetadata metadata2) {
        this(metadata2, null);
    }

    public AbstractAdminCommand(CommandData inCommandData) throws CommandNotFoundException {
        this(AbstractAdminCommand.getCommandMetadata(inCommandData.getName()), inCommandData);
    }

    public static CommandMetadata getCommandMetadata(String cmdName) throws CommandNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandMetadata", cmdName);
        }
        try {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCommandMetadata");
            }
            return CommandMgr.getCommandMgr().getCommandMetadata(cmdName);
        }
        catch (CommandNotFoundException ex) {
            throw ex;
        }
        catch (ConnectorException ex) {
            return null;
        }
        catch (CommandException ex) {
            return null;
        }
    }

    private AbstractAdminCommand(CommandMetadata inMetadata, CommandData inCommandData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AbstractAdminCommand", new Object[]{inMetadata, inCommandData});
        }
        this.metadata = inMetadata;
        this.listSetParamsTable = new HashMap();
        this.setCommandData(inCommandData);
        if (this.commandData == null) {
            this.commandData = this.initCommandData();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "commandData", this.commandData);
        }
        this.commandData.setName(this.metadata.getName());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AbstractAdminCommand");
        }
    }

    private void setCommandData(CommandData inCommandData) {
        this.commandData = inCommandData;
        if (this.commandData != null) {
            String wsId;
            UserData userData = this.commandData.getUserData();
            if (userData != null && (wsId = this.commandData.getUserData().getWorkspaceId()) != null) {
                this.setConfigSession(new Session(wsId, true));
            }
            CommandMetadata metadata2 = this.getCommandMetadata();
            EList paramMetadata = metadata2.getParameters();
            Iterator iter = paramMetadata.iterator();
            while (iter.hasNext()) {
                String param = ((ParameterMetadata)iter.next()).getName();
                if (this.isTable()) {
                    for (int i = 0; i < this.getCommandData().getCmdParams().size(); ++i) {
                        try {
                            Object val = this.getParameter(param, i);
                            if (val == null) continue;
                            this.setParameter(param, val, i);
                            continue;
                        }
                        catch (Exception ex) {
                            if (!tc.isDebugEnabled()) continue;
                            Throwable t = ex.getCause();
                            if (t == null) {
                                Tr.debug(tc, "Handle unexpected exception, " + ex, ex);
                                continue;
                            }
                            Tr.debug(tc, "Handle unexpected exception, " + ex + " Root cause is: " + ex.getCause(), t);
                        }
                    }
                    continue;
                }
                try {
                    Object val = this.getParameter(param);
                    if (val == null) continue;
                    this.setParameter(param, val);
                }
                catch (Exception ex) {
                    if (!tc.isDebugEnabled()) continue;
                    Throwable t = ex.getCause();
                    if (t == null) {
                        Tr.debug(tc, "Handle unexpected exception, " + ex, ex);
                        continue;
                    }
                    Tr.debug(tc, "Handle unexpected exception, " + ex + " Root cause is: " + ex.getCause(), t);
                }
            }
        }
    }

    protected CommandData initCommandData() {
        return CommandDataFactory.eINSTANCE.createCommandData();
    }

    public Locale getLocale() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLocale");
        }
        String localeVal = this.getUserData().getLocale();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "localeVal: " + localeVal);
        }
        Locale locale = null;
        if (localeVal != null) {
            StringTokenizer tokenizer = new StringTokenizer(localeVal, "/");
            String language = null;
            String country = null;
            String variant = null;
            if (tokenizer.hasMoreTokens()) {
                language = tokenizer.nextToken();
                if (tokenizer.hasMoreTokens()) {
                    country = tokenizer.nextToken();
                    if (tokenizer.hasMoreTokens()) {
                        variant = tokenizer.nextToken();
                        locale = new Locale(language, country, variant);
                    } else {
                        locale = new Locale(language, country);
                    }
                } else {
                    locale = new Locale(language);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "language", language);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "country", country);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "variant", variant);
                }
            } else {
                locale = Locale.getDefault();
            }
        } else {
            locale = Locale.getDefault();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLocale", locale);
        }
        return locale;
    }

    public void setLocale(Locale locale) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setLocale", locale);
        }
        String localeVal = null;
        if (locale != null) {
            StringBuffer buf = new StringBuffer(locale.getLanguage());
            buf.append('/').append(locale.getCountry());
            buf.append('/').append(locale.getVariant());
            localeVal = buf.toString();
            this.getUserData().setLocale(localeVal);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setLocale", localeVal);
        }
    }

    public String getName() {
        return this.metadata.getName();
    }

    public CommandMetadata getCommandMetadata() {
        return this.metadata;
    }

    protected CommandData getCommandData() {
        return this.commandData;
    }

    protected void setCommandMetadata(CommandMetadata cmdmetadata) {
        this.metadata = cmdmetadata;
    }

    public Object getTargetObject() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTargetObject");
        }
        Object returnObject = null;
        ObjectValue targetObj = this.commandData.getTargetObject();
        if (targetObj != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Target Object is " + targetObj);
            }
            returnObject = targetObj.getValue();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTargetObject", returnObject);
        }
        return returnObject;
    }

    public void setTargetObject(Object obj) throws InvalidParameterValueException {
        ObjectValue val;
        String targetObjectType;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTargetObject", obj);
        }
        if ((targetObjectType = this.metadata.getTargetObjectType()) == null && this.metadata.isTargetObjectRequired()) {
            throw new InvalidParameterValueException(this.getName(), "targetObject", obj);
        }
        if (targetObjectType != null && !obj.getClass().getName().endsWith(targetObjectType)) {
            throw new InvalidParameterValueException(this.getName(), "targetObject", obj);
        }
        if (this.commandData == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "commanddata is null");
            }
            this.commandData = CommandDataFactory.eINSTANCE.createCommandData();
            this.commandData.setName(this.metadata.getName());
        }
        if ((val = this.commandData.getTargetObject()) == null) {
            this.commandData.setTargetObject(CommandDataFactory.eINSTANCE.createGenericObjectValue());
            val = this.commandData.getTargetObject();
        }
        val.setValue(obj);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTargetObject", val);
        }
    }

    public Collection listSetParams() {
        return this.listSetParams(0);
    }

    protected Collection listSetParams(int rowIndex) {
        Collection<String> setParams;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listSetParams," + rowIndex);
        }
        if ((setParams = this.listSetParamsTable.get(new Integer(rowIndex))) == null) {
            setParams = new ArrayList<String>();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listSetParams", setParams);
        }
        return setParams;
    }

    public Object getParameter(String parameterName) throws InvalidParameterNameException {
        return this.getParameter(parameterName, 0);
    }

    public boolean isAsyncCommand() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAsyncCommand, command name: " + this.getName());
        }
        boolean isAsync = false;
        EList customProperties = this.metadata.getCustom();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Custom = " + customProperties);
        }
        if (customProperties != null && !customProperties.isEmpty()) {
            for (CustomProperties cp : customProperties) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Custom = " + cp);
                }
                if (!cp.getKey().equalsIgnoreCase(ASYNC_CUSTOM_TAG)) continue;
                EList valueList = cp.getValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Valus of async custom tag = " + valueList);
                }
                if (valueList == null || valueList.isEmpty()) continue;
                String value = (String)valueList.iterator().next();
                isAsync = value.equalsIgnoreCase("true");
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAsyncCommand, command name: " + this.getName() + " return " + isAsync);
        }
        return isAsync;
    }

    public boolean isDynamicStepCommand() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isDynamicStepCommand, command name: " + this.getName());
        }
        boolean isDynamic = false;
        EList customProperties = this.metadata.getCustom();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Custom = " + customProperties);
        }
        if (customProperties != null && !customProperties.isEmpty()) {
            for (CustomProperties cp : customProperties) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Custom = " + cp);
                }
                if (!cp.getKey().equalsIgnoreCase(DYNAMIC_CUSTOM_TAG)) continue;
                EList valueList = cp.getValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Valus of dynamicStep custom tag = " + valueList);
                }
                if (valueList == null || valueList.isEmpty()) continue;
                String value = (String)valueList.iterator().next();
                isDynamic = value.equalsIgnoreCase("true");
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isDynamicStepCommand, command name: " + this.getName() + " return " + isDynamic);
        }
        return isDynamic;
    }

    public boolean isPrivateParameter(String paramName) throws InvalidParameterNameException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isPrivateParameter, command name: " + this.getName() + ", param name: " + paramName);
        }
        boolean isPrivate = false;
        ParameterMetadata pMetadata = this.getParameterMetadata(paramName);
        EList customProperties = pMetadata.getCustom();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Custom = " + customProperties);
        }
        if (customProperties != null && !customProperties.isEmpty()) {
            for (CustomProperties cp : customProperties) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Custom = " + cp);
                }
                if (!cp.getKey().equalsIgnoreCase(PRIVATE_CUSTOM_TAG)) continue;
                EList valueList = cp.getValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Valus of private custom tag = " + valueList);
                }
                if (valueList == null || valueList.isEmpty()) continue;
                String value = (String)valueList.iterator().next();
                isPrivate = value.equalsIgnoreCase("true");
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isPrivateParameter, command name: " + this.getName() + ", param name: " + paramName + " return " + isPrivate);
        }
        return isPrivate;
    }

    public List listAllParameterName() {
        boolean publicOnly = false;
        return this.listAllParameterName(publicOnly);
    }

    public List listParameterName() {
        boolean publicOnly = true;
        return this.listAllParameterName(publicOnly);
    }

    private List listAllParameterName(boolean publicOnly) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listAllParameterName, publicOnly=" + publicOnly);
        }
        ArrayList<String> result = new ArrayList<String>();
        EList params = this.metadata.getParameters();
        for (int i = 0; i < params.size(); ++i) {
            ParameterMetadata pmeta = (ParameterMetadata)params.get(i);
            String pname = pmeta.getName();
            try {
                if (publicOnly && !this.isPrivateParameter(pname)) {
                    result.add(pname);
                    continue;
                }
                result.add(pname);
                continue;
            }
            catch (InvalidParameterNameException ipn) {
                // empty catch block
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listAllParameterName, publicOnly=" + publicOnly, new Object[]{result});
        }
        return result;
    }

    protected Object getParameter(String parameterName, int rowIndex) throws InvalidParameterNameException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getParameter", new Object[]{parameterName, new Integer(rowIndex)});
        }
        Object result = null;
        this.getParameterMetadata(parameterName);
        EList params = this.commandData.getCmdParams();
        if (params.size() > 0) {
            EObject paramData = (EObject)params.get(rowIndex);
            EStructuralFeature sf = paramData.eClass().getEStructuralFeature(parameterName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "default attribute value is " + sf.getDefaultValue());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "default param value is " + paramData.eGet(sf));
            }
            if (sf instanceof EAttribute) {
                result = paramData.eGet(sf);
            } else {
                GenericObjectValue sfValue = (GenericObjectValue)paramData.eGet(sf);
                if (sfValue == null) {
                    return null;
                }
                result = sfValue.getValue();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getParameter.  Parameter Value is " + result);
        }
        return result;
    }

    public void setParameter(String paramName, Object value) throws InvalidParameterValueException, InvalidParameterNameException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setParameter", new Object[]{paramName, value});
        }
        this.setParameter(paramName, value, 0, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setParameter");
        }
    }

    public void setOrigParameterValue(String paramName, Object value) throws InvalidParameterValueException, InvalidParameterNameException {
        HashMap callerID;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setOrigParameterValue, paramName: " + paramName + ", value: " + value);
        }
        if (!this.isValidCaller(callerID = new HashMap())) {
            throw new UnsupportedOperationException("Invalid caller: " + callerID.get("caller"));
        }
        if (value != null) {
            Class<?> valueClass = value.getClass();
            if (valueClass != UploadFile.class && valueClass != DownloadFile.class) {
                throw new UnsupportedOperationException("Unsupported parameter value " + valueClass);
            }
        } else {
            throw new InvalidParameterValueException(this.getName(), paramName, value);
        }
        this.origParameterValue.put(paramName, value);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setOrigParameterValue, paramName: " + paramName + ", value: " + value);
        }
    }

    public Object getOrigParameterValue(String paramName) throws InvalidParameterNameException {
        Object retValue;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOrigParameterValue, paramName: " + paramName);
        }
        if ((retValue = this.origParameterValue.get(paramName)) == null) {
            retValue = this.getParameter(paramName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOrigParameterValue, paramName: " + paramName + ", value: " + retValue);
        }
        return retValue;
    }

    private boolean isValidCaller(HashMap callerID) {
        boolean retVal = false;
        StackTraceElement[] ste = new Throwable().getStackTrace();
        if (ste.length > 2) {
            callerID.put("caller", ste[2]);
            String caller = ste[2].getClassName();
            if (caller.startsWith(CMDFRAMEWORK_WEBSPHERE_PREFIX) || caller.startsWith(CMDFRAMEWORK_WS_PREFIX)) {
                retVal = true;
            }
        }
        return retVal;
    }

    protected void initializeParameter(String paramName, Object value) throws InvalidParameterValueException, InvalidParameterNameException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "InitializeParameter", new Object[]{paramName, value});
        }
        this.setParameter(paramName, value, 0, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "InitializeParameter");
        }
    }

    protected void setParameter(String paramName, Object value, int rowIndex) throws InvalidParameterValueException, InvalidParameterNameException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setParameter", new Object[]{paramName, value, new Integer(rowIndex)});
        }
        this.setParameter(paramName, value, rowIndex, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setParameter");
        }
    }

    protected void initializeParameter(String paramName, Object value, int rowIndex) throws InvalidParameterValueException, InvalidParameterNameException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeParameter", new Object[]{paramName, value, new Integer(rowIndex)});
        }
        this.setParameter(paramName, value, rowIndex, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeParameter");
        }
    }

    private void setParameter(String paramName, Object value, int rowIndex, boolean isProvider) throws InvalidParameterValueException, InvalidParameterNameException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setParameter", new Object[]{paramName, value, new Integer(rowIndex), isProvider});
        }
        if (this.isParamReadonly(paramName) && !isProvider) {
            throw new InvalidParameterValueException(this.getName(), paramName, value);
        }
        EList params = this.commandData.getCmdParams();
        EObject paramData = null;
        if (!this.isTable() && params.size() == 0) {
            try {
                paramData = this.createParamEObject();
                params.add(paramData);
            }
            catch (CommandNotFoundException ex) {
                ex.printStackTrace();
            }
        } else {
            paramData = (EObject)params.get(rowIndex);
        }
        try {
            EStructuralFeature sf = paramData.eClass().getEStructuralFeature(paramName);
            if (sf instanceof EAttribute) {
                paramData.eSet(sf, value);
            } else {
                GenericObjectValue sfValue = (GenericObjectValue)paramData.eGet(sf);
                if (sfValue == null) {
                    sfValue = CommandDataFactory.eINSTANCE.createGenericObjectValue();
                    paramData.eSet(sf, sfValue);
                }
                sfValue.setValue(value);
            }
            if (!isProvider) {
                this.setListSetParamsTable(rowIndex, paramName);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setParameter");
            }
        }
        catch (ClassCastException cce) {
            InvalidParameterValueException ex = new InvalidParameterValueException(this.getName(), paramName, value);
            ex.initCause(cce);
            throw ex;
        }
        catch (IllegalArgumentException iae) {
            InvalidParameterValueException ex = new InvalidParameterValueException(this.getName(), paramName, value);
            ex.initCause(iae);
            throw ex;
        }
        catch (NullPointerException npe) {
            InvalidParameterNameException ex = new InvalidParameterNameException(this.getName(), paramName);
            ex.initCause(npe);
            throw ex;
        }
    }

    protected void setListSetParamsTable(int rowIndex, String paramName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setListSetParamsTable, rowIndex = " + rowIndex + ", paramName = " + paramName);
        }
        Integer rowIndexInInteger = new Integer(rowIndex);
        Collection<String> paramNamesForRow = this.listSetParamsTable.get(rowIndexInInteger);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "parameter name Collection for row " + rowIndex + ": " + paramNamesForRow);
        }
        if (paramNamesForRow == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "creating new parameter name Collection for row " + rowIndex);
            }
            paramNamesForRow = new ArrayList<String>();
            this.listSetParamsTable.put(rowIndexInInteger, paramNamesForRow);
        }
        if (!paramNamesForRow.contains(paramName)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "adding " + paramName + " to the parameter name Collection.");
            }
            paramNamesForRow.add(paramName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setListSetParamsTable, paramNamesForRow = " + paramNamesForRow);
        }
    }

    protected boolean isTable() {
        return false;
    }

    public Object[] getChoices(String paramName) {
        return null;
    }

    public Object[] getTargetObjectChoices() {
        return null;
    }

    public void validate() throws CommandValidationException {
        CommandMetadata metadata2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        if ((metadata2 = this.getCommandMetadata()).isTargetObjectRequired() && this.getTargetObject() == null) {
            throw new CommandValidationException(TraceNLS.getStringFromBundle("com.ibm.ws.management.resources.cmdframework", "ADMF0007E"));
        }
        EList paramsMetadata = metadata2.getParameters();
        EList params = this.getCommandData().getCmdParams();
        if (!this.isTable() && params.size() == 0) {
            try {
                EObject paramData = this.createParamEObject();
                params.add(paramData);
            }
            catch (CommandNotFoundException ex) {
                ex.printStackTrace();
            }
        }
        for (int i = 0; i < params.size(); ++i) {
            for (ParameterMetadata paramMetadata : paramsMetadata) {
                Class<?> cls;
                String parmType;
                String paramName = paramMetadata.getName();
                Object paramVal = this.getParameter(paramName, i);
                if (paramMetadata.isRequired()) {
                    if (paramVal == null || paramVal instanceof String && paramVal.equals("")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "In validate(), parameter value is null or empty for ParameterMetadata: " + paramName + ", value: " + paramVal + ".");
                        }
                        throw new RequiredParameterNotFoundException(this.getName(), paramName);
                    }
                } else if (paramVal == null) continue;
                if ((parmType = paramMetadata.getType()).equals("String")) {
                    if (paramVal instanceof String) continue;
                    throw new InvalidParameterValueException(this.getName(), paramName, paramVal);
                }
                try {
                    cls = Class.forName(paramMetadata.getType());
                }
                catch (ClassNotFoundException ex) {
                    try {
                        cls = Class.forName("java.lang." + paramMetadata.getType());
                    }
                    catch (ClassNotFoundException ex2) {
                        throw new CommandValidationException("Type definition is not found for Parameter " + paramName + ex);
                    }
                }
                if (paramVal == null || cls.isInstance(paramVal)) continue;
                throw new InvalidParameterValueException(this.getName(), paramName, paramVal);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    public void setConfigSession(Session session) {
        this.getUserData().setWorkspaceId(session.toString());
    }

    public Session getConfigSession() {
        Session session;
        String workspaceId = this.getUserData().getWorkspaceId();
        if (workspaceId == null) {
            session = new Session();
            this.getUserData().setWorkspaceId(session.toString());
        } else {
            session = new Session(workspaceId, true);
        }
        return session;
    }

    public CommandResult getCommandResult() {
        return this.cmdResult;
    }

    protected void setCommandResult(CommandResult thisResult) {
        this.cmdResult = thisResult;
    }

    public void save(OutputStream outputStream) {
        block2: {
            ResourceSetImpl resSet = new ResourceSetImpl();
            XMIResourceImpl res = new XMIResourceImpl();
            res.setURI(URI.createURI("Command.xmi"));
            res.getContents().add(this.commandData);
            try {
                HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                options.put("DECLARE_XML", Boolean.TRUE);
                res.save(outputStream, options);
            }
            catch (IOException e) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.error(tc, e.getMessage());
            }
        }
    }

    public abstract void execute();

    public void execute(CommandHistory cmdHistory) {
        this.execute();
        cmdHistory.add(this.getCommandData());
    }

    public void setCommandSession(TaskCommandSession session) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCommandSession", session);
        }
        this.asyncCmdSession = session;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCommandSession", this.asyncCmdSession);
        }
    }

    public TaskCommandSession getCommandSession() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandSession", this.asyncCmdSession);
        }
        if (this.asyncCmdSession == null) {
            if (!this.isLocalMode()) {
                CommandMgr cmdMgr = CommandMgr.getCommandMgr();
                TaskCommandSessionMgr sessionMgr = ((ServerCommandMgr)cmdMgr).getTaskCommandSessionMgr();
                this.asyncCmdSession = sessionMgr.createTaskCommandSession(this);
            } else {
                this.asyncCmdSession = new TaskCommandSession();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandSession", this.asyncCmdSession);
        }
        return this.asyncCmdSession;
    }

    public void setCmdHandler(CmdNotificationHandler handler) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setHandler", handler);
        }
        this.cnh = handler;
        if (!this.isLocalMode()) {
            this.setupListener(this.cnh);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setHandler");
        }
    }

    protected void setupListener(Object obj) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setupListener", obj);
            }
            try {
                CmdNotificationListener l = new CmdNotificationListener(this.getCommandSession().getSessionId());
                NotificationFilterSupport filter = new NotificationFilterSupport();
                filter.enableType("CmdNotification");
                AdminServiceFactory.getAdminService().addNotificationListenerExtended(this.getRCMMbeanObjName(), l, filter, obj);
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Exception occured", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setupListener");
        }
    }

    public Collection getResult() {
        ArrayList<Object> result = new ArrayList<Object>(1);
        if (this.cmdResult.isSuccessful()) {
            result.add(this.cmdResult.getResult());
        } else {
            result.add(this.cmdResult.getException());
        }
        return result;
    }

    public void sendNotification(CommandNotification cmdNotification) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendNotification");
        }
        if (!this.isLocalMode()) {
            if (cmdNotification.getCmdStatus().equals("Completed") && this.isAsyncCommand()) {
                this.cleanupUploadedFiles();
            }
            RemoteCommandMgr rcm = ((ServerCommandMgr)CommandMgr.getCommandMgr()).getRCMMbean();
            rcm.sendCmdNotification("CmdNotification", cmdNotification);
        } else {
            this.cnh.handleCmdNotification(cmdNotification);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendNotification");
        }
    }

    public void redo() {
        throw new UnsupportedOperationException();
    }

    public void cleanupUploadedFiles() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanupUploadedFiles");
        }
        EList paramMetadatas = this.getCommandMetadata().getParameters();
        Iterator iter = paramMetadatas.iterator();
        while (iter.hasNext()) {
            try {
                Object val;
                ParameterMetadata paramMetadata = (ParameterMetadata)iter.next();
                if (!paramMetadata.getType().equals("com.ibm.websphere.management.cmdframework.UploadFile") || (val = this.getParameter(paramMetadata.getName())) == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "detect DownloadFile parameter " + paramMetadata.getName() + " value is " + val);
                }
                new File(((UploadFile)val).getPath()).delete();
            }
            catch (Throwable th) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "unexpected exception", th);
                }
                Manager.Ffdc.log(th, this, "com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand.cleanupUploadedFiles", "795", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanupUploadedFiles");
        }
    }

    protected EObject createParamEObject() throws CommandNotFoundException {
        EObject result = null;
        try {
            result = CommandMetadataMgr.getInstance().createParamDataEObject(this.getName());
        }
        catch (CommandNotFoundException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.commandframework.provider.AbstractAdminCommand", "365");
        }
        return result;
    }

    protected UserData getUserData() {
        UserData userData = this.commandData.getUserData();
        if (userData == null) {
            userData = CommandDataFactory.eINSTANCE.createUserData();
            this.commandData.setUserData(userData);
        }
        return userData;
    }

    public void resetCommandData(CommandData cmdData) {
        this.setCommandData(cmdData);
    }

    protected void resetCommandMetadata(CommandMetadata newMetadata) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resetCommandMetadata", newMetadata);
        }
        this.metadata = newMetadata;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resetCommandMetadata", this.metadata);
        }
    }

    public String generateScript(String lang) throws CommandException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateScript", lang);
        }
        Object generator = this.getScriptGenerator(lang);
        String script = null;
        try {
            Class<?> generatorCls = Class.forName("com.ibm.ws.scripting.adminCommand.AdminCmdScriptGenerator");
            Method generateMethod = generatorCls.getMethod("generateScriptFromCmd", AdminCommand.class);
            Object result = generateMethod.invoke(generator, this);
            script = result.toString();
        }
        catch (Throwable th) {
            throw new CommandException(th, "unable to generate script from command in " + lang);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateScript", script);
        }
        return script;
    }

    protected ParameterMetadata getParameterMetadata(String paramName) throws InvalidParameterNameException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getParameterMetadata", paramName);
        }
        EList paramMetadataList = this.getCommandMetadata().getParameters();
        ParameterMetadata result = null;
        for (ParameterMetadata paramMetadata : paramMetadataList) {
            if (!paramMetadata.getName().equals(paramName)) continue;
            result = paramMetadata;
            break;
        }
        if (result == null) {
            throw new InvalidParameterNameException(this.getName(), paramName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getParameterMetadata");
        }
        return result;
    }

    private Object getScriptGenerator(String lang) throws CommandException {
        Object result;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getScriptGenerator", lang);
        }
        if ((result = scriptGenerators.get(lang)) == null) {
            try {
                Class<?> generatorCls = Class.forName("com.ibm.ws.scripting.adminCommand.AdminCmdScriptGenerator");
                Constructor<?> construct = generatorCls.getConstructor(String.class);
                result = construct.newInstance(lang);
            }
            catch (Throwable th) {
                throw new CommandException(th, "unable to instantiate script generator");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getScriptGenerator", result);
        }
        return result;
    }

    private ObjectName getRCMMbeanObjName() throws MalformedObjectNameException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRCMMbeanObjName");
        }
        String process = AdminServiceFactory.getAdminService().getProcessName();
        String objectNameString = "WebSphere:type=RemoteCommandMgr,process=" + process + ",*";
        ObjectName match = new ObjectName(objectNameString);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRCMMbeanObjName", match);
        }
        return match;
    }

    protected boolean isLocalMode() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isLocalMode");
        }
        boolean result = this.cmdMgrType.equals(CmdFrameworkConstants.LOCAL_CMD_MANAGER);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isLocalMode", new Boolean(result));
        }
        return result;
    }

    public void setCmdMgrType(Integer cmdMgrType) {
        this.cmdMgrType = cmdMgrType;
    }

    public Integer getCmdMgrType() {
        return this.cmdMgrType;
    }

    protected boolean isParamReadonly(String paramName) throws InvalidParameterNameException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isParamReadonly", paramName);
        }
        ParameterMetadata pm = this.getParameterMetadata(paramName);
        boolean result = pm.isReadonly();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isParamReadonly", new Boolean(result));
        }
        return result;
    }

    protected ConfigService getConfigService() {
        return ConfigServiceFactory.getConfigService();
    }

    public ParameterMetadata createParameterMetadata(String pmName, Hashtable featureList) throws InvalidParameterValueException, InvalidParameterNameException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createParameterMetadata", new Object[]{pmName, featureList});
        }
        ParameterMetadata pm = CommandMetadataFactory.eINSTANCE.createParameterMetadata();
        pm.setName(pmName);
        for (Integer featureID : featureList.keySet()) {
            Object value = featureList.get(featureID);
            EStructuralFeature sf = pm.eClass().getEStructuralFeature(featureID);
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "setting feature " + sf.getName() + " to \"" + value + "\"");
                }
                pm.eSet(sf, value);
            }
            catch (ClassCastException cce) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Got unexpected " + cce + ", when creating " + pmName + " ParameterMetadata with " + sf.getName() + " = \"" + value + "\"");
                }
                throw new InvalidParameterValueException(pmName, sf.getName(), value);
            }
            catch (IllegalArgumentException iae) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Got unexpected " + iae + ", when creating " + pmName + " ParameterMetadata with " + sf.getName() + " = \"" + value + "\"");
                }
                throw new InvalidParameterValueException(pmName, sf.getName(), value);
            }
            catch (NullPointerException npe) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Got unexpected " + npe + ", when creating " + pmName + " ParameterMetadata with feature name " + sf.getName());
                }
                throw new InvalidParameterNameException(pmName, sf.getName());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createParameterMetadata returns", new Object[]{pm});
        }
        return pm;
    }

    public class CmdNotificationListener
    implements NotificationListener {
        protected boolean success;
        protected boolean complete;
        protected long session;

        public CmdNotificationListener() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "CmdNotificationListener");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "CmdNotificationListener");
            }
        }

        public CmdNotificationListener(long cmdSession) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "CmdNotificationListener");
            }
            this.session = cmdSession;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "CmdNotificationListener");
            }
        }

        public void handleNotification(Notification notf, Object handback) {
            Object ud;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "handleNotification", new Object[]{notf, handback});
            }
            if ((ud = notf.getUserData()) instanceof CommandNotification) {
                CommandNotification cn = (CommandNotification)ud;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Command name is " + cn.getCmdName() + ", Command status is " + cn.getCmdStatus() + ", Command message is " + cn.getMessage() + ", session id is " + cn.getSessionID());
                }
                if (cn.getSessionID() == AbstractAdminCommand.this.asyncCmdSession.getSessionId()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Command status is " + cn.getCmdStatus());
                    }
                    if (cn.getCmdStatus().equals("Completed")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Command completed.  Result is " + cn.getResult().getResult());
                        }
                        this.complete = true;
                        AbstractAdminCommand.this.setCommandResult(cn.getResult());
                        try {
                            this.removeListener();
                        }
                        catch (Exception ex) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "unexpected exception", ex);
                            }
                            Manager.Ffdc.log(ex, this, "com.ibm.websphere.management.cmdframework.CmdNotificationListener", "134");
                        }
                    }
                    AbstractAdminCommand.this.cnh.handleCmdNotification(cn);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Command notified");
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "received irrelevant event", ud);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleNotification");
            }
        }

        public void removeListener() throws Exception {
            AdminServiceFactory.getAdminService().removeNotificationListenerExtended(this);
        }

        public boolean isSuccess() {
            return this.success;
        }

        public boolean isComplete() {
            return this.complete;
        }
    }
}

